/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jmx.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.jmx.MBeanServerNotFoundException;
import com.bmc.thirdparty.org.springframework.jmx.support.JmxUtils;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;

public class MBeanServerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean locateExistingServerIfPossible = false;
    private String agentId;
    private String defaultDomain;
    private boolean registerWithFactory = true;
    private MBeanServer server;
    private boolean newlyRegistered = false;
    static /* synthetic */ Class class$javax$management$MBeanServer;

    public void setLocateExistingServerIfPossible(boolean locateExistingServerIfPossible) {
        this.locateExistingServerIfPossible = locateExistingServerIfPossible;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public void setRegisterWithFactory(boolean registerWithFactory) {
        this.registerWithFactory = registerWithFactory;
    }

    public void afterPropertiesSet() throws MBeanServerNotFoundException {
        if (this.locateExistingServerIfPossible || this.agentId != null) {
            try {
                this.server = this.locateMBeanServer(this.agentId);
            }
            catch (MBeanServerNotFoundException ex) {
                if (this.agentId != null) {
                    throw ex;
                }
                this.logger.info("No existing MBeanServer found - creating new one");
            }
        }
        if (this.server == null) {
            this.server = this.createMBeanServer(this.defaultDomain, this.registerWithFactory);
            this.newlyRegistered = this.registerWithFactory;
        }
    }

    protected MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(agentId);
    }

    protected MBeanServer createMBeanServer(String defaultDomain, boolean registerWithFactory) {
        if (registerWithFactory) {
            return MBeanServerFactory.createMBeanServer(defaultDomain);
        }
        return MBeanServerFactory.newMBeanServer(defaultDomain);
    }

    public Object getObject() {
        return this.server;
    }

    public Class getObjectType() {
        return this.server != null ? this.server.getClass() : (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = MBeanServerFactoryBean.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.newlyRegistered) {
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

