/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrDecodingStream;
import com.bmc.thirdparty.org.acplt.oncrpc.web.Base64;
import com.bmc.thirdparty.org.acplt.oncrpc.web.HttpClientConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;

public class XdrHttpDecodingStream
extends XdrDecodingStream {
    private HttpClientConnection httpClient;
    private byte[] buffer;
    private byte[] asciiBuffer;
    private int asciiBufferSize;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrHttpDecodingStream(HttpClientConnection httpClientConnection) {
        this.httpClient = httpClientConnection;
        int n2 = 100;
        int n3 = n2 * 48;
        int n4 = n2 * 66;
        this.buffer = new byte[n3];
        this.asciiBuffer = new byte[n4];
        this.asciiBufferSize = n4;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public InetAddress getSenderAddress() {
        return null;
    }

    public int getSenderPort() {
        return 0;
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.httpClient.beginDecoding();
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void endDecoding() throws OncRpcException, IOException {
        try {
            this.httpClient.endDecoding();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void close() throws OncRpcException, IOException {
        this.httpClient = null;
        this.buffer = null;
    }

    private void fill() throws OncRpcException, IOException {
        int n2;
        int n3;
        try {
            n3 = this.httpClient.getRemainingContentLength();
            n2 = n3 < 0 ? this.httpClient.readContentBytes(this.asciiBuffer, 0, this.asciiBufferSize) : this.httpClient.readContentBytes(this.asciiBuffer, 0, n3);
        }
        catch (ProtocolException protocolException) {
            throw new OncRpcException(43);
        }
        n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            int n5 = n2 >= 64 ? 64 : n2 - 2;
            n3 += Base64.decode((byte[])this.asciiBuffer, (int)n4, (int)n5, (byte[])this.buffer, (int)n3);
            n4 += n5 + 2;
            n2 -= n5 + 2;
        }
        this.bufferIndex = 0;
        this.bufferHighmark = n3 - 4;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int n2 = this.buffer[this.bufferIndex++] & 0xFF;
        n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return n2;
    }

    public byte[] xdrDecodeOpaque(int n2) throws OncRpcException, IOException {
        int n3 = 4 - (n2 & 3) & 3;
        int n4 = 0;
        byte[] byArray = new byte[n2];
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n2 > 0) {
            int n5 = this.bufferHighmark - this.bufferIndex + 4;
            if (n5 >= n2) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n4, n2);
                this.bufferIndex += n2;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n4, n5);
            this.bufferIndex += n5;
            n4 += n5;
            n2 -= n5;
            this.fill();
        }
        this.bufferIndex += n3;
        return byArray;
    }

    public void xdrDecodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = 4 - (n3 & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n3 > 0) {
            int n5 = this.bufferHighmark - this.bufferIndex + 4;
            if (n5 >= n3) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n2, n3);
                this.bufferIndex += n3;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n2, n5);
            this.bufferIndex += n5;
            n2 += n5;
            n3 -= n5;
            this.fill();
        }
        this.bufferIndex += n4;
    }
}

