/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsRequest4In;
import com.bmc.arsys.arrpc.ArEsRequest4Out;
import com.bmc.arsys.arrpc.ArPropList;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.AREAPluggable;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AREAPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(AREAPluginRepository.class);
    private static final int AR_AUTH_PROP_NONE = 0;
    private static final int AR_AUTH_PROP_NAME = 1;
    private static final int AR_AUTH_PROP_PASSWORD = 2;
    private static final int AR_AUTH_PROP_LICENSE_TYPE = 3;
    private static final int AR_AUTH_PROP_LICENSE_FTS = 4;
    private static final int AR_AUTH_PROP_LICENSE_RES1 = 5;
    private static final int AR_AUTH_PROP_GROUPS = 6;
    private static final int AR_AUTH_PROP_EMAIL = 7;
    private static final int AR_AUTH_PROP_STATUS = 8;
    private static final int AR_AUTH_PROP_MESSAGE_TEXT = 9;
    private static final int AR_AUTH_PROP_NETWORK_ADDR = 10;
    private static final int AR_AUTH_PROP_NOTIFY_MECH = 11;
    private static final int AR_AUTH_PROP_LOG_TEXT = 12;
    private static final int AR_AUTH_PROP_MOD_TIME = 13;
    private static final int AR_AUTH_PROP_AUTH_STRING = 14;
    private static final int AR_AUTH_PROP_LICENSE_APPS = 15;
    private static final int AR_AUTH_PROP_BSM_AUTH = 16;
    private static final int AR_AUTH_MAX_PROP = 16;
    public static final int AREA_VERIFY_LOGIN = 1;
    public static final int AREA_NEED_SYNC = 2;
    protected ArrayList<PluginEnvelope> mPlugins = new ArrayList();

    AREAPluginRepository() {
    }

    @Override
    void addPlugin(String pName, PluginEnvelope pEnvelope) throws ARException {
        this.mPlugins.add(pEnvelope);
    }

    @Override
    PluginEnvelope getPlugin(String pName) {
        for (PluginEnvelope envelope : this.mPlugins) {
            if (!envelope.getPluginName().equals(pName)) continue;
            return envelope;
        }
        return null;
    }

    public ArEsRequest4Out AREANeedSync(ArEsRequest4In argIn) {
        ArEsRequest4Out out = new ArEsRequest4Out();
        out.setControl(argIn.getControl());
        out.setStatus(new ArStatusList6());
        PropInfo[] retProps = null;
        retProps = new PropInfo[]{new PropInfo(8, new Value(1))};
        String pluginName = "";
        try {
            this.validateClient(argIn.getControl().getPassword());
            Iterator<PluginEnvelope> ite = this.mPlugins.iterator();
            AREAPluggable pl = null;
            PluginEnvelope envelope = null;
            boolean needSync = false;
            while (ite.hasNext()) {
                try {
                    envelope = ite.next();
                    pluginName = envelope.getPluginName();
                    pl = (AREAPluggable)envelope.mPlugin;
                    needSync = pl.areaNeedSync(ApiToRpcMapping.getInstance().getContextFromControl((ArEsControlStruct4)argIn.getControl(), envelope.mPluginInfo));
                    if (!needSync) continue;
                    break;
                }
                catch (ARException are) {
                    LOGGER.warn((Object)("AREANeedSync() FAIL: for plugin " + envelope.getPluginName()), (Throwable)are);
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)("AREANeedSync() FAIL: for plugin " + envelope.getPluginName()), e);
                }
            }
            retProps[0] = new PropInfo(8, new Value(needSync ? 1 : 0));
            out.setProps(ValueObjectFactory.setPropList(retProps));
        }
        catch (ARException are) {
            LOGGER.error((Object)"AREANeedSync() FAIL: ", (Throwable)are);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(are.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.warn((Object)("AREANeedSync() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName);
            out.setStatus(status);
        }
        return out;
    }

    public ArEsRequest4Out AREAVerifyLogin(ArEsRequest4In argIn) {
        ArEsRequest4Out out = new ArEsRequest4Out();
        out.setControl(argIn.getControl());
        out.setStatus(new ArStatusList6());
        String pluginName = "";
        try {
            this.validateClient(argIn.getControl().getPassword());
            ArPropList propList = argIn.getProps();
            PropInfo[] props = ValueObjectFactory.getPropList(propList);
            String userName = null;
            String password = null;
            String ipAddress = null;
            String authString = null;
            block14: for (int i = 0; i < props.length; ++i) {
                switch (props[i].getPropertyTag()) {
                    case 1: {
                        userName = (String)props[i].getPropertyValue().getValue();
                        continue block14;
                    }
                    case 2: {
                        password = (String)props[i].getPropertyValue().getValue();
                        if (password == null) continue block14;
                        PasswordEncryption pwdEnc = new PasswordEncryption(0, false);
                        try {
                            byte[] decryptedBytes = pwdEnc.decryptPasswordEx(password.getBytes());
                            password = new String(decryptedBytes, ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
                            continue block14;
                        }
                        catch (AREncryptionException ence) {
                            throw new ARException(0, 0, "Decryption Failed");
                        }
                    }
                    case 10: {
                        ipAddress = (String)props[i].getPropertyValue().getValue();
                        continue block14;
                    }
                    case 14: {
                        authString = (String)props[i].getPropertyValue().getValue();
                        continue block14;
                    }
                }
            }
            Iterator<PluginEnvelope> ite = this.mPlugins.iterator();
            AREAResponse resp = null;
            AREAPluggable pl = null;
            PluginEnvelope envelope = null;
            while (ite.hasNext()) {
                try {
                    envelope = ite.next();
                    pluginName = envelope.getPluginName();
                    pl = (AREAPluggable)envelope.mPlugin;
                    resp = pl.areaVerifyLogin(ApiToRpcMapping.getInstance().getContextFromControl((ArEsControlStruct4)argIn.getControl(), envelope.mPluginInfo), userName, password, ipAddress, authString);
                    if (resp.getLoginStatus() != 0 && resp.getLoginStatus() != 3) continue;
                    break;
                }
                catch (ARException are) {
                    LOGGER.warn((Object)("AREAVerifyLogin() FAIL for plugin " + envelope.getPluginName()), (Throwable)are);
                }
                catch (Throwable e) {
                    LOGGER.warn((Object)("AREAVerifyLogin() FAIL for plugin " + envelope.getPluginName()), e);
                }
            }
            PropInfo[] retProps = null;
            boolean isTrustedAreaPlugin = false;
            if (envelope != null) {
                isTrustedAreaPlugin = envelope.isTrustedAreaPlugin();
            }
            retProps = this.responseToPropList(resp, isTrustedAreaPlugin);
            out.setProps(ValueObjectFactory.setPropList(retProps));
        }
        catch (ARException are) {
            LOGGER.error((Object)("AREAVerifyLogin() FAILs in plugin: " + pluginName), (Throwable)are);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(are.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("AREAVerifyLogin() FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName);
            out.setStatus(status);
        }
        return out;
    }

    private PropInfo[] responseToPropList(AREAResponse resp, boolean isTrustedAreaPlugin) {
        PropInfo[] props = null;
        int i = 0;
        if (resp == null) {
            props = new PropInfo[1];
            Value val = new Value(1);
            props[0] = new PropInfo(8, val);
            return props;
        }
        props = new PropInfo[16];
        Value val = new Value(resp.getLoginStatus());
        props[i] = new PropInfo(8, val);
        ++i;
        if (resp.getLoginStatus() == 0) {
            if ((resp.getLicenseMask() & 1) > 0) {
                val = new Value(resp.getLicenseWrite());
                props[i] = new PropInfo(3, val);
                ++i;
            }
            if ((resp.getLicenseMask() & 2) > 0) {
                val = new Value(resp.getLicenseFTS());
                props[i] = new PropInfo(4, val);
                ++i;
            }
            if ((resp.getLicenseMask() & 4) > 0) {
                val = new Value(resp.getLicenseRes1());
                props[i] = new PropInfo(5, val);
                ++i;
            }
            if ((resp.getLicenseMask() & 8) > 0 && resp.getLicenseApps() != null) {
                val = new Value(resp.getLicenseApps());
                props[i] = new PropInfo(15, val);
                ++i;
            }
            if (resp.getGroups() != null) {
                val = new Value(resp.getGroups());
                props[i] = new PropInfo(6, val);
                ++i;
            }
            if (resp.getNotifyMech() <= 3) {
                val = new Value(resp.getNotifyMech());
                props[i] = new PropInfo(11, val);
                ++i;
            }
            if (resp.getEmail() != null) {
                val = new Value(resp.getEmail());
                props[i] = new PropInfo(7, val);
                ++i;
            }
            if (resp.getModTime() != null) {
                val = new Value(resp.getModTime());
                props[i] = new PropInfo(13, val);
                ++i;
            }
            if (isTrustedAreaPlugin) {
                val = new Value(1);
                props[i] = new PropInfo(16, val);
                ++i;
            }
        }
        if (resp.getMessageText() != null) {
            val = new Value(resp.getMessageText());
            props[i] = new PropInfo(9, val);
            ++i;
        }
        if (resp.getLogText() != null) {
            val = new Value(resp.getLogText());
            props[i] = new PropInfo(12, val);
            ++i;
        }
        if (i == 0) {
            props = null;
        }
        return props;
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext context, int eventId) {
        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
        for (PluginEnvelope env : this.mPlugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.onEvent(context, eventId);
            }
            catch (ARException e) {
                status.addAll(e.getLastStatus());
            }
        }
        return status;
    }

    @Override
    void terminatePlugins(ARPluginContext context) {
        for (PluginEnvelope env : this.mPlugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.terminate(context);
            }
            catch (ARException e) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + env.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)e);
            }
        }
    }
}

