/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.encrypt;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.arxdrenc.ArXdrEncryptRPCSvrToCnt;
import com.bmc.arsys.api.arxdrenc.ArXdrUnXdrBufferStream;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.arencrypt.ARPublicPrivateKeyPair;
import com.bmc.arsys.arencrypt.KeyExchangeEncryption;
import com.bmc.arsys.arencrypt.NetWorkDataKeyInfo;
import com.bmc.arsys.arencrypt.NetworkDataEncryption;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import com.bmc.arsys.arrpc.ArEncryptRPCCntToSvr;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginSvrRemoteHostInfo;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.encrypt.AREncryptAPISessionNode;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferDecodingStream;
import org.acplt.oncrpc.XdrDecodingStream;
import org.apache.log4j.Logger;

public class ARPluginServerEncryptionInfo
extends ARPluginSvrRemoteHostInfo {
    private static Logger log = Logger.getLogger(ARPluginServerEncryptionInfo.class);
    private int mDataEncryptionKeyExpiry;
    private int mPublicKeyExpiry;
    private int mEncryptionSecurityPolicy;
    private int mDataEncryptionAlgorithm;
    private int mPublicKeyAlgorithm;
    private int mNumEncSessionHashentries;
    private transient ARPublicPrivateKeyPair mKeypair;
    private Map<Integer, AREncryptAPISessionNode> mMapSessionNodes;
    private static ARPluginServerEncryptionInfo theInstance;
    private static final transient String PLUGIN_USER = "Plug-in Server";
    private static final transient String ARPLUGIN_A = "Plug-in";
    private static final transient String ARPLUGIN_B = "Alert";
    private static final transient String ARPLUGIN_C = "$";
    private static final transient String ARPLUGIN_D = "Msg";
    private static final int PASSWORD_CHAR_SIZE = 30;
    public static final transient int PASSWORD_CHAR_ENCRYPTED_SIZE = 120;

    private ARPluginServerEncryptionInfo() throws ARException {
        log.debug((Object)"Constructor ARPluginServerEncryptionInfo");
        this.mDataEncryptionKeyExpiry = ARPluginServerConfiguration.getInstance().getDataEncryptionKeyExpiry();
        this.mPublicKeyExpiry = ARPluginServerConfiguration.getInstance().getPublicKeyExpiry();
        this.mEncryptionSecurityPolicy = ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy();
        this.mDataEncryptionAlgorithm = ARPluginServerConfiguration.getInstance().getDataEncryptionAlgorithm();
        this.mPublicKeyAlgorithm = ARPluginServerConfiguration.getInstance().getPublicKeyAlgorithm();
        this.mMapSessionNodes = new ConcurrentHashMap<Integer, AREncryptAPISessionNode>();
        try {
            this.mKeypair = new ARPublicPrivateKeyPair(this.mPublicKeyAlgorithm, this.mPublicKeyExpiry);
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8786), (Throwable)e);
            throw new ARException(2, 8786);
        }
    }

    public static synchronized void initialize() throws ARException {
        if (theInstance == null) {
            theInstance = new ARPluginServerEncryptionInfo();
        }
    }

    public static ARPluginServerEncryptionInfo getInstance() throws ARException {
        return theInstance;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public boolean disableAllEncryption() {
        boolean flag = false;
        String osarch = System.getProperty("os.arch");
        if (osarch != null && osarch.equals("sparc") && this.mEncryptionSecurityPolicy == 2) {
            flag = true;
        }
        return flag;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public PrivateKey getPrivateKey() throws ARException {
        log.info((Object)"getPrivateKey");
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            try {
                return this.mKeypair.getPrivateKey();
            }
            catch (AREncryptionException e) {
                log.error((Object)CatalogReader.getInstance().getMessage(8787), (Throwable)e);
                throw new ARException(2, 8787, e.getLocalizedMessage());
            }
        }
    }

    public PublicKey getPublicKey() throws ARException {
        log.info((Object)"getPublicKey");
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            try {
                return this.mKeypair.getPublicKey();
            }
            catch (AREncryptionException e) {
                log.error((Object)CatalogReader.getInstance().getMessage(8788), (Throwable)e);
                throw new ARException(2, 8788);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastCreateTime() {
        Date date;
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            date = this.mKeypair.getLastCreateTime();
        }
        return date;
    }

    public byte[] getPublicKeyBytes() throws ARException {
        log.info((Object)"getPublicKeyBytes");
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            try {
                return this.mKeypair.getPublicKeyBytes();
            }
            catch (AREncryptionException e) {
                log.error((Object)CatalogReader.getInstance().getMessage(8788), (Throwable)e);
                throw new ARException(2, 8788);
            }
        }
    }

    public static byte[] generateRandomBytes() {
        return StringByteUtil.generateRandomBytes((int)20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createAndInsertSessionNode(byte[] svrBytes, byte[] clntBytes) {
        log.info((Object)"createAndInsertSessionNode");
        AREncryptAPISessionNode node = new AREncryptAPISessionNode(this.mDataEncryptionAlgorithm, svrBytes, clntBytes);
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            this.mMapSessionNodes.put(node.getSessionId(), node);
        }
        return node.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unxdrAndDecryptPreMasterkey(int sessionId, byte[] databytes) throws ARException {
        log.info((Object)"unxdrAndDecryptPreMasterkey");
        byte[] bytes = null;
        try {
            byte[] dataTounxdr;
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            log.debug((Object)("KeyExchange Create new encryption session node for sessionId: " + sessionId));
            if (node != null) {
                ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
                synchronized (aRPublicPrivateKeyPair) {
                    KeyExchangeEncryption keyEncryption = new KeyExchangeEncryption((ARPPKey)this.mKeypair);
                    dataTounxdr = keyEncryption.decrypt(databytes, (Key)this.mKeypair.getPrivateKey());
                }
            } else {
                throw new ARException(2, 9002);
            }
            bytes = ArXdrUnXdrBufferStream.unXdrBytes((byte[])dataTounxdr);
            node.setPreMasterKey(bytes);
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
            throw new ARException(2, 9002);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AREncryptAPISessionNode getSessionNode(int sessionId) {
        AREncryptAPISessionNode node;
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            node = this.mMapSessionNodes.get(sessionId);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionNode(int sessionId) {
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            this.mMapSessionNodes.remove(sessionId);
        }
    }

    public void generateServerAndClientDataKey(int sessionId, byte[] preMasterKey) throws ARException {
        log.info((Object)"generateServerAndClientDataKey");
        try {
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(9002));
                throw new ARException(2, 9002);
            }
            NetWorkDataKeyInfo datakey = new NetWorkDataKeyInfo();
            datakey.setEncAlgorithmParam(this.mDataEncryptionAlgorithm);
            datakey.genDataEncKeys(node.getEncTransferObject());
            node.setServerClientDataKey(datakey);
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
            throw new ARException(2, 9002);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CleanUpTimedoutSessions() {
        log.info((Object)"CleanUpTimedoutSessions");
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            Set<Integer> keys = this.mMapSessionNodes.keySet();
            if (keys.size() > 0) {
                for (Integer key : keys) {
                    AREncryptAPISessionNode node = this.mMapSessionNodes.get(key);
                    if (node == null || System.currentTimeMillis() <= node.getCreateTime() + (long)this.mDataEncryptionKeyExpiry && node.getEncryptionAlgorithm() == this.mDataEncryptionAlgorithm) continue;
                    this.mMapSessionNodes.remove(key);
                }
            }
        }
    }

    public byte[] XdrAndEncryptSessionId(int sessionId) throws ARException {
        byte[] sessionBytes;
        block4: {
            log.info((Object)("XdrAndEncryptSessionId: " + sessionId));
            sessionBytes = null;
            try {
                AREncryptAPISessionNode node = this.getSessionNode(sessionId);
                if (node != null) {
                    byte[] xdredBytes = ArXdrUnXdrBufferStream.xdrInt((int)sessionId);
                    ARDataKey datakey = node.getServerDataKey();
                    if (datakey != null) {
                        NetworkDataEncryption dataEncryptor = new NetworkDataEncryption(false, false);
                        sessionBytes = dataEncryptor.encryptData(datakey, xdredBytes);
                    }
                    break block4;
                }
                log.error((Object)CatalogReader.getInstance().getMessage(9002));
                throw new ARException(2, 9002);
            }
            catch (Exception e) {
                log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
                throw new ARException(2, 9002);
            }
        }
        return sessionBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XdrAble encryptAndXdrData(int sessionId, byte[] bufToencode) throws OncRpcException {
        log.debug((Object)"encryptAndXdrData");
        NetworkDataEncryption dataEnc = new NetworkDataEncryption(false, false);
        try {
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node != null) {
                byte[] encryptedData;
                int errorCode = 0;
                AREncryptAPISessionNode aREncryptAPISessionNode = node;
                synchronized (aREncryptAPISessionNode) {
                    ARDataKey dataKey = node.getServerDataKey();
                    encryptedData = dataEnc.encryptData(dataKey, bufToencode);
                }
                ArXdrEncryptRPCSvrToCnt arXdrEnc = new ArXdrEncryptRPCSvrToCnt(new byte[0], 0);
                arXdrEnc.setOut(encryptedData);
                arXdrEnc.setErrorCode(errorCode);
                return arXdrEnc;
            }
            log.error((Object)"Encryption info not found for the API session. Key Exchange required.");
            throw new OncRpcAuthenticationException(2);
        }
        catch (OncRpcAuthenticationException oae) {
            throw oae;
        }
        catch (Throwable e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8784), e);
            throw new OncRpcException(1, e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unXdrAndDecryptData(byte[] bufToDecode, ArEncryptionContext conn) throws OncRpcException {
        log.debug((Object)"unXdrAndDecryptData");
        ArEncryptRPCCntToSvr arXdrEnc = null;
        XdrBufferDecodingStream xdr = null;
        try {
            arXdrEnc = new ArEncryptRPCCntToSvr();
            xdr = new XdrBufferDecodingStream(bufToDecode, bufToDecode.length + 4);
            xdr.beginDecoding();
            arXdrEnc.xdrDecode((XdrDecodingStream)xdr);
            byte[] encryptedXdrData = arXdrEnc.getIn();
            int sessionId = arXdrEnc.getSessionId();
            conn.setCurrentSessionId(sessionId);
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node != null) {
                byte[] rst;
                Object object = node;
                synchronized (object) {
                    NetworkDataEncryption dataEnc = new NetworkDataEncryption(false, false);
                    rst = dataEnc.decryptData(node.getClientDataKey(), encryptedXdrData);
                }
                object = rst;
                return object;
            }
            try {
                log.debug((Object)("Encryption info not found for the API session. Key Exchange required for sessionId: " + sessionId));
                throw new OncRpcAuthenticationException(2);
            }
            catch (OncRpcAuthenticationException oae) {
                throw oae;
            }
            catch (Throwable e) {
                log.error((Object)CatalogReader.getInstance().getMessage(8785), e);
                throw new OncRpcException(2, e, e.getMessage());
            }
        }
        finally {
            try {
                xdr.endDecoding();
                xdr.close();
                xdr = null;
            }
            catch (Exception e) {
                log.debug((Object)("DecodingStream can not be closes." + e.getLocalizedMessage()));
            }
        }
    }

    public String toPswdString(String str) throws ARException {
        return this.toPswdString(str, ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
    }

    public String toPswdString(String str, String charset) throws ARException {
        String rtnStr = "";
        byte[] buf = str.getBytes();
        if (buf.length == 120) {
            PasswordEncryption pwdEnc = new PasswordEncryption(0, false);
            try {
                byte[] decryptedBuf = pwdEnc.decryptPasswordEx(str.getBytes());
                try {
                    rtnStr = new String(decryptedBuf, charset);
                }
                catch (UnsupportedEncodingException e) {
                    rtnStr = new String(decryptedBuf);
                    log.warn((Object)e.getLocalizedMessage());
                }
            }
            catch (AREncryptionException e) {
                throw new ARException(2, e.getErrorNum(), e.getLocalizedMessage());
            }
        }
        return rtnStr;
    }

    public String doMagic(String str) {
        String ret = "";
        char[] temp = new char[30];
        char[] retArray = new char[30];
        StringBuilder builder = new StringBuilder(30);
        builder.append(ARPLUGIN_A);
        builder.append(ARPLUGIN_D);
        builder.append(ARPLUGIN_C);
        builder.append(ARPLUGIN_B);
        builder.append(ARPLUGIN_C);
        ret = builder.toString();
        int size = ret.length();
        if (str != null && !str.equals("")) {
            StringBuilder newBuilder = new StringBuilder(str).reverse();
            String conf = newBuilder.toString();
            if (conf.length() < 30 - size) {
                builder.append(conf);
                return builder.toString();
            }
            char[] confArray = conf.toCharArray();
            char[] newArray = builder.toString().toCharArray();
            System.arraycopy(confArray, 0, temp, 30 - confArray.length, confArray.length);
            for (int i = 0; i < 30; ++i) {
                retArray[i] = (char)(newArray[i] ^ temp[i]);
                if (retArray[i] != '\u0000' && retArray[i] != '\n' && retArray[i] != '\r') continue;
                retArray[i] = temp[i];
            }
            return new String(retArray);
        }
        return ret;
    }

    static {
        log.debug((Object)("os.name: " + System.getProperty("os.name")));
        log.debug((Object)("os.arch: " + System.getProperty("os.arch")));
        log.debug((Object)("java.vendor: " + System.getProperty("java.vendor")));
    }
}

