/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfigKey;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginServerConfiguration {
    private static final String PLUGIN_SERVER_WORKING_DIRECTORY = "pluginWork";
    private static Logger log = Logger.getLogger(ARPluginServerConfiguration.class);
    private static ARPluginServerConfiguration theInstance = new ARPluginServerConfiguration();
    private static String AR_PLUGIN_SERVER_CONFIG_FILE = "pluginsvr_config.xml";
    public static String DEFAULT_SET_NAME = "NONE";
    private static String SET_NAME_PREFIX = "PluginSet_";
    private static int SETCOUNT = 0;
    private static String AR_PLUGIN_USER_DEFINED_TAG = "userDefined";
    private XMLConfiguration mConfig;
    private InetAddress mHostID;
    private int mPort;
    private String mInstallPath = "";
    private String[] mCmdLineArgs;
    private int workQueueTaskThreshold;
    private long workQueueMonitorLogInterval;
    private int numCoreThreads;
    private int maxThreads;
    private long mThreadTimeout;
    private int numSelectorThreads;
    private int mDataEncryptionKeyExpiry = ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue();
    private int mPublicKeyExpiry = ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue();
    private int mEncryptionSecurityPolicy = ARPluginServerConfigKey.EncPolicy.getIntDefaultValue();
    private int mDataEncryptionAlgorithm = ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue();
    private int mPublicKeyAlgorithm = ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue();
    private int mNumEncSessionHashentries;
    private HashMap<String, PluginGroup> mPluginGroups;
    private ArrayList<ARPluginDefinition> mTopLevelPlugins;
    private ArrayList<ARPluginDefinition> mLegacyPlugins;
    private HashMap<String, String> mPluginNames;
    private HashMap<String, Integer> mPluginCount;
    private HashMap<String, Integer> mGroupCount;
    private ConcurrentHashMap<String, Object> mARConfig;
    private String mPluginAuth;
    private String mPluginPass;
    private boolean mbRegPortMapper = false;
    private static boolean mbSupportNativePluginHost = false;
    private static boolean mbLoadNativePluginHost = false;
    private int mReloadDelay = ARPluginServerConfigKey.ReloadDelay.getIntDefaultValue();
    private FileChangedReloadingStrategy fcrs;
    private String missingParam;
    static HashMap<String, String> pluginAccessibleConfig = new HashMap();

    private ARPluginServerConfiguration() {
        this.mLegacyPlugins = new ArrayList();
        this.mPluginNames = new HashMap();
        this.mPluginCount = new HashMap();
        this.mGroupCount = new HashMap();
        this.mARConfig = new ConcurrentHashMap();
    }

    private void initializeLogging() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("log4j_pluginsvr.xml");
        if (url != null) {
            DOMConfigurator.configure((URL)url);
        }
        String filePathName = "";
        try {
            String fileName;
            int endIdx;
            Logger root = Logger.getRootLogger();
            Appender app = root.getAppender("PluginLog");
            if (app != null && app instanceof RollingFileAppender && (endIdx = (fileName = ((RollingFileAppender)app).getFile()).lastIndexOf(".log")) > 0 && fileName.length() >= endIdx) {
                filePathName = fileName.substring(0, endIdx);
            }
        }
        catch (Throwable e) {
            filePathName = "";
        }
        this.redirecSystemLog(filePathName);
    }

    private void redirecSystemLog(String filePathNamePrefix) {
        block11: {
            FileOutputStream errOutputStream;
            PrintStream errPrintStream;
            String syserrfileName;
            block10: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = sdf.format(Calendar.getInstance().getTime());
                String sysoutfileName = filePathNamePrefix + "-stdout-" + dateStr + ".log";
                syserrfileName = filePathNamePrefix + "-stderr-" + dateStr + ".log";
                PrintStream outPrintStream = null;
                errPrintStream = null;
                FileOutputStream outOutputStream = null;
                errOutputStream = null;
                try {
                    File sysoutlogFile = new File(sysoutfileName);
                    if (!sysoutlogFile.exists()) {
                        sysoutlogFile.createNewFile();
                    }
                    outOutputStream = new FileOutputStream(sysoutfileName, true);
                    outPrintStream = new PrintStream(outOutputStream);
                    System.setOut(outPrintStream);
                }
                catch (IOException e) {
                    log.warn((Object)"Error encountered while redirecting stdout to the plugin server stdout log", (Throwable)e);
                    if (outOutputStream == null) break block10;
                    try {
                        outOutputStream.close();
                    }
                    catch (IOException e1) {
                        log.debug((Object)("outputStream can not be closes." + e1.getLocalizedMessage()));
                    }
                }
            }
            try {
                File syserrlogFile = new File(syserrfileName);
                if (!syserrlogFile.exists()) {
                    syserrlogFile.createNewFile();
                }
                errOutputStream = new FileOutputStream(syserrfileName, true);
                errPrintStream = new PrintStream(errOutputStream);
                System.setErr(errPrintStream);
            }
            catch (IOException e) {
                log.warn((Object)"Error encountered while redirecting stderr to the plugin server stderr log", (Throwable)e);
                if (errOutputStream == null) break block11;
                try {
                    errOutputStream.close();
                }
                catch (IOException e1) {
                    log.debug((Object)("errOutputStream can not be closes." + e1.getLocalizedMessage()));
                }
            }
        }
    }

    public void initialize(String[] args) throws ARException {
        this.mCmdLineArgs = args;
        try {
            this.initializeLogging();
            this.parseCommandLineArguments(args);
            URL url = Thread.currentThread().getContextClassLoader().getResource(AR_PLUGIN_SERVER_CONFIG_FILE);
            if (url == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(8768));
                System.out.println(CatalogReader.getInstance().getMessage(8768));
                throw new ARException(2, 8768);
            }
            this.mConfig = new XMLConfiguration(url);
            log.info((Object)("Loading the Configuration File ::" + url.toString()));
            this.fcrs = new FileChangedReloadingStrategy();
            this.mReloadDelay = this.mConfig.getInt(ARPluginServerConfigKey.ReloadDelay.getKey(), ARPluginServerConfigKey.ReloadDelay.getIntDefaultValue());
            this.mEncryptionSecurityPolicy = this.mConfig.getInt(ARPluginServerConfigKey.EncPolicy.getKey(), ARPluginServerConfigKey.EncPolicy.getIntDefaultValue());
            this.mPublicKeyAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyAlg.getKey(), ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue());
            this.mPublicKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyExpiry.getKey(), ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue());
            this.mDataEncryptionAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.DataEncryptionAlg.getKey(), ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue());
            this.mDataEncryptionKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.DataKeyExpiry.getKey(), ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue());
            this.readThreadPoolExecutorConfigValue();
            try {
                this.mEncryptionSecurityPolicy = ARDataKey.validateNetworkDataEncConfigSetting((int)this.mEncryptionSecurityPolicy, (int)this.mPublicKeyAlgorithm, (int)this.mDataEncryptionAlgorithm);
            }
            catch (AREncryptionException e) {
                log.error((Object)CatalogReader.getInstance().getMessage(e.getErrorNum()), (Throwable)e);
                System.out.println(CatalogReader.getInstance().getMessage(e.getErrorNum()));
                throw new ARException(2, 8768, e.getLocalizedMessage());
            }
            this.mPort = this.mConfig.getInt(ARPluginServerConfigKey.TcpPort.getKey(), ARPluginServerConfigKey.TcpPort.getIntDefaultValue());
            this.mPluginAuth = this.mConfig.getString(ARPluginServerConfigKey.PluginAuth.getKey(), ARPluginServerConfigKey.PluginAuth.getDefaultValue());
            this.mbRegPortMapper = this.mConfig.getBoolean(ARPluginServerConfigKey.RegPortMapper.getKey(), ARPluginServerConfigKey.RegPortMapper.getBoolDefaultValue());
            mbSupportNativePluginHost = this.mConfig.getBoolean(ARPluginServerConfigKey.SupportNativePluginHost.getKey(), ARPluginServerConfigKey.SupportNativePluginHost.getBoolDefaultValue());
            mbLoadNativePluginHost = this.mConfig.getBoolean(ARPluginServerConfigKey.LoadNativePluginHost.getKey(), ARPluginServerConfigKey.LoadNativePluginHost.getBoolDefaultValue());
            if (!mbSupportNativePluginHost && mbLoadNativePluginHost) {
                mbLoadNativePluginHost = false;
                log.error((Object)"Java plug-in server does not support C plug-ins. Contact Customer Support for details.");
            }
            if (this.mPort < 0 || this.mPort > 65535) {
                log.error((Object)CatalogReader.getInstance().getMessage(8782));
                log.error((Object)"Using portmapper for an available port");
                this.mbRegPortMapper = true;
                this.mPort = 0;
            }
            if (this.mPort == 0) {
                this.mbRegPortMapper = true;
                this.mPort = 0;
                log.info((Object)"Using portmapper for an available port");
            }
            String path = ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey();
            this.setupPluginAccessibleValues();
            this.mTopLevelPlugins = this.loadPlugins((HierarchicalConfiguration)this.mConfig, path, path);
            this.mPluginGroups = this.loadPluginGroups(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.PluginSet.getKey(), DEFAULT_SET_NAME);
            this.fcrs.setRefreshDelay((long)this.mReloadDelay);
            this.fcrs.setConfiguration((FileConfiguration)this.mConfig);
            this.mConfig.setReloadingStrategy((ReloadingStrategy)this.fcrs);
            this.setupPluginAuth();
        }
        catch (ConfigurationException cex) {
            log.error((Object)CatalogReader.getInstance().getMessage(8768), (Throwable)cex);
            System.out.println(CatalogReader.getInstance().getMessage(8768) + cex.getLocalizedMessage());
            throw new ARException(2, 8768, cex.getLocalizedMessage());
        }
    }

    private void readThreadPoolExecutorConfigValue() {
        this.workQueueTaskThreshold = this.mConfig.getInt(ARPluginServerConfigKey.WorkQueueTaskThreshold.getKey(), ARPluginServerConfigKey.WorkQueueTaskThreshold.getIntDefaultValue());
        this.workQueueMonitorLogInterval = this.mConfig.getLong(ARPluginServerConfigKey.WorkQueueMonitorLogInterval.getKey(), ARPluginServerConfigKey.WorkQueueMonitorLogInterval.getLongDefaultValue());
        this.numCoreThreads = this.mConfig.getInt(ARPluginServerConfigKey.NumCoreThreads.getKey(), ARPluginServerConfigKey.NumCoreThreads.getIntDefaultValue());
        this.maxThreads = this.mConfig.getInt(ARPluginServerConfigKey.MaxThreads.getKey(), ARPluginServerConfigKey.MaxThreads.getIntDefaultValue());
        this.numSelectorThreads = this.mConfig.getInt(ARPluginServerConfigKey.NumSelectorThreads.getKey(), ARPluginServerConfigKey.NumSelectorThreads.getIntDefaultValue());
        this.mThreadTimeout = this.mConfig.getLong(ARPluginServerConfigKey.ExcessCoreThreadsIdleKeepAliveTimeInSecond.getKey(), ARPluginServerConfigKey.ExcessCoreThreadsIdleKeepAliveTimeInSecond.getLongDefaultValue());
        if (this.maxThreads < this.numCoreThreads) {
            log.error((Object)"maxThreads configured bigger than coreWorkerThreads.");
            log.info((Object)"maxWorkerThreads is set to be same as coreWorkerThreads by plugin server");
            this.maxThreads = this.numCoreThreads;
        }
    }

    private void setupPluginAccessibleValues() {
        pluginAccessibleConfig.put("port", String.valueOf(this.mPort));
        pluginAccessibleConfig.put("numCoreThreads", String.valueOf(this.numCoreThreads));
        log.debug((Object)"Plugin Accessible Configured Values:");
        log.debug((Object)("port " + pluginAccessibleConfig.get("port")));
        log.debug((Object)("numCoreThreads " + pluginAccessibleConfig.get("numCoreThreads")));
    }

    private boolean isValidPluginConfiguration(ARPluginDefinition def) {
        boolean yesorno = true;
        String name = def.getPluginName();
        String code = def.getPluginCode();
        String filename = def.getFileName();
        String classname = def.getClassName();
        if (name == null || name.equals("")) {
            String string = this.missingParam = this.missingParam != null ? this.missingParam : "<name/>";
            if (filename == null || !filename.endsWith(".dll") && !filename.endsWith(".so") && !filename.endsWith(".sl") && !filename.endsWith(".a")) {
                this.missingParam = this.missingParam != null ? this.missingParam : "<filename/>";
                return false;
            }
            name = "";
        }
        if (code == null || code.equals("")) {
            code = "JAVA";
        } else if (!code.equalsIgnoreCase("C") && !code.equalsIgnoreCase("JAVA")) {
            this.missingParam = this.missingParam != null ? this.missingParam : "<code/>";
            return false;
        }
        if (code.equalsIgnoreCase("JAVA") && (classname == null || classname.equals(""))) {
            this.missingParam = this.missingParam != null ? this.missingParam : "<classname/>";
            return false;
        }
        if (code.equals("C") && (filename == null || filename.equals(""))) {
            this.missingParam = this.missingParam != null ? this.missingParam : "<filename/>";
            return false;
        }
        return yesorno;
    }

    private ArrayList<ARPluginDefinition> loadPlugins(HierarchicalConfiguration conf, String absolutePath, String path) {
        ArrayList<ARPluginDefinition> plugins = new ArrayList<ARPluginDefinition>();
        List fields = conf.configurationsAt(path);
        for (HierarchicalConfiguration sub : fields) {
            ARPluginDefinition pluginDef = null;
            this.missingParam = null;
            pluginDef = this.loadPluginsDef(sub);
            if (pluginDef == null) continue;
            String pluginName = pluginDef.getPluginName();
            if (this.mPluginNames.containsKey(pluginName)) {
                int count = this.mPluginCount.get(pluginName) + 1;
                this.mPluginCount.put(pluginName, count);
                if ((pluginName == null || pluginName.equals("")) && pluginDef.getPluginCode().equals("C") ? this.mLegacyPlugins.contains(pluginDef) && count > 1 : count > 1) continue;
            }
            this.mPluginNames.put(pluginName, absolutePath);
            this.mPluginCount.put(pluginName, 1);
            if (pluginDef.getFileName() != null && (pluginDef.getPluginCode().equalsIgnoreCase("C") || pluginDef.getFileName().endsWith(".dll") || pluginDef.getFileName().endsWith(".so") || pluginDef.getFileName().endsWith(".sl") || pluginDef.getFileName().endsWith(".a"))) {
                this.mLegacyPlugins.add(pluginDef);
                continue;
            }
            plugins.add(pluginDef);
        }
        return plugins;
    }

    private ARPluginDefinition loadPluginsDef(HierarchicalConfiguration conf) {
        String pluginName = conf.getString(ARPluginServerConfigKey.PluginName.getKey());
        String pluginType = conf.getString(ARPluginServerConfigKey.PluginType.getKey());
        String fileName = conf.getString(ARPluginServerConfigKey.PluginFilename.getKey());
        String code = conf.getString(ARPluginServerConfigKey.PluginCode.getKey());
        String className = conf.getString(ARPluginServerConfigKey.PluginClassname.getKey());
        int version = conf.getInt(ARPluginServerConfigKey.PluginVersion.getKey(), ARPluginServerConfigKey.PluginVersion.getIntDefaultValue());
        ARPluginDefinition def = new ARPluginDefinition(pluginName, fileName, className, code, pluginType, version);
        ArrayList paths = new ArrayList();
        paths.addAll(conf.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey()));
        if (paths != null && paths.size() > 0) {
            ArrayList<String> jars = new ArrayList<String>();
            ArrayList<String> folders = new ArrayList<String>();
            for (HierarchicalConfiguration classpath : paths) {
                String type = classpath.getString("[@type]");
                String folder = null;
                String jarfile = null;
                if (type != null && type.equals("path")) {
                    folder = (String)classpath.getRoot().getValue();
                } else if (type != null && type.equals("location")) {
                    jarfile = (String)classpath.getRoot().getValue();
                }
                if (folder != null) {
                    folders.add(folder);
                }
                if (jarfile == null) continue;
                jars.add(jarfile);
            }
            def.setClassPathFolders(folders);
            def.setClassPathJars(jars);
        }
        if (!this.isValidPluginConfiguration(def)) {
            String id = def.getPluginName();
            String string = id = id == null ? className : id;
            if (def.getPluginName() == null || def.getPluginName().equals("")) {
                id = def.getFileName();
            }
            log.error((Object)(CatalogReader.getInstance().getMessage(8769) + " " + this.missingParam + ": " + id));
            log.error((Object)("Not Loading the Plugin:" + id));
            return null;
        }
        return def;
    }

    private HashMap<String, PluginGroup> loadPluginGroups(String path, String parent) {
        List fields = this.mConfig.configurationsAt(path);
        HashMap<String, PluginGroup> groups = new HashMap<String, PluginGroup>();
        for (HierarchicalConfiguration sub : fields) {
            String groupName = sub.getString("[@name]");
            if (groupName == null) {
                groupName = SET_NAME_PREFIX + SETCOUNT++;
            }
            if (groups.containsKey(groupName)) {
                int count = this.mGroupCount.get(groupName) + 1;
                this.mGroupCount.put(groupName, count);
                if (count <= 2) continue;
                log.warn((Object)(CatalogReader.getInstance().getMessage(8771) + " " + groupName));
                continue;
            }
            ArrayList<ARPluginDefinition> plugins = this.loadPlugins(sub, path + ARPluginServerConfigKey.Plugins.getKey(), ARPluginServerConfigKey.Plugins.getKey().substring(1));
            HashMap<String, PluginGroup> subgroups = this.loadPluginGroups(path + ARPluginServerConfigKey.PluginSet.getKey(), groupName);
            PluginGroup group = new PluginGroup(parent, subgroups, plugins);
            List paths = sub.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey());
            if (paths != null && paths.size() > 0) {
                ArrayList<String> jars = new ArrayList<String>();
                ArrayList<String> folders = new ArrayList<String>();
                for (HierarchicalConfiguration classpath : paths) {
                    String type = classpath.getString("[@type]");
                    String folder = null;
                    String jarfile = null;
                    if (type != null && type.equals("path")) {
                        folder = (String)classpath.getRoot().getValue();
                    } else if (type != null && type.equals("location")) {
                        jarfile = (String)classpath.getRoot().getValue();
                    }
                    if (folder != null) {
                        folders.add(folder);
                    }
                    if (jarfile == null) continue;
                    jars.add(jarfile);
                }
                group.setClassPathFolders(folders);
                group.setClassPathJars(jars);
            }
            groups.put(groupName, group);
            this.mGroupCount.put(groupName, 1);
        }
        return groups;
    }

    public static ARPluginServerConfiguration getInstance() {
        return theInstance;
    }

    public static boolean getLoadNativePluginhost() {
        if (!mbSupportNativePluginHost && mbLoadNativePluginHost) {
            mbLoadNativePluginHost = false;
        }
        return mbLoadNativePluginHost;
    }

    public String[] getCmdLineArgs() {
        return this.mCmdLineArgs;
    }

    public String getConfigValue(String pluginName, String key) {
        String value = null;
        if (pluginName == null && key != null) {
            value = this.getPluginAccessiblePluginSvrConfigValue(key);
        } else if (pluginName != null && key != null) {
            value = this.getPluginConfigValue(pluginName, key);
        }
        return value;
    }

    private String getPluginAccessiblePluginSvrConfigValue(String key) {
        String value = null;
        if (key != null && pluginAccessibleConfig.containsKey(key)) {
            value = pluginAccessibleConfig.get(key);
        }
        return value;
    }

    private synchronized String getPluginConfigValue(String pluginName, String key) {
        String path;
        String value = null;
        if (pluginName != null && key != null && (path = this.mPluginNames.get(pluginName)) != null && !path.equals("")) {
            List fields = this.mConfig.configurationsAt(path);
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (name == null || !name.equals(pluginName)) continue;
                value = sub.getString(AR_PLUGIN_USER_DEFINED_TAG + "." + key);
                break;
            }
        }
        return value;
    }

    public synchronized void setConfigValue(String pluginName, String key, Object value) {
        String path;
        if (pluginName != null && key != null && (path = this.mPluginNames.get(pluginName)) != null && !path.equals("")) {
            List fields = this.mConfig.configurationsAt(path);
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (!name.equals(pluginName)) continue;
                StringBuffer newKey = new StringBuffer();
                if (!key.startsWith(AR_PLUGIN_USER_DEFINED_TAG)) {
                    newKey.append(AR_PLUGIN_USER_DEFINED_TAG + ".");
                    newKey.append(key);
                } else {
                    newKey.append(key);
                }
                sub.setProperty(newKey.toString(), value);
                break;
            }
        }
    }

    public synchronized void saveConfiguration() {
        try {
            this.mConfig.save();
        }
        catch (ConfigurationException cex) {
            log.warn((Object)CatalogReader.getInstance().getMessage(8769), (Throwable)cex);
        }
    }

    public long getThreadTimeout() {
        return this.mThreadTimeout;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostName() {
        return this.mHostID.getHostName();
    }

    public InetAddress getHostID() {
        return this.mHostID;
    }

    public int getNumCoreThreads() {
        return this.numCoreThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public ArrayList<ARPluginDefinition> getConfiguredPlugins() {
        return this.mTopLevelPlugins;
    }

    public ArrayList<ARPluginDefinition> getNativePlugins() {
        return this.mLegacyPlugins;
    }

    public HashMap<String, PluginGroup> getConfiguredPluginGroups() {
        return this.mPluginGroups;
    }

    public boolean isRegisteredWithPortMapper() {
        return this.mbRegPortMapper;
    }

    public void setMaxThreads(int queueType, int numThreads) {
        this.maxThreads = numThreads;
    }

    public void setMinThreads(int queutType, int numThreads) {
        this.numCoreThreads = numThreads;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public String getWorkingDirectory() {
        if (this.mInstallPath.endsWith(File.separator)) {
            return this.mInstallPath + PLUGIN_SERVER_WORKING_DIRECTORY;
        }
        return this.mInstallPath + File.separator + PLUGIN_SERVER_WORKING_DIRECTORY;
    }

    public String getARConfigEntry(String key) {
        StringBuffer ret = new StringBuffer("");
        Object o = this.mARConfig.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List list = (List)o;
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                ret.append(s);
                ret.append(";");
            }
        } else {
            ret.append((String)o);
        }
        return ret.toString();
    }

    public Object getARConfigItem(String key) {
        Object o = this.mARConfig.get(key);
        return o;
    }

    public String getPluginPassword() {
        return this.mPluginPass;
    }

    public void parseCommandLineArguments(String[] args) throws ARException {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String path;
                if (i < args.length && args[i].equals("-x")) {
                    String hostName;
                    String string = hostName = ++i < args.length ? args[i] : null;
                    if (hostName != null && !hostName.equals("")) {
                        try {
                            this.mHostID = InetAddress.getByName(hostName);
                            continue;
                        }
                        catch (UnknownHostException ue) {
                            try {
                                this.mHostID = InetAddress.getLocalHost();
                                continue;
                            }
                            catch (UnknownHostException e) {
                                log.error((Object)CatalogReader.getInstance().getMessage(8783), (Throwable)ue);
                                throw new ARException(2, 8783);
                            }
                        }
                    }
                    try {
                        this.mHostID = InetAddress.getLocalHost();
                        continue;
                    }
                    catch (UnknownHostException e) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8781));
                        throw new ARException(2, 8781);
                    }
                }
                if (i < args.length && args[i].equals("-t")) {
                    String port;
                    String string = port = ++i < args.length ? args[i] : null;
                    if (port == null || port.equals("")) continue;
                    try {
                        this.mPort = Integer.parseInt(port);
                    }
                    catch (NumberFormatException ne) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8782), (Throwable)ne);
                    }
                    continue;
                }
                if (i >= args.length || !args[i].equals("-i")) continue;
                String string = path = ++i < args.length ? args[i] : null;
                if (path != null && !path.equals("")) {
                    File file = new File(path);
                    if (!file.exists() || !file.isDirectory()) {
                        log.error((Object)("Invalid path for install folder " + path));
                        this.mInstallPath = "";
                        continue;
                    }
                    this.mInstallPath = path;
                    if (this.mInstallPath.endsWith("/") || this.mInstallPath.endsWith("\\")) continue;
                    this.mInstallPath = this.mInstallPath + "/";
                    continue;
                }
                this.mInstallPath = "";
                log.error((Object)CatalogReader.getInstance().getMessage(8781));
                System.out.println(CatalogReader.getInstance().getMessage(8781));
                throw new ARException(2, 8781);
            }
            if (this.mHostID == null) {
                try {
                    this.mHostID = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.error((Object)CatalogReader.getInstance().getMessage(8781));
                    throw new ARException(2, 8781);
                }
            }
        } else {
            System.out.println("Invalid command line arguments");
            this.printUsage();
            log.error((Object)CatalogReader.getInstance().getMessage(8781));
            throw new ARException(2, 8781);
        }
        this.loadARConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadARConfigFile() {
        if (this.mInstallPath != null && !this.mInstallPath.equals("")) {
            BufferedReader input = null;
            ConcurrentHashMap<String, Object> concurrentHashMap = this.mARConfig;
            synchronized (concurrentHashMap) {
                this.mARConfig.clear();
                try {
                    String arInstallPath = this.mInstallPath + File.separator + "conf" + File.separator + "ar.";
                    String arConfFile = arInstallPath + "cfg";
                    File confFile = new File(arConfFile);
                    if (!confFile.exists() || !confFile.isFile()) {
                        arConfFile = arInstallPath + "conf";
                        confFile = new File(arConfFile);
                    }
                    if (confFile.exists() && confFile.isFile()) {
                        input = new BufferedReader(new FileReader(confFile));
                        String line = null;
                        while ((line = input.readLine()) != null) {
                            int index;
                            if ("".equals(line) || (index = line.indexOf(58)) <= 0) continue;
                            String key = line.substring(0, index).trim();
                            String value = line.substring(index + 1).trim();
                            if (this.mARConfig.containsKey(key)) {
                                Object o = this.mARConfig.get(key);
                                if (o instanceof List) {
                                    ((List)o).add(value);
                                    this.mARConfig.put(key, o);
                                    continue;
                                }
                                ArrayList<Object> list = new ArrayList<Object>();
                                list.add(o);
                                list.add(value);
                                this.mARConfig.put(key, list);
                                continue;
                            }
                            this.mARConfig.put(key, value);
                        }
                    } else {
                        log.error((Object)("Could not find AR config file " + arConfFile));
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Could not load AR config file ", e);
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception ie) {
                            log.debug((Object)("config file can not be closes." + ie.getLocalizedMessage()));
                        }
                    }
                }
            }
        }
    }

    private void setupPluginAuth() throws ARException {
        String conf = null;
        if (this.mPluginAuth == null || this.mPluginAuth.equals("")) {
            Object o = this.getARConfigItem("Plugin-Password");
            if (o != null) {
                String passwordForThisServer = null;
                if (o instanceof String) {
                    passwordForThisServer = (String)o;
                } else {
                    List list = (List)o;
                    for (int i = 0; i < list.size() && (passwordForThisServer = (String)list.get(i)) == null; ++i) {
                    }
                }
                if (passwordForThisServer != null && passwordForThisServer.length() > 0) {
                    conf = passwordForThisServer;
                }
            }
        } else {
            conf = this.mPluginAuth;
        }
        this.mPluginPass = conf != null ? (ARPluginServerEncryptionInfo.getInstance().disableAllEncryption() ? null : ARPluginServerEncryptionInfo.getInstance().toPswdString(conf, "utf-8")) : null;
    }

    private void printUsage() {
        System.out.println("Usage: java ARPluginServerMain -x hostname -t portnum");
    }

    public long getReloadDelay() {
        return this.mReloadDelay;
    }

    public HashMap<String, PluginGroup> loadNewPluginGroups() {
        return this.loadPluginGroups(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.PluginSet.getKey(), DEFAULT_SET_NAME);
    }

    public ArrayList<ARPluginDefinition> loadNewPlugins() {
        String path = ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey();
        return this.loadPlugins((HierarchicalConfiguration)this.mConfig, path, path);
    }

    public synchronized void updateConfig(String[] args) {
        if (this.mConfig.getReloadingStrategy().reloadingRequired()) {
            try {
                this.mConfig = new XMLConfiguration(Thread.currentThread().getContextClassLoader().getResource(AR_PLUGIN_SERVER_CONFIG_FILE));
                this.mConfig.setReloadingStrategy((ReloadingStrategy)this.fcrs);
                this.mConfig.getInt(ARPluginServerConfigKey.TcpPort.getKey(), ARPluginServerConfigKey.TcpPort.getIntDefaultValue());
                this.mConfig.configurationsAt(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey());
                this.discoverNewPlugins(args);
                this.mConfig.getReloadingStrategy().reloadingPerformed();
            }
            catch (ConfigurationException cex) {
                log.error((Object)CatalogReader.getInstance().getMessage(8768), (Throwable)cex);
                System.out.println(CatalogReader.getInstance().getMessage(8768) + cex.getLocalizedMessage());
            }
        }
    }

    private void discoverNewPlugins(String[] args) {
        ArrayList<Object> newTopLevelPlugins = new ArrayList();
        ArrayList<Object> oldLegacyPlugins = new ArrayList();
        ArrayList<ARPluginDefinition> newLegacyPlugins = new ArrayList<ARPluginDefinition>();
        HashMap<Object, Object> updatedPluginGroups = new HashMap();
        HashMap<String, PluginGroup> newPluginGroups = new HashMap<String, PluginGroup>();
        oldLegacyPlugins = new ArrayList<ARPluginDefinition>(this.mLegacyPlugins);
        newTopLevelPlugins = this.loadNewPlugins();
        updatedPluginGroups = this.loadNewPluginGroups();
        Iterator<Object> itr = null;
        Object var8_8 = null;
        for (ARPluginDefinition aRPluginDefinition : newTopLevelPlugins) {
            if (this.mTopLevelPlugins.contains(aRPluginDefinition)) continue;
            this.mTopLevelPlugins.add(aRPluginDefinition);
        }
        Iterator<Object> itrGrp = null;
        for (String string : updatedPluginGroups.keySet()) {
            if (this.mPluginGroups.containsKey(string)) continue;
            this.mPluginGroups.put(string, (PluginGroup)updatedPluginGroups.get(string));
            newPluginGroups.put(string, (PluginGroup)updatedPluginGroups.get(string));
        }
        for (ARPluginDefinition aRPluginDefinition : this.mLegacyPlugins) {
            if (oldLegacyPlugins.contains(aRPluginDefinition)) continue;
            newLegacyPlugins.add(aRPluginDefinition);
        }
        try {
            if (newLegacyPlugins.size() > 0) {
                PluginProxy.initializePluginProxy(newLegacyPlugins, args);
            }
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8792), (Throwable)e);
            System.out.println(CatalogReader.getInstance().getMessage(8792) + e.getLocalizedMessage());
        }
        if (newPluginGroups.size() > 0 || newTopLevelPlugins.size() > 0) {
            ARPluginLoaderRouter.initializeNewJavaPlugins(newTopLevelPlugins, newPluginGroups, args);
            ARPluginLoaderRouter.instantiateNewJavaPlugins(newTopLevelPlugins, newPluginGroups, args);
        }
    }

    static boolean isNativePluginHostSupported() {
        return mbSupportNativePluginHost;
    }

    public int getNumSelectorThreads() {
        return this.numSelectorThreads;
    }

    public int getWorkQueueTaskThreshold() {
        return this.workQueueTaskThreshold;
    }

    public long getWorkQueueMonitorLogInterval() {
        return this.workQueueMonitorLogInterval;
    }
}

