/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.arrpc.ArByteList;
import com.bmc.arsys.arrpc.ArEncryptRPCCntToSvr;
import com.bmc.arsys.arrpc.ArEncryptRPCSvrToCnt;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsGetEncryptInfo4In;
import com.bmc.arsys.arrpc.ArEsGetEncryptInfo4Out;
import com.bmc.arsys.arrpc.ArEsKeyExchangeBegin4In;
import com.bmc.arsys.arrpc.ArEsKeyExchangeBegin4Out;
import com.bmc.arsys.arrpc.ArEsKeyExchangeFinal4In;
import com.bmc.arsys.arrpc.ArEsKeyExchangeFinal4Out;
import com.bmc.arsys.arrpc.ArEsRequest4In;
import com.bmc.arsys.arrpc.ArEsRequest4Out;
import com.bmc.arsys.arrpc.ArEsSignal4In;
import com.bmc.arsys.arrpc.ArEsSignal4Out;
import com.bmc.arsys.arrpc.ArServerInfoList;
import com.bmc.arsys.arrpc.ArServerInfoRequestList;
import com.bmc.arsys.arrpc.ArServerInfoStruct;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginSvrRemoteHostInfo;
import com.bmc.arsys.pluginsvr.binding.ARPluginOnEventHandler;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ARGenericCallRouter {
    private static Logger log = Logger.getLogger(ARGenericCallRouter.class);
    ARPluginServerEncryptionInfo mEncryptInfo = ARPluginServerEncryptionInfo.getInstance();

    static void getRemoteHostLanguageStr(ArEsControlStruct4 control) {
        String languageStr = null;
        try {
            languageStr = StringByteUtil.createNullTerminatedString((byte[])control.getLanguage(), (String)"utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)e.getLocalizedMessage());
        }
        String knowCharSet = ARCharSet.getServerCharSetName((String)languageStr);
        log.info((Object)("RemoteHostLanguage " + languageStr + ", CharSet " + knowCharSet));
        if (!ARPluginSvrRemoteHostInfo.isRemoteHostCodeSetExist()) {
            ARPluginSvrRemoteHostInfo.setRemoteHostCharSet((String)knowCharSet);
        }
    }

    public ArEsRequest4Out ArExternalServerRequest(ArEsRequest4In arg1) {
        return null;
    }

    public ArEsSignal4Out ArEsSignal(ArEsSignal4In arg1) {
        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
        ARPluginContext context = ApiToRpcMapping.getInstance().getContextFromControl((ArEsControlStruct4)arg1.control, null);
        if (arg1.signalList != null) {
            int eventId = 10005;
            Thread t1 = new Thread(new ARPluginOnEventHandler(context, eventId));
            t1.start();
        }
        ArEsSignal4Out out = new ArEsSignal4Out(arg1.getControl(), ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(status));
        return out;
    }

    public ArEsGetEncryptInfo4Out ArEsGetEncryptInfo(ArEsGetEncryptInfo4In arg1) {
        ArEsGetEncryptInfo4Out out;
        block15: {
            out = new ArEsGetEncryptInfo4Out();
            try {
                ARGenericCallRouter.getRemoteHostLanguageStr((ArEsControlStruct4)arg1.getControl());
                ArServerInfoRequestList requestList = arg1.requestList;
                if (requestList == null || requestList.value == null) break block15;
                ArServerInfoStruct[] serverInfoList = new ArServerInfoStruct[requestList.value.length];
                block13: for (int i = 0; i < requestList.value.length; ++i) {
                    serverInfoList[i] = new ArServerInfoStruct();
                    serverInfoList[i].setOperation(requestList.value[i]);
                    ArValueStruct value = new ArValueStruct();
                    switch (requestList.value[i]) {
                        case 131: {
                            value.dataType = 2;
                            value.intVal = ARPluginServerConfiguration.getInstance().getDataEncryptionKeyExpiry();
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        case 130: {
                            value.dataType = 2;
                            value.intVal = ARPluginServerConfiguration.getInstance().getPublicKeyExpiry();
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        case 133: {
                            value.dataType = 2;
                            value.intVal = ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy();
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        case 132: {
                            value.dataType = 2;
                            value.intVal = ARPluginServerConfiguration.getInstance().getDataEncryptionAlgorithm();
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        case 168: {
                            value.dataType = 2;
                            value.intVal = ARPluginServerConfiguration.getInstance().getPublicKeyAlgorithm();
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        case 129: {
                            value.dataType = 9;
                            ArByteList bytes = new ArByteList();
                            if (ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy() < 2) {
                                try {
                                    bytes.bytes = this.mEncryptInfo.getPublicKeyBytes();
                                }
                                catch (Exception e) {
                                    log.debug((Object)e.getLocalizedMessage());
                                }
                            }
                            value.byteListVal = bytes;
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        case 134: {
                            value.dataType = 2;
                            value.intVal = ARPluginServerConfiguration.getInstance().getNumEncSessionHashentries();
                            serverInfoList[i].setValue(value);
                            continue block13;
                        }
                        default: {
                            value.dataType = 0;
                            serverInfoList[i].setValue(value);
                        }
                    }
                }
                ArServerInfoList serverInfo = new ArServerInfoList(serverInfoList);
                out.setServerInfoList(serverInfo);
            }
            catch (Throwable e) {
                log.error((Object)"getEncryptInfo() FAIL: ", e);
                ArStatusList6 status = new ArStatusList6();
                status.value = new ArStatusStruct6[1];
                status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
                out.setStatus(status);
            }
        }
        return out;
    }

    public ArEsKeyExchangeBegin4Out ArEsKeyExchangeBegin(ArEsKeyExchangeBegin4In arg1) {
        int sessionId;
        ArEsKeyExchangeBegin4Out out = new ArEsKeyExchangeBegin4Out();
        byte[] svrRandomBytes = ARPluginServerEncryptionInfo.generateRandomBytes();
        out.sessionId = sessionId = this.mEncryptInfo.createAndInsertSessionNode(svrRandomBytes, arg1.clientRandBytes.value);
        out.serverRandBytes.value = svrRandomBytes;
        return out;
    }

    public ArEsKeyExchangeFinal4Out ArEsKeyExchangeFinal(ArEsKeyExchangeFinal4In arg1) {
        ArEsKeyExchangeFinal4Out out = new ArEsKeyExchangeFinal4Out();
        try {
            byte[] premasterKey = arg1.encPreMasterKey;
            int sessionId = arg1.getSessionId();
            byte[] premaster = this.mEncryptInfo.unxdrAndDecryptPreMasterkey(sessionId, premasterKey);
            this.mEncryptInfo.generateServerAndClientDataKey(sessionId, premaster);
            byte[] sessionBytes = this.mEncryptInfo.XdrAndEncryptSessionId(sessionId);
            out.setEncSessionId(sessionBytes);
        }
        catch (ARException e) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
            ArStatusList6 statusOut = new ArStatusList6();
            out.setStatus(statusOut);
        }
        return out;
    }

    public ArEncryptRPCSvrToCnt ArEsEncryptRPC(ArEncryptRPCCntToSvr arg1) {
        return null;
    }
}

