/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.CommandLineBase;
import com.bmc.arsys.apiext.definition.CompletionEvent;
import com.bmc.arsys.apiext.definition.DefinitionEvent;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.ExpansionEvent;
import com.bmc.arsys.apiext.definition.ExportCommandParser;
import com.bmc.arsys.apiext.definition.IDefinitionListener;
import com.bmc.arsys.apiext.definition.InitializationEvent;
import com.bmc.arsys.apiext.definition.ProcessEvent;
import com.bmc.arsys.apiext.definition.Util;
import com.bmc.arsys.artranscode.ARCharSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionImport
extends CommandLineBase {
    private static final String goto = System.getProperty("line.separator");
    private static final String char = "   objectdata     :+";
    private static Logger long = Logger.getLogger("com.bmc.arsys.api.definition");
    private static final int else = 5;
    private final int new = 0;
    private final List<IDefinitionListener> case = new ArrayList<IDefinitionListener>();
    private final int try = 0;
    private final int int = 0;
    private List<List<String>> byte = null;
    private boolean for = true;

    public static void main(String[] stringArray) {
        DefinitionImport definitionImport = new DefinitionImport();
        definitionImport.if();
        if (stringArray.length == 1 && stringArray[0].equals("--version")) {
            definitionImport.printVersion();
        } else if (stringArray.length > 5) {
            DefinitionOptions definitionOptions = null;
            try {
                definitionOptions = definitionImport.parseCommandLine(stringArray);
                definitionImport.validateCommandLine(definitionOptions, false);
            }
            catch (Exception exception) {
                System.err.println("Unable to parse command line parameters. Please verify your parameters.");
            }
            if (definitionOptions != null) {
                try {
                    definitionImport.setOptions(definitionOptions);
                    definitionOptions.validate();
                    definitionOptions.connect();
                    if (definitionOptions.getContext().isAdministrator() || definitionOptions.getContext().isSubAdministrator()) {
                        if (definitionOptions.getCommandSetFile() != null) {
                            File file = new File(definitionOptions.getCommandSetFile());
                            ExportCommandParser exportCommandParser = new ExportCommandParser(definitionOptions);
                            exportCommandParser.populateFromFile(file, false);
                        }
                        definitionImport.importObjects();
                    } else if (long.isEnabledFor(Level.ERROR)) {
                        long.error("Only users that belong to the Administrator or Sub Administrator groups can export definitions.");
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (long.isEnabledFor(Level.ERROR)) {
                        long.error("Import failed: Unable to load the AR System JNI interface. Please make sure your environment includes the location of the AR System native libraries");
                    }
                }
                catch (Error error) {
                    if (long.isEnabledFor(Level.ERROR)) {
                        long.error(MessageFormat.format("Import failed: {0}", error.getMessage()));
                    }
                }
                catch (Exception exception) {
                    if (!(exception instanceof ARException) && long.isEnabledFor(Level.ERROR)) {
                        long.error(MessageFormat.format("Import failed: {0}{1}", System.getProperty("line.separator"), exception.getMessage()));
                    }
                }
            }
        } else {
            definitionImport.printUsage(false);
        }
    }

    public void addListener(IDefinitionListener iDefinitionListener) {
        this.case.add(iDefinitionListener);
    }

    public List<StatusInfo> importObjects() throws DefinitionException, ARException, IOException {
        boolean bl = this.getOptions().isXML();
        if (long.isEnabledFor(Level.INFO)) {
            long.info(MessageFormat.format("Importing objects from {0} to {1}", this.getOptions().getFileName(), this.getOptions().getServer()));
        }
        List<StatusInfo> list = null;
        File file = null;
        try {
            List<StatusInfo> list2;
            File object;
            String string;
            if (!bl && (string = this.getOptions().getFileName()) != null && string.endsWith(".def") && (object = new File(string)).exists()) {
                String string2 = null;
                string2 = this.getOptions().getCharset() != null ? this.getOptions().getCharset() : ARCharSet.getServerKnownCodeSet((String)System.getProperty("file.encoding"));
                if (string2.equalsIgnoreCase("shift_jis")) {
                    string2 = "EUC_JP";
                }
                if (System.getProperty("file.encoding").equalsIgnoreCase("MS932")) {
                    string2 = "EUC_JP";
                }
                if ((file = DefinitionImport.updateDefFileWithCharSet(this.getOptions(), string2, true)) != null) {
                    long.info("Charset is missing in the definition file, using charset : " + string2);
                }
            }
            if (!bl) {
                this.do();
            } else {
                this.for = false;
            }
            this.getOptions().connect();
            this.checkDSOLicense();
            boolean bl2 = false;
            bl2 = this.getOptions().getItems() == null || this.getOptions().getItems() != null && this.getOptions().getItems().isEmpty();
            list = bl2 ? this.if(bl) : this.do(bl);
            if (this.byte != null && !this.byte.isEmpty() && (list2 = this.a(bl2)) != null && !list2.isEmpty()) {
                if (list == null) {
                    list = list2;
                } else {
                    list.addAll(list2);
                }
            }
        }
        catch (ARException aRException) {
            for (IDefinitionListener iDefinitionListener : this.case) {
                iDefinitionListener.event(new CompletionEvent(0, 0, 0, aRException.getLastStatus()));
            }
            throw aRException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        for (IDefinitionListener iDefinitionListener : this.case) {
            iDefinitionListener.event(new CompletionEvent(0, 0, 0, list));
        }
        return list;
    }

    public static File updateDefFileWithCharSet(DefinitionOptions definitionOptions, String string, boolean bl) throws DefinitionException {
        String string2 = null;
        FileOutputStream fileOutputStream = null;
        File file = new File(definitionOptions.getFileName());
        if (bl && file.exists()) {
            string2 = DefinitionImport.getDefFileCharSet(definitionOptions);
        }
        if (string2 != null) {
            return null;
        }
        File file2 = null;
        byte[] byArray = null;
        try {
            try {
                byArray = DefinitionImport.getBytesFromFile(new File(definitionOptions.getFileName()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DefinitionException("Unable to open export file", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new DefinitionException("Unable to open export file", iOException);
            }
            File file3 = new File(definitionOptions.getFileName());
            int n = definitionOptions.getFileName().lastIndexOf("\\");
            String string3 = definitionOptions.getFileName().substring(0, n + 1) + "Fixed_DS_" + file3.getName();
            file2 = new File(string3);
            fileOutputStream = new FileOutputStream(file2, bl);
            String string4 = "char-set: " + string + goto;
            fileOutputStream.write(string4.getBytes());
            fileOutputStream.write(byArray);
            definitionOptions.setFileName(file2.getAbsolutePath());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DefinitionException("Unable to open export file", unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DefinitionException("Unable to open export file", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DefinitionException("Unable to write to export file", iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new DefinitionException("Unable to close export file", iOException);
            }
        }
        return file2;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = fileInputStream.read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        fileInputStream.close();
        return byArray;
    }

    public static String getDefFileCharSet(DefinitionOptions definitionOptions) throws DefinitionException {
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(definitionOptions.getFileName());
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            if (string2 != null && string2.startsWith("char-set: ")) {
                string = string2.substring("char-set: ".length());
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DefinitionException("Unable to open export file", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DefinitionException("Unable to open export file", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new DefinitionException("Unable to close export file", iOException);
                }
            }
        }
        return string;
    }

    public void removeListener(IDefinitionListener iDefinitionListener) {
        this.case.remove(iDefinitionListener);
    }

    private void if() {
        this.case.add(new IDefinitionListener(){

            public void event(DefinitionEvent definitionEvent) {
                if (definitionEvent instanceof CompletionEvent) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List<StatusInfo> list = ((CompletionEvent)definitionEvent).getStatusList();
                    if (list != null) {
                        for (StatusInfo statusInfo : list) {
                            if (statusInfo.getMessageType() == 2) {
                                bl = true;
                            }
                            if (statusInfo.getMessageType() != 1) continue;
                            bl2 = true;
                        }
                    }
                    if (bl) {
                        if (long.isEnabledFor(Level.ERROR)) {
                            long.error("Import Completed with Errors");
                        }
                    } else if (bl2) {
                        if (long.isEnabledFor(Level.INFO)) {
                            long.info("Import Completed with Warnings");
                        }
                    } else if (long.isEnabledFor(Level.INFO)) {
                        long.info("Import Completed");
                    }
                    if ((bl || bl2) && list != null) {
                        for (StatusInfo statusInfo : list) {
                            if (statusInfo.getMessageType() == 2) {
                                if (!long.isEnabledFor(Level.ERROR)) continue;
                                long.error(statusInfo);
                                continue;
                            }
                            if (!long.isEnabledFor(Level.INFO)) continue;
                            long.info(statusInfo);
                        }
                    }
                } else if (definitionEvent instanceof InitializationEvent) {
                    InitializationEvent initializationEvent = (InitializationEvent)definitionEvent;
                    switch (initializationEvent.getEvent()) {
                        case 1: {
                            if (!long.isEnabledFor(Level.INFO)) break;
                            long.info("Connecting to server");
                            break;
                        }
                        case 3: {
                            if (!long.isEnabledFor(Level.INFO)) break;
                            long.info(MessageFormat.format("Importing {0} objects to {1}", initializationEvent.getNumItems(), DefinitionImport.this.getOptions().getFileName()));
                            break;
                        }
                    }
                } else if (definitionEvent instanceof ExpansionEvent || definitionEvent instanceof ProcessEvent) {
                    // empty if block
                }
            }
        });
    }

    private String if(String string) {
        String string2 = null;
        if (string.startsWith("   name           : ")) {
            string2 = string.replace("   name           : ", "");
        }
        return string2;
    }

    private DefinitionItemType a(String string) {
        if (string.startsWith("begin active link")) {
            return DefinitionItemType.ACTIVE_LINK;
        }
        if (string.startsWith("begin admin ext")) {
            return DefinitionItemType.ADMIN_EXT;
        }
        if (string.startsWith("begin char menu")) {
            return DefinitionItemType.MENU;
        }
        if (string.startsWith("begin container")) {
            return DefinitionItemType.CONTAINER;
        }
        if (string.startsWith("begin distributed mapping")) {
            return DefinitionItemType.DISTRIBUTED_MAPPING;
        }
        if (string.startsWith("begin filter")) {
            return DefinitionItemType.FILTER;
        }
        if (string.startsWith("begin escalation")) {
            return DefinitionItemType.ESCALATION;
        }
        if (!string.startsWith("begin group")) {
            if (string.startsWith("begin schema")) {
                return DefinitionItemType.FORM;
            }
            if (string.startsWith("begin schema data")) {
                return DefinitionItemType.FORM_DATA;
            }
            if (string.startsWith("begin distributed pool")) {
                return DefinitionItemType.DISTRIBUTED_POOL;
            }
            if (string.startsWith("begin vui")) {
                return DefinitionItemType.VIEW;
            }
            if (!string.startsWith("begin lock block")) {
                if (string.startsWith("begin application")) {
                    return DefinitionItemType.APPLICATION;
                }
                if (string.startsWith("begin image")) {
                    return DefinitionItemType.IMAGE;
                }
            }
        }
        return null;
    }

    private List<StatusInfo> if(boolean bl) throws ARException, IOException {
        ArrayList<StatusInfo> arrayList = new ArrayList();
        int n = 0;
        if (this.getOptions().isOverwrite()) {
            n |= 1;
            if (!this.getOptions().isDeleteExcessFields()) {
                n |= 0x40;
            }
            if (!this.getOptions().isDeleteExcessViews()) {
                n |= 0x1000;
            }
            if (this.getOptions().isPreserveIndex()) {
                n |= 0x20000;
            }
            if (this.getOptions().isPreserveVUINamespace()) {
                n |= 0x40000;
            }
            if (this.getOptions().isPreserveAppForms()) {
                n |= 0x80000;
            }
            if (this.getOptions().isImportWithAppOwner()) {
                n |= 0x100000;
            }
            n |= this.getOptions().getConflictHandling();
        }
        this.getOptions().getContext().importDefFromFile(this.getOptions().getFileName(), n);
        arrayList = this.getOptions().getContext().getLastStatus();
        return arrayList;
    }

    private List<StatusInfo> do(boolean bl) throws ARException, IOException {
        ArrayList<StatusInfo> arrayList = new ArrayList();
        List<StructItemInfo> list = this.convertToItemList(bl);
        this.getOptions().getContext().login();
        int n = 0;
        if (this.getOptions().isOverwrite()) {
            n |= 1;
            if (!this.getOptions().isDeleteExcessFields()) {
                n |= 0x40;
            }
            if (!this.getOptions().isDeleteExcessViews()) {
                n |= 0x1000;
            }
            if (this.getOptions().isPreserveIndex()) {
                n |= 0x20000;
            }
            if (this.getOptions().isPreserveVUINamespace()) {
                n |= 0x40000;
            }
            if (this.getOptions().isPreserveAppForms()) {
                n |= 0x80000;
            }
            if (this.getOptions().isImportWithAppOwner()) {
                n |= 0x100000;
            }
            n |= this.getOptions().getConflictHandling();
        }
        if (list != null && !list.isEmpty() || this.byte != null && !this.byte.isEmpty()) {
            this.getOptions().getContext().importDefFromFile(this.getOptions().getFileName(), n, list);
        } else if (long.isEnabledFor(Level.INFO)) {
            long.info("Import Aborted. There are no objects to import");
        }
        arrayList = this.getOptions().getContext().getLastStatus();
        return arrayList;
    }

    private List<StatusInfo> a(boolean bl) throws IOException, DefinitionException, ARException {
        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
        boolean bl2 = true;
        if (this.byte != null && !this.byte.isEmpty()) {
            for (List<String> list : this.byte) {
                Object object;
                Object object2;
                Object object3;
                DefinitionItemType definitionItemType;
                Entry entry = this.a(list);
                String string = (String)((Value)entry.get((Object)41000)).getValue();
                String string2 = (String)((Value)entry.get((Object)41052)).getValue();
                String string3 = (String)((Value)entry.get((Object)41050)).getValue();
                if (!bl && (definitionItemType = this.a(string, string2)) != null && (object3 = this.getOptions().getItems().get((Object)definitionItemType)) != null && !object3.isEmpty()) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (BaseItemData)object2.next();
                        if (string3.equals(((BaseItemData)object).getName())) {
                            bl2 = true;
                            break;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                definitionItemType = null;
                object3 = this.getDataVisualizationQualifier(string, string2, string3);
                object2 = this.getOptions().getContext().getListEntry(this.getDataVisualizationForm(), (QualifierInfo)object3, 0, 1, null, null, false, null);
                if (object2 != null && !object2.isEmpty()) {
                    try {
                        definitionItemType = this.getOptions().getContext().getEntry(this.getDataVisualizationForm(), ((EntryListInfo)object2.get(0)).getEntryID(), null);
                    }
                    catch (ARException aRException) {
                        Object object4 = aRException.getLastStatus();
                        if (object4 != null && !object4.isEmpty()) {
                            boolean bl3 = false;
                            Iterator iterator = object4.iterator();
                            while (iterator.hasNext()) {
                                StatusInfo statusInfo = (StatusInfo)iterator.next();
                                if (statusInfo.getMessageNum() != 302L) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                throw aRException;
                            }
                        }
                        throw aRException;
                    }
                }
                if (definitionItemType != null) {
                    for (Object object4 : entry.keySet()) {
                        definitionItemType.put((Integer)object4, (Value)entry.get(object4));
                    }
                    object = definitionItemType.getEntryId();
                    definitionItemType.remove(1);
                    definitionItemType.remove(2);
                    definitionItemType.remove(3);
                    definitionItemType.remove(5);
                    definitionItemType.remove(6);
                    definitionItemType.remove(15);
                    this.getOptions().getContext().setEntry(this.getDataVisualizationForm(), (String)object, (Entry)definitionItemType, null, 0);
                    arrayList.addAll(this.getOptions().getContext().getLastStatus());
                    continue;
                }
                entry.remove((Object)1);
                entry.remove((Object)2);
                entry.remove((Object)3);
                entry.remove((Object)5);
                entry.remove((Object)6);
                entry.remove((Object)15);
                this.getOptions().getContext().createEntry(this.getDataVisualizationForm(), entry);
                arrayList.addAll(this.getOptions().getContext().getLastStatus());
            }
        }
        return arrayList;
    }

    private DefinitionItemType a(String string, String string2) {
        if ("Flashboard".equals(string)) {
            if ("FLASHBOARD".equals(string2)) {
                return DefinitionItemType.FLASHBOARD;
            }
            if ("ALARM".equals(string2)) {
                return DefinitionItemType.FLASHBOARD_ALARM;
            }
            if ("VARIABLE".equals(string2)) {
                return DefinitionItemType.FLASHBOARD_VARIABLE;
            }
        }
        return null;
    }

    private void do() throws IOException, DefinitionException {
        String string = this.getOptions().getFileName();
        this.byte = new ArrayList<List<String>>();
        BufferedReader bufferedReader = Util.openFile(string, null);
        String string2 = null;
        int n = 0;
        boolean bl = false;
        ArrayList<String> arrayList = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if (string2.startsWith("begin Data Visualization Definition") || string2.startsWith("begin Data Visulaization Definition")) {
                    arrayList = new ArrayList<String>();
                    bl = true;
                } else if (string2.startsWith("end")) {
                    bl = false;
                    if (arrayList != null) {
                        this.byte.add(arrayList);
                    }
                    arrayList = null;
                } else if (string2.startsWith("begin ")) {
                    this.for = false;
                }
                if (arrayList == null || !bl) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            throw new DefinitionException("Error encountered while parsing definition file for content", exception.getCause());
        }
        finally {
            bufferedReader.close();
        }
    }

    private Entry a(List<String> list) throws ARException {
        Entry entry = null;
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object : list) {
                if (object.startsWith(char)) {
                    stringBuilder.append(object.substring(char.length()).replaceAll("[\r\n]", ""));
                    continue;
                }
                if (!object.startsWith("   objectdata     :")) continue;
                stringBuilder.append(object.substring("   objectdata     :".length()).replaceAll("[\r\n]", ""));
            }
            int n = stringBuilder.length();
            if (n > 0) {
                entry = new Entry();
                Pattern pattern = Pattern.compile("( \\d+,\\d,\\\"(.*?)\\\";)");
                Matcher matcher = pattern.matcher(stringBuilder.toString());
                block5: while (matcher.find()) {
                    String string = matcher.group();
                    int n2 = string.indexOf(44);
                    int n3 = string.indexOf(44, n2 + 1);
                    int n4 = Integer.parseInt(string.substring(1, n2));
                    int n5 = Integer.parseInt(string.substring(n2 + 1, n3));
                    String string2 = string.substring(n3 + 2, string.length() - 2);
                    switch (n5) {
                        case 6: {
                            long l = Long.parseLong(string2);
                            if (n4 == 41051) {
                                if (l == 1L) {
                                    entry.put(Integer.valueOf(n4), new Value((Object)0L, DataType.ENUM));
                                    continue block5;
                                }
                                entry.put(Integer.valueOf(n4), new Value());
                                continue block5;
                            }
                            entry.put(Integer.valueOf(n4), new Value((Object)l, DataType.ENUM));
                            continue block5;
                        }
                        case 5: {
                            DiaryListValue diaryListValue = DiaryListValue.decode((String)string2);
                            entry.put(Integer.valueOf(n4), new Value(diaryListValue));
                            continue block5;
                        }
                    }
                    entry.put(Integer.valueOf(n4), new Value(string2, DataType.toDataType((int)n5)));
                }
            }
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ImportItem {
        private String int;
        private boolean do = false;
        private String if;
        private List<String> a = new ArrayList<String>();
        private DefinitionItemType for;

        ImportItem() {
        }

        public String getContent() {
            return this.int;
        }

        public String getName() {
            return this.if;
        }

        public List<String> getSubItems() {
            return this.a;
        }

        public DefinitionItemType getType() {
            return this.for;
        }

        public boolean isInLockedBlock() {
            return this.do;
        }

        public void setContent(String string) {
            this.int = string;
        }

        public void setInLockedBlock(boolean bl) {
            this.do = bl;
        }

        public void setName(String string) {
            this.if = string;
        }

        public void setSubItems(List<String> list) {
            this.a = list;
        }

        public void setType(DefinitionItemType definitionItemType) {
            this.for = definitionItemType;
        }
    }
}

