package com.bmc.arsys.plugin.sample;

import com.bmc.arsys.plugin.sample.FooBar;
import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;

import java.util.*;
/**
 * A sample implementation of a filterapi plugin. In this case, this implementation extends 
 * ARFilterAPIPlugin.  Alternatively, one could just implement the interface ARFilterAPIPluggable.
 * This sample has a dependency on a class FooBar, which is a part of another jar file it depends
 * on. It also illustrates the use of the ARPluginContext to fetch username, or config items for 
 * itself.
 *
 */

public class FilterAPISample extends ARFilterAPIPlugin {

    private int count = 0;
    private static int staticCount = 0;
    
    private  ARPluginInfo pluginInfo = new ARPluginInfo("SAMPLE.FILTERAPI", this);
    FooBar myFoo = new FooBar();
   
    /**
     * Implementation of the static init method, to do any static initialization for this class. 
     * This method is called once for each class that implements one of the ARPluggable interface
     * on plugin server startup
     * @param context
     */
    public static void init(ARPluginContext context){
    	System.out.println("Static initialize method invoked");
    	System.out.println("UserDefined value for sample " + context.getConfigItem("sample"));
    }
    
    /*
     * This is the main filter api call that is passed a list of values that the filter action has setup
     * as input values.  A list of Value objects is expected as an output.
     */
    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException{
        context.logMessage(pluginInfo, ARPluginContext.PLUGIN_LOG_LEVEL_INFO, "filterapiCall()");
        count++;
        staticCount++;
        if (pInValues.size() == 0)
            return null;
        
        ArrayList<Value> outValues = new ArrayList<Value>();
        
        // first element holds the number of counts received by this instance
        outValues.add(0, new Value(count));
        
        // second element holds the number of counts received by all instances of this class
        outValues.add(1, new Value(staticCount));
        
        // third element holds the upper case value of the first input value.
        outValues.add(2, new Value(
                 context.getUser()+": "+((String)pInValues.get(0).getValue()).toUpperCase() 
                ));
        
        //fourth element holds the fooBar count. This is from the external
        //dependency package
        outValues.add(3, new Value(myFoo.doSomething()));
        
        return outValues;
    }

}
