/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.core.Constants;
import com.bmc.thirdparty.org.springframework.transaction.IllegalTransactionStateException;
import com.bmc.thirdparty.org.springframework.transaction.InvalidTimeoutException;
import com.bmc.thirdparty.org.springframework.transaction.NestedTransactionNotSupportedException;
import com.bmc.thirdparty.org.springframework.transaction.PlatformTransactionManager;
import com.bmc.thirdparty.org.springframework.transaction.TransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.TransactionException;
import com.bmc.thirdparty.org.springframework.transaction.TransactionStatus;
import com.bmc.thirdparty.org.springframework.transaction.TransactionSuspensionNotSupportedException;
import com.bmc.thirdparty.org.springframework.transaction.UnexpectedRollbackException;
import com.bmc.thirdparty.org.springframework.transaction.support.DefaultTransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.support.DefaultTransactionStatus;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronization;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPlatformTransactionManager
implements PlatformTransactionManager,
Serializable {
    public static final int SYNCHRONIZATION_ALWAYS = 0;
    public static final int SYNCHRONIZATION_ON_ACTUAL_TRANSACTION = 1;
    public static final int SYNCHRONIZATION_NEVER = 2;
    private static final Constants constants = new Constants(class$org$springframework$transaction$support$AbstractPlatformTransactionManager == null ? (class$org$springframework$transaction$support$AbstractPlatformTransactionManager = AbstractPlatformTransactionManager.class$("com.bmc.thirdparty.org.springframework.transaction.support.AbstractPlatformTransactionManager")) : class$org$springframework$transaction$support$AbstractPlatformTransactionManager);
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private int transactionSynchronization = 0;
    private boolean nestedTransactionAllowed = false;
    private boolean globalRollbackOnParticipationFailure = true;
    private boolean failEarlyOnGlobalRollbackOnly = false;
    private boolean rollbackOnCommitFailure = false;
    static /* synthetic */ Class class$org$springframework$transaction$support$AbstractPlatformTransactionManager;

    public final void setTransactionSynchronizationName(String constantName) {
        this.setTransactionSynchronization(constants.asNumber(constantName).intValue());
    }

    public final void setTransactionSynchronization(int transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    public final int getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    public final void setNestedTransactionAllowed(boolean nestedTransactionAllowed) {
        this.nestedTransactionAllowed = nestedTransactionAllowed;
    }

    public final boolean isNestedTransactionAllowed() {
        return this.nestedTransactionAllowed;
    }

    public final void setGlobalRollbackOnParticipationFailure(boolean globalRollbackOnParticipationFailure) {
        this.globalRollbackOnParticipationFailure = globalRollbackOnParticipationFailure;
    }

    public final boolean isGlobalRollbackOnParticipationFailure() {
        return this.globalRollbackOnParticipationFailure;
    }

    public final void setFailEarlyOnGlobalRollbackOnly(boolean failEarlyOnGlobalRollbackOnly) {
        this.failEarlyOnGlobalRollbackOnly = failEarlyOnGlobalRollbackOnly;
    }

    public final boolean isFailEarlyOnGlobalRollbackOnly() {
        return this.failEarlyOnGlobalRollbackOnly;
    }

    public final void setRollbackOnCommitFailure(boolean rollbackOnCommitFailure) {
        this.rollbackOnCommitFailure = rollbackOnCommitFailure;
    }

    public final boolean isRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    public final TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        Object transaction = this.doGetTransaction();
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug("Using transaction object [" + transaction + "]");
        }
        if (definition == null) {
            definition = new DefaultTransactionDefinition();
        }
        if (this.isExistingTransaction(transaction)) {
            return this.handleExistingTransaction(definition, transaction, debugEnabled);
        }
        if (definition.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", definition.getTimeout());
        }
        if (definition.getPropagationBehavior() == 2) {
            throw new IllegalTransactionStateException("Transaction propagation 'mandatory' but no existing transaction found");
        }
        if (definition.getPropagationBehavior() == 0 || definition.getPropagationBehavior() == 3 || definition.getPropagationBehavior() == 6) {
            if (debugEnabled) {
                this.logger.debug("Creating new transaction with name [" + definition.getName() + "]");
            }
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.getTransactionSynchronization() != 2;
            return this.newTransactionStatus(definition, transaction, true, newSynchronization, debugEnabled, null);
        }
        boolean newSynchronization = this.getTransactionSynchronization() == 0;
        return this.newTransactionStatus(definition, null, false, newSynchronization, debugEnabled, null);
    }

    private TransactionStatus handleExistingTransaction(TransactionDefinition definition, Object transaction, boolean debugEnabled) throws TransactionException {
        if (definition.getPropagationBehavior() == 5) {
            throw new IllegalTransactionStateException("Transaction propagation 'never' but existing transaction found");
        }
        if (definition.getPropagationBehavior() == 4) {
            if (debugEnabled) {
                this.logger.debug("Suspending current transaction");
            }
            SuspendedResourcesHolder suspendedResources = this.suspend(transaction);
            boolean newSynchronization = this.getTransactionSynchronization() == 0;
            return this.newTransactionStatus(definition, null, false, newSynchronization, debugEnabled, suspendedResources);
        }
        if (definition.getPropagationBehavior() == 3) {
            if (debugEnabled) {
                this.logger.debug("Suspending current transaction, creating new transaction with name [" + definition.getName() + "]");
            }
            SuspendedResourcesHolder suspendedResources = this.suspend(transaction);
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.getTransactionSynchronization() != 2;
            return this.newTransactionStatus(definition, transaction, true, newSynchronization, debugEnabled, suspendedResources);
        }
        if (definition.getPropagationBehavior() == 6) {
            if (!this.isNestedTransactionAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions by default - specify 'nestedTransactionAllowed' property with value 'true'");
            }
            if (debugEnabled) {
                this.logger.debug("Creating nested transaction with name [" + definition.getName() + "]");
            }
            if (this.useSavepointForNestedTransaction()) {
                DefaultTransactionStatus status = this.newTransactionStatus(definition, transaction, false, false, debugEnabled, null);
                status.createAndHoldSavepoint();
                return status;
            }
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.getTransactionSynchronization() != 2;
            return this.newTransactionStatus(definition, transaction, true, newSynchronization, debugEnabled, null);
        }
        if (debugEnabled) {
            this.logger.debug("Participating in existing transaction");
        }
        boolean newSynchronization = this.getTransactionSynchronization() != 2;
        return this.newTransactionStatus(definition, transaction, false, newSynchronization, debugEnabled, null);
    }

    protected DefaultTransactionStatus newTransactionStatus(TransactionDefinition definition, Object transaction, boolean newTransaction, boolean newSynchronization, boolean debug, Object suspendedResources) {
        boolean actualNewSynchronization;
        boolean bl = actualNewSynchronization = newSynchronization && !TransactionSynchronizationManager.isSynchronizationActive();
        if (actualNewSynchronization) {
            if (newTransaction) {
                TransactionSynchronizationManager.setActualTransactionActive(true);
            }
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(definition.isReadOnly());
            TransactionSynchronizationManager.setCurrentTransactionName(definition.getName());
            TransactionSynchronizationManager.initSynchronization();
        }
        return new DefaultTransactionStatus(transaction, newTransaction, actualNewSynchronization, definition.isReadOnly(), debug, suspendedResources);
    }

    private SuspendedResourcesHolder suspend(Object transaction) throws TransactionException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            List suspendedSynchronizations = TransactionSynchronizationManager.getSynchronizations();
            Iterator it = suspendedSynchronizations.iterator();
            while (it.hasNext()) {
                ((TransactionSynchronization)it.next()).suspend();
            }
            TransactionSynchronizationManager.clearSynchronization();
            String name = TransactionSynchronizationManager.getCurrentTransactionName();
            TransactionSynchronizationManager.setCurrentTransactionName(null);
            boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
            TransactionSynchronizationManager.setActualTransactionActive(false);
            Object holder = this.doSuspend(transaction);
            return new SuspendedResourcesHolder(holder, suspendedSynchronizations, name, readOnly);
        }
        Object holder = this.doSuspend(transaction);
        return new SuspendedResourcesHolder(holder, null, null, false);
    }

    private void resume(Object transaction, SuspendedResourcesHolder resourcesHolder) throws TransactionException {
        this.doResume(transaction, resourcesHolder.getSuspendedResources());
        if (resourcesHolder.getSuspendedSynchronizations() != null) {
            TransactionSynchronizationManager.setActualTransactionActive(true);
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(resourcesHolder.isReadOnly());
            TransactionSynchronizationManager.setCurrentTransactionName(resourcesHolder.getName());
            TransactionSynchronizationManager.initSynchronization();
            Iterator it = resourcesHolder.getSuspendedSynchronizations().iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                synchronization.resume();
                TransactionSynchronizationManager.registerSynchronization(synchronization);
            }
        }
    }

    public final void commit(TransactionStatus status) throws TransactionException {
        if (status.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        if (defStatus.isLocalRollbackOnly()) {
            if (defStatus.isDebug()) {
                this.logger.debug("Transactional code has requested rollback");
            }
            this.processRollback(defStatus);
            return;
        }
        if (!this.shouldCommitOnGlobalRollbackOnly() && defStatus.isGlobalRollbackOnly()) {
            if (defStatus.isDebug()) {
                this.logger.debug("Global transaction is marked as rollback-only but transactional code requested commit");
            }
            this.processRollback(defStatus);
            if (status.isNewTransaction() || this.isFailEarlyOnGlobalRollbackOnly()) {
                throw new UnexpectedRollbackException("Transaction rolled back because it has been marked as rollback-only");
            }
            return;
        }
        this.processCommit(defStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit(DefaultTransactionStatus status) throws TransactionException {
        try {
            boolean beforeCompletionInvoked = false;
            try {
                this.triggerBeforeCommit(status);
                this.triggerBeforeCompletion(status);
                beforeCompletionInvoked = true;
                boolean globalRollbackOnly = false;
                if (status.isNewTransaction() || this.isFailEarlyOnGlobalRollbackOnly()) {
                    globalRollbackOnly = status.isGlobalRollbackOnly();
                }
                if (status.hasSavepoint()) {
                    if (status.isDebug()) {
                        this.logger.debug("Releasing transaction savepoint");
                    }
                    status.releaseHeldSavepoint();
                } else if (status.isNewTransaction()) {
                    if (status.isDebug()) {
                        this.logger.debug("Initiating transaction commit");
                    }
                    this.doCommit(status);
                }
                if (globalRollbackOnly) {
                    throw new UnexpectedRollbackException("Transaction silently rolled back because it has been marked as rollback-only");
                }
            }
            catch (UnexpectedRollbackException ex) {
                this.triggerAfterCompletion(status, 1);
                throw ex;
            }
            catch (TransactionException ex) {
                if (this.isRollbackOnCommitFailure()) {
                    this.doRollbackOnCommitException(status, ex);
                } else {
                    this.triggerAfterCompletion(status, 2);
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (!beforeCompletionInvoked) {
                    this.triggerBeforeCompletion(status);
                }
                this.doRollbackOnCommitException(status, ex);
                throw ex;
            }
            catch (Error err) {
                if (!beforeCompletionInvoked) {
                    this.triggerBeforeCompletion(status);
                }
                this.doRollbackOnCommitException(status, err);
                throw err;
            }
            try {
                this.triggerAfterCommit(status);
            }
            finally {
                this.triggerAfterCompletion(status, 0);
            }
        }
        finally {
            this.cleanupAfterCompletion(status);
        }
    }

    public final void rollback(TransactionStatus status) throws TransactionException {
        if (status.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)status;
        this.processRollback(defStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRollback(DefaultTransactionStatus status) {
        try {
            try {
                this.triggerBeforeCompletion(status);
                if (status.hasSavepoint()) {
                    if (status.isDebug()) {
                        this.logger.debug("Rolling back transaction to savepoint");
                    }
                    status.rollbackToHeldSavepoint();
                } else if (status.isNewTransaction()) {
                    if (status.isDebug()) {
                        this.logger.debug("Initiating transaction rollback");
                    }
                    this.doRollback(status);
                } else if (status.hasTransaction()) {
                    if (status.isLocalRollbackOnly() || this.isGlobalRollbackOnParticipationFailure()) {
                        if (status.isDebug()) {
                            this.logger.debug("Participating transaction failed - marking existing transaction as rollback-only");
                        }
                        this.doSetRollbackOnly(status);
                    } else if (status.isDebug()) {
                        this.logger.debug("Participating transaction failed - letting transaction originator decide on rollback");
                    }
                } else {
                    this.logger.debug("Should roll back transaction but cannot - no transaction available");
                }
            }
            catch (RuntimeException ex) {
                this.triggerAfterCompletion(status, 2);
                throw ex;
            }
            catch (Error err) {
                this.triggerAfterCompletion(status, 2);
                throw err;
            }
            this.triggerAfterCompletion(status, 1);
        }
        finally {
            this.cleanupAfterCompletion(status);
        }
    }

    private void doRollbackOnCommitException(DefaultTransactionStatus status, Throwable ex) throws TransactionException {
        try {
            if (status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug("Initiating transaction rollback on commit exception", ex);
                }
                this.doRollback(status);
            }
        }
        catch (RuntimeException rbex) {
            this.logger.error("Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2);
            throw rbex;
        }
        catch (Error rberr) {
            this.logger.error("Commit exception overridden by rollback exception", ex);
            this.triggerAfterCompletion(status, 2);
            throw rberr;
        }
        this.triggerAfterCompletion(status, 1);
    }

    private void triggerBeforeCommit(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            if (status.isDebug()) {
                this.logger.debug("Triggering beforeCommit synchronization");
            }
            TransactionSynchronizationUtils.triggerBeforeCommit(status.isReadOnly());
        }
    }

    private void triggerBeforeCompletion(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            if (status.isDebug()) {
                this.logger.debug("Triggering beforeCompletion synchronization");
            }
            TransactionSynchronizationUtils.triggerBeforeCompletion();
        }
    }

    private void triggerAfterCommit(DefaultTransactionStatus status) {
        if (status.isNewSynchronization()) {
            if (status.isDebug()) {
                this.logger.debug("Triggering afterCommit synchronization");
            }
            TransactionSynchronizationUtils.triggerAfterCommit();
        }
    }

    private void triggerAfterCompletion(DefaultTransactionStatus status, int completionStatus) {
        if (status.isNewSynchronization()) {
            List synchronizations = TransactionSynchronizationManager.getSynchronizations();
            if (!status.hasTransaction() || status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug("Triggering afterCompletion synchronization");
                }
                this.invokeAfterCompletion(synchronizations, completionStatus);
            } else {
                this.registerAfterCompletionWithExistingTransaction(status.getTransaction(), synchronizations);
            }
        }
    }

    protected final void invokeAfterCompletion(List synchronizations, int completionStatus) {
        TransactionSynchronizationUtils.invokeAfterCompletion(synchronizations, completionStatus);
    }

    private void cleanupAfterCompletion(DefaultTransactionStatus status) {
        status.setCompleted();
        if (status.isNewSynchronization()) {
            TransactionSynchronizationManager.clearSynchronization();
            TransactionSynchronizationManager.setCurrentTransactionName(null);
            TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
            if (status.isNewTransaction()) {
                TransactionSynchronizationManager.setActualTransactionActive(false);
            }
        }
        if (status.isNewTransaction()) {
            this.doCleanupAfterCompletion(status.getTransaction());
        }
        if (status.getSuspendedResources() != null) {
            if (status.isDebug()) {
                this.logger.debug("Resuming suspended transaction");
            }
            this.resume(status.getTransaction(), (SuspendedResourcesHolder)status.getSuspendedResources());
        }
    }

    protected abstract Object doGetTransaction() throws TransactionException;

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return false;
    }

    protected boolean useSavepointForNestedTransaction() {
        return true;
    }

    protected abstract void doBegin(Object var1, TransactionDefinition var2) throws TransactionException;

    protected Object doSuspend(Object transaction) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return false;
    }

    protected abstract void doCommit(DefaultTransactionStatus var1) throws TransactionException;

    protected abstract void doRollback(DefaultTransactionStatus var1) throws TransactionException;

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        throw new IllegalTransactionStateException("Participating in existing transactions is not supported - when 'isExistingTransaction' returns true, appropriate 'doSetRollbackOnly' behavior must be provided");
    }

    protected void registerAfterCompletionWithExistingTransaction(Object transaction, List synchronizations) throws TransactionException {
        this.logger.debug("Cannot register Spring after-completion synchronization with existing transaction - performing Spring after-completion callbacks immediately, with outcome status 'unknown'");
        this.invokeAfterCompletion(synchronizations, 2);
    }

    protected void doCleanupAfterCompletion(Object transaction) {
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SuspendedResourcesHolder {
        private final Object suspendedResources;
        private final List suspendedSynchronizations;
        private final String name;
        private final boolean readOnly;

        public SuspendedResourcesHolder(Object suspendedResources, List suspendedSynchronizations, String name, boolean readOnly) {
            this.suspendedResources = suspendedResources;
            this.suspendedSynchronizations = suspendedSynchronizations;
            this.name = name;
            this.readOnly = readOnly;
        }

        public Object getSuspendedResources() {
            return this.suspendedResources;
        }

        public List getSuspendedSynchronizations() {
            return this.suspendedSynchronizations;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }
}

