/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core;

import com.bmc.thirdparty.org.springframework.core.ControlFlow;
import com.bmc.thirdparty.org.springframework.core.JdkVersion;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class ControlFlowFactory {
    public static ControlFlow createControlFlow() {
        return JdkVersion.isAtLeastJava14() ? new Jdk14ControlFlow() : new Jdk13ControlFlow();
    }

    static class Jdk13ControlFlow
    implements ControlFlow {
        private final String stackTrace;
        private final int stackTraceLength;

        public Jdk13ControlFlow() {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            this.stackTrace = sw.toString();
            this.stackTraceLength = this.stackTrace.length();
        }

        public boolean under(Class clazz) {
            Assert.notNull(clazz, "Class must not be null");
            return this.stackTrace.indexOf(clazz.getName()) != -1;
        }

        public boolean under(Class clazz, String methodName) {
            Assert.notNull(clazz, "Class must not be null");
            Assert.notNull(methodName, "Method name must not be null");
            String searchPattern = clazz.getName() + "." + methodName;
            int patternLength = searchPattern.length();
            int index = 0;
            do {
                if ((index = this.stackTrace.indexOf(searchPattern, index)) == -1) continue;
                int endIndex = index + patternLength;
                if (endIndex == this.stackTraceLength) {
                    return true;
                }
                char afterPattern = this.stackTrace.charAt(endIndex);
                if (afterPattern == '(' || Character.isWhitespace(afterPattern)) {
                    return true;
                }
                index = endIndex;
            } while (index != -1);
            return false;
        }

        public boolean underToken(String token) {
            return token != null && this.stackTrace.indexOf(token) != -1;
        }
    }

    static class Jdk14ControlFlow
    implements ControlFlow {
        private StackTraceElement[] stack = new Throwable().getStackTrace();

        public boolean under(Class clazz) {
            Assert.notNull(clazz, "Class must not be null");
            String className = clazz.getName();
            for (int i2 = 0; i2 < this.stack.length; ++i2) {
                if (!this.stack[i2].getClassName().equals(className)) continue;
                return true;
            }
            return false;
        }

        public boolean under(Class clazz, String methodName) {
            Assert.notNull(clazz, "Class must not be null");
            Assert.notNull(methodName, "Method name must not be null");
            String className = clazz.getName();
            for (int i2 = 0; i2 < this.stack.length; ++i2) {
                if (!this.stack[i2].getClassName().equals(className) || !this.stack[i2].getMethodName().equals(methodName)) continue;
                return true;
            }
            return false;
        }

        public boolean underToken(String token) {
            if (token == null) {
                return false;
            }
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            return stackTrace.indexOf(token) != -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Jdk14ControlFlow: ");
            for (int i2 = 0; i2 < this.stack.length; ++i2) {
                if (i2 > 0) {
                    sb.append("\n\t@");
                }
                sb.append(this.stack[i2]);
            }
            return sb.toString();
        }
    }
}

