/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class JNDIConfiguration
extends AbstractConfiguration {
    private static Log log = LogFactory.getLog(class$org$apache$commons$configuration$JNDIConfiguration == null ? (class$org$apache$commons$configuration$JNDIConfiguration = JNDIConfiguration.class$("com.bmc.thirdparty.org.apache.commons.configuration.JNDIConfiguration")) : class$org$apache$commons$configuration$JNDIConfiguration);
    private String prefix;
    private Context context;
    private Context baseContext;
    private Set clearedProperties = new HashSet();
    static /* synthetic */ Class class$org$apache$commons$configuration$JNDIConfiguration;

    public JNDIConfiguration() throws NamingException {
        this((String)null);
    }

    public JNDIConfiguration(String prefix) throws NamingException {
        this(new InitialContext(), prefix);
    }

    public JNDIConfiguration(Context context) {
        this(context, null);
    }

    public JNDIConfiguration(Context context, String prefix) {
        this.context = context;
        this.prefix = prefix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recursiveGetKeys(Set keys, Context context, String prefix) throws NamingException {
        NamingEnumeration<NameClassPair> elements = null;
        try {
            elements = context.list("");
            while (elements.hasMore()) {
                NameClassPair nameClassPair = elements.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                StringBuffer key = new StringBuffer();
                key.append(prefix);
                if (key.length() > 0) {
                    key.append(".");
                }
                key.append(name);
                if (object instanceof Context) {
                    Context subcontext = (Context)object;
                    this.recursiveGetKeys(keys, subcontext, key.toString());
                    continue;
                }
                keys.add(key.toString());
            }
            Object var11_10 = null;
            if (elements == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (elements == null) throw throwable;
            elements.close();
            throw throwable;
        }
        elements.close();
    }

    public Iterator getKeys() {
        return this.getKeys("");
    }

    public Iterator getKeys(String prefix) {
        String[] splitPath = StringUtils.split(prefix, ".");
        ArrayList<String> path = new ArrayList<String>();
        int i2 = 0;
        while (i2 < splitPath.length) {
            path.add(splitPath[i2]);
            ++i2;
        }
        try {
            Context context = this.getContext(path, this.getBaseContext());
            HashSet<String> keys = new HashSet<String>();
            if (context != null) {
                this.recursiveGetKeys(keys, context, prefix);
            } else if (this.containsKey(prefix)) {
                keys.add(prefix);
            }
            return keys.iterator();
        }
        catch (NamingException e2) {
            log.error(e2.getMessage(), e2);
            return new ArrayList().iterator();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Context getContext(List path, Context context) throws NamingException {
        NamingEnumeration<NameClassPair> elements;
        block4: {
            Context context2;
            if (path == null) return context;
            if (path.isEmpty()) {
                return context;
            }
            String key = (String)path.get(0);
            elements = null;
            try {
                NameClassPair nameClassPair;
                String name;
                Object object;
                elements = context.list("");
                do {
                    if (elements.hasMore()) continue;
                    break block4;
                } while (!((object = context.lookup(name = (nameClassPair = elements.next()).getName())) instanceof Context) || !name.equals(key));
                Context subcontext = (Context)object;
                context2 = this.getContext(path.subList(1, path.size()), subcontext);
                Object var11_10 = null;
                if (elements == null) return context2;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (elements == null) throw throwable;
                elements.close();
                throw throwable;
            }
            elements.close();
            return context2;
        }
        Object var11_11 = null;
        if (elements == null) return null;
        elements.close();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        try {
            boolean bl;
            NamingEnumeration<NameClassPair> enumeration = null;
            try {
                enumeration = this.getBaseContext().list("");
                bl = !enumeration.hasMore();
                Object var4_4 = null;
                if (enumeration == null) return bl;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (enumeration == null) throw throwable;
                enumeration.close();
                throw throwable;
            }
            enumeration.close();
            return bl;
        }
        catch (NamingException e2) {
            log.error(e2.getMessage(), e2);
            return true;
        }
    }

    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void clearProperty(String key) {
        this.clearedProperties.add(key);
    }

    public boolean containsKey(String key) {
        if (this.clearedProperties.contains(key)) {
            return false;
        }
        key = StringUtils.replace(key, ".", "/");
        try {
            this.getBaseContext().lookup(key);
            return true;
        }
        catch (NameNotFoundException e2) {
            return false;
        }
        catch (NamingException e3) {
            log.error(e3.getMessage(), e3);
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.baseContext = null;
    }

    public Object getProperty(String key) {
        if (this.clearedProperties.contains(key)) {
            return null;
        }
        try {
            key = StringUtils.replace(key, ".", "/");
            return this.getBaseContext().lookup(key);
        }
        catch (NameNotFoundException e2) {
            return null;
        }
        catch (NamingException e3) {
            log.error(e3.getMessage(), e3);
            return null;
        }
    }

    protected void addPropertyDirect(String key, Object obj) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Context getBaseContext() throws NamingException {
        if (this.baseContext == null) {
            this.baseContext = (Context)this.getContext().lookup(this.prefix == null ? "" : this.prefix);
        }
        return this.baseContext;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.clearedProperties.clear();
        this.context = context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

