/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.WsdlOperation;
import com.bmc.arsys.ws.wsdl.WsdlPortBindingOperation;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlService {
    protected String serviceName = null;
    protected Service service = null;
    protected Map<String, WsdlPortBindingOperation> wsports = null;
    protected String description = null;

    public WsdlService(Service service) {
        this.service = service;
        this.serviceName = this.service.getQName().toString();
        this.wsports = new HashMap<String, WsdlPortBindingOperation>();
    }

    public WsdlService() {
        this.wsports = new HashMap<String, WsdlPortBindingOperation>();
    }

    protected Service getService() {
        return this.service;
    }

    protected void setService(Service service) {
        this.service = service;
        this.serviceName = this.service.getQName().toString();
    }

    protected Map getPorts() {
        return this.wsports;
    }

    protected void setPorts(HashMap<String, WsdlPortBindingOperation> hashMap) {
        this.wsports = hashMap;
    }

    protected void addPort(WsdlPortBindingOperation wsdlPortBindingOperation) {
        if (this.wsports == null) {
            this.wsports = new HashMap<String, WsdlPortBindingOperation>();
        }
        this.wsports.put(wsdlPortBindingOperation.getPortName(), wsdlPortBindingOperation);
    }

    protected WsdlPortBindingOperation getPortByName(String string) {
        if (string == null || this.wsports == null) {
            return null;
        }
        return this.wsports.get(string);
    }

    protected void parseServiceBinding() {
        Object object;
        Element element = this.service.getDocumentationElement();
        if (element != null && element.getLocalName().equals("documentation") && (object = element.getFirstChild()) != null && object.getNodeType() == 3) {
            this.description = object.getNodeValue();
        }
        object = this.service.getPorts();
        Iterator iterator = object.values().iterator();
        while (iterator.hasNext()) {
            Object object22;
            SOAPBinding sOAPBinding = null;
            Port port = (Port)iterator.next();
            WsdlUtil.trace(" Port: " + port.getName());
            Binding binding = port.getBinding();
            WsdlUtil.trace(" Binding: " + binding.getQName());
            List list = binding.getExtensibilityElements();
            for (Object object22 : list) {
                if (!(object22 instanceof SOAPBinding)) continue;
                sOAPBinding = (SOAPBinding)object22;
                break;
            }
            if (sOAPBinding == null) continue;
            object22 = new WsdlPortBindingOperation(this.service, port, binding, sOAPBinding);
            ((WsdlPortBindingOperation)object22).parseOperations();
            this.addPort((WsdlPortBindingOperation)object22);
        }
        if (this.wsports.isEmpty()) {
            throw new ARWSException("INVALID_WSDL", "Cannot find supported SOAP binding");
        }
    }

    public void createMappingDoc(Document document, String string, XMLSchemaParser xMLSchemaParser, Definition definition, StringBuffer stringBuffer) {
        String string2 = this.service.getQName().getLocalPart();
        String string3 = "";
        Iterator<WsdlPortBindingOperation> iterator = this.wsports.values().iterator();
        WsdlPortBindingOperation wsdlPortBindingOperation2 = null;
        WsdlOperation wsdlOperation = null;
        if (iterator.hasNext()) {
            wsdlPortBindingOperation2 = iterator.next();
        }
        if (wsdlPortBindingOperation2 != null) {
            wsdlOperation = wsdlPortBindingOperation2.operationsList.get(0);
        }
        if (wsdlOperation != null && wsdlOperation.getUseStyle().equals("encoded")) {
            string3 = wsdlOperation.getInputBody().getNamespaceURI();
        } else if (wsdlPortBindingOperation2 != null && wsdlPortBindingOperation2.getBinding() != null) {
            string3 = wsdlPortBindingOperation2.getBinding().getQName().getNamespaceURI();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        ARSWebService aRSWebService = new ARSWebService(string2, string3, this.description);
        for (WsdlPortBindingOperation wsdlPortBindingOperation2 : this.wsports.values()) {
            wsdlPortBindingOperation2.createMappingDoc(aRSWebService, document, xMLSchemaParser, definition, stringBuffer);
        }
        aRSWebService.generateXML(document);
    }
}

