/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsFilterApi4In;
import com.bmc.arsys.arrpc.ArEsFilterApi4Out;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArValueList;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARFilterAPIPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(ARFilterAPIPluginRepository.class);
    protected ConcurrentHashMap<String, PluginEnvelope> mPlugins = new ConcurrentHashMap();

    ARFilterAPIPluginRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArEsFilterApi4Out ARFilterApiCall(ArEsFilterApi4In arEsFilterApi4In) {
        ArEsFilterApi4Out arEsFilterApi4Out = new ArEsFilterApi4Out();
        String string = ApiToRpcMapping.getInstance().getEncodedString(arEsFilterApi4In.getServiceName().value);
        ARFilterAPIPluggable aRFilterAPIPluggable = null;
        ARPluginInfo aRPluginInfo = null;
        ArValueStruct[] arValueStructArray = this.mPlugins.get(string);
        if (arValueStructArray != null) {
            aRFilterAPIPluggable = (ARFilterAPIPluggable)arValueStructArray.mPlugin;
            aRPluginInfo = arValueStructArray.mPluginInfo;
        }
        if (aRFilterAPIPluggable == null) {
            arValueStructArray = new ARException();
            LOGGER.error((Object)("ARFilterApiCall FAIL " + string), (Throwable)arValueStructArray);
            ArStatusList6 arStatusList6 = new ArStatusList6();
            arStatusList6.value = new ArStatusStruct6[1];
            arStatusList6.value[0] = new ArStatusStruct6(2, 8755, CatalogReader.getInstance().getMessage(8755), string);
            arEsFilterApi4Out.setStatus(arStatusList6);
            return arEsFilterApi4Out;
        }
        LOGGER.trace((Object)("getting the value list from incoming arguments before filterAPIcall to " + string));
        arValueStructArray = arEsFilterApi4In.getInValues().value;
        ArrayList<Value> arrayList = new ArrayList<Value>();
        try {
            this.validateClient(arEsFilterApi4In.getControl().getPassword());
            for (int i = 0; i < arValueStructArray.length; ++i) {
                arrayList.add(i, ValueObjectFactory.getValueObject(arValueStructArray[i]));
            }
            LOGGER.trace((Object)("mapped fromRpc in, calling filterAPI to " + string));
            List<Value> list = aRFilterAPIPluggable.filterAPICall(ApiToRpcMapping.getInstance().getContextFromControl((ArEsControlStruct4)arEsFilterApi4In.getControl(), aRPluginInfo), arrayList);
            LOGGER.trace((Object)("after filterAPI returned from " + string));
            ArValueList arValueList = null;
            if (list != null) {
                ArValueStruct[] arValueStructArray2 = new ArValueStruct[list.size()];
                for (int i = 0; i < arValueStructArray2.length; ++i) {
                    arValueStructArray2[i] = ValueObjectFactory.setValueObject(list.get(i), ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
                }
                arValueList = new ArValueList(arValueStructArray2);
            } else {
                arValueList = new ArValueList();
            }
            arEsFilterApi4Out = new ArEsFilterApi4Out(arEsFilterApi4In.getControl(), arValueList, new ArStatusList6());
            LOGGER.trace((Object)("after mapping toRpc out for after filterAPIcall from " + string));
        }
        catch (ARException aRException) {
            LOGGER.error((Object)("ARFilterApiCall FAILs in plugin: " + string), (Throwable)aRException);
            arEsFilterApi4Out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(aRException.getLastStatus()));
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)("ARFilterApiCall FAILs in plugin: " + string), throwable);
            ArStatusList6 arStatusList6 = new ArStatusList6();
            arStatusList6.value = new ArStatusStruct6[1];
            arStatusList6.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), string);
            arEsFilterApi4Out.setStatus(arStatusList6);
        }
        return arEsFilterApi4Out;
    }

    @Override
    void addPlugin(String string, PluginEnvelope pluginEnvelope) throws ARException {
        assert (string != null && pluginEnvelope != null && pluginEnvelope.mPlugin != null);
        this.mPlugins.put(string, pluginEnvelope);
    }

    @Override
    PluginEnvelope getPlugin(String string) {
        return this.mPlugins.get(string);
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext aRPluginContext, int n) {
        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
        Collection<PluginEnvelope> collection = this.mPlugins.values();
        for (PluginEnvelope pluginEnvelope : collection) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                aRPluginContext.setPluginInfo(pluginEnvelope.mPluginInfo);
                stringBuilder.append(pluginEnvelope.mPluginInfo.getName()).append("; version: ").append(pluginEnvelope.mPluginInfo.getVersion()).append("; eventId = ").append(n);
                LOGGER.debug((Object)("calling " + stringBuilder.toString()));
                pluginEnvelope.mPlugin.onEvent(aRPluginContext, n);
            }
            catch (ARException aRException) {
                arrayList.addAll(aRException.getLastStatus());
            }
        }
        return arrayList;
    }

    @Override
    void terminatePlugins(ARPluginContext aRPluginContext) {
        Collection<PluginEnvelope> collection = this.mPlugins.values();
        for (PluginEnvelope pluginEnvelope : collection) {
            try {
                aRPluginContext.setPluginInfo(pluginEnvelope.mPluginInfo);
                pluginEnvelope.mPlugin.terminate(aRPluginContext);
            }
            catch (ARException aRException) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + pluginEnvelope.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)aRException);
            }
        }
    }
}

