/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ObjectPrinter;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import com.bmc.arsys.demo.javadriver.WFD;
import java.io.PrintWriter;

public class WfdOutputWriter
extends ObjectPrinter {
    public void printResult(String string) {
        if ((WFD.quietMode & WFD.SUPPRESS_RESULTS) == 0) {
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            PrintWriter printWriter = threadControlBlock.getOutFile();
            printWriter.print(string);
            printWriter.flush();
        }
    }

    public void driverPrintHeader(String string) {
        ThreadControlBlock threadControlBlock;
        if ((WFD.quietMode & WFD.SUPPRESS_HEADERS) == 0 && (threadControlBlock = WFD.getThreadControlBlockPtr()).getPrimaryThread()) {
            System.out.println(string);
        }
    }

    public void driverPrintPrompt(String string) {
        ThreadControlBlock threadControlBlock;
        if ((WFD.quietMode & WFD.SUPPRESS_PROMPTS) == 0 && (threadControlBlock = WFD.getThreadControlBlockPtr()).getPrimaryThread()) {
            System.out.print(string);
        }
    }

    public void driverPrintNotSupportCommand(int n) {
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        String string = threadControlBlock.getBuffer();
        String string2 = threadControlBlock.getArgs();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" **** No support for this command: ").append(n).append(", with args: ").append(string2).append(", in line: ").append(string);
        if (threadControlBlock.getCurrentInputFileName() != null) {
            stringBuilder.append(", from: ").append(threadControlBlock.getCurrentInputFileName());
        }
        stringBuilder.append(", in driver \n");
        this.driverPrintError(stringBuilder.toString());
    }

    public void driverPrintMenu(String string) {
        if ((WFD.quietMode & WFD.SUPPRESS_MENU) == 0) {
            System.out.print(string);
        }
    }

    public void driverPrintError(String string) {
        if ((WFD.quietMode & WFD.SUPPRESS_RESULTS) == 0) {
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            PrintWriter printWriter = threadControlBlock.getOutFile();
            printWriter.print(string);
            printWriter.flush();
        }
    }

    public void driverPrintException(Exception exception) {
        if ((WFD.quietMode & WFD.SUPPRESS_RESULTS) == 0) {
            exception.printStackTrace();
        }
    }

    public void driverPrintWarning(String string) {
        if ((WFD.quietMode & WFD.SUPPRESS_WARNINGS) == 0) {
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            PrintWriter printWriter = threadControlBlock.getOutFile();
            printWriter.print(string);
            printWriter.flush();
        }
    }

    public void closeOutputFile() {
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        if (threadControlBlock.getIsStdOut()) {
            this.driverPrintWarning(" **** Output to stdout; cannot close stdout file\n");
        } else {
            threadControlBlock.setOutputToStdOut();
        }
    }

    public void openOutputFile(String string) {
        if (string == null || string.length() == 0) {
            this.driverPrintWarning(" **** No filename specified so no change to output file\n");
        } else {
            if ((WFD.getQuietMode() & WFD.SUPPRESS_RESULTS) != 0) {
                return;
            }
            String string2 = null;
            String string3 = WFD.getResultDirectory();
            string2 = string3 != null && string3.length() > 0 ? string3 + "\\" + string : string;
            try {
                ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
                threadControlBlock.setOutputFile(string2);
            }
            catch (Exception exception) {
                this.driverPrintWarning(" **** File error during open; no change to output file\n");
            }
        }
    }

    public void driverPrintHelp() {
        System.out.print("         AR System Workflow Debugger\n");
        System.out.println();
        System.out.print("\n");
        System.out.print(" Execution       Local BkPts     Data            Misc.        \n");
        System.out.print(" -------------   -------------   -------------   -------------\n");
        System.out.print(" step      (s)   brk pt   (bp)   get FVL  (gf)   init   (init)\n");
        System.out.print(" run to bp (g)   clr bk   (bc)   set FVL  (sf)   term   (term)\n");
        System.out.print(" run to rbp(r)   list bkp (bl)   get qual (gq)   log     (log)\n");
        System.out.print("                 clr list (bx)   set qual (sq)   quit  (q|x|e)\n");
        System.out.print("                                 location (cl)   help    (h|?)\n");
        System.out.print(" term API (ta)   Remote BkPts    stack fr (st)   set port(ssp)\n");
        System.out.print(" finish   (fi)   -------------   list stk (li)   get mode (gm)\n");
        System.out.print("                 brk pt  (rbp)   get keywd(kw)   set mode (sm)\n");
        System.out.print("                 clr bk  (rbc)   user ctx (uc)   mode all(sma)\n");
        System.out.print("                 list bkp(rbl)                   mode clr(smc)\n");
        System.out.print("                 clr list(rbx)                   restart (rst)\n");
    }

    public void printExtraHelp() {
        System.out.print("         AR System Workflow Debugger Information\n");
        System.out.println();
        System.out.print("WorkflowName indicates either FilterName or EscalationName\n");
        System.out.print("Information in square brackets is optional.\n");
        System.out.print(" Current location format:\n");
        System.out.print(" (Workflow Stage) API Name->Schema Name->WorkflowName[GuideName]->action ## (Action Type)\n");
    }
}

