/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Util;
import com.bmc.arsys.apiext.data.arm.ARMParser;
import com.bmc.arsys.apiext.data.arm.ARMXMLParser;
import com.bmc.arsys.apiext.data.arm.CustomXMLParser;
import com.bmc.arsys.apiext.data.arx.ARXImporter;
import com.bmc.arsys.apiext.data.ascii.ASCIIImporter;
import com.bmc.arsys.apiext.data.csv.CSVImporter;
import com.bmc.arsys.apiext.data.xml.ARXMLImporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.SimpleLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataImport {
    public static final String VERSION = "arimportcmd version 7.5.00";
    private ImportOptions do = null;
    private static final String for = "\"=\"";
    private static Logger if = Logger.getLogger("com.bmc.arsys.apiext.data");
    boolean commandLine = false;
    boolean logInitialized = false;
    private Set<IParseListener> a = null;

    public static void main(String[] stringArray) throws ARException, ARImportException, IOException {
        block2: {
            DataImport dataImport = new DataImport();
            try {
                dataImport.commandLine = true;
                dataImport.doImport(stringArray);
            }
            catch (ARImportException aRImportException) {
                if (dataImport.logInitialized) break block2;
                aRImportException.printStackTrace();
            }
        }
    }

    public void doImport(String[] stringArray) throws ARException, ARImportException, IOException {
        block13: {
            if (stringArray.length < 7) {
                boolean bl = false;
                for (String string : stringArray) {
                    if (!string.equals("--version")) continue;
                    bl = true;
                    System.out.println(VERSION);
                    System.exit(0);
                }
                if (!bl) {
                    this.a();
                    System.exit(1);
                }
            } else {
                this.do = this.parseCommandLine(stringArray);
                try {
                    this.startImport();
                }
                catch (ARImportException aRImportException) {
                    if.error(MessageFormat.format("Cannot import, exception occured while importing {0}", this.do.getFileOptions().getDataFile()));
                    if (if.isDebugEnabled()) {
                        if.debug("Cannot import, exception occured while importing", aRImportException);
                    }
                    if (!this.commandLine) {
                        throw aRImportException;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if.error(MessageFormat.format("Cannot open datafile. {0}", this.do.getFileOptions().getDataFile()));
                    if (if.isDebugEnabled()) {
                        if.debug("Cannot open datafile.", fileNotFoundException);
                    }
                    if (!this.commandLine) {
                        throw fileNotFoundException;
                    }
                }
                catch (Exception exception) {
                    if.error(MessageFormat.format("Cannot import, exception occured while importing {0}", this.do.getFileOptions().getDataFile()));
                    if (if.isDebugEnabled()) {
                        if.debug("Cannot import, exception occured while importing", exception);
                    }
                    if (this.commandLine) break block13;
                    throw new ARImportException(exception);
                }
            }
        }
    }

    public void startImport() throws ARImportException, IOException, ARException {
        block11: {
            if (!this.logInitialized) {
                this.a(this.do.getLogFile(), this.do.getLogLevel());
            }
            try {
                this.validateOptions();
            }
            catch (ARImportException aRImportException) {
                if (if.isEnabledFor(Level.ERROR)) {
                    if.error(aRImportException.getMessage());
                }
                if (this.commandLine) break block11;
                throw aRImportException;
            }
        }
        if (this.getOptions().getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
            boolean bl = false;
            if (this.getOptions().getUserAlertListener() == null) {
                bl = true;
            }
            if (this.commandLine || bl) {
                if (if.isInfoEnabled()) {
                    if.info("Bad Record handling was set to alert the user, but no mechanism is available to do so. Switching bad record handling to skip records");
                }
                this.getOptions().getDataOptions().setBadRecordHandling(DataOptions.BadRecords.SKIP);
            }
        }
        this.do.getResults().reset();
        BaseImporter baseImporter = this.getImporter();
        if (baseImporter != null) {
            if (this.a != null && baseImporter.getParser() != null) {
                for (IParseListener iParseListener : this.a) {
                    if (iParseListener == null) continue;
                    baseImporter.getParser().addListener(iParseListener);
                }
            }
            baseImporter.startImport();
        }
    }

    protected BaseImporter getImporter() throws ARImportException {
        if (this.do.getFileOptions().getType() != null) {
            if (this.do.getFileOptions().getType().equals("ARX")) {
                return new ARXImporter(this.do);
            }
            if (this.do.getFileOptions().getType().equals("XML")) {
                return new ARXMLImporter(this.do);
            }
            if (this.do.getFileOptions().getType().equals("CSV")) {
                return new CSVImporter(this.do);
            }
            if (this.do.getFileOptions().getType().equals("ASC")) {
                return new ASCIIImporter(this.do);
            }
        } else if (this.do.getFileOptions().getDataFile() != null) {
            if (this.do.getFileOptions().getDataFile().toUpperCase().endsWith("ARX")) {
                return new ARXImporter(this.do);
            }
            if (this.do.getFileOptions().getDataFile().toUpperCase().endsWith("XML")) {
                return new ARXMLImporter(this.do);
            }
            if (this.do.getFileOptions().getDataFile().toUpperCase().endsWith("CSV")) {
                return new CSVImporter(this.do);
            }
            if (this.do.getFileOptions().getDataFile().toUpperCase().endsWith("ASC")) {
                return new ASCIIImporter(this.do);
            }
        }
        return null;
    }

    public ImportOptions parseCommandLine(String[] stringArray) throws ARException, UnsupportedEncodingException, ARImportException {
        String string;
        String string2;
        int n;
        int n2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        ImportOptions importOptions;
        block61: {
            importOptions = new ImportOptions();
            int n3 = 3;
            String string10 = null;
            String string11 = null;
            string9 = null;
            string8 = null;
            string7 = null;
            string6 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            n2 = 0;
            n = 0;
            string2 = null;
            string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                int n4;
                String string12 = stringArray[i];
                if (string12.equals("-x")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-u")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-p")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-d")) {
                    string10 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-m")) {
                    string11 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-l")) {
                    importOptions.setLogFile(stringArray[++i]);
                    continue;
                }
                if (string12.equals("-f")) {
                    String string13;
                    if ((n4 = (string13 = stringArray[++i]).indexOf(for)) < 0) {
                        importOptions.getFormMap().put("ARImport_Data_Holder", string13.substring(0, string13.length()));
                        continue;
                    }
                    String[] stringArray2 = string13.substring(1, n4);
                    String string14 = string13.substring(n4 + for.length(), string13.length() - 1);
                    importOptions.getFormMap().put(string14, (String)stringArray2);
                    continue;
                }
                if (string12.equals("-o")) {
                    string5 = stringArray[++i];
                    importOptions.getFileOptions().setDataFile(string5);
                    if (importOptions.getFileOptions().getType() != null) continue;
                    if (string5.toUpperCase().endsWith("ARX")) {
                        importOptions.getFileOptions().setType("ARX");
                        string = "ARX";
                        continue;
                    }
                    if (string5.toUpperCase().endsWith("XML")) {
                        importOptions.getFileOptions().setType("XML");
                        string = "XML";
                        continue;
                    }
                    if (string5.toUpperCase().endsWith("CSV")) {
                        importOptions.getFileOptions().setType("CSV");
                        string = "CSV";
                        continue;
                    }
                    if (!string5.toUpperCase().endsWith("ASC")) continue;
                    importOptions.getFileOptions().setType("ASC");
                    string = "ASC";
                    continue;
                }
                if (string12.equals("-M")) {
                    string9 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-D")) {
                    int n5 = Integer.parseInt(stringArray[++i]);
                    importOptions.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(n5));
                    continue;
                }
                if (string12.equals("-a")) {
                    n2 = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (string12.equals("-r")) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (string12.equals("-e")) {
                    String[] stringArray3 = stringArray[++i].split(",");
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray3.length);
                    for (String string15 : stringArray3) {
                        int n6 = Integer.parseInt(string15);
                        arrayList.add(n6);
                    }
                    importOptions.getDataOptions().setDuplicateFields(arrayList);
                    continue;
                }
                if (string12.equals("-n")) {
                    importOptions.getDataOptions().setSuppressFilters(true);
                    continue;
                }
                if (string12.equals("-v")) {
                    importOptions.getContext().setOverridePrevIP(true);
                    continue;
                }
                if (string12.equals("-t")) {
                    int n7 = Integer.parseInt(stringArray[++i]);
                    importOptions.getDataOptions().setMultiMatch(DataOptions.MultiMatch.fromARMValue(n7));
                    continue;
                }
                if (string12.equals("-w")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (string12.equals("-q")) {
                    String string16 = stringArray[++i];
                    n4 = 0;
                    if (string16.equalsIgnoreCase("1")) {
                        n4 = 1;
                    }
                    importOptions.getDataOptions().setDisableRequired(n4 != 0);
                    continue;
                }
                if (string12.equals("-c")) {
                    String string17 = stringArray[++i];
                    n4 = 0;
                    if (string17.equalsIgnoreCase("1")) {
                        n4 = 1;
                    }
                    importOptions.getDataOptions().setTruncate(n4 != 0);
                    continue;
                }
                if (string12.equals("-h")) {
                    String string18 = stringArray[++i];
                    n4 = 0;
                    if (string18.equalsIgnoreCase("1")) {
                        n4 = 1;
                    }
                    importOptions.getDataOptions().setDisablePattern(n4 != 0);
                    continue;
                }
                if (string12.equals("-i")) {
                    String string19 = stringArray[++i];
                    n4 = 0;
                    if (string19.equalsIgnoreCase("1")) {
                        n4 = 1;
                    }
                    importOptions.getDataOptions().setSuppressDefaults(n4 != 0);
                    continue;
                }
                if (string12.equals("-charset")) {
                    string7 = stringArray[++i];
                    importOptions.getFileOptions().setCharSet(string7);
                    continue;
                }
                if (string12.equals("-b")) {
                    int n8 = Integer.parseInt(stringArray[++i]);
                    importOptions.getDataOptions().setTransactionSize(n8);
                    continue;
                }
                if (string12.equals("-debug")) {
                    try {
                        n3 = Integer.parseInt(stringArray[++i]);
                    }
                    catch (Exception exception) {
                        n3 = 3;
                    }
                    continue;
                }
                if (!string12.equals("-custom")) continue;
                string8 = stringArray[++i];
            }
            importOptions.setLogLevel(n3);
            this.a(importOptions.getLogFile(), importOptions.getLogLevel());
            if (string9 == null && string11 != null) {
                try {
                    string9 = Util.findMappingFile(string10, string11, string7);
                }
                catch (IOException iOException) {
                    if (!if.isDebugEnabled()) break block61;
                    if.debug("Exception encountered while looking for mapping file", iOException);
                }
            }
        }
        if (string9 != null && string9.length() > 0) {
            try {
                if (string9.toUpperCase().endsWith(".ARM")) {
                    ARMParser aRMParser = new ARMParser(importOptions);
                    aRMParser.populateFromARM(importOptions, string9, string7);
                    if (string5 != null) {
                        importOptions.getFileOptions().setDataFile(string5);
                    }
                    if (string != null) {
                        importOptions.getFileOptions().setType(string);
                    }
                }
                if (string9.toUpperCase().endsWith(".ARMX")) {
                    ARMXMLParser aRMXMLParser = new ARMXMLParser(importOptions);
                    aRMXMLParser.parseFile(string9);
                    if (string5 != null) {
                        importOptions.getFileOptions().setDataFile(string5);
                    }
                    if (string != null) {
                        importOptions.getFileOptions().setType(string);
                    }
                }
            }
            catch (Exception exception) {
                if (if.isEnabledFor(Level.ERROR)) {
                    if.error(MessageFormat.format("Import was not attempted. Unable to parse mapping file {0}", string9));
                }
                if (if.isDebugEnabled()) {
                    if.debug("Unable to parse mapping file: ", exception);
                }
                throw new ARImportException(exception);
            }
        }
        if (string8 != null && string8.length() > 0) {
            try {
                CustomXMLParser customXMLParser = new CustomXMLParser(importOptions);
                customXMLParser.parseFile(string8);
            }
            catch (Exception exception) {
                if (if.isEnabledFor(Level.ERROR)) {
                    if.error(MessageFormat.format("Import was not attempted. Unable to parse custom XML file {0}", string8));
                }
                if (if.isDebugEnabled()) {
                    if.debug("Unable to parse custom XML file: ", exception);
                }
                throw new ARImportException(exception);
            }
        }
        if (string6 != null) {
            importOptions.getContext().setServer(string6);
        }
        if (string2 != null) {
            importOptions.getContext().setAuthentication(string2);
        }
        if (string4 != null) {
            importOptions.getContext().setUser(string4);
        }
        if (string3 != null) {
            importOptions.getContext().setPassword(string3);
        }
        if (n2 != 0) {
            importOptions.getContext().setPort(n2);
        }
        if (n != 0) {
            importOptions.getContext().usePrivateRpcQueue(n);
        }
        return importOptions;
    }

    private void a() {
        System.out.println("Command Line Options:");
        System.out.println("    -u <user>          : Required login parameter that identifies the user account. ");
        System.out.println("    -p <password>      : Optional login parameter that identifies the password. Omit the option if the user account has no password.");
        System.out.println("    -x <servername>    : Login parameter that specifies the server to log in to. This option overrides the server specified in the mapping. If this option is not specified, the server name in the mapping is used.");
        System.out.println("    -w <authenticator> : Name of an external authentication string or Windows NT domain. This is related to the Login window Authentication field, which is discussed in the Configuring guide.");
        System.out.println("    -r <programnumber> : RPC program number. Private server, for example, if a dedicated import server is available. If not specified, the default is the admin server 390600.");
        System.out.println("    -a <tcpport>       : TCP port number. Port number for the server. This value is especially important in a multiple server environment. The option also identifies a TCP specific port, if chosen.");
        System.out.println("    -l <logfile>       : Full path name of the log file. Use this option to log details of the import execution.");
        System.out.println("    -e <fieldids>      : Duplicate fields. IDs of the fields to check for duplicate data. For example, for the Short Description field, you would enter the value 8. By default, the Request ID field (field ID 1) is used when -e parameter is omitted. Multiple values can be specified by seperatng them with commas (2,4,8)");
        System.out.println("    -n <option>        : Suppress filters. When the system is merging entries on forms, this command instructs arimportcmd to suppress the merge filters.");
        System.out.println("    -t <option>        : Multiple match option. Use when more than one entry matches. Enter a value of 3 to affect the first match, and a value of 5 to affect all matches.");
        System.out.println("    -o <filename>      : Data file name. Name of the file containing data to import. If specified, this option overrides the data file specified in the mapping. If not specified, the data file specified in the mapping is used.");
        System.out.println("    -f <formnames>     : Destination form name. Name of the form to import into. If specified, this option overrides the form specified in the mapping. If not specified, the form specified in the mapping is used.");
        System.out.println("    -v <option>        : Forces override. If the user has logged in from a different IP address, this option tells the server to use the new IP address of the BMC Remedy Import client and invalidates the old IP address.");
        System.out.println("    -i <option>        : Suppress default values. If specified this option is specified import will ignore the default values of fields if the value in the data file is null or not supplied.");
        System.out.println("    -M <mappingfile>   : Full path name of mapping file. Required fully qualified path name of the mapping file to use.");
        System.out.println("    -D <option>        : Duplicate ID. Defines how to process records that contain request IDs, which duplicate those already in the form. With this option, you must include one of the following numbers:");
        System.out.println("                            0 : Generate new ID for all records");
        System.out.println("                            1 : Reject duplicate records");
        System.out.println("                            2 : Generate new ID for duplicate records");
        System.out.println("                            3 : Replace old record with new record ");
        System.out.println("                            4 : Update old record with new records data (the default)");
        System.out.println("    -q <option>        : Suppresses the required field property for non core fields.");
        System.out.println("    -c <option>        : Truncates character values longer than the field length for character fields.");
        System.out.println("    -h <option>        : Suppresses pattern matching for fields. If supplied the $PATTERN$ field limit is ignored");
        System.out.println("    -charset <name>    : Specifies the character set used in the data file. The character set name must be supplied as listed in the IANA Charset Registry");
        System.out.println("    -b <option>        : Sets the transaction size to use.");
        System.out.println("    -custom            : Full path name of the XML file containing user-defined custom options for handling date/time values and real numbers. This is optional.");
        System.out.println("");
        System.out.println("Usage - WITH MAPPING FILE: arimportcmd -x server -u user -p password -M mappingfile -o datafile -f targetform -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -w AuthenticationServer -i suppressdefaultvalues");
        System.out.println("    Values for Username and Password are required.");
        System.out.println("");
        System.out.println("Usage - WITHOUT MAPPING FILE: arimportcmd -x server -u user -p password -o datafile -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues");
        System.out.println("    Values for Username, Password, Server, Datafile  are required.");
    }

    public ImportOptions getOptions() {
        return this.do;
    }

    public void setOptions(ImportOptions importOptions) {
        this.do = importOptions;
    }

    private void a(String string, Level level) {
        if.setLevel(level);
        Layout layout = null;
        layout = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d %-5p [%t] %C (%F:%L) - %m%n") : new SimpleLayout();
        if (string != null && string.length() > 0) {
            try {
                FileAppender fileAppender = new FileAppender(layout, string, false);
                fileAppender.setName("ARIMPORT_FILE_APPENDER");
                Util.getInstance().setFileAppender(fileAppender);
                if.addAppender(fileAppender);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!this.commandLine) {
            Object object;
            boolean bl = true;
            Enumeration enumeration = if.getRootLogger().getAllAppenders();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!(object instanceof ConsoleAppender)) continue;
                bl = false;
                break;
            }
            if (bl) {
                enumeration = null;
                object = LogManager.getLoggerRepository().getCurrentLoggers();
                if (object != null) {
                    block3: while (object.hasMoreElements()) {
                        Logger logger = (Logger)object.nextElement();
                        enumeration = logger.getAllAppenders();
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            if (!(e instanceof ConsoleAppender)) continue;
                            ((ConsoleAppender)e).setThreshold(Level.OFF);
                            bl = false;
                            continue block3;
                        }
                    }
                }
            }
            if (bl) {
                if.addAppender(new ConsoleAppender(layout));
            }
        }
        this.logInitialized = true;
        if (if.isInfoEnabled()) {
            if.info("AR System Import Tool 7.5.00 " + DateFormat.getDateTimeInstance().format(new Date()));
        }
    }

    public void addParseListener(IParseListener iParseListener) {
        if (this.a == null) {
            this.a = new HashSet<IParseListener>();
        }
        this.a.add(iParseListener);
    }

    public void removeParseListener(IParseListener iParseListener) {
        if (this.a != null) {
            this.a.remove(iParseListener);
        }
    }

    public void clearParseListeners() {
        if (this.a != null) {
            this.a.clear();
        }
    }

    public Set<IParseListener> getParseListeners() {
        return this.a;
    }

    public void validateOptions() throws ARImportException {
        if (this.getOptions().getFileOptions().getDataFile() == null) {
            throw new ARImportException("Cannot import. No data file was specified.");
        }
        if (this.getOptions().getFileOptions().getDataFile().length() == 0) {
            throw new ARImportException("Cannot import. No data file was specified.");
        }
        File file = new File(this.getOptions().getFileOptions().getDataFile());
        if (!file.exists()) {
            throw new ARImportException(MessageFormat.format("Cannot import. The specfied data file does not exist: {0}", this.getOptions().getFileOptions().getDataFile()));
        }
        if (this.getOptions().getFileOptions().getType() == null) {
            throw new ARImportException(MessageFormat.format("Cannot import. Unknown data file type for file: {0}", this.getOptions().getFileOptions().getDataFile()));
        }
        if (this.getOptions().getContext().getServer() == null || this.getOptions().getContext().getServer() != null && this.getOptions().getContext().getServer().length() == 0) {
            throw new ARImportException("Cannot import. No destination server was specified.");
        }
        if (this.getOptions().getContext().getUser() == null || this.getOptions().getContext().getUser() != null && this.getOptions().getContext().getUser().length() == 0) {
            throw new ARImportException("Cannot import. No user name was specified.");
        }
    }
}

