/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.support;

import com.bmc.thirdparty.org.springframework.aop.ClassFilter;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.io.Serializable;
import java.util.Arrays;

public abstract class ClassFilters {
    public static ClassFilter union(ClassFilter a2, ClassFilter b2) {
        return new UnionClassFilter(new ClassFilter[]{a2, b2});
    }

    public static ClassFilter intersection(ClassFilter a2, ClassFilter b2) {
        return new IntersectionClassFilter(new ClassFilter[]{a2, b2});
    }

    private static class IntersectionClassFilter
    implements ClassFilter,
    Serializable {
        private ClassFilter[] filters;

        public IntersectionClassFilter(ClassFilter[] filters) {
            Assert.notNull(filters, "'filters' cannot be null.");
            this.filters = filters;
        }

        public boolean matches(Class clazz) {
            for (int i2 = 0; i2 < this.filters.length; ++i2) {
                if (this.filters[i2].matches(clazz)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof IntersectionClassFilter && ObjectUtils.nullSafeEquals(this.filters, ((IntersectionClassFilter)other).filters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }
    }

    private static class UnionClassFilter
    implements ClassFilter,
    Serializable {
        private ClassFilter[] filters;

        public UnionClassFilter(ClassFilter[] filters) {
            Assert.notNull(filters, "'filters' cannot be null.");
            this.filters = filters;
        }

        public boolean matches(Class clazz) {
            for (int i2 = 0; i2 < this.filters.length; ++i2) {
                if (!this.filters[i2].matches(clazz)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UnionClassFilter && ObjectUtils.nullSafeEquals(this.filters, ((UnionClassFilter)other).filters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }
    }
}

