/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.aop.ProxyMethodInvocation;
import com.bmc.thirdparty.org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.support.AopUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectiveMethodInvocation
implements ProxyMethodInvocation,
Cloneable {
    protected final Object proxy;
    protected final Object target;
    protected final Method method;
    protected Object[] arguments;
    private final Class targetClass;
    private ReflectiveMethodInvocation parent;
    private Map userAttributes;
    protected final List interceptorsAndDynamicMethodMatchers;
    private int currentInterceptorIndex;

    public ReflectiveMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers) {
        this.proxy = proxy;
        this.target = target;
        this.targetClass = targetClass;
        this.method = method;
        this.arguments = arguments;
        this.interceptorsAndDynamicMethodMatchers = interceptorsAndDynamicMethodMatchers;
    }

    public final Object getProxy() {
        return this.proxy;
    }

    public final Object getThis() {
        return this.target;
    }

    public final AccessibleObject getStaticPart() {
        return this.method;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final Object[] getArguments() {
        return this.arguments == null ? new Object[]{} : this.arguments;
    }

    protected Map getUserAttributes() {
        if (this.userAttributes == null) {
            this.userAttributes = new HashMap();
        }
        return this.userAttributes;
    }

    public Object getUserAttribute(String key) {
        return this.getUserAttributes().get(key);
    }

    public void setUserAttribute(String key, Object value) {
        Object valueInParent;
        if (this.parent != null && (valueInParent = this.parent.getUserAttribute(key)) == null) {
            this.parent.setUserAttribute(key, value);
        }
        this.getUserAttributes().put(key, value);
    }

    public Object proceed() throws Throwable {
        if (this.currentInterceptorIndex == this.interceptorsAndDynamicMethodMatchers.size()) {
            return this.invokeJoinpoint();
        }
        Object interceptorOrInterceptionAdvice = this.interceptorsAndDynamicMethodMatchers.get(this.currentInterceptorIndex);
        if (interceptorOrInterceptionAdvice instanceof InterceptorAndDynamicMethodMatcher) {
            InterceptorAndDynamicMethodMatcher dm = (InterceptorAndDynamicMethodMatcher)interceptorOrInterceptionAdvice;
            if (dm.methodMatcher.matches(this.method, this.targetClass, this.arguments)) {
                return dm.interceptor.invoke(this.nextInvocation());
            }
            ++this.currentInterceptorIndex;
            return this.proceed();
        }
        return ((MethodInterceptor)interceptorOrInterceptionAdvice).invoke(this.nextInvocation());
    }

    private ReflectiveMethodInvocation nextInvocation() throws CloneNotSupportedException {
        ReflectiveMethodInvocation invocation = (ReflectiveMethodInvocation)this.clone();
        invocation.currentInterceptorIndex = this.currentInterceptorIndex + 1;
        invocation.parent = this;
        return invocation;
    }

    protected Object invokeJoinpoint() throws Throwable {
        return AopUtils.invokeJoinpointUsingReflection(this.target, this.method, this.arguments);
    }

    public MethodInvocation invocableClone() {
        try {
            ReflectiveMethodInvocation clone = (ReflectiveMethodInvocation)this.clone();
            if (this.arguments != null) {
                clone.arguments = new Object[this.arguments.length];
                System.arraycopy(this.arguments, 0, clone.arguments, 0, this.arguments.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException("Should be able to clone object of type [" + this.getClass() + "]: " + ex);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("invocation: method '");
        sb.append(this.method.getName()).append("', ").append("arguments ");
        sb.append(this.arguments != null ? Arrays.asList(this.arguments).toString() : "[]");
        sb.append("; ");
        if (this.target == null) {
            sb.append("target is null");
        } else {
            sb.append("target is of class [").append(this.target.getClass().getName()).append(']');
        }
        return sb.toString();
    }
}

