/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.aspectj;

import com.bmc.thirdparty.org.springframework.aop.ClassFilter;
import com.bmc.thirdparty.org.springframework.aop.IntroductionAwareMethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.MethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.aspectj.RuntimeTestWalker;
import com.bmc.thirdparty.org.springframework.aop.framework.ReflectiveMethodInvocation;
import com.bmc.thirdparty.org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import com.bmc.thirdparty.org.springframework.aop.support.AbstractExpressionPointcut;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.aspectj.weaver.tools.ShadowMatch;

public class AspectJExpressionPointcut
extends AbstractExpressionPointcut
implements ClassFilter,
IntroductionAwareMethodMatcher {
    private static final Set DEFAULT_SUPPORTED_PRIMITIVES = new HashSet();
    private final Map shadowMapCache = new HashMap();
    private PointcutParser pointcutParser;
    private Class pointcutDeclarationScope;
    private String[] pointcutParameterNames = new String[0];
    private Class[] pointcutParameterTypes = new Class[0];
    private PointcutExpression pointcutExpression;

    public AspectJExpressionPointcut() {
        this.pointcutParser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution((Set)this.getSupportedPrimitives());
    }

    public AspectJExpressionPointcut(Class scope, String[] paramNames, Class[] paramTypes) {
        this();
        this.pointcutDeclarationScope = scope;
        if (paramNames.length != paramTypes.length) {
            throw new IllegalStateException("Number of pointcut parameter names must match number of pointcut parameter types");
        }
        this.pointcutParameterNames = paramNames;
        this.pointcutParameterTypes = paramTypes;
    }

    public ClassFilter getClassFilter() {
        this.checkReadyToMatch();
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        this.checkReadyToMatch();
        return this;
    }

    public void setParameterNames(String[] names) {
        this.pointcutParameterNames = names;
    }

    public void setParameterTypes(Class[] types) {
        this.pointcutParameterTypes = types;
    }

    public void onSetExpression(String expression) {
    }

    private String replaceBooleanOperators(String pcExpr) {
        pcExpr = StringUtils.replace(pcExpr, " and ", " && ");
        pcExpr = StringUtils.replace(pcExpr, " or ", " || ");
        pcExpr = StringUtils.replace(pcExpr, " not ", " ! ");
        return pcExpr;
    }

    public PointcutExpression getPointcutExpression() {
        this.checkReadyToMatch();
        return this.pointcutExpression;
    }

    protected Set getSupportedPrimitives() {
        return DEFAULT_SUPPORTED_PRIMITIVES;
    }

    private void checkReadyToMatch() {
        if (this.getExpression() == null) {
            throw new IllegalStateException("Must set property [expression] before attempting to match.");
        }
        if (this.pointcutExpression == null) {
            this.buildPointcutExpression();
        }
    }

    private void buildPointcutExpression() {
        PointcutParameter[] pointcutParameters = new PointcutParameter[this.pointcutParameterNames.length];
        for (int i2 = 0; i2 < pointcutParameters.length; ++i2) {
            pointcutParameters[i2] = this.pointcutParser.createPointcutParameter(this.pointcutParameterNames[i2], this.pointcutParameterTypes[i2]);
        }
        this.pointcutExpression = this.pointcutParser.parsePointcutExpression(this.replaceBooleanOperators(this.getExpression()), this.pointcutDeclarationScope, pointcutParameters);
    }

    public boolean matches(Class targetClass) {
        this.checkReadyToMatch();
        return this.pointcutExpression.couldMatchJoinPointsInType(targetClass);
    }

    public boolean isRuntime() {
        this.checkReadyToMatch();
        return this.pointcutExpression.mayNeedDynamicTest();
    }

    public boolean matches(Method method, Class targetClass, boolean beanHasIntroductions) {
        this.checkReadyToMatch();
        Method methodToMatch = this.findMethodToMatchAgainst(method, targetClass);
        ShadowMatch shadowMatch = this.getShadowMatch(methodToMatch);
        if (shadowMatch.alwaysMatches()) {
            return true;
        }
        if (shadowMatch.neverMatches()) {
            return false;
        }
        if (!beanHasIntroductions) {
            return this.matchesIgnoringSubtypes(shadowMatch);
        }
        return true;
    }

    public boolean matches(Method method, Class targetClass) {
        return this.matches(method, targetClass, false);
    }

    private Method findMethodToMatchAgainst(Method method, Class targetClass) {
        Class originalTargetClass = targetClass;
        Class<?> declaredClass = method.getDeclaringClass();
        if (declaredClass.isInterface()) {
            Class<?>[] ptypes = method.getParameterTypes();
            String name = method.getName();
            while (true) {
                try {
                    return targetClass.getDeclaredMethod(name, ptypes);
                }
                catch (NoSuchMethodException ex) {
                    if ((targetClass = targetClass.getSuperclass()) != null) continue;
                    return method;
                }
                break;
            }
        }
        return method;
    }

    private boolean matchesIgnoringSubtypes(ShadowMatch shadowMatch) {
        return !new RuntimeTestWalker(shadowMatch).testsSubtypeSensitiveVars();
    }

    public boolean matches(Method method, Class targetClass, Object[] args) {
        Object thisObject;
        Object targetObject;
        ReflectiveMethodInvocation invocation;
        this.checkReadyToMatch();
        Method methodToMatch = this.findMethodToMatchAgainst(method, targetClass);
        ShadowMatch shadowMatch = this.getShadowMatch(methodToMatch);
        try {
            invocation = (ReflectiveMethodInvocation)ExposeInvocationInterceptor.currentInvocation();
            targetObject = invocation.getThis();
            thisObject = invocation.getProxy();
        }
        catch (IllegalStateException ex) {
            targetObject = null;
            thisObject = null;
            invocation = null;
        }
        JoinPointMatch joinPointMatch = shadowMatch.matchesJoinPoint(thisObject, targetObject, args);
        if (joinPointMatch.matches() && invocation != null) {
            this.bindParameters(invocation, joinPointMatch);
        }
        return joinPointMatch.matches();
    }

    private void bindParameters(ReflectiveMethodInvocation invocation, JoinPointMatch jpm) {
        invocation.setUserAttribute(this.getExpression(), jpm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowMatch getShadowMatch(Method method) {
        Map map = this.shadowMapCache;
        synchronized (map) {
            ShadowMatch shadowMatch = (ShadowMatch)this.shadowMapCache.get(method);
            if (shadowMatch == null) {
                shadowMatch = this.pointcutExpression.matchesMethodExecution(method);
                this.shadowMapCache.put(method, shadowMatch);
            }
            return shadowMatch;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AspectJExpressionPointcut: ");
        if (this.pointcutParameterNames != null && this.pointcutParameterTypes != null) {
            sb.append("(");
            for (int i2 = 0; i2 < this.pointcutParameterTypes.length; ++i2) {
                sb.append(this.pointcutParameterTypes[i2].getName());
                sb.append(" ");
                sb.append(this.pointcutParameterNames[i2]);
                if (i2 + 1 >= this.pointcutParameterTypes.length) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append(" ");
        if (this.getExpression() != null) {
            sb.append(this.getExpression());
        } else {
            sb.append("<pointcut expression not set>");
        }
        return sb.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.pointcutDeclarationScope == null ? 0 : this.pointcutDeclarationScope.hashCode());
        result = 31 * result + Arrays.hashCode(this.pointcutParameterNames);
        result = 31 * result + Arrays.hashCode(this.pointcutParameterTypes);
        result = 31 * result + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AspectJExpressionPointcut other = (AspectJExpressionPointcut)obj;
        if (this.pointcutDeclarationScope == null ? other.pointcutDeclarationScope != null : !this.pointcutDeclarationScope.equals(other.pointcutDeclarationScope)) {
            return false;
        }
        if (this.getExpression() == null ? other.getExpression() != null : !this.getExpression().equals(other.getExpression())) {
            return false;
        }
        if (!Arrays.equals(this.pointcutParameterNames, other.pointcutParameterNames)) {
            return false;
        }
        return Arrays.equals(this.pointcutParameterTypes, other.pointcutParameterTypes);
    }

    static {
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.EXECUTION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.REFERENCE);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.THIS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.TARGET);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ANNOTATION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_TARGET);
    }
}

