/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8176908615342565971L;
    private DataType _dataType;
    private Object _value;

    public Value() {
        this._value = null;
        this._dataType = DataType.NULL;
    }

    public Value(String string, DataType dataType) {
        switch (dataType.toInt()) {
            case 2: {
                this._value = new Integer(string.trim());
                this._dataType = DataType.INTEGER;
                break;
            }
            case 3: {
                this._value = new Double(string.trim());
                this._dataType = DataType.REAL;
                break;
            }
            case 4: {
                this._value = string;
                this._dataType = DataType.CHAR;
                break;
            }
            case 7: {
                long l2 = ConversionUtil.getLongValue(string);
                this._value = new Timestamp(l2);
                this._dataType = DataType.TIME;
                break;
            }
            case 8: {
                this._value = new Long(string);
                this._dataType = DataType.BITMASK;
                break;
            }
            case 14: {
                this._value = new Time(string);
                this._dataType = DataType.TIME_OF_DAY;
                break;
            }
            case 10: {
                if (".".equals(string)) {
                    string = "0";
                }
                this._value = new BigDecimal(string);
                this._dataType = DataType.DECIMAL;
                break;
            }
            case 40: {
                this._value = new Long(string.trim());
                this._dataType = DataType.ULONG;
                break;
            }
            case 6: {
                this._value = new Integer(string.trim());
                this._dataType = DataType.ENUM;
                break;
            }
            case 42: {
                this._value = string;
                this._dataType = DataType.VIEW;
                break;
            }
            case 43: {
                this._value = string;
                this._dataType = DataType.DISPLAY;
                break;
            }
            case 13: {
                this._value = new DateInfo(string);
                this._dataType = DataType.DATE;
                break;
            }
            case 12: {
                this._value = new CurrencyValue(string);
                this._dataType = DataType.CURRENCY;
                break;
            }
            case 33: {
                this._value = new Integer(string.trim());
                this._dataType = DataType.INTEGER;
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by this method. The datatype is " + dataType.toInt());
            }
        }
    }

    public Value(Keyword keyword) {
        this._value = keyword;
        this._dataType = DataType.KEYWORD;
    }

    public Value(int n2) {
        this._value = new Integer(n2);
        this._dataType = DataType.INTEGER;
    }

    public Value(double d2) {
        this._value = new Double(d2);
        this._dataType = DataType.REAL;
    }

    public Value(String string) {
        this._value = string;
        this._dataType = DataType.CHAR;
    }

    public Value(DiaryListValue diaryListValue) {
        this._value = diaryListValue;
        this._dataType = DataType.DIARY;
    }

    public Value(long l2) {
        this._value = new Long(l2);
        this._dataType = DataType.ULONG;
    }

    public Value(ByteListValue byteListValue) {
        this._value = byteListValue;
        this._dataType = DataType.BYTES;
    }

    public Value(Timestamp timestamp) {
        this._value = timestamp;
        this._dataType = DataType.TIME;
    }

    public Value(Time time) {
        this._value = time;
        this._dataType = DataType.TIME_OF_DAY;
    }

    public Value(BigDecimal bigDecimal) {
        this._value = bigDecimal;
        this._dataType = DataType.DECIMAL;
    }

    public Value(CurrencyValue currencyValue) {
        this._value = currencyValue;
        this._dataType = DataType.CURRENCY;
    }

    public Value(DateInfo dateInfo) {
        this._value = dateInfo;
        this._dataType = DataType.DATE;
    }

    public Value(AttachmentValue attachmentValue) {
        this._value = attachmentValue;
        this._dataType = DataType.ATTACHMENT;
    }

    public Value(List<CoordinateInfo> list) {
        this._value = list;
        this._dataType = DataType.COORDS;
    }

    Value(int n2, long l2) {
        this(l2, DataType.toDataType(n2));
    }

    Value(int n2, String string) {
        DataType dataType = DataType.toDataType(n2);
        if (!(dataType.equals(DataType.DECIMAL) || dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY))) {
            throw new IllegalArgumentException("datatype should be decimal, view or display");
        }
        if (dataType.equals(DataType.DECIMAL)) {
            if (".".equals(string)) {
                string = "0";
            }
            this._value = new BigDecimal(string);
        } else if (dataType.equals(DataType.VIEW) || dataType.equals(DataType.DISPLAY)) {
            this._value = string;
        }
        this._dataType = DataType.toDataType(n2);
    }

    void setKeyword(int n2) {
        this._dataType = DataType.KEYWORD;
        this._value = Keyword.toKeyword(n2);
    }

    public Object getValue() {
        return this._value;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    int getType() {
        return this._dataType.toInt();
    }

    int getIntValue() {
        return ((Number)this._value).intValue();
    }

    int getKeywordValue() {
        return ((Keyword)this._value).toInt();
    }

    double getDoubleValue() {
        return ((Number)this._value).doubleValue();
    }

    long getLongValue() {
        return ((Number)this._value).longValue();
    }

    int getEnumValue() {
        return ((Number)this._value).intValue();
    }

    long getTimestampValue() {
        return ((Timestamp)this._value).getValue();
    }

    long getTimeValue() {
        return ((Time)this._value).getValue();
    }

    int getDateValue() {
        return ((DateInfo)this._value).getValue();
    }

    String getDiaryValue() {
        if (this._value instanceof DiaryListValue) {
            return ((DiaryListValue)this._value).toString();
        }
        if (this._value instanceof String) {
            return (String)this._value;
        }
        return this._value != null ? this._value.toString() : null;
    }

    String getDecimalStringValue() {
        return ConversionUtil.getStringValue((BigDecimal)this._value);
    }

    public String getCurrencyValue() {
        return ((CurrencyValue)this._value).getValue().toString();
    }

    public String toString() {
        if (null == this._value) {
            return null;
        }
        return this._value.toString();
    }

    public Value(Object object, DataType dataType) {
        this._value = this.a(object, dataType);
        this._dataType = dataType;
    }

    private Object a(Object object, DataType dataType) {
        Object object2 = dataType.equals(DataType.ENUM) && object instanceof Number && !(object instanceof Integer) ? new Integer(((Number)object).intValue()) : object;
        return object2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Value)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Value value = (Value)object;
        if (value == null) {
            return false;
        }
        if (this._dataType == null && value.getDataType() != null || this._dataType != null && value.getDataType() == null) {
            return false;
        }
        if (this._dataType == null && value.getDataType() == null) {
            return this._value == null ? value.getValue() == null : this._value.equals(value.getValue());
        }
        if (!this._dataType.equals(value.getDataType())) {
            return false;
        }
        switch (this._dataType.toInt()) {
            case 0: {
                return true;
            }
            case 1: {
                return ((Keyword)this._value).equals(value.getValue());
            }
            case 6: {
                return ((Integer)this._value).equals(new Integer(ConversionUtil.getIntValue(value.getValue())));
            }
            case 2: {
                return ((Integer)this._value).equals(ConversionUtil.getIntValue(value.getValue()));
            }
            case 3: {
                return ((Double)this._value).equals(value.getValue());
            }
            case 4: {
                return ((String)this._value).equals(value.getValue());
            }
            case 5: {
                return this._value == null ? value.getValue() == null : this._value.equals(value.getValue());
            }
            case 7: {
                return ((Timestamp)this._value).equals(value.getValue());
            }
            case 8: 
            case 40: {
                return ((Long)this._value).equals(value.getValue());
            }
            case 14: {
                return ((Time)this._value).equals(value.getValue());
            }
            case 12: {
                return ((CurrencyValue)this._value).equals(value.getValue());
            }
            case 13: {
                return ((DateInfo)this._value).equals(value.getValue());
            }
            case 10: {
                return ((BigDecimal)this._value).compareTo((BigDecimal)value.getValue()) == 0;
            }
            case 41: {
                return this._value.equals(value.getValue());
            }
        }
        return this._value.equals(value.getValue());
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 37);
        hashCodeBuilder.append(this._dataType);
        hashCodeBuilder.append(this._value);
        return hashCodeBuilder.toHashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        Value value = (Value)super.clone();
        switch (this.getDataType().toInt()) {
            case 1: {
                value.a(this._value);
                break;
            }
            case 2: {
                value.a(new Integer(this.getIntValue()));
                break;
            }
            case 3: {
                value.a(new Double(this.getDoubleValue()));
                break;
            }
            case 4: {
                value.a(this._value);
                break;
            }
            case 5: {
                if (this._value == null) break;
                if (this._value instanceof DiaryListValue) {
                    value.a(((DiaryListValue)this._value).clone());
                    break;
                }
                if (!(this._value instanceof String)) break;
                value.a(this._value);
                break;
            }
            case 6: {
                value.a(new Integer(this.getIntValue()));
                break;
            }
            case 7: {
                if (this._value == null) break;
                value.a(((Timestamp)this._value).clone());
                break;
            }
            case 8: {
                value.a(new Long(this.getLongValue()));
                break;
            }
            case 9: {
                if (this._value == null) break;
                value.a(((ByteListValue)this._value).clone());
                break;
            }
            case 10: {
                value.a(new BigDecimal(((BigDecimal)this._value).toString()));
                break;
            }
            case 11: {
                if (this._value == null) break;
                value.a(((AttachmentValue)this._value).clone());
                break;
            }
            case 12: {
                if (this._value == null) break;
                value.a(((CurrencyValue)this._value).clone());
                break;
            }
            case 13: {
                if (this._value == null) break;
                value.a(((DateInfo)this._value).clone());
                break;
            }
            case 14: {
                if (this._value == null) break;
                value.a(((Time)this._value).clone());
                break;
            }
            case 40: {
                value.a(new Long(this.getLongValue()));
                break;
            }
            case 41: {
                if (this._value == null) break;
                ArrayList<CoordinateInfo> arrayList = new ArrayList<CoordinateInfo>(((List)this._value).size());
                List list = (List)this._value;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    CoordinateInfo coordinateInfo = (CoordinateInfo)list.get(i2);
                    arrayList.add(i2, (CoordinateInfo)coordinateInfo.clone());
                }
                value.a(arrayList);
                break;
            }
            case 42: {
                value.a(this._value);
                break;
            }
            case 43: {
                value.a(this._value);
                break;
            }
            default: {
                value.a((Object)null);
            }
        }
        return value;
    }

    private void a(DataType dataType) {
        this._dataType = dataType;
    }

    private void a(Object object) {
        this._value = object;
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        DataType dataType = DataType.toDataType(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 0)));
        this.a(dataType);
        Object object = ARTypeMgr.GetAt((Object)objectArray, 1);
        switch (dataType.toInt()) {
            case 0: {
                break;
            }
            case 2: 
            case 6: {
                this._value = ConversionUtil.getIntValue(object);
                break;
            }
            case 3: {
                this._value = ConversionUtil.getDoubleValue(object);
                break;
            }
            case 4: 
            case 42: 
            case 43: {
                this._value = object;
                break;
            }
            case 5: {
                String string = ConversionUtil.getStringValue(object);
                if (string != null && string.length() > 0) {
                    try {
                        this._value = DiaryListValue.decode(string);
                    }
                    catch (ARException aRException) {
                        this._value = object;
                    }
                    break;
                }
                this._value = object;
                break;
            }
            case 13: {
                int n2 = ConversionUtil.getIntValue(object);
                this._value = new DateInfo(n2);
                break;
            }
            case 7: {
                long l2 = ConversionUtil.getLongValue(object);
                this._value = new Timestamp(l2);
                break;
            }
            case 8: {
                long l3 = ConversionUtil.getLongValue(object);
                this._value = new Long(l3);
                break;
            }
            case 14: {
                long l4 = ConversionUtil.getLongValue(object);
                this._value = new Time(l4);
                break;
            }
            case 10: {
                this._value = new BigDecimal(object.toString());
                break;
            }
            case 40: {
                this._value = ConversionUtil.getLongValue(object);
                break;
            }
            case 12: {
                this._value = ARTypeMgr.getInstance().ObjectFromVariant(CurrencyValue.class, object, aRServerUser);
                break;
            }
            case 1: {
                this._value = Keyword.toKeyword(ConversionUtil.getIntValue(object));
                break;
            }
            case 11: {
                this._value = ARTypeMgr.getInstance().ObjectFromVariant(AttachmentValue.class, object, aRServerUser);
                break;
            }
            case 41: {
                this._value = ARTypeMgr.getInstance().ObjectListFromVariant(CoordinateInfo.class, object, aRServerUser);
                break;
            }
            case 9: {
                this._value = ARTypeMgr.getInstance().ObjectFromVariant(ByteListValue.class, object, aRServerUser);
                break;
            }
            case 33: {
                this._value = object;
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by this method");
            }
        }
    }

    static Value createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        Value value = new Value();
        if (objectArray.length == 2 && objectArray[0] != null) {
            value.fromVariant(objectArray, aRServerUser);
        }
        return value;
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[2];
        int n2 = this.getDataType().toInt();
        objectArray[0] = new Integer(n2);
        objectArray[1] = n2 == 1 ? new Integer(this.getKeywordValue()) : ARTypeMgr.getInstance().ObjectToVariant(this._value, aRServerUser);
        return objectArray;
    }

    private static int a(java.util.Date date) {
        return (int)(date.getTime() / 1000L);
    }

    private static java.util.Date if(int n2) {
        Date date = new Date(n2 * 1000);
        return date;
    }

    private static boolean a(int n2) {
        return n2 != 46;
    }

    private static int a(String string) {
        int n2 = 46;
        if (string.startsWith("$-") && string.endsWith("$")) {
            String string2 = string.substring(2, string.length() - 3);
            n2 = ConversionUtil.getIntValue(string2);
        }
        return n2;
    }

    public static Object ConvertToARValue(Object object) {
        Object[] objectArray = new Object[2];
        if (object instanceof Object[] && ((Object[])object).length == 2) {
            objectArray[0] = ((Object[])object)[0];
            objectArray[1] = ((Object[])object)[1];
            if (objectArray[1] instanceof java.util.Date) {
                objectArray[1] = Value.a((java.util.Date)objectArray[1]);
            } else if (objectArray[1] instanceof BigDecimal) {
                objectArray[1] = objectArray[1].toString();
            } else if (objectArray[1] instanceof AttachmentValue) {
                objectArray[0] = 11;
                Object object2 = ARTypeMgr.getInstance().ObjectToVariant(objectArray[1], null);
                byte[] byArray = ((AttachmentValue)objectArray[1]).getContent();
                ((Object[])object2)[3] = new Object[]{2, new Object[]{byArray.length, byArray}};
                objectArray[1] = object2;
            } else if (objectArray[1] instanceof CurrencyValue) {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(objectArray[1], null);
            } else if (objectArray[1] instanceof DiaryListValue) {
                objectArray[1] = ((DiaryListValue)objectArray[1]).encode();
            } else if (objectArray[1] instanceof StatusHistoryValue) {
                objectArray[0] = 4;
                objectArray[1] = ((StatusHistoryValue)objectArray[1]).encode();
            } else if (objectArray[1] instanceof ByteListValue) {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(objectArray[1], null);
            }
        } else if (object instanceof Integer) {
            objectArray[0] = 2;
            objectArray[1] = object;
        } else if (object instanceof String) {
            int n2 = Value.a((String)object);
            if (Value.a(n2)) {
                objectArray[0] = 1;
                objectArray[1] = n2;
            } else {
                objectArray[0] = 4;
                objectArray[1] = object;
            }
        } else if (object instanceof Double) {
            objectArray[0] = 3;
            objectArray[1] = object;
        } else if (object instanceof java.util.Date) {
            objectArray[0] = 7;
            objectArray[1] = Value.a((java.util.Date)object);
        } else if (object instanceof BigDecimal) {
            objectArray[0] = 10;
            objectArray[1] = object.toString();
        } else if (object instanceof AttachmentValue) {
            objectArray[0] = 11;
            objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(object, null);
            byte[] byArray = ((AttachmentValue)object).getContent();
            ((Object[])objectArray[1])[3] = new Object[]{2, new Object[]{byArray.length, byArray}};
        } else if (object instanceof CurrencyValue) {
            objectArray[0] = 12;
            objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(object, null);
        } else if (object instanceof DiaryListValue) {
            objectArray[0] = 5;
            objectArray[1] = ((DiaryListValue)object).encode();
        } else if (object instanceof StatusHistoryValue) {
            objectArray[0] = 4;
            objectArray[1] = ((StatusHistoryValue)object).encode();
        } else if (object instanceof ByteListValue) {
            objectArray[0] = 9;
            objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(object, null);
        } else if (object instanceof byte[] && ((byte[])object).length > 0) {
            objectArray[0] = 9;
            objectArray[1] = object;
        } else if (object instanceof Long) {
            objectArray[0] = 40;
            objectArray[1] = object;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof CoordinateInfo) {
            objectArray[0] = 41;
            objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(object, null);
        } else {
            objectArray[0] = 0;
            objectArray[1] = null;
        }
        return objectArray;
    }

    public static int getARValueType(Object object) {
        int n2 = 0;
        n2 = object instanceof Object[] && ((Object[])object).length == 2 ? ConversionUtil.getIntValue(((Object[])object)[0]) : (object instanceof Integer ? 2 : (object instanceof String ? (Value.a(Value.a((String)object)) ? 1 : 4) : (object instanceof Double ? 3 : (object instanceof java.util.Date ? 7 : (object instanceof BigDecimal ? 10 : (object instanceof Long ? 40 : (object instanceof AttachmentValue ? 11 : (object instanceof ArrayList && ((ArrayList)object).get(0) instanceof CoordinateInfo ? 41 : (object instanceof CurrencyValue ? 12 : (object instanceof DiaryListValue ? 5 : (object instanceof byte[] ? 9 : 0)))))))))));
        return n2;
    }

    public static Object convertFromARValue(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray == null || objectArray.length < 2) {
            return null;
        }
        int n2 = Value.getARValueType(objectArray);
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return String.format("$-%d$", ConversionUtil.getIntValue(objectArray[1]));
            }
            case 2: {
                return ConversionUtil.getIntValue(objectArray[1]);
            }
            case 3: {
                return ConversionUtil.getDoubleValue(objectArray[1]);
            }
            case 4: {
                if (bl) {
                    try {
                        return StatusHistoryValue.decode(objectArray[1].toString().trim());
                    }
                    catch (ARException aRException) {
                        return objectArray[1].toString();
                    }
                }
                return objectArray[1].toString();
            }
            case 5: {
                try {
                    DiaryListValue diaryListValue = DiaryListValue.decode(objectArray[1].toString());
                    return diaryListValue;
                }
                catch (ARException aRException) {
                    return objectArray[1];
                }
            }
            case 6: {
                if (bl2) {
                    return objectArray;
                }
                return ConversionUtil.getIntValue(objectArray[1]);
            }
            case 7: {
                if (objectArray[1] instanceof java.util.Date) {
                    return objectArray[1];
                }
                return Value.if(ConversionUtil.getIntValue(objectArray[1]));
            }
            case 8: {
                return objectArray[1];
            }
            case 9: {
                return ARTypeMgr.getInstance().ObjectFromVariant(ByteListValue.class, objectArray[1], null);
            }
            case 10: {
                return ConversionUtil.getBigDecimalValue(objectArray[1]);
            }
            case 11: {
                if (objectArray[1] instanceof AttachmentValue) {
                    return objectArray[1];
                }
                return ARTypeMgr.getInstance().ObjectFromVariant(AttachmentValue.class, objectArray[1], null);
            }
            case 12: {
                if (objectArray[1] instanceof CurrencyValue) {
                    return objectArray[1];
                }
                return ARTypeMgr.getInstance().ObjectFromVariant(CurrencyValue.class, objectArray[1], null);
            }
            case 13: {
                if (objectArray[1] instanceof Date) {
                    Date date = (Date)objectArray[1];
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return DateInfo.dateToJulianDate(calendar.get(1), calendar.get(2), calendar.get(6));
                }
                return ConversionUtil.getIntValue(objectArray[1]);
            }
            case 14: {
                return ConversionUtil.getIntValue(objectArray[1]);
            }
            case 33: {
                return objectArray;
            }
            case 40: {
                return ConversionUtil.getLongValue(objectArray[1]);
            }
            case 41: {
                return ARTypeMgr.getInstance().ObjectListFromVariant(CoordinateInfo.class, objectArray[1], null);
            }
            case 42: 
            case 43: {
                return objectArray;
            }
        }
        return null;
    }

    protected String valueToString() throws ARException {
        if (this.getValue() == null) {
            return new String();
        }
        switch (this.getType()) {
            case 0: {
                return new String();
            }
            case 2: 
            case 3: 
            case 6: {
                return Integer.valueOf(this.getIntValue()).toString();
            }
            case 4: 
            case 5: 
            case 10: {
                return this.getValue().toString();
            }
            case 7: {
                return Long.valueOf(this.getTimestampValue()).toString();
            }
            case 13: {
                return ((DateInfo)this._value).toString();
            }
            case 14: {
                return ((Time)this._value).toString();
            }
            case 12: {
                CurrencyValue currencyValue = (CurrencyValue)this.getValue();
                return new String(currencyValue.getValueString() + " " + currencyValue.getCurrencyCode());
            }
        }
        return new String();
    }

    static Value deserializeFromBytesBuffer(byte[] byArray, int n2, int n3, int n4, String string, OutputInteger outputInteger) throws ARException {
        Value value;
        String string2 = null;
        if (string == null) {
            string = "utf-8";
        }
        try {
            string2 = new String(byArray, n2, n3, string);
            if (string.equals("EUC_JP")) {
                string2 = new String(string2.getBytes("SJIS"), "windows-31j");
            }
            if (outputInteger != null) {
                outputInteger.setValue(string2.length());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ARException(2, 9062, unsupportedEncodingException.getMessage());
        }
        switch (n4) {
            case 12: {
                value = new Value(CurrencyValue.deserializeFromObjectStr(string2), DataType.toDataType(n4));
                break;
            }
            case 3: {
                value = new Value(RealField.deserializeFromObjectStr(string2), DataType.toDataType(n4));
                break;
            }
            case 11: {
                value = new Value(AttachmentValue.deserializeFromObjectStr(string2), DataType.toDataType(n4));
                break;
            }
            case 9: {
                value = new Value(ByteListValue.deserializeFromObjectStr(string2));
                break;
            }
            case 5: {
                try {
                    value = new Value(DiaryListValue.decode(string2));
                }
                catch (ARException aRException) {
                    value = new Value((Object)string2, DataType.DIARY);
                }
                break;
            }
            default: {
                value = new Value(string2, DataType.toDataType(n4));
            }
        }
        return value;
    }
}

