/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSOperation;
import com.bmc.arsys.ws.mapping.ARSPort;
import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.WsdlOperation;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlPortBindingOperation {
    protected String portName = null;
    protected Service service = null;
    protected Port port = null;
    protected Binding binding = null;
    protected SOAPBinding soapBinding = null;
    protected String bindingStyle = null;
    protected Map<String, WsdlOperation> operations = null;
    protected List<WsdlOperation> operationsList = null;

    public WsdlPortBindingOperation() {
    }

    public WsdlPortBindingOperation(Service service, Port port, Binding binding, SOAPBinding sOAPBinding) {
        this.setPort(port);
        this.service = service;
        this.binding = binding;
        this.soapBinding = sOAPBinding;
        this.operationsList = new LinkedList<WsdlOperation>();
        this.operations = new HashMap<String, WsdlOperation>();
    }

    public Service getParentService() {
        return this.service;
    }

    public void setParentService(Service service) {
        this.service = service;
    }

    public Port getPort() {
        return this.port;
    }

    public void setPort(Port port) {
        this.port = port;
        this.portName = port.getName();
    }

    public String getPortName() {
        return this.portName;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public SOAPBinding getSoapBinding() {
        return this.soapBinding;
    }

    public void setSoapBinding(SOAPBinding sOAPBinding) {
        this.soapBinding = sOAPBinding;
    }

    public String getBindingStyle() {
        return this.bindingStyle;
    }

    public void setBindingStyle(String string) {
        this.bindingStyle = string;
    }

    public WsdlOperation getOperation(String string) {
        return this.operations.get(string);
    }

    public List getOperationList() {
        return this.operationsList;
    }

    public Map getOperationMap() {
        return this.operations;
    }

    public void addOperation(WsdlOperation wsdlOperation) {
        if (this.operationsList == null) {
            this.operationsList = new LinkedList<WsdlOperation>();
        }
        if (this.operations == null) {
            this.operations = new HashMap<String, WsdlOperation>();
        }
        this.operations.put(wsdlOperation.getName(), wsdlOperation);
        this.operationsList.add(wsdlOperation);
    }

    public void setOperationList(Map<String, WsdlOperation> map, List<WsdlOperation> list) {
        this.operations = map;
        this.operationsList = list;
    }

    protected void parseOperations() {
        String string = this.soapBinding.getStyle();
        WsdlUtil.trace(" SoapBindingStyle: " + string);
        if (string == null || string.equals("")) {
            string = "document";
        }
        List list = this.binding.getBindingOperations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WsdlOperation wsdlOperation = new WsdlOperation((BindingOperation)iterator.next(), string);
            this.addOperation(wsdlOperation);
        }
        if (this.operationsList.size() == 0) {
            throw new ARWSException("INVALID_WSDL", "Not a single document/literal operation");
        }
        this.setBindingStyle(string);
    }

    public void createMappingDoc(ARSWebService aRSWebService, Document document, XMLSchemaParser xMLSchemaParser, Definition definition, StringBuffer stringBuffer) {
        String string3;
        String string2 = null;
        List list = this.port.getExtensibilityElements();
        for (String string3 : list) {
            if (!(string3 instanceof SOAPAddress)) continue;
            string2 = ((SOAPAddress)string3).getLocationURI();
        }
        string3 = "";
        Iterator<WsdlOperation> iterator = this.operationsList.iterator();
        if (this.operationsList.size() > 0) {
            string3 = this.operationsList.get((int)0).useStyle;
        }
        ARSPort aRSPort = new ARSPort(this.portName, string2, aRSWebService.getTargetNamespace(), this.bindingStyle, string3);
        while (iterator.hasNext()) {
            WsdlOperation wsdlOperation = iterator.next();
            try {
                this.createOperationDoc(wsdlOperation, document, xMLSchemaParser, definition, aRSPort);
            }
            catch (ARWSException aRWSException) {
                stringBuffer.append("WARNING: Ignored method: " + wsdlOperation.getName() + aRWSException + System.getProperty("line.separator"));
            }
        }
        aRSWebService.addPort(aRSPort);
    }

    protected void createOperationDoc(WsdlOperation wsdlOperation, Document document, XMLSchemaParser xMLSchemaParser, Definition definition, ARSPort aRSPort) {
        Object object;
        String string = "";
        String string2 = "";
        ARSMapping aRSMapping = null;
        ARSMapping aRSMapping2 = null;
        if (wsdlOperation.getBindingStyle().equals("rpc")) {
            if (wsdlOperation.getInputMessage() != null) {
                string = wsdlOperation.getName();
                object = wsdlOperation.getUseStyle().equals("encoded") ? wsdlOperation.getInputBody().getNamespaceURI() : aRSPort.getTargetNamespace();
                aRSMapping = new ARSMapping(xMLSchemaParser, wsdlOperation.getInputMessage(), (String)object, document, wsdlOperation.getUseStyle());
            }
            if (wsdlOperation.getOutputMessage() != null) {
                string2 = wsdlOperation.getName() + "Response";
                object = wsdlOperation.getUseStyle().equals("encoded") ? wsdlOperation.getOutputBody().getNamespaceURI() : aRSPort.getTargetNamespace();
                aRSMapping2 = new ARSMapping(xMLSchemaParser, wsdlOperation.getOutputMessage(), (String)object, document, wsdlOperation.getUseStyle());
            }
        } else if (wsdlOperation.getBindingStyle().equals("document")) {
            if (wsdlOperation.getFirstInputPart() != null) {
                string = wsdlOperation.getFirstInputPart().getElementName() == null ? "" : wsdlOperation.getFirstInputPart().getElementName().getLocalPart();
                aRSMapping = new ARSMapping(xMLSchemaParser, wsdlOperation.getFirstInputPart(), document, wsdlOperation.getUseStyle(), true);
            }
            if (wsdlOperation.getFirstOutputPart() != null) {
                string2 = wsdlOperation.getFirstOutputPart().getElementName() == null ? "" : wsdlOperation.getFirstOutputPart().getElementName().getLocalPart();
                aRSMapping2 = new ARSMapping(xMLSchemaParser, wsdlOperation.getFirstOutputPart(), document, wsdlOperation.getUseStyle(), true);
            }
        }
        if ((object = wsdlOperation.getInputHeaderList()) != null && object.size() > 0) {
            aRSMapping.addSoapHeaderList(xMLSchemaParser, (List)object, definition);
        }
        if (aRSMapping != null) {
            aRSPort.addMapping(aRSMapping);
        }
        if (aRSMapping2 != null) {
            aRSPort.addMapping(aRSMapping2);
        }
        ARSOperation aRSOperation = new ARSOperation(wsdlOperation.getName(), wsdlOperation.getSoapActionURI(), aRSMapping != null ? aRSMapping.getName() : "", string, aRSMapping2 != null ? aRSMapping2.getName() : "", string2, wsdlOperation.getBindingStyle(), wsdlOperation.getUseStyle(), aRSMapping.getTargetNamespace(), aRSMapping2.getTargetNamespace());
        aRSPort.addOperation(aRSOperation);
    }
}

