/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.registry;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.webservices.uddiapi.RegistryServerInfo;
import com.bmc.webservices.uddiapi.RegistryServerInfoFactory;
import com.bmc.webservices.uddiapi.Service;
import com.bmc.webservices.uddiapi.ServiceFactory;
import com.bmc.webservices.uddiapi.UDDIRegistry;
import com.bmc.webservices.uddiapi.UDDIRegistryFactory;
import com.bmc.webservices.uddiapi.User;
import com.bmc.webservices.uddiapi.UserFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARRegistryPlugin
extends ARFilterAPIPlugin {
    private String applicationName = null;
    private String businessName = null;
    private String webService = null;
    private String description = null;
    private String webServiceVersion = null;
    private URL wsdlUrl = null;
    private URL endPointUrl = null;
    private Value publish = null;
    private String outStr = null;
    private ArrayList<Value> outValues = new ArrayList();
    private RegistryServerInfo serverInfo;
    private UDDIRegistry uddiRegistry;
    private User user;
    private String registryLocation = null;
    private String tempRegLocation = null;
    private String registryAdminUser;
    private String registryAdminPassword;
    private URL securityServiceAccessPoint;
    private URL inquiryAccessPoint;
    private URL publishingAccessPoint;
    private URL subscriptionAccessPoint;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.REGISTRY", this);
    private final ReentrantLock lock = new ReentrantLock();

    public static void init(ARPluginContext aRPluginContext) {
        System.out.println("Static initialize method invoked");
        System.out.println("UserDefined value for ARRegistry " + aRPluginContext.getConfigItem("ARRegistry"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> filterAPICall(ARPluginContext aRPluginContext, List<Value> list) throws ARException {
        this.lock.lock();
        try {
            aRPluginContext.logMessage(this.pluginInfo, 0, "filterapiCall()");
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                aRPluginContext.logMessage(this.pluginInfo, 2, "Registry Location cannot be empty");
                throw new ARException(2, 9130, "Registry Location cannot be empty");
            }
            if (list.size() == 0) {
                aRPluginContext.logMessage(this.pluginInfo, 2, "Incorrect number of inputs. Got " + Integer.toString(list.size()) + ". Expected 7 or 8");
                throw new ARException(2, 9130, "Invalid number of arguments");
            }
            if (list.size() > 8) {
                aRPluginContext.logMessage(this.pluginInfo, 2, "Incorrect number of inputs. Got " + Integer.toString(list.size()) + ". Expected 7 or 8");
                throw new ARException(2, 9130, "Invalid number of arguments");
            }
            aRPluginContext.logMessage(this.pluginInfo, 0, "applicationName : " + list.get(0).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "businessName : " + list.get(1).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "webService : " + list.get(2).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "webServiceVersion : " + list.get(3).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "description : " + list.get(4).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "wsdlUrl : " + list.get(5).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "endPointUrl : " + list.get(6).toString());
            this.applicationName = list.get(0).toString();
            this.businessName = list.get(1).toString();
            this.webService = list.get(2).toString();
            this.webServiceVersion = list.get(3).toString();
            this.description = list.get(4).toString();
            try {
                this.wsdlUrl = new URL(list.get(5).toString());
                aRPluginContext.logMessage(this.pluginInfo, 0, "wsdlUrl : " + this.wsdlUrl.toString());
                this.endPointUrl = new URL(list.get(6).toString());
                aRPluginContext.logMessage(this.pluginInfo, 0, "endPointUrl : " + this.endPointUrl.toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new ARException(2, 9130, "Invalid URL: " + malformedURLException.toString());
            }
            if (list.size() > 7) {
                this.publish = list.get(7);
                Integer n = (Integer)this.publish.getValue();
                aRPluginContext.logMessage(this.pluginInfo, 0, "publish : " + n.toString());
                if (n == 0) {
                    this.outStr = this.registerService(aRPluginContext);
                }
                if (n == 1) {
                    this.outStr = this.deregisterService(aRPluginContext);
                }
            } else {
                aRPluginContext.logMessage(this.pluginInfo, 0, "publish : null");
                this.outStr = this.deregisterService(aRPluginContext);
            }
            this.outValues.add(0, new Value(this.outStr));
        }
        finally {
            this.lock.unlock();
        }
        return this.outValues;
    }

    @Override
    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        try {
            this.tempRegLocation = aRPluginContext.getARConfigEntry("Registry-Location");
            aRPluginContext.logMessage(this.pluginInfo, 0, "tempRegLocation " + this.tempRegLocation);
            if (this.registryLocation == null && this.tempRegLocation == null || this.tempRegLocation != null && this.tempRegLocation.equals(this.registryLocation)) {
                this.checkLocation = false;
            } else {
                this.registryLocation = this.tempRegLocation;
                this.checkLocation = true;
            }
            if (this.onEventFlag == 0) {
                this.checkLocation = true;
            } else {
                this.onEventFlag = 0;
            }
            aRPluginContext.logMessage(this.pluginInfo, 0, "registry location " + this.registryLocation);
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                if (this.checkLocation) {
                    aRPluginContext.logMessage(this.pluginInfo, 1, "Null registry location");
                    return;
                }
                return;
            }
            this.registryAdminUser = aRPluginContext.getARConfigEntry("Registry-Admin-User");
            aRPluginContext.logMessage(this.pluginInfo, 0, "registry admin user " + this.registryAdminUser);
            this.registryAdminPassword = aRPluginContext.getARConfigEntry("Registry-Admin-Password");
            if (this.registryAdminPassword != null) {
                PasswordReserveFieldEncryption passwordReserveFieldEncryption = new PasswordReserveFieldEncryption(false);
                byte[] byArray = passwordReserveFieldEncryption.decryptPasswordEx(this.registryAdminPassword.getBytes());
                this.registryAdminPassword = new String(byArray);
            }
            this.securityServiceAccessPoint = new URL(this.registryLocation + "/uddi/services/security");
            this.inquiryAccessPoint = new URL(this.registryLocation + "/uddi/services/inquiry");
            this.publishingAccessPoint = new URL(this.registryLocation + "/uddi/services/publication");
            this.subscriptionAccessPoint = new URL(this.registryLocation + "/uddi/services/subscription");
            this.serverInfo = RegistryServerInfoFactory.newInstance((URL)this.securityServiceAccessPoint, (URL)this.inquiryAccessPoint, (URL)this.publishingAccessPoint, (URL)this.subscriptionAccessPoint);
            this.uddiRegistry = UDDIRegistryFactory.newInstance((RegistryServerInfo)this.serverInfo);
            this.user = UserFactory.newInstance((String)this.registryAdminUser, (String)this.registryAdminPassword);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ARException(2, 9130, exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ARPluginContext aRPluginContext, int n) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "on event called with event id " + String.valueOf(n));
        this.lock.lock();
        try {
            if (n == 10005) {
                this.onEventFlag = 1;
                this.initialize(aRPluginContext);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private String registerService(ARPluginContext aRPluginContext) {
        Service service = ServiceFactory.newInstance((String)this.webService, (String)this.businessName, (String)this.applicationName, (String)this.webServiceVersion, (String)this.description, (URL)this.endPointUrl, (URL)this.wsdlUrl);
        Service service2 = this.uddiRegistry.publishService(this.user, service);
        aRPluginContext.logMessage(this.pluginInfo, 0, "registerService returned " + service2);
        if (service2 != null) {
            return "Registered";
        }
        return "Not Registered";
    }

    private String deregisterService(ARPluginContext aRPluginContext) {
        boolean bl = false;
        Service service = ServiceFactory.newInstance((String)this.webService, (String)this.businessName, (String)this.applicationName, (String)this.webServiceVersion);
        Service service2 = this.uddiRegistry.findService(this.user, this.businessName, this.applicationName, this.webService, this.webServiceVersion);
        bl = service2 != null ? this.uddiRegistry.deleteService(this.user, service) : true;
        aRPluginContext.logMessage(this.pluginInfo, 0, "deregisterService returned " + bl);
        if (bl) {
            return "Not Registered";
        }
        return "Registered";
    }
}

