/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefinitionOptions {
    private static Logger o = Logger.getLogger("com.bmc.arsys.api.definition");
    private ARServerUser for;
    private String p = "";
    private String a = "";
    private String f = "";
    private String else = "";
    private int new = 0;
    private final Map<DefinitionItemType, Boolean> try = new HashMap<DefinitionItemType, Boolean>();
    private final Map<DefinitionItemType, List<BaseItemData>> d = new HashMap<DefinitionItemType, List<BaseItemData>>();
    private Operation goto = Operation.NONE;
    private String n = "";
    private String h = null;
    private boolean do = false;
    private boolean i = false;
    private boolean void = false;
    private int k = 0;
    private boolean byte = true;
    private boolean e = false;
    private String char = "";
    private int m = 16;
    private boolean g = false;
    private boolean case = false;
    private boolean long = false;
    private boolean b = false;
    private String j = null;
    private boolean c = false;
    private String int = null;
    private String if = null;
    private int l = 36;

    public String getCharset() {
        return this.int;
    }

    public void setCharset(String string) {
        this.int = string;
    }

    public String getServerLanguage() {
        return this.if;
    }

    public void setServerLanguage(String string) {
        this.if = string;
    }

    public boolean isDsoLicensed() {
        return this.c;
    }

    public void setDsoLicensed(boolean bl) {
        this.c = bl;
    }

    public String getLockKey() {
        return this.char;
    }

    public void setLockKey(String string) {
        this.char = string;
    }

    public int getLockType() {
        return this.k;
    }

    public void setLockType(int n) {
        this.k = n;
    }

    public String getFileName() {
        return this.n;
    }

    public void setFileName(String string) {
        this.n = string;
    }

    public Operation getOperation() {
        return this.goto;
    }

    public void setOperation(Operation operation) {
        this.goto = operation;
    }

    public boolean isAll(DefinitionItemType definitionItemType) {
        if (this.try.get((Object)definitionItemType) != null) {
            return this.try.get((Object)definitionItemType);
        }
        return false;
    }

    public void setAll(DefinitionItemType definitionItemType, boolean bl) {
        this.try.put(definitionItemType, bl);
    }

    public String getAuthentication() {
        return this.else;
    }

    public void setAuthentication(String string) {
        this.else = string;
    }

    public String getPassword() {
        return this.a;
    }

    public void setPassword(String string) {
        this.a = string;
    }

    public int getPortNumber() {
        return this.new;
    }

    public void setPortNumber(int n) {
        this.new = n;
    }

    public String getServer() {
        return this.f;
    }

    public void setServer(String string) {
        this.f = string;
    }

    public String getUser() {
        return this.p;
    }

    public void setUser(String string) {
        this.p = string;
    }

    public void add(DefinitionItemType definitionItemType, String string, RelatedType relatedType) {
        if (string != null && string.length() > 0) {
            if (this.d.get((Object)definitionItemType) == null) {
                this.d.put(definitionItemType, new ArrayList());
            }
            this.d.get((Object)definitionItemType).add(new DefinitionItemData(definitionItemType, string, relatedType));
        }
    }

    public void add(BaseItemData baseItemData) {
        if (baseItemData != null) {
            if (this.d.get((Object)baseItemData.getType()) == null) {
                this.d.put(baseItemData.getType(), new ArrayList());
            }
            this.d.get((Object)baseItemData.getType()).add(baseItemData);
        }
    }

    public boolean isOverwrite() {
        return this.do;
    }

    public void setOverwrite(boolean bl) {
        this.do = bl;
    }

    public String getCommandSetFile() {
        return this.h;
    }

    public void setCommandSetFile(String string) {
        this.h = string;
    }

    public void validate() throws DefinitionException {
        if (this.getUser() == null || this.getUser() != null && this.getUser().length() == 0) {
            throw new DefinitionException("User Name must be provided");
        }
        if (this.getServer() == null || this.getServer() != null && this.getServer().length() == 0) {
            throw new DefinitionException("Server Name must be provided");
        }
        if (this.getFileName() == null || this.getFileName() != null && this.getFileName().length() == 0) {
            throw new DefinitionException("File Name must be provided");
        }
        int n = Util.validateFileName(this.getFileName());
        switch (n) {
            case 1: {
                throw new DefinitionException("File name validation failed. The directory is not valid.");
            }
            case 2: {
                throw new DefinitionException("File name validation failed. The file name is invalid.");
            }
            case 3: {
                throw new DefinitionException("File name validation failed. No file name was supplied.");
            }
            case 4: {
                throw new DefinitionException("File name validation failed. The supplied file name is a directory.");
            }
            case 5: {
                throw new DefinitionException("File name validation failed. The directory does not exist.");
            }
            case 6: {
                throw new DefinitionException("File name validation failed. The file name must have a .def or .xml extension.");
            }
        }
        if (n != 0) {
            // empty if block
        }
    }

    public boolean requiresExpansion() {
        for (DefinitionItemType definitionItemType : this.try.keySet()) {
            if (this.try.get((Object)definitionItemType) == null || !this.try.get((Object)definitionItemType).booleanValue()) continue;
            return true;
        }
        for (DefinitionItemType definitionItemType : this.d.keySet()) {
            List<BaseItemData> list = this.d.get((Object)definitionItemType);
            if (list == null) continue;
            for (BaseItemData baseItemData : list) {
                if (!(baseItemData instanceof DefinitionItemData) || ((DefinitionItemData)baseItemData).getRelated() == RelatedType.NONE || ((DefinitionItemData)baseItemData).getRelated() == RelatedType.FULL) continue;
                return true;
            }
        }
        return false;
    }

    public void connect() throws ARException {
        try {
            this.for = new ARServerUser();
            this.for.setUser(this.getUser());
            this.for.setPassword(this.getPassword());
            this.for.setServer(this.getServer());
            this.for.setPort(this.getPortNumber());
            this.for.setAuthentication(this.getAuthentication());
            this.for.setClientType(this.l);
            this.for.useAdminRpcQueue();
            this.for.login();
        }
        catch (ARException aRException) {
            if (o.isEnabledFor(Level.ERROR)) {
                o.error(MessageFormat.format("Unable to connect to server {0} : {1}", this.getServer(), aRException.getMessage()));
            }
            throw aRException;
        }
    }

    public ARServerUser getContext() {
        return this.for;
    }

    public boolean isXML() {
        return this.n != null && this.n.length() > 0 && this.n.toUpperCase().endsWith(".XML");
    }

    public int getObjectCount() {
        int n = 0;
        for (DefinitionItemType definitionItemType : this.d.keySet()) {
            if (this.d.get((Object)definitionItemType) == null) continue;
            n += this.d.get((Object)definitionItemType).size();
        }
        return n;
    }

    public List<BaseItemData> getItems(DefinitionItemType definitionItemType) {
        return this.d.get((Object)definitionItemType);
    }

    public void addAll(Map<DefinitionItemType, List<BaseItemData>> map) {
        for (DefinitionItemType definitionItemType : map.keySet()) {
            List<BaseItemData> list = map.get((Object)definitionItemType);
            if (list == null) continue;
            if (this.d.get((Object)definitionItemType) == null) {
                this.d.put(definitionItemType, list);
                continue;
            }
            for (BaseItemData baseItemData : list) {
                this.d.get((Object)definitionItemType).add(baseItemData);
            }
        }
    }

    public Map<DefinitionItemType, Boolean> getAllFlags() {
        return this.try;
    }

    public boolean isServerIndependent() {
        return this.byte;
    }

    public void setServerIndependent(boolean bl) {
        this.byte = bl;
    }

    public Map<DefinitionItemType, List<BaseItemData>> getItems() {
        return this.d;
    }

    public boolean isDeleteExcessFields() {
        return this.i;
    }

    public void setDeleteExcessFields(boolean bl) {
        this.i = bl;
    }

    public boolean isDeleteExcessViews() {
        return this.void;
    }

    public void setDeleteExcessViews(boolean bl) {
        this.void = bl;
    }

    public int getConflictHandling() {
        return this.m;
    }

    public void setConflictHandling(int n) {
        this.m = n;
    }

    public boolean isImportCompleteFile() {
        return this.e;
    }

    public void setImportCompleteFile(boolean bl) {
        this.e = bl;
    }

    public boolean isPreserveVUINamespace() {
        return this.case;
    }

    public void setPreserveVUINamespace(boolean bl) {
        this.case = bl;
    }

    public boolean isPreserveIndex() {
        return this.g;
    }

    public void setPreserveIndex(boolean bl) {
        this.g = bl;
    }

    public boolean isPreserveAppForms() {
        return this.long;
    }

    public void setPreserveAppForms(boolean bl) {
        this.long = bl;
    }

    public boolean isImportWithAppOwner() {
        return this.b;
    }

    public void setImportWithAppOwner(boolean bl) {
        this.b = bl;
    }

    public String getLogFile() {
        return this.j;
    }

    public void setLogFile(String string) {
        this.j = string;
    }

    public void setClientType(int n) {
        this.l = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        NONE,
        IMPORT,
        EXPORT;

    }
}

