/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.csv;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.Util;
import com.bmc.arsys.apiext.data.csv.CSVParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVImporter
extends BaseImporter {
    private static Logger ce = Logger.getLogger(CSVImporter.class);
    private boolean cf = true;

    public CSVImporter(ImportOptions importOptions) throws ARImportException {
        super(importOptions);
    }

    @Override
    protected void handleDataEvent(List<String> list, String string) throws ARImportException, ARException {
        FormInformation formInformation;
        if (this.cf && (formInformation = this.options.getFileForms().get("ARImport_Data_Holder")) == null) {
            formInformation = this.a(list);
            this.options.addFileForm(formInformation);
            this.setSourceForm(formInformation);
            this.cf = false;
        }
        if (this.getParser().isAbort() && this.getParser().isCopyToLog()) {
            Util.logEntry(string);
            this.getOptions().getResults().addError(this.getTargetForm().getName(), null);
            this.getOptions().getResults().incrementRecordCount(this.getTargetForm().getName());
        } else {
            this.createEntry(list, string);
        }
    }

    @Override
    protected void handleTitlesEvent(List<String> list) throws ARException {
        FormInformation formInformation = this.options.getFileForms().get("ARImport_Data_Holder");
        if (formInformation == null) {
            formInformation = this.a(list);
            this.options.addFileForm(formInformation);
            this.setSourceForm(formInformation);
            this.cf = false;
        }
        String string = null;
        string = this.getTargetForm() == null ? this.options.getFormMap().get("ARImport_Data_Holder") : this.getTargetForm().getName();
        MappingOptions mappingOptions = this.options.getMappingOptions("ARImport_Data_Holder", string);
        if (mappingOptions == null || mappingOptions != null && mappingOptions.getMappings().isEmpty()) {
            this.options.addMappingOptions("ARImport_Data_Holder", this.getTargetForm().getName(), Util.generateMappingsForTextFiles(this.getTargetForm(), formInformation));
        } else {
            for (Mapping mapping : mappingOptions.getMappings().values()) {
                int n;
                if (mapping.getType() != Mapping.Type.FIELDNAME || (n = list.indexOf(mapping.getFieldName())) == -1) continue;
                if (mapping.getTokenIndex() == -1) {
                    mapping.setTokenIndex(n);
                }
                if (mapping.getFieldId() != -1) continue;
                mapping.setFieldId(n);
            }
        }
        super.handleTitlesEvent(list);
    }

    private FormInformation a(List<String> list) {
        FormInformation formInformation = new FormInformation();
        formInformation.setName("ARImport_Data_Holder");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            FieldInformation fieldInformation = new FieldInformation();
            fieldInformation.setName(string);
            fieldInformation.setFieldId(i);
            fieldInformation.setTokenIndex(i);
            formInformation.getFields().put(i, fieldInformation);
        }
        return formInformation;
    }

    private void a(String string, String string2) throws ARImportException, IOException, ARException {
        ((CSVParser)this.getParser()).parseFile(string, string2);
    }

    @Override
    public void startImport() throws ARImportException, IOException, ARException {
        if (ce.isInfoEnabled()) {
            ce.info(MessageFormat.format("Starting import of {0}", this.options.getFileOptions().getDataFile()));
        }
        this.a(this.options.getFileOptions().getDataFile(), this.options.getFileOptions().getCharSet());
    }

    @Override
    protected Parser createParser() {
        return new CSVParser(this.options.getFileOptions().isHasTitles());
    }

    @Override
    protected FormInformation getTargetForm() throws ARException {
        Iterator<String> iterator;
        Object object;
        if (super.getTargetForm() != null) {
            return super.getTargetForm();
        }
        String string = null;
        if (this.getSourceForm() != null && (object = this.options.getMappingOptions("ARImport_Data_Holder")) != null && (iterator = object.keySet().iterator()).hasNext()) {
            String string2;
            string = string2 = iterator.next();
        }
        if (string == null) {
            object = this.options.getFormMap().get("ARImport_Data_Holder");
            if (object != null) {
                this.setTargetForm(Util.getServerForm(this.options, (String)object));
                this.options.addServerForm(super.getTargetForm());
            } else {
                this.setTargetForm(this.options.getFirstServerForm());
            }
        }
        if (super.getTargetForm() == null && string != null) {
            this.setTargetForm(Util.getServerForm(this.options, string));
        }
        return super.getTargetForm();
    }
}

