/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.Util;
import java.text.MessageFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class ARDataImporter
extends BaseImporter {
    private static Logger cg = Logger.getLogger(ARDataImporter.class);

    public ARDataImporter(ImportOptions importOptions) throws ARImportException {
        super(importOptions);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleNewFormEvent(FormInformation formInformation) throws ARImportException, ARException {
        Object object;
        Object object2;
        if (this.getCurrentSource() != null) {
            // empty if block
        }
        this.setSourceForm(formInformation);
        this.setProcessDataSet(true);
        if (cg.isInfoEnabled()) {
            cg.info(MessageFormat.format("Found new form in file : {0} ", formInformation.getName()));
        }
        Object object3 = null;
        String object4 = null;
        String string = formInformation.getName();
        this.setTargetForm(null);
        if (!this.options.getFormMap().isEmpty()) {
            object4 = this.options.getFormMap().get(string);
            if (object4 == null || object4 != null && object4.length() == 0) {
                object4 = this.options.getFormMap().get("ARImport_Data_Holder");
            }
            if (object4 == null && (this.options.getFileOptions().getType().equals("ARX") || this.options.getFileOptions().getType().equals("XML"))) {
                object2 = this.options.getFormMap().keySet().iterator();
                if (object2.hasNext()) {
                    object3 = object = (String)object2.next();
                }
                if (!this.options.getFileForms().keySet().contains(object3) && this.options.isImportAllDataSets()) {
                    object4 = this.options.getFormMap().get(object3);
                    if (cg.isEnabledFor(Level.WARN)) {
                        cg.warn(MessageFormat.format("Mapped source form {0} does not exist in the data file. Switching import to first data set only and remapping {1} to {2}", object3, string, object4));
                    }
                    this.options.setImportAllDataSets(false);
                } else {
                    if (cg.isInfoEnabled()) {
                        cg.info(MessageFormat.format("Skipping unmapped data set {0}.", string));
                    }
                    this.setProcessDataSet(false);
                }
            }
        }
        if (object4 != null) {
            try {
                this.setTargetForm(Util.getServerForm(this.options, object4));
                this.options.addServerForm(this.getTargetForm());
            }
            catch (ARException aRException) {
                throw new ARImportException(MessageFormat.format("Unable to retrieve destination form {0} from server {1}", object4, this.options.getContext().getServer()), aRException);
            }
        }
        if (this.getTargetForm() == null && this.isProcessDataSet()) {
            if (this.options.isImportAllDataSets()) {
                this.options.addMappingOptions(string, string, null);
                object2 = null;
                try {
                    object2 = Util.getServerForm(this.options, this.getSourceForm().getName());
                    this.setTargetForm((FormInformation)object2);
                    this.options.addServerForm(this.getTargetForm());
                    object4 = ((FormInformation)object2).getName();
                }
                catch (ARException aRException) {
                    if (cg.isEnabledFor(Level.WARN)) {
                        void var7_13;
                        String object5 = "";
                        if (aRException.getLastStatus() != null && !aRException.getLastStatus().isEmpty()) {
                            String string2 = ((StatusInfo)aRException.getLastStatus().get(0)).getMessageText();
                        }
                        cg.warn(MessageFormat.format("Unable to retrieve destination form {0} from server {1}. The import was not attempted : {2}", this.getSourceForm().getName(), this.options.getContext().getServer(), var7_13));
                    }
                    if (cg.isDebugEnabled()) {
                        cg.debug("Form missing.", aRException);
                    }
                    this.setProcessDataSet(false);
                }
            } else if (this.options.isFromARM()) {
                object2 = this.options.getMappingOptions(string);
                if (object2 == null) {
                    object2 = this.options.getMappingOptions("ARImport_Data_Holder");
                }
                if ((object = object2.keySet().iterator()).hasNext()) {
                    String string3;
                    object4 = string3 = (String)object.next();
                }
                try {
                    this.setTargetForm(Util.getServerForm(this.options, object4));
                    this.options.addServerForm(this.getTargetForm());
                }
                catch (ARException aRException) {
                    throw new ARImportException("Unable to retrieve destination from information from server");
                }
                this.options.addMappingOptions(string, object4, null);
            } else {
                try {
                    this.setTargetForm(Util.getServerForm(this.options, formInformation.getName()));
                    this.options.addServerForm(this.getTargetForm());
                    object4 = this.getTargetForm().getName();
                }
                catch (ARException aRException) {
                    throw new ARImportException("Unable to retrieve destination from information from server");
                }
            }
        }
        if (this.isProcessDataSet()) {
            object2 = this.options.getMappingOptions(string, object4);
            if (object2 == null) {
                object2 = this.options.getMappingOptions("ARImport_Data_Holder", object4);
            }
            if (object2 == null || ((MappingOptions)object2).isEmpty()) {
                object2 = Util.generateMappingsForARX(this.getTargetForm(), this.getSourceForm());
                this.options.addMappingOptions(string, object4, (MappingOptions)object2);
            } else {
                for (FieldInformation fieldInformation : this.getTargetForm().getFields().values()) {
                    int n;
                    Mapping mapping = ((MappingOptions)object2).getMappings().get(fieldInformation.getFieldId());
                    if (mapping == null || (n = mapping.getTokenIndex()) != -1) continue;
                    FieldInformation fieldInformation2 = null;
                    if (mapping.getType() == Mapping.Type.FIELDID) {
                        fieldInformation2 = this.getSourceForm().getFields().get(mapping.getFieldId());
                        if (fieldInformation2 == null) continue;
                        mapping.setTokenIndex(fieldInformation2.getTokenIndex());
                        continue;
                    }
                    if (mapping.getType() == Mapping.Type.FIELDNAME) {
                        for (FieldInformation fieldInformation3 : this.getSourceForm().getFields().values()) {
                            if (!mapping.getFieldName().equals(fieldInformation3.getName())) continue;
                            fieldInformation2 = fieldInformation3;
                            break;
                        }
                        if (fieldInformation2 == null) continue;
                        mapping.setTokenIndex(fieldInformation2.getTokenIndex());
                        continue;
                    }
                    if (mapping.getType() == Mapping.Type.COMPOUND) {
                        fieldInformation2 = this.getSourceForm().getFields().get(fieldInformation.getFieldId());
                        if (fieldInformation2 == null) continue;
                        mapping.setTokenIndex(fieldInformation2.getTokenIndex());
                        continue;
                    }
                    if (mapping.getType() != Mapping.Type.KEYWORD || (fieldInformation2 = this.getSourceForm().getFields().get(fieldInformation.getFieldId())) == null) continue;
                    mapping.setTokenIndex(fieldInformation2.getTokenIndex());
                }
            }
            this.options.addFileForm(formInformation);
            if (cg.isInfoEnabled()) {
                cg.info(MessageFormat.format("Attempting import from source form {0} to destination form {1} on server {2}", this.getSourceForm().getName(), this.getTargetForm().getName(), this.getOptions().getContext().getServer()));
            }
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setSourceForm(this.getSourceForm());
                this.getEntryFactory().setTargetForm(this.getTargetForm());
            }
        }
    }
}

