/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.jdbc.datasource.ConnectionHandle;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryPlusOperations;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryUtils;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerPlusOperations;
import com.bmc.thirdparty.org.springframework.orm.jpa.JpaDialect;
import com.bmc.thirdparty.org.springframework.transaction.InvalidIsolationLevelException;
import com.bmc.thirdparty.org.springframework.transaction.TransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.TransactionException;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;

public class DefaultJpaDialect
implements JpaDialect {
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Standard JPA does not support custom isolation levels - use a special JpaDialect for your JPA implementation");
        }
        entityManager.getTransaction().begin();
        return null;
    }

    public void cleanupTransaction(Object transactionData) {
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return null;
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, EntityManager em) throws PersistenceException, SQLException {
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    public boolean supportsEntityManagerFactoryPlusOperations() {
        return false;
    }

    public boolean supportsEntityManagerPlusOperations() {
        return false;
    }

    public EntityManagerFactoryPlusOperations getEntityManagerFactoryPlusOperations(EntityManagerFactory rawEntityManager) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support EntityManagerFactoryPlusOperations");
    }

    public EntityManagerPlusOperations getEntityManagerPlusOperations(EntityManager rawEntityManager) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support EntityManagerPlusOperations");
    }
}

