/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.datasource;

import com.bmc.thirdparty.org.springframework.jdbc.datasource.ConnectionHandle;
import com.bmc.thirdparty.org.springframework.jdbc.datasource.SimpleConnectionHandle;
import com.bmc.thirdparty.org.springframework.transaction.support.ResourceHolderSupport;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionHolder
extends ResourceHolderSupport {
    public static final String SAVEPOINT_NAME_PREFIX = "SAVEPOINT_";
    private ConnectionHandle connectionHandle;
    private Connection currentConnection;
    private boolean transactionActive = false;
    private Boolean savepointsSupported;
    private int savepointCounter = 0;

    public ConnectionHolder(ConnectionHandle connectionHandle) {
        Assert.notNull(connectionHandle, "ConnectionHandle must not be null");
        this.connectionHandle = connectionHandle;
    }

    public ConnectionHolder(Connection connection) {
        this.connectionHandle = new SimpleConnectionHandle(connection);
    }

    public ConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    protected boolean hasConnection() {
        return this.connectionHandle != null;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setConnection(Connection connection) {
        if (this.currentConnection != null) {
            this.connectionHandle.releaseConnection(this.currentConnection);
            this.currentConnection = null;
        }
        this.connectionHandle = connection != null ? new SimpleConnectionHandle(connection) : null;
    }

    public Connection getConnection() {
        Assert.notNull(this.connectionHandle, "Active Connection is required");
        if (this.currentConnection == null) {
            this.currentConnection = this.connectionHandle.getConnection();
        }
        return this.currentConnection;
    }

    public boolean supportsSavepoints() throws SQLException {
        if (this.savepointsSupported == null) {
            this.savepointsSupported = new Boolean(this.getConnection().getMetaData().supportsSavepoints());
        }
        return this.savepointsSupported;
    }

    public Object createSavepoint() throws SQLException {
        ++this.savepointCounter;
        return this.getConnection().setSavepoint(SAVEPOINT_NAME_PREFIX + this.savepointCounter);
    }

    public void released() {
        super.released();
        if (this.currentConnection != null) {
            this.connectionHandle.releaseConnection(this.currentConnection);
            this.currentConnection = null;
        }
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
        this.savepointsSupported = null;
        this.savepointCounter = 0;
    }
}

