/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.wiring;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.wiring.BeanWiringInfo;
import com.bmc.thirdparty.org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import com.bmc.thirdparty.org.springframework.beans.factory.wiring.ClassNameBeanWiringInfoResolver;
import com.bmc.thirdparty.org.springframework.util.Assert;

public abstract class BeanConfigurerSupport
implements BeanFactoryAware,
DisposableBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private BeanWiringInfoResolver beanWiringInfoResolver = new ClassNameBeanWiringInfoResolver();
    private AutowireCapableBeanFactory beanFactory;

    public void setBeanWiringInfoResolver(BeanWiringInfoResolver beanWiringInfoResolver) {
        Assert.notNull(beanWiringInfoResolver, "beanWiringInfoResolver is required");
        this.beanWiringInfoResolver = beanWiringInfoResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AutowireCapableBeanFactory)) {
            throw new IllegalArgumentException("Bean configurer aspect needs to run in an AutowireCapableBeanFactory, not in [" + beanFactory + "]");
        }
        this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
    }

    public void destroy() {
        this.beanFactory = null;
        this.beanWiringInfoResolver = null;
    }

    protected void configureBean(Object beanInstance) {
        BeanWiringInfo bwi = this.beanWiringInfoResolver.resolveWiringInfo(beanInstance);
        if (bwi == null) {
            return;
        }
        if (this.beanFactory == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("BeanFactory has not been set on [" + this.getClass().getName() + "]: " + "Make sure this configurer runs in a Spring container. " + "For example, add it to a Spring application context as an XML bean definition.");
            }
            return;
        }
        if (bwi.indicatesAutowiring()) {
            this.beanFactory.autowireBeanProperties(beanInstance, bwi.getAutowireMode(), bwi.getDependencyCheck());
        } else {
            this.beanFactory.applyBeanPropertyValues(beanInstance, bwi.getBeanName());
        }
    }
}

