/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrDecodingStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;

public class XdrTcpDecodingStream
extends XdrDecodingStream {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    InputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int fragmentLength;
    private boolean lastFragment;

    public XdrTcpDecodingStream(Socket socket, int n2) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getInputStream();
        if (n2 < 1024) {
            n2 = 1024;
        }
        if ((n2 & 3) != 0) {
            n2 = n2 + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n2];
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
        this.lastFragment = false;
        this.fragmentLength = 0;
    }

    protected XdrTcpDecodingStream(Socket socket, byte[] byArray) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getInputStream();
        this.buffer = byArray;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
        this.lastFragment = false;
        this.fragmentLength = 0;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.fill();
    }

    protected void readBuffer(InputStream inputStream, byte[] byArray, int n2) throws IOException, OncRpcException {
        String string;
        int n3 = 0;
        if (debugout != null) {
            string = "readBuffer: start, bytesToRead=" + n2;
            string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
            debugout.println(string);
        }
        while (n2 > 0) {
            int n4 = inputStream.read(byArray, n3, n2);
            if (n4 <= 0) {
                if (debugout != null) {
                    string = "readBuffer: EOF: bytesToRead=" + n2 + ", byteOffset=" + n3 + ", bytesRead=" + n4;
                    debugout.println("/* " + formatter.format(System.currentTimeMillis()) + " */" + string);
                }
                throw new OncRpcException(4);
            }
            n2 -= n4;
            n3 += n4;
            if (debugout == null) continue;
            string = "readBuffer: bytesToRead=" + n2 + ", byteOffset=" + n3 + ", bytesRead=" + n4;
            string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
            debugout.println(string);
        }
    }

    protected void fill() throws OncRpcException, IOException {
        Object object;
        if (this.fragmentLength <= 0) {
            if (this.lastFragment) {
                throw new OncRpcException(43);
            }
            object = new byte[4];
            this.readIncomingFragmentInfo(this.stream, (byte[])object, 4);
        }
        this.bufferIndex = 0;
        if (this.fragmentLength < this.buffer.length) {
            this.readBuffer(this.stream, this.buffer, this.fragmentLength);
            this.bufferHighmark = this.fragmentLength - 4;
            this.fragmentLength = 0;
        } else {
            this.readBuffer(this.stream, this.buffer, this.buffer.length);
            this.bufferHighmark = this.buffer.length - 4;
            this.fragmentLength -= this.buffer.length;
        }
        if (debugout != null) {
            object = "fill: fragmentLength=" + this.fragmentLength + " lastFragment=" + this.lastFragment + " bufferHighmark=" + this.bufferHighmark + " bufferIndex=" + this.bufferIndex;
            object = "/* " + formatter.format(System.currentTimeMillis()) + " */" + (String)object;
            debugout.println((String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDecoding() throws OncRpcException, IOException {
        try {
            while (!this.lastFragment || this.fragmentLength != 0) {
                this.fill();
            }
        }
        finally {
            this.bufferIndex = 0;
            this.bufferHighmark = -4;
            this.lastFragment = false;
            this.fragmentLength = 0;
        }
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.stream = null;
        this.socket = null;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int n2 = this.buffer[this.bufferIndex++] & 0xFF;
        n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return n2;
    }

    public byte[] xdrDecodeOpaque(int n2) throws OncRpcException, IOException {
        int n3 = 4 - (n2 & 3) & 3;
        int n4 = 0;
        byte[] byArray = new byte[n2];
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n2 > 0) {
            int n5 = this.bufferHighmark - this.bufferIndex + 4;
            if (n5 >= n2) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n4, n2);
                this.bufferIndex += n2;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n4, n5);
            this.bufferIndex += n5;
            n4 += n5;
            n2 -= n5;
            this.fill();
        }
        this.bufferIndex += n3;
        return byArray;
    }

    public void xdrDecodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = 4 - (n3 & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (n3 > 0) {
            int n5 = this.bufferHighmark - this.bufferIndex + 4;
            if (n5 >= n3) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n2, n3);
                this.bufferIndex += n3;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, n2, n5);
            this.bufferIndex += n5;
            n2 += n5;
            n3 -= n5;
            this.fill();
        }
        this.bufferIndex += n4;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    protected void setBufferIndex(int n2) {
        this.bufferIndex = n2;
    }

    public int getBufferHighmark() {
        return this.bufferHighmark;
    }

    protected void setBufferHighmark(int n2) {
        this.bufferHighmark = n2;
    }

    protected boolean isLastFragment() {
        return this.lastFragment;
    }

    protected void readIncomingFragmentInfo(InputStream inputStream, byte[] byArray, int n2) throws IOException, OncRpcException {
        this.readBuffer(inputStream, byArray, 4);
        this.fragmentLength = byArray[0] & 0xFF;
        this.fragmentLength = (this.fragmentLength << 8) + (byArray[1] & 0xFF);
        this.fragmentLength = (this.fragmentLength << 8) + (byArray[2] & 0xFF);
        this.fragmentLength = (this.fragmentLength << 8) + (byArray[3] & 0xFF);
        if ((this.fragmentLength & Integer.MIN_VALUE) != 0) {
            this.fragmentLength &= Integer.MAX_VALUE;
            this.lastFragment = true;
        } else {
            this.lastFragment = false;
        }
        if ((this.fragmentLength & 3) != 0) {
            throw new IOException("ONC/RPC XDR fragment length is not a multiple of four");
        }
        if (this.fragmentLength == 0 && !this.lastFragment) {
            throw new IOException("empty ONC/RPC XDR fragment which is not a trailing fragment");
        }
    }

    protected int getFragmentLength() {
        return this.fragmentLength;
    }

    protected byte[] getBufferArray() {
        return this.buffer;
    }
}

