/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfigKey;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginServerConfiguration {
    private static final String PLUGIN_SERVER_WORKING_DIRECTORY = "pluginWork";
    private static Logger log = Logger.getLogger(ARPluginServerConfiguration.class);
    private static ARPluginServerConfiguration theInstance = new ARPluginServerConfiguration();
    private static String AR_PLUGIN_SERVER_CONFIG_FILE = "pluginsvr_config.xml";
    public static String DEFAULT_SET_NAME = "NONE";
    private static String SET_NAME_PREFIX = "PluginSet_";
    private static int SETCOUNT = 0;
    private static String AR_PLUGIN_USER_DEFINED_TAG = "userDefined";
    private XMLConfiguration mConfig;
    private InetAddress mHostID;
    private int mPort;
    private String mInstallPath = "";
    private String[] mCmdLineArgs;
    private int workQueueTaskThreshold;
    private long workQueueMonitorLogInterval;
    private int numCoreThreads;
    private int maxThreads;
    private long mThreadTimeout;
    private int numSelectorThreads;
    private int mDataEncryptionKeyExpiry = ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue();
    private int mPublicKeyExpiry = ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue();
    private int mEncryptionSecurityPolicy = ARPluginServerConfigKey.EncPolicy.getIntDefaultValue();
    private int mDataEncryptionAlgorithm = ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue();
    private int mPublicKeyAlgorithm = ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue();
    private int mNumEncSessionHashentries;
    private HashMap<String, PluginGroup> mPluginGroups;
    private ArrayList<ARPluginDefinition> mTopLevelPlugins;
    private ArrayList<ARPluginDefinition> mLegacyPlugins;
    private HashMap<String, String> mPluginNames;
    private HashMap<String, Integer> mPluginCount;
    private HashMap<String, Integer> mGroupCount;
    private ConcurrentHashMap<String, Object> mARConfig;
    private String mPluginAuth;
    private String mPluginPass;
    private boolean mbRegPortMapper = false;
    private static boolean mbSupportNativePluginHost = false;
    private static boolean mbLoadNativePluginHost = false;
    private int mReloadDelay = ARPluginServerConfigKey.ReloadDelay.getIntDefaultValue();
    private FileChangedReloadingStrategy fcrs;
    private String missingParam;
    static HashMap<String, String> pluginAccessibleConfig = new HashMap();

    private ARPluginServerConfiguration() {
        this.mLegacyPlugins = new ArrayList();
        this.mPluginNames = new HashMap();
        this.mPluginCount = new HashMap();
        this.mGroupCount = new HashMap();
        this.mARConfig = new ConcurrentHashMap();
    }

    private void initializeLogging() {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("log4j_pluginsvr.xml");
        if (uRL != null) {
            DOMConfigurator.configure((URL)uRL);
        }
        String string = "";
        try {
            String string2;
            int n;
            Logger logger = Logger.getRootLogger();
            Appender appender = logger.getAppender("PluginLog");
            if (appender != null && appender instanceof RollingFileAppender && (n = (string2 = ((RollingFileAppender)appender).getFile()).lastIndexOf(".log")) > 0 && string2.length() >= n) {
                string = string2.substring(0, n);
            }
        }
        catch (Throwable throwable) {
            string = "";
        }
        this.redirecSystemLog(string);
    }

    private void redirecSystemLog(String string) {
        block11: {
            File file;
            FileOutputStream fileOutputStream;
            PrintStream printStream;
            String string2;
            block10: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String string3 = simpleDateFormat.format(Calendar.getInstance().getTime());
                String string4 = string + "-stdout-" + string3 + ".log";
                string2 = string + "-stderr-" + string3 + ".log";
                PrintStream printStream2 = null;
                printStream = null;
                FileOutputStream fileOutputStream2 = null;
                fileOutputStream = null;
                try {
                    file = new File(string4);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    fileOutputStream2 = new FileOutputStream(string4, true);
                    printStream2 = new PrintStream(fileOutputStream2);
                    System.setOut(printStream2);
                }
                catch (IOException iOException) {
                    log.warn((Object)"Error encountered while redirecting stdout to the plugin server stdout log", (Throwable)iOException);
                    if (fileOutputStream2 == null) break block10;
                    try {
                        fileOutputStream2.close();
                    }
                    catch (IOException iOException2) {
                        log.debug((Object)("outputStream can not be closes." + iOException2.getLocalizedMessage()));
                    }
                }
            }
            try {
                file = new File(string2);
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileOutputStream = new FileOutputStream(string2, true);
                printStream = new PrintStream(fileOutputStream);
                System.setErr(printStream);
            }
            catch (IOException iOException) {
                log.warn((Object)"Error encountered while redirecting stderr to the plugin server stderr log", (Throwable)iOException);
                if (fileOutputStream == null) break block11;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException3) {
                    log.debug((Object)("errOutputStream can not be closes." + iOException3.getLocalizedMessage()));
                }
            }
        }
    }

    public void initialize(String[] stringArray) throws ARException {
        this.mCmdLineArgs = stringArray;
        try {
            this.initializeLogging();
            this.parseCommandLineArguments(stringArray);
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(AR_PLUGIN_SERVER_CONFIG_FILE);
            if (uRL == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(8768));
                System.out.println(CatalogReader.getInstance().getMessage(8768));
                throw new ARException(2, 8768);
            }
            this.mConfig = new XMLConfiguration(uRL);
            log.info((Object)("Loading the Configuration File ::" + uRL.toString()));
            this.fcrs = new FileChangedReloadingStrategy();
            this.mReloadDelay = this.mConfig.getInt(ARPluginServerConfigKey.ReloadDelay.getKey(), ARPluginServerConfigKey.ReloadDelay.getIntDefaultValue());
            this.mEncryptionSecurityPolicy = this.mConfig.getInt(ARPluginServerConfigKey.EncPolicy.getKey(), ARPluginServerConfigKey.EncPolicy.getIntDefaultValue());
            this.mPublicKeyAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyAlg.getKey(), ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue());
            this.mPublicKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyExpiry.getKey(), ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue());
            this.mDataEncryptionAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.DataEncryptionAlg.getKey(), ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue());
            this.mDataEncryptionKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.DataKeyExpiry.getKey(), ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue());
            this.readThreadPoolExecutorConfigValue();
            try {
                this.mEncryptionSecurityPolicy = ARDataKey.validateNetworkDataEncConfigSetting((int)this.mEncryptionSecurityPolicy, (int)this.mPublicKeyAlgorithm, (int)this.mDataEncryptionAlgorithm);
            }
            catch (AREncryptionException aREncryptionException) {
                log.error((Object)CatalogReader.getInstance().getMessage(aREncryptionException.getErrorNum()), (Throwable)aREncryptionException);
                System.out.println(CatalogReader.getInstance().getMessage(aREncryptionException.getErrorNum()));
                throw new ARException(2, 8768, aREncryptionException.getLocalizedMessage());
            }
            this.mPort = this.mConfig.getInt(ARPluginServerConfigKey.TcpPort.getKey(), ARPluginServerConfigKey.TcpPort.getIntDefaultValue());
            this.mPluginAuth = this.mConfig.getString(ARPluginServerConfigKey.PluginAuth.getKey(), ARPluginServerConfigKey.PluginAuth.getDefaultValue());
            this.mbRegPortMapper = this.mConfig.getBoolean(ARPluginServerConfigKey.RegPortMapper.getKey(), ARPluginServerConfigKey.RegPortMapper.getBoolDefaultValue());
            mbSupportNativePluginHost = this.mConfig.getBoolean(ARPluginServerConfigKey.SupportNativePluginHost.getKey(), ARPluginServerConfigKey.SupportNativePluginHost.getBoolDefaultValue());
            mbLoadNativePluginHost = this.mConfig.getBoolean(ARPluginServerConfigKey.LoadNativePluginHost.getKey(), ARPluginServerConfigKey.LoadNativePluginHost.getBoolDefaultValue());
            if (!mbSupportNativePluginHost && mbLoadNativePluginHost) {
                mbLoadNativePluginHost = false;
                log.error((Object)"Java plug-in server does not support C plug-ins. Contact Customer Support for details.");
            }
            if (this.mPort < 0 || this.mPort > 65535) {
                log.error((Object)CatalogReader.getInstance().getMessage(8782));
                log.error((Object)"Using portmapper for an available port");
                this.mbRegPortMapper = true;
                this.mPort = 0;
            }
            if (this.mPort == 0) {
                this.mbRegPortMapper = true;
                this.mPort = 0;
                log.info((Object)"Using portmapper for an available port");
            }
            String string = ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey();
            this.setupPluginAccessibleValues();
            this.mTopLevelPlugins = this.loadPlugins((HierarchicalConfiguration)this.mConfig, string, string);
            this.mPluginGroups = this.loadPluginGroups(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.PluginSet.getKey(), DEFAULT_SET_NAME);
            this.fcrs.setRefreshDelay((long)this.mReloadDelay);
            this.fcrs.setConfiguration((FileConfiguration)this.mConfig);
            this.mConfig.setReloadingStrategy((ReloadingStrategy)this.fcrs);
            this.setupPluginAuth();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)CatalogReader.getInstance().getMessage(8768), (Throwable)configurationException);
            System.out.println(CatalogReader.getInstance().getMessage(8768) + configurationException.getLocalizedMessage());
            throw new ARException(2, 8768, configurationException.getLocalizedMessage());
        }
    }

    private void readThreadPoolExecutorConfigValue() {
        this.workQueueTaskThreshold = this.mConfig.getInt(ARPluginServerConfigKey.WorkQueueTaskThreshold.getKey(), ARPluginServerConfigKey.WorkQueueTaskThreshold.getIntDefaultValue());
        this.workQueueMonitorLogInterval = this.mConfig.getLong(ARPluginServerConfigKey.WorkQueueMonitorLogInterval.getKey(), ARPluginServerConfigKey.WorkQueueMonitorLogInterval.getLongDefaultValue());
        this.numCoreThreads = this.mConfig.getInt(ARPluginServerConfigKey.NumCoreThreads.getKey(), ARPluginServerConfigKey.NumCoreThreads.getIntDefaultValue());
        this.maxThreads = this.mConfig.getInt(ARPluginServerConfigKey.MaxThreads.getKey(), ARPluginServerConfigKey.MaxThreads.getIntDefaultValue());
        this.numSelectorThreads = this.mConfig.getInt(ARPluginServerConfigKey.NumSelectorThreads.getKey(), ARPluginServerConfigKey.NumSelectorThreads.getIntDefaultValue());
        this.mThreadTimeout = this.mConfig.getLong(ARPluginServerConfigKey.ExcessCoreThreadsIdleKeepAliveTimeInSecond.getKey(), ARPluginServerConfigKey.ExcessCoreThreadsIdleKeepAliveTimeInSecond.getLongDefaultValue());
        if (this.maxThreads < this.numCoreThreads) {
            log.error((Object)"maxThreads configured bigger than coreWorkerThreads.");
            log.info((Object)"maxWorkerThreads is set to be same as coreWorkerThreads by plugin server");
            this.maxThreads = this.numCoreThreads;
        }
    }

    private void setupPluginAccessibleValues() {
        pluginAccessibleConfig.put("port", String.valueOf(this.mPort));
        pluginAccessibleConfig.put("numCoreThreads", String.valueOf(this.numCoreThreads));
        log.debug((Object)"Plugin Accessible Configured Values:");
        log.debug((Object)("port " + pluginAccessibleConfig.get("port")));
        log.debug((Object)("numCoreThreads " + pluginAccessibleConfig.get("numCoreThreads")));
    }

    private boolean isValidPluginConfiguration(ARPluginDefinition aRPluginDefinition) {
        boolean bl = true;
        String string = aRPluginDefinition.getPluginName();
        String string2 = aRPluginDefinition.getPluginCode();
        String string3 = aRPluginDefinition.getFileName();
        String string4 = aRPluginDefinition.getClassName();
        if (string == null || string.equals("")) {
            String string5 = this.missingParam = this.missingParam != null ? this.missingParam : "<name/>";
            if (string3 == null || !string3.endsWith(".dll") && !string3.endsWith(".so") && !string3.endsWith(".sl") && !string3.endsWith(".a")) {
                this.missingParam = this.missingParam != null ? this.missingParam : "<filename/>";
                return false;
            }
            string = "";
        }
        if (string2 == null || string2.equals("")) {
            string2 = "JAVA";
        } else if (!string2.equalsIgnoreCase("C") && !string2.equalsIgnoreCase("JAVA")) {
            this.missingParam = this.missingParam != null ? this.missingParam : "<code/>";
            return false;
        }
        if (string2.equalsIgnoreCase("JAVA") && (string4 == null || string4.equals(""))) {
            this.missingParam = this.missingParam != null ? this.missingParam : "<classname/>";
            return false;
        }
        if (string2.equals("C") && (string3 == null || string3.equals(""))) {
            this.missingParam = this.missingParam != null ? this.missingParam : "<filename/>";
            return false;
        }
        return bl;
    }

    private ArrayList<ARPluginDefinition> loadPlugins(HierarchicalConfiguration hierarchicalConfiguration, String string, String string2) {
        ArrayList<ARPluginDefinition> arrayList = new ArrayList<ARPluginDefinition>();
        List list = hierarchicalConfiguration.configurationsAt(string2);
        for (HierarchicalConfiguration hierarchicalConfiguration2 : list) {
            ARPluginDefinition aRPluginDefinition = null;
            this.missingParam = null;
            aRPluginDefinition = this.loadPluginsDef(hierarchicalConfiguration2);
            if (aRPluginDefinition == null) continue;
            String string3 = aRPluginDefinition.getPluginName();
            if (this.mPluginNames.containsKey(string3)) {
                int n = this.mPluginCount.get(string3) + 1;
                this.mPluginCount.put(string3, n);
                if ((string3 == null || string3.equals("")) && aRPluginDefinition.getPluginCode().equals("C") ? this.mLegacyPlugins.contains(aRPluginDefinition) && n > 1 : n > 1) continue;
            }
            this.mPluginNames.put(string3, string);
            this.mPluginCount.put(string3, 1);
            if (aRPluginDefinition.getFileName() != null && (aRPluginDefinition.getPluginCode().equalsIgnoreCase("C") || aRPluginDefinition.getFileName().endsWith(".dll") || aRPluginDefinition.getFileName().endsWith(".so") || aRPluginDefinition.getFileName().endsWith(".sl") || aRPluginDefinition.getFileName().endsWith(".a"))) {
                this.mLegacyPlugins.add(aRPluginDefinition);
                continue;
            }
            arrayList.add(aRPluginDefinition);
        }
        return arrayList;
    }

    private ARPluginDefinition loadPluginsDef(HierarchicalConfiguration hierarchicalConfiguration) {
        Object object;
        String string = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginName.getKey());
        String string2 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginType.getKey());
        String string3 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginFilename.getKey());
        String string4 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginCode.getKey());
        String string5 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginClassname.getKey());
        int n = hierarchicalConfiguration.getInt(ARPluginServerConfigKey.PluginVersion.getKey(), ARPluginServerConfigKey.PluginVersion.getIntDefaultValue());
        ARPluginDefinition aRPluginDefinition = new ARPluginDefinition(string, string3, string5, string4, string2, n);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hierarchicalConfiguration.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey()));
        if (arrayList != null && arrayList.size() > 0) {
            object = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (HierarchicalConfiguration hierarchicalConfiguration2 : arrayList) {
                String string6 = hierarchicalConfiguration2.getString("[@type]");
                String string7 = null;
                String string8 = null;
                if (string6 != null && string6.equals("path")) {
                    string7 = (String)hierarchicalConfiguration2.getRoot().getValue();
                } else if (string6 != null && string6.equals("location")) {
                    string8 = (String)hierarchicalConfiguration2.getRoot().getValue();
                }
                if (string7 != null) {
                    arrayList2.add(string7);
                }
                if (string8 == null) continue;
                ((ArrayList)object).add(string8);
            }
            aRPluginDefinition.setClassPathFolders(arrayList2);
            aRPluginDefinition.setClassPathJars((ArrayList<String>)object);
        }
        if (!this.isValidPluginConfiguration(aRPluginDefinition)) {
            object = aRPluginDefinition.getPluginName();
            Object object2 = object = object == null ? string5 : object;
            if (aRPluginDefinition.getPluginName() == null || aRPluginDefinition.getPluginName().equals("")) {
                object = aRPluginDefinition.getFileName();
            }
            log.error((Object)(CatalogReader.getInstance().getMessage(8769) + " " + this.missingParam + ": " + (String)object));
            log.error((Object)("Not Loading the Plugin:" + (String)object));
            return null;
        }
        return aRPluginDefinition;
    }

    private HashMap<String, PluginGroup> loadPluginGroups(String string, String string2) {
        List list = this.mConfig.configurationsAt(string);
        HashMap<String, PluginGroup> hashMap = new HashMap<String, PluginGroup>();
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            String string3 = hierarchicalConfiguration.getString("[@name]");
            if (string3 == null) {
                string3 = SET_NAME_PREFIX + SETCOUNT++;
            }
            if (hashMap.containsKey(string3)) {
                int n = this.mGroupCount.get(string3) + 1;
                this.mGroupCount.put(string3, n);
                if (n <= 2) continue;
                log.warn((Object)(CatalogReader.getInstance().getMessage(8771) + " " + string3));
                continue;
            }
            ArrayList<ARPluginDefinition> arrayList = this.loadPlugins(hierarchicalConfiguration, string + ARPluginServerConfigKey.Plugins.getKey(), ARPluginServerConfigKey.Plugins.getKey().substring(1));
            HashMap<String, PluginGroup> hashMap2 = this.loadPluginGroups(string + ARPluginServerConfigKey.PluginSet.getKey(), string3);
            PluginGroup pluginGroup = new PluginGroup(string2, hashMap2, arrayList);
            List list2 = hierarchicalConfiguration.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey());
            if (list2 != null && list2.size() > 0) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (HierarchicalConfiguration hierarchicalConfiguration2 : list2) {
                    String string4 = hierarchicalConfiguration2.getString("[@type]");
                    String string5 = null;
                    String string6 = null;
                    if (string4 != null && string4.equals("path")) {
                        string5 = (String)hierarchicalConfiguration2.getRoot().getValue();
                    } else if (string4 != null && string4.equals("location")) {
                        string6 = (String)hierarchicalConfiguration2.getRoot().getValue();
                    }
                    if (string5 != null) {
                        arrayList3.add(string5);
                    }
                    if (string6 == null) continue;
                    arrayList2.add(string6);
                }
                pluginGroup.setClassPathFolders(arrayList3);
                pluginGroup.setClassPathJars(arrayList2);
            }
            hashMap.put(string3, pluginGroup);
            this.mGroupCount.put(string3, 1);
        }
        return hashMap;
    }

    public static ARPluginServerConfiguration getInstance() {
        return theInstance;
    }

    public static boolean getLoadNativePluginhost() {
        if (!mbSupportNativePluginHost && mbLoadNativePluginHost) {
            mbLoadNativePluginHost = false;
        }
        return mbLoadNativePluginHost;
    }

    public String[] getCmdLineArgs() {
        return this.mCmdLineArgs;
    }

    public String getConfigValue(String string, String string2) {
        String string3 = null;
        if (string == null && string2 != null) {
            string3 = this.getPluginAccessiblePluginSvrConfigValue(string2);
        } else if (string != null && string2 != null) {
            string3 = this.getPluginConfigValue(string, string2);
        }
        return string3;
    }

    private String getPluginAccessiblePluginSvrConfigValue(String string) {
        String string2 = null;
        if (string != null && pluginAccessibleConfig.containsKey(string)) {
            string2 = pluginAccessibleConfig.get(string);
        }
        return string2;
    }

    private synchronized String getPluginConfigValue(String string, String string2) {
        String string3;
        String string4 = null;
        if (string != null && string2 != null && (string3 = this.mPluginNames.get(string)) != null && !string3.equals("")) {
            List list = this.mConfig.configurationsAt(string3);
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string5 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (string5 == null || !string5.equals(string)) continue;
                string4 = hierarchicalConfiguration.getString(AR_PLUGIN_USER_DEFINED_TAG + "." + string2);
                break;
            }
        }
        return string4;
    }

    public synchronized void setConfigValue(String string, String string2, Object object) {
        String string3;
        if (string != null && string2 != null && (string3 = this.mPluginNames.get(string)) != null && !string3.equals("")) {
            List list = this.mConfig.configurationsAt(string3);
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string4 = hierarchicalConfiguration.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (!string4.equals(string)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                if (!string2.startsWith(AR_PLUGIN_USER_DEFINED_TAG)) {
                    stringBuffer.append(AR_PLUGIN_USER_DEFINED_TAG + ".");
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(string2);
                }
                hierarchicalConfiguration.setProperty(stringBuffer.toString(), object);
                break;
            }
        }
    }

    public synchronized void saveConfiguration() {
        try {
            this.mConfig.save();
        }
        catch (ConfigurationException configurationException) {
            log.warn((Object)CatalogReader.getInstance().getMessage(8769), (Throwable)configurationException);
        }
    }

    public long getThreadTimeout() {
        return this.mThreadTimeout;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostName() {
        return this.mHostID.getHostName();
    }

    public InetAddress getHostID() {
        return this.mHostID;
    }

    public int getNumCoreThreads() {
        return this.numCoreThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public ArrayList<ARPluginDefinition> getConfiguredPlugins() {
        return this.mTopLevelPlugins;
    }

    public ArrayList<ARPluginDefinition> getNativePlugins() {
        return this.mLegacyPlugins;
    }

    public HashMap<String, PluginGroup> getConfiguredPluginGroups() {
        return this.mPluginGroups;
    }

    public boolean isRegisteredWithPortMapper() {
        return this.mbRegPortMapper;
    }

    public void setMaxThreads(int n, int n2) {
        this.maxThreads = n2;
    }

    public void setMinThreads(int n, int n2) {
        this.numCoreThreads = n2;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public String getWorkingDirectory() {
        if (this.mInstallPath.endsWith(File.separator)) {
            return this.mInstallPath + PLUGIN_SERVER_WORKING_DIRECTORY;
        }
        return this.mInstallPath + File.separator + PLUGIN_SERVER_WORKING_DIRECTORY;
    }

    public String getARConfigEntry(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        Object object = this.mARConfig.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                stringBuffer.append(string2);
                stringBuffer.append(";");
            }
        } else {
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public Object getARConfigItem(String string) {
        Object object = this.mARConfig.get(string);
        return object;
    }

    public String getPluginPassword() {
        return this.mPluginPass;
    }

    public void parseCommandLineArguments(String[] stringArray) throws ARException {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (i < stringArray.length && stringArray[i].equals("-x")) {
                    String string2 = string = ++i < stringArray.length ? stringArray[i] : null;
                    if (string != null && !string.equals("")) {
                        try {
                            this.mHostID = InetAddress.getByName(string);
                            continue;
                        }
                        catch (UnknownHostException unknownHostException) {
                            try {
                                this.mHostID = InetAddress.getLocalHost();
                                continue;
                            }
                            catch (UnknownHostException unknownHostException2) {
                                log.error((Object)CatalogReader.getInstance().getMessage(8783), (Throwable)unknownHostException);
                                throw new ARException(2, 8783);
                            }
                        }
                    }
                    try {
                        this.mHostID = InetAddress.getLocalHost();
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8781));
                        throw new ARException(2, 8781);
                    }
                }
                if (i < stringArray.length && stringArray[i].equals("-t")) {
                    String string3 = string = ++i < stringArray.length ? stringArray[i] : null;
                    if (string == null || string.equals("")) continue;
                    try {
                        this.mPort = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8782), (Throwable)numberFormatException);
                    }
                    continue;
                }
                if (i >= stringArray.length || !stringArray[i].equals("-i")) continue;
                String string4 = string = ++i < stringArray.length ? stringArray[i] : null;
                if (string != null && !string.equals("")) {
                    File file = new File(string);
                    if (!file.exists() || !file.isDirectory()) {
                        log.error((Object)("Invalid path for install folder " + string));
                        this.mInstallPath = "";
                        continue;
                    }
                    this.mInstallPath = string;
                    if (this.mInstallPath.endsWith("/") || this.mInstallPath.endsWith("\\")) continue;
                    this.mInstallPath = this.mInstallPath + "/";
                    continue;
                }
                this.mInstallPath = "";
                log.error((Object)CatalogReader.getInstance().getMessage(8781));
                System.out.println(CatalogReader.getInstance().getMessage(8781));
                throw new ARException(2, 8781);
            }
            if (this.mHostID == null) {
                try {
                    this.mHostID = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    log.error((Object)CatalogReader.getInstance().getMessage(8781));
                    throw new ARException(2, 8781);
                }
            }
        } else {
            System.out.println("Invalid command line arguments");
            this.printUsage();
            log.error((Object)CatalogReader.getInstance().getMessage(8781));
            throw new ARException(2, 8781);
        }
        this.loadARConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadARConfigFile() {
        if (this.mInstallPath != null && !this.mInstallPath.equals("")) {
            BufferedReader bufferedReader = null;
            ConcurrentHashMap<String, Object> concurrentHashMap = this.mARConfig;
            synchronized (concurrentHashMap) {
                this.mARConfig.clear();
                try {
                    String string = this.mInstallPath + File.separator + "conf" + File.separator + "ar.";
                    String string2 = string + "cfg";
                    File file = new File(string2);
                    if (!file.exists() || !file.isFile()) {
                        string2 = string + "conf";
                        file = new File(string2);
                    }
                    if (file.exists() && file.isFile()) {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        String string3 = null;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            int n;
                            if ("".equals(string3) || (n = string3.indexOf(58)) <= 0) continue;
                            String string4 = string3.substring(0, n).trim();
                            String string5 = string3.substring(n + 1).trim();
                            if (this.mARConfig.containsKey(string4)) {
                                Object object = this.mARConfig.get(string4);
                                if (object instanceof List) {
                                    ((List)object).add(string5);
                                    this.mARConfig.put(string4, object);
                                    continue;
                                }
                                ArrayList<Object> arrayList = new ArrayList<Object>();
                                arrayList.add(object);
                                arrayList.add(string5);
                                this.mARConfig.put(string4, arrayList);
                                continue;
                            }
                            this.mARConfig.put(string4, string5);
                        }
                    } else {
                        log.error((Object)("Could not find AR config file " + string2));
                    }
                }
                catch (Throwable throwable) {
                    log.error((Object)"Could not load AR config file ", throwable);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            log.debug((Object)("config file can not be closes." + exception.getLocalizedMessage()));
                        }
                    }
                }
            }
        }
    }

    private void setupPluginAuth() throws ARException {
        String string = null;
        if (this.mPluginAuth == null || this.mPluginAuth.equals("")) {
            Object object = this.getARConfigItem("Plugin-Password");
            if (object != null) {
                String string2 = null;
                if (object instanceof String) {
                    string2 = (String)object;
                } else {
                    List list = (List)object;
                    for (int i = 0; i < list.size() && (string2 = (String)list.get(i)) == null; ++i) {
                    }
                }
                if (string2 != null && string2.length() > 0) {
                    string = string2;
                }
            }
        } else {
            string = this.mPluginAuth;
        }
        this.mPluginPass = string != null ? (ARPluginServerEncryptionInfo.getInstance().disableAllEncryption() ? null : ARPluginServerEncryptionInfo.getInstance().toPswdString(string, "utf-8")) : null;
    }

    private void printUsage() {
        System.out.println("Usage: java ARPluginServerMain -x hostname -t portnum");
    }

    public long getReloadDelay() {
        return this.mReloadDelay;
    }

    public HashMap<String, PluginGroup> loadNewPluginGroups() {
        return this.loadPluginGroups(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.PluginSet.getKey(), DEFAULT_SET_NAME);
    }

    public ArrayList<ARPluginDefinition> loadNewPlugins() {
        String string = ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey();
        return this.loadPlugins((HierarchicalConfiguration)this.mConfig, string, string);
    }

    public synchronized void updateConfig(String[] stringArray) {
        if (this.mConfig.getReloadingStrategy().reloadingRequired()) {
            try {
                this.mConfig = new XMLConfiguration(Thread.currentThread().getContextClassLoader().getResource(AR_PLUGIN_SERVER_CONFIG_FILE));
                this.mConfig.setReloadingStrategy((ReloadingStrategy)this.fcrs);
                this.mConfig.getInt(ARPluginServerConfigKey.TcpPort.getKey(), ARPluginServerConfigKey.TcpPort.getIntDefaultValue());
                this.mConfig.configurationsAt(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey());
                this.discoverNewPlugins(stringArray);
                this.mConfig.getReloadingStrategy().reloadingPerformed();
            }
            catch (ConfigurationException configurationException) {
                log.error((Object)CatalogReader.getInstance().getMessage(8768), (Throwable)configurationException);
                System.out.println(CatalogReader.getInstance().getMessage(8768) + configurationException.getLocalizedMessage());
            }
        }
    }

    private void discoverNewPlugins(String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList();
        ArrayList<ARPluginDefinition> arrayList3 = new ArrayList<ARPluginDefinition>();
        HashMap<Object, Object> hashMap = new HashMap();
        HashMap<String, PluginGroup> hashMap2 = new HashMap<String, PluginGroup>();
        arrayList2 = new ArrayList<ARPluginDefinition>(this.mLegacyPlugins);
        arrayList = this.loadNewPlugins();
        hashMap = this.loadNewPluginGroups();
        Iterator<Object> iterator = null;
        Object aRPluginDefinition2 = null;
        for (ARPluginDefinition aRPluginDefinition : arrayList) {
            if (this.mTopLevelPlugins.contains(aRPluginDefinition)) continue;
            this.mTopLevelPlugins.add(aRPluginDefinition);
        }
        Iterator<Object> iterator2 = null;
        for (Object object : hashMap.keySet()) {
            if (this.mPluginGroups.containsKey(object)) continue;
            this.mPluginGroups.put((String)object, (PluginGroup)hashMap.get(object));
            hashMap2.put((String)object, (PluginGroup)hashMap.get(object));
        }
        for (ARPluginDefinition aRPluginDefinition : this.mLegacyPlugins) {
            if (arrayList2.contains(aRPluginDefinition)) continue;
            arrayList3.add(aRPluginDefinition);
        }
        try {
            if (arrayList3.size() > 0) {
                PluginProxy.initializePluginProxy(arrayList3, stringArray);
            }
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(8792), (Throwable)exception);
            System.out.println(CatalogReader.getInstance().getMessage(8792) + exception.getLocalizedMessage());
        }
        if (hashMap2.size() > 0 || arrayList.size() > 0) {
            ARPluginLoaderRouter.initializeNewJavaPlugins(arrayList, hashMap2, stringArray);
            ARPluginLoaderRouter.instantiateNewJavaPlugins(arrayList, hashMap2, stringArray);
        }
    }

    static boolean isNativePluginHostSupported() {
        return mbSupportNativePluginHost;
    }

    public int getNumSelectorThreads() {
        return this.numSelectorThreads;
    }

    public int getWorkQueueTaskThreshold() {
        return this.workQueueTaskThreshold;
    }

    public long getWorkQueueMonitorLogInterval() {
        return this.workQueueMonitorLogInterval;
    }
}

