/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.handler;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanInitializationException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import com.bmc.thirdparty.org.springframework.web.context.ServletConfigAware;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class SimpleServletPostProcessor
implements DestructionAwareBeanPostProcessor,
ServletContextAware,
ServletConfigAware {
    private boolean useSharedServletConfig = true;
    private ServletContext servletContext;
    private ServletConfig servletConfig;

    public void setUseSharedServletConfig(boolean useSharedServletConfig) {
        this.useSharedServletConfig = useSharedServletConfig;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Servlet) {
            ServletConfig config = this.servletConfig;
            if (config == null || !this.useSharedServletConfig) {
                config = new DelegatingServletConfig(beanName, this.servletContext);
            }
            try {
                ((Servlet)bean).init(config);
            }
            catch (ServletException ex) {
                throw new BeanInitializationException("Servlet.init threw exception", ex);
            }
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (bean instanceof Servlet) {
            ((Servlet)bean).destroy();
        }
    }

    private static class DelegatingServletConfig
    implements ServletConfig {
        private final String servletName;
        private final ServletContext servletContext;

        public DelegatingServletConfig(String servletName, ServletContext servletContext) {
            this.servletName = servletName;
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return this.servletName;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
    }
}

