/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanPostProcessor;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.ApplicationContextAware;
import com.bmc.thirdparty.org.springframework.context.ApplicationEventPublisherAware;
import com.bmc.thirdparty.org.springframework.context.MessageSourceAware;
import com.bmc.thirdparty.org.springframework.context.ResourceLoaderAware;

public class ApplicationContextAwareProcessor
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ApplicationContext applicationContext;

    public ApplicationContextAwareProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ResourceLoaderAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking setResourceLoader on ResourceLoaderAware bean '" + beanName + "'");
            }
            ((ResourceLoaderAware)bean).setResourceLoader(this.applicationContext);
        }
        if (bean instanceof ApplicationEventPublisherAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking setApplicationEventPublisher on ApplicationEventPublisherAware bean '" + beanName + "'");
            }
            ((ApplicationEventPublisherAware)bean).setApplicationEventPublisher(this.applicationContext);
        }
        if (bean instanceof MessageSourceAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking setMessageSource on MessageSourceAware bean '" + beanName + "'");
            }
            ((MessageSourceAware)bean).setMessageSource(this.applicationContext);
        }
        if (bean instanceof ApplicationContextAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking setApplicationContext on ApplicationContextAware bean '" + beanName + "'");
            }
            ((ApplicationContextAware)bean).setApplicationContext(this.applicationContext);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String name) {
        return bean;
    }
}

