/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcAuthenticationException;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcClientAuth;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcReplyMessage;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrDecodingStream;
import java.io.IOException;

public class OncRpcClientReplyMessage
extends OncRpcReplyMessage {
    protected OncRpcClientAuth auth;

    public OncRpcClientReplyMessage(OncRpcClientAuth oncRpcClientAuth) {
        this.auth = oncRpcClientAuth;
    }

    public boolean successfullyAccepted() {
        return this.replyStatus == 0 && this.acceptStatus == 0;
    }

    public OncRpcException newException() {
        switch (this.replyStatus) {
            case 0: {
                switch (this.acceptStatus) {
                    case 0: {
                        return new OncRpcException(0);
                    }
                    case 3: {
                        return new OncRpcException(10);
                    }
                    case 2: {
                        return new OncRpcException(9);
                    }
                    case 1: {
                        return new OncRpcException(8);
                    }
                    case 4: {
                        return new OncRpcException(11);
                    }
                    case 5: {
                        return new OncRpcException(12);
                    }
                }
                break;
            }
            case 1: {
                switch (this.rejectStatus) {
                    case 1: {
                        return new OncRpcAuthenticationException(this.authStatus);
                    }
                    case 0: {
                        return new OncRpcException(16);
                    }
                }
            }
        }
        return new OncRpcException();
    }

    public void xdrDecode(XdrDecodingStream xdrDecodingStream) throws OncRpcException, IOException {
        this.messageId = xdrDecodingStream.xdrDecodeInt();
        this.messageType = xdrDecodingStream.xdrDecodeInt();
        if (this.messageType != 1) {
            throw new OncRpcException(44);
        }
        this.replyStatus = xdrDecodingStream.xdrDecodeInt();
        block0 : switch (this.replyStatus) {
            case 0: {
                if (this.auth != null) {
                    this.auth.xdrDecodeVerf(xdrDecodingStream);
                } else {
                    if (xdrDecodingStream.xdrDecodeInt() != 0) {
                        throw new OncRpcAuthenticationException(7);
                    }
                    if (xdrDecodingStream.xdrDecodeInt() != 0) {
                        throw new OncRpcAuthenticationException(7);
                    }
                }
                this.acceptStatus = xdrDecodingStream.xdrDecodeInt();
                switch (this.acceptStatus) {
                    case 2: {
                        this.lowVersion = xdrDecodingStream.xdrDecodeInt();
                        this.highVersion = xdrDecodingStream.xdrDecodeInt();
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.rejectStatus = xdrDecodingStream.xdrDecodeInt();
                switch (this.rejectStatus) {
                    case 0: {
                        this.lowVersion = xdrDecodingStream.xdrDecodeInt();
                        this.highVersion = xdrDecodingStream.xdrDecodeInt();
                        break block0;
                    }
                    case 1: {
                        this.authStatus = xdrDecodingStream.xdrDecodeInt();
                        break block0;
                    }
                }
            }
        }
    }
}

