/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CriteriaFlags;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.IARPersistentObject;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectBase
implements IARPersistentObject,
Cloneable {
    private static Logger a = Logger.getLogger(ObjectBase.class);
    @ARStructMemTypeInfo(Name="name", Offset=0)
    private String m_name;
    private String m_newName;
    @ARStructMemTypeInfo(Name="permissionList", Offset=1)
    protected List<PermissionInfo> m_permissionList;
    @ARStructMemTypeInfo(Name="helpText", Offset=2)
    private String m_helpText;
    @ARStructMemTypeInfo(Name="lastUpdateTime", Offset=3)
    private Timestamp m_lastUpdateTime;
    @ARStructMemTypeInfo(Name="owner", Offset=4)
    private String m_owner;
    @ARStructMemTypeInfo(Name="lastChangedBy", Offset=5)
    private String m_lastChangedBy;
    @ARStructMemTypeInfo(Name="diaryStr", Offset=6)
    private DiaryListValue m_diaryList;
    protected ObjectBaseCriteria m_changeFlags;
    protected Integer[] hashValues = null;

    protected ObjectBase() {
        this.m_name = "";
        this.m_newName = "";
        this.m_permissionList = new ArrayList<PermissionInfo>();
        this.m_helpText = "";
        this.m_lastUpdateTime = new Timestamp();
        this.m_owner = "";
        this.m_lastChangedBy = "";
        this.m_diaryList = new DiaryListValue();
    }

    protected ObjectBase(String string, List<PermissionInfo> list, String string2, long l2, String string3, String string4, String string5) {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.m_name = string;
        if (list == null || list.isEmpty()) {
            this.m_permissionList = list;
        } else {
            this.setPermissions(list);
        }
        if (string2 == null || string2.length() <= 0) {
            this.m_helpText = string2;
        } else {
            this.setHelpText(string2);
        }
        if (l2 == 0L) {
            this.m_lastUpdateTime = new Timestamp();
        } else {
            this.setLastUpdateTime(l2);
        }
        if (string3 == null || string3.length() <= 0) {
            this.m_owner = string3;
        } else {
            this.setOwner(string3);
        }
        if (string4 == null || string4.length() <= 0) {
            this.m_lastChangedBy = string4;
        } else {
            this.setLastChangedBy(string4);
        }
        if (string5 == null || string5.length() <= 0) {
            this.m_diaryList = this.a(string5);
        } else {
            this.setDiary(string5);
        }
    }

    protected void createChangeFlags() {
        this.m_changeFlags = new ObjectBaseCriteria(8);
    }

    public void clear() {
        this.m_name = null;
        this.m_newName = null;
        this.m_permissionList = null;
        this.m_helpText = null;
        this.m_lastUpdateTime = null;
        this.m_owner = null;
        this.m_lastChangedBy = null;
        this.m_diaryList = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ObjectBase objectBase = (ObjectBase)super.clone();
        if (this.m_permissionList != null) {
            objectBase.m_permissionList = new ArrayList<PermissionInfo>(this.m_permissionList.size());
            for (int i2 = 0; i2 < this.m_permissionList.size(); ++i2) {
                objectBase.m_permissionList.add((PermissionInfo)this.m_permissionList.get(i2).clone());
            }
        }
        if (this.m_lastUpdateTime != null) {
            objectBase.m_lastUpdateTime = (Timestamp)this.m_lastUpdateTime.clone();
        }
        if (this.m_diaryList != null) {
            objectBase.m_diaryList = (DiaryListValue)this.m_diaryList.clone();
        }
        if (this.m_changeFlags != null) {
            objectBase.m_changeFlags = (ObjectBaseCriteria)this.m_changeFlags.clone();
        }
        this.calculateHashCode();
        return objectBase;
    }

    @Override
    public void setName(String string) {
        this.m_name = string;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNewName() {
        return this.m_newName;
    }

    @Override
    public void setNewName(String string) {
        this.m_newName = string;
        if (this.m_name != null && this.m_name.length() == 0) {
            this.m_name = string;
        }
        this.m_changeFlags.setParameter(0L, true);
    }

    @Override
    public List<PermissionInfo> getPermissions() {
        return this.m_permissionList;
    }

    @Override
    public void setPermissions(List<PermissionInfo> list) {
        this.m_permissionList = list;
        this.m_changeFlags.setParameter(1L, true);
    }

    @Override
    public String getHelpText() {
        return this.m_helpText;
    }

    @Override
    public void setHelpText(String string) {
        this.m_helpText = string;
        this.m_changeFlags.setParameter(2L, true);
    }

    @Override
    public Timestamp getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    protected void setLastUpdateTime(Timestamp timestamp) {
        this.m_lastUpdateTime = timestamp;
        this.m_changeFlags.setParameter(5L, true);
    }

    protected void setLastUpdateTime(long l2) {
        this.setLastUpdateTime(new Timestamp(l2));
    }

    @Override
    public String getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(String string) {
        this.m_owner = string;
        this.m_changeFlags.setParameter(3L, true);
    }

    @Override
    public String getLastChangedBy() {
        return this.m_lastChangedBy;
    }

    @Override
    public void setLastChangedBy(String string) {
        this.m_lastChangedBy = string;
        this.m_changeFlags.setParameter(6L, true);
    }

    @Override
    public DiaryListValue getDiary() {
        return this.m_diaryList;
    }

    @Override
    public void setDiary(DiaryListValue diaryListValue) {
        this.m_diaryList = diaryListValue;
        this.m_changeFlags.setParameter(4L, true);
    }

    private DiaryListValue a(String string) {
        DiaryListValue diaryListValue = null;
        try {
            diaryListValue = DiaryListValue.decode(string);
        }
        catch (ARException aRException) {
            a.error("Error in setDiary, String=" + string, aRException);
        }
        return diaryListValue;
    }

    public void setDiary(String string) {
        this.setDiary(this.a(string));
        this.m_changeFlags.setParameter(4L, true);
    }

    @Override
    public void appendDiaryText(String string) {
        this.m_diaryList.setAppendedText(string);
        this.m_changeFlags.setParameter(4L, true);
    }

    protected void resetChangeFlags() {
        this.m_changeFlags.setRetrieveAll(false);
    }

    public void setChangeFlags(ObjectBaseCriteria objectBaseCriteria) {
        try {
            this.m_changeFlags = (ObjectBaseCriteria)(objectBaseCriteria != null ? objectBaseCriteria.clone() : null);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            a.debug(cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ObjectBase)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ObjectBase objectBase = (ObjectBase)object;
        return new EqualsBuilder().append(this.m_name, objectBase.m_name).append(this.m_newName, objectBase.m_newName).append(this.m_permissionList, objectBase.m_permissionList).append(this.m_helpText, objectBase.m_helpText).append(this.m_lastUpdateTime, objectBase.m_lastUpdateTime).append(this.m_owner, objectBase.m_owner).append(this.m_lastChangedBy, objectBase.m_lastChangedBy).append(this.m_diaryList, objectBase.m_diaryList).append(this.m_changeFlags, objectBase.m_changeFlags).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_name).append(this.m_newName).append(this.m_permissionList).append(this.m_helpText).append(this.m_lastUpdateTime).append(this.m_owner).append(this.m_lastChangedBy).append(this.m_diaryList).append(this.m_changeFlags).toHashCode();
    }

    public CriteriaFlags getChangeFlags() {
        return this.m_changeFlags;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Name", this.m_name).append("New Name", this.m_newName).append("Permission List", this.m_permissionList).append("Help Text", this.m_helpText).append("Last Update Time", this.m_lastUpdateTime).append("Owner", this.m_owner).append("Last Changed By", this.m_lastChangedBy).append("Diary List", this.m_diaryList).append("Change Flags", this.m_changeFlags).toString();
    }

    void calculateHashCode() {
        if (this.hashValues == null) {
            throw new IllegalArgumentException("hashValues has not been initialized");
        }
        this.hashValues[1] = this.m_permissionList != null && !this.m_permissionList.isEmpty() ? Integer.valueOf(((Object)this.m_permissionList).hashCode()) : null;
        this.hashValues[4] = this.m_diaryList != null && !this.m_diaryList.isEmpty() ? Integer.valueOf(this.m_diaryList.hashCode()) : null;
    }

    void calculateHashCodeOnGet(ObjectBaseCriteria objectBaseCriteria) {
        ObjectBaseCriteria objectBaseCriteria2 = null;
        if (objectBaseCriteria != null) {
            try {
                objectBaseCriteria2 = (ObjectBaseCriteria)objectBaseCriteria.clone();
                objectBaseCriteria2.resetCriteriaFlags();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                a.debug(cloneNotSupportedException);
            }
        }
        this.setChangeFlags(objectBaseCriteria2);
        this.calculateHashCode();
    }

    void calculateChangeFlagsOnSet() {
        int n2;
        if (this.hashValues == null) {
            throw new IllegalArgumentException("hashValues has not been initialized");
        }
        boolean[] blArray = this.m_changeFlags.getParameters();
        if (!blArray[1]) {
            if (this.m_permissionList != null && !this.m_permissionList.isEmpty()) {
                n2 = ((Object)this.m_permissionList).hashCode();
                if (this.hashValues[1] == null || n2 != this.hashValues[1]) {
                    this.m_changeFlags.setParameter(1L, true);
                }
                this.hashValues[1] = this.m_permissionList != null && !this.m_permissionList.isEmpty() ? Integer.valueOf(n2) : null;
            } else if (this.hashValues[1] != null) {
                this.m_changeFlags.setParameter(1L, true);
                this.hashValues[1] = null;
            }
        }
        if (!blArray[4]) {
            if (this.m_diaryList != null && (this.m_diaryList.size() != 0 || this.m_diaryList.getAppendedText() != null)) {
                n2 = this.m_diaryList.hashCode();
                if (this.hashValues[4] == null || n2 != this.hashValues[4]) {
                    this.m_changeFlags.setParameter(4L, true);
                }
                this.hashValues[4] = this.m_diaryList != null && !this.m_diaryList.isEmpty() ? Integer.valueOf(n2) : null;
            } else if (this.hashValues[4] != null) {
                this.m_changeFlags.setParameter(4L, true);
                this.hashValues[4] = null;
            }
        }
    }
}

