/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.ui.velocity;

import com.bmc.thirdparty.org.apache.commons.collections.ExtendedProperties;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class SpringResourceLoader
extends ResourceLoader {
    public static final String NAME = "spring";
    public static final String SPRING_RESOURCE_LOADER_CLASS = "spring.resource.loader.class";
    public static final String SPRING_RESOURCE_LOADER_CACHE = "spring.resource.loader.cache";
    public static final String SPRING_RESOURCE_LOADER = "spring.resource.loader";
    public static final String SPRING_RESOURCE_LOADER_PATH = "spring.resource.loader.path";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private com.bmc.thirdparty.org.springframework.core.io.ResourceLoader resourceLoader;
    private String resourceLoaderPath;

    public void init(ExtendedProperties configuration) {
        this.resourceLoader = (com.bmc.thirdparty.org.springframework.core.io.ResourceLoader)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER);
        this.resourceLoaderPath = (String)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER_PATH);
        if (this.resourceLoader == null) {
            throw new IllegalArgumentException("'resourceLoader' application attribute must be present for SpringResourceLoader");
        }
        if (this.resourceLoaderPath == null) {
            throw new IllegalArgumentException("'resourceLoaderPath' application attribute must be present for SpringResourceLoader");
        }
        if (!this.resourceLoaderPath.endsWith("/")) {
            this.resourceLoaderPath = this.resourceLoaderPath + "/";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SpringResourceLoader for Velocity: using resource loader [" + this.resourceLoader + "] and resource loader path [" + this.resourceLoaderPath + "]");
        }
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking for Velocity resource with name [" + source + "]");
        }
        com.bmc.thirdparty.org.springframework.core.io.Resource resource = this.resourceLoader.getResource(this.resourceLoaderPath + source);
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not find Velocity resource: " + resource);
            }
            throw new ResourceNotFoundException(ex.getMessage());
        }
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

