/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.remoting;

import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.jms.listener.SessionAwareMessageListener;
import com.bmc.thirdparty.org.springframework.jms.support.JmsUtils;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocation;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationBasedExporter;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationResult;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class JmsInvokerServiceExporter
extends RemoteInvocationBasedExporter
implements SessionAwareMessageListener,
InitializingBean {
    private boolean ignoreInvalidRequests = true;
    private Object proxy;

    public void setIgnoreInvalidRequests(boolean ignoreInvalidRequests) {
        this.ignoreInvalidRequests = ignoreInvalidRequests;
    }

    public void afterPropertiesSet() {
        this.proxy = this.getProxyForService();
    }

    public void onMessage(Message requestMessage, Session session) throws JMSException {
        RemoteInvocation invocation = this.readRemoteInvocation(requestMessage);
        if (invocation != null) {
            RemoteInvocationResult result = this.invokeAndCreateResult(invocation, this.proxy);
            this.writeRemoteInvocationResult(requestMessage, session, result);
        }
    }

    protected RemoteInvocation readRemoteInvocation(Message requestMessage) throws JMSException {
        ObjectMessage objectMessage;
        Serializable body;
        if (requestMessage instanceof ObjectMessage && (body = (objectMessage = (ObjectMessage)requestMessage).getObject()) instanceof RemoteInvocation) {
            return (RemoteInvocation)body;
        }
        return this.onInvalidRequest(requestMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRemoteInvocationResult(Message requestMessage, Session session, RemoteInvocationResult result) throws JMSException {
        Message response = this.createResponseMessage(requestMessage, session, result);
        MessageProducer producer = session.createProducer(requestMessage.getJMSReplyTo());
        try {
            producer.send(response);
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected Message createResponseMessage(Message requestMessage, Session session, RemoteInvocationResult result) throws JMSException {
        ObjectMessage response = session.createObjectMessage((Serializable)result);
        response.setJMSCorrelationID(requestMessage.getJMSCorrelationID());
        return response;
    }

    protected RemoteInvocation onInvalidRequest(Message requestMessage) throws JMSException {
        if (this.ignoreInvalidRequests) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Invalid request message will be discarded: " + requestMessage);
            }
            return null;
        }
        throw new MessageFormatException("Invalid request message: " + requestMessage);
    }
}

