/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcAuthenticationException;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcClientAuth;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrDecodingStream;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrEncodingStream;
import java.io.IOException;

public class OncRpcClientAuthUnix
extends OncRpcClientAuth {
    private int stamp = (int)(System.currentTimeMillis() / 1000L);
    private String machinename;
    private int uid;
    private int gid;
    private int[] gids;
    private byte[] shorthandCred;
    public static final int[] NO_GIDS = new int[0];

    public OncRpcClientAuthUnix(String string, int n2, int n3, int[] nArray) {
        this.machinename = string;
        this.uid = n2;
        this.gid = n3;
        this.gids = nArray;
    }

    public OncRpcClientAuthUnix(String string, int n2, int n3) {
        this(string, n2, n3, NO_GIDS);
    }

    protected void xdrEncodeCredVerf(XdrEncodingStream xdrEncodingStream) throws OncRpcException, IOException {
        if (this.shorthandCred == null) {
            if (this.gids.length > 16 || this.machinename.length() > 255) {
                throw new OncRpcAuthenticationException(7);
            }
            xdrEncodingStream.xdrEncodeInt(1);
            int n2 = 4 + (this.machinename.length() + 7 & 0xFFFFFFFC) + 4 + 4 + this.gids.length * 4 + 4;
            if (n2 > 400) {
                throw new OncRpcAuthenticationException(7);
            }
            xdrEncodingStream.xdrEncodeInt(n2);
            xdrEncodingStream.xdrEncodeInt(this.stamp);
            xdrEncodingStream.xdrEncodeString(this.machinename);
            xdrEncodingStream.xdrEncodeInt(this.uid);
            xdrEncodingStream.xdrEncodeInt(this.gid);
            xdrEncodingStream.xdrEncodeIntVector(this.gids);
        } else {
            xdrEncodingStream.xdrEncodeInt(2);
            xdrEncodingStream.xdrEncodeDynamicOpaque(this.shorthandCred);
        }
        xdrEncodingStream.xdrEncodeInt(0);
        xdrEncodingStream.xdrEncodeInt(0);
    }

    protected void xdrDecodeVerf(XdrDecodingStream xdrDecodingStream) throws OncRpcException, IOException {
        switch (xdrDecodingStream.xdrDecodeInt()) {
            case 0: {
                if (xdrDecodingStream.xdrDecodeInt() == 0) break;
                throw new OncRpcAuthenticationException(7);
            }
            case 2: {
                this.shorthandCred = xdrDecodingStream.xdrDecodeDynamicOpaque();
                if (this.shorthandCred.length <= 400) break;
                throw new OncRpcAuthenticationException(7);
            }
            default: {
                throw new OncRpcAuthenticationException(6);
            }
        }
    }

    protected boolean canRefreshCred() {
        if (this.shorthandCred == null) {
            return false;
        }
        this.shorthandCred = null;
        this.stamp = (int)(System.currentTimeMillis() / 1000L);
        return true;
    }

    public void setStamp(int n2) {
        this.stamp = n2;
    }

    public int getStamp() {
        return this.stamp;
    }

    public void setMachinename(String string) {
        this.machinename = string;
    }

    public String getMachinename() {
        return this.machinename;
    }

    public void setUid(int n2) {
        this.uid = n2;
    }

    public int getUid() {
        return this.uid;
    }

    public void setGid(int n2) {
        this.gid = n2;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGids(int[] nArray) {
        this.gids = nArray;
    }

    public int[] getGids() {
        return this.gids;
    }
}

