/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DefaultProxyManager;
import com.bmc.arsys.api.PoolingProxyManager;
import com.bmc.arsys.api.Proxy;
import com.bmc.arsys.api.ProxyJRpc;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.session.ARServerContext;
import com.bmc.arsys.api.session.b;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ProxyManager {
    private static int maxProxiesPerServer = Config.getInstance().getMaxProxiesPerServer();
    private static boolean for = true;
    private static ProxyManager do = null;
    private static Map<String, ARServerContext> a = new Hashtable<String, ARServerContext>();
    private static Logger if = Logger.getLogger(ProxyManager.class);

    public static ProxyManager getProxyManager() {
        if (do == null) {
            do = ProxyManager.isUseConnectionPooling() ? new PoolingProxyManager(maxProxiesPerServer) : new DefaultProxyManager();
        }
        return do;
    }

    public static void setConnectionLimits(int n2) {
        maxProxiesPerServer = n2;
        if.info("Client sets connection limits per server to :" + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseConnectionPooling(boolean bl) {
        if.info("Client sets useConnectionPooling to : " + bl);
        if (for == bl) {
            return;
        }
        if (do != null) {
            ProxyManager proxyManager = do;
            synchronized (proxyManager) {
                for = bl;
                do.clear();
                do = ProxyManager.getProxyManager();
            }
        } else {
            for = bl;
        }
    }

    public static boolean isUseConnectionPooling() {
        return for;
    }

    public static PoolInfo[] getPoolInformation() {
        return do.getInfo();
    }

    synchronized PoolInfo[] getInfo() {
        return new PoolInfo[0];
    }

    public abstract Proxy getProxy(ARServerUser var1) throws ARException;

    public abstract void releaseProxy(Proxy var1, ARServerUser var2);

    synchronized void clear() {
    }

    protected Proxy createProxy(ARServerUser aRServerUser) throws ARException {
        Proxy proxy = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connects to ARServer ").append(aRServerUser.getServer()).append(" through ");
        if (Config.getInstance().getJrpcMode()) {
            try {
                proxy = new ProxyJRpc(aRServerUser);
                stringBuilder.append(proxy);
                if.info(stringBuilder.toString());
            }
            catch (ARException aRException) {
                stringBuilder.append("Java Rpc failed with: ").append(aRException);
                if.error(stringBuilder.toString());
                List<StatusInfo> list = aRException.getLastStatus();
                if (list.size() > 0 && list.get(0).getMessageNum() == 8203L) {
                    if.error("Will retry Jni");
                }
                aRServerUser.setLastStatus(list);
                throw aRException;
            }
        }
        if (proxy == null) {
            proxy = new Proxy(true);
            stringBuilder.append(proxy);
            if.info(stringBuilder.toString());
        }
        return proxy;
    }

    public static Map<String, ARServerContext> getServerContextMap() {
        return a;
    }

    static b getARServerContext(String string, int n2) {
        String string2 = string + ":" + n2;
        return (b)a.get(string2);
    }

    public static class PoolInfo {
        protected String mServerKey;
        protected int mFree;
        protected int mInUse;
        protected int mNotCreated;

        PoolInfo(String string, int n2, int n3, int n4) {
            this.mServerKey = string;
            this.mInUse = n2;
            this.mFree = n3;
            this.mNotCreated = n4;
        }

        public String getServerName() {
            return this.mServerKey;
        }

        public int getInUse() {
            return this.mInUse;
        }

        public int getFree() {
            return this.mFree;
        }

        public int getNotCreated() {
            return this.mNotCreated;
        }
    }
}

