/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.EntryFactory;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.RecordResult;
import com.bmc.arsys.apiext.data.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseImporter
extends BaseObject {
    private static Logger cd = Logger.getLogger(BaseImporter.class);
    public static final String DATA_FILE_FORM = "ARImport_Data_Holder";
    protected static final int AR_MERGE_NO_SUPPRESS_FILTERS = 4096;
    protected ImportOptions options;
    private Parser b4;
    private EntryFactory cc = null;
    private FormInformation b6 = null;
    private FormInformation b9 = null;
    private String ca = null;
    private IParseListener b7;
    private int b3 = 0;
    private boolean cb = false;
    private boolean b8 = true;
    private String b5 = "";

    public BaseImporter(ImportOptions importOptions) throws ARImportException {
        this.options = importOptions;
        this.createParser();
        this.createListener();
    }

    protected abstract Parser createParser() throws ARImportException;

    protected void createListener() {
        this.b7 = new IParseListener(){

            public void handleEvent(ParseEvent parseEvent) throws ARImportException, ARException {
                switch (parseEvent.getType()) {
                    case 0: {
                        if (parseEvent.getData() != null && BaseImporter.this.getTargetForm() != null && cd.isInfoEnabled()) {
                            if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                                cd.info(MessageFormat.format("Import Completed. {0} records were imported to {1}; {2} Records were not.", BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName())));
                            } else {
                                cd.info(MessageFormat.format("Import Completed. {0} records were imported to {1}.", BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                            }
                        }
                        BaseImporter.this.handleNewFormEvent((FormInformation)parseEvent.getData());
                        break;
                    }
                    case 1: {
                        if (BaseImporter.this.getTargetForm() != null) {
                            BaseImporter.this.getOptions().getResults().incrementRecordCount(BaseImporter.this.getTargetForm().getName());
                        }
                        BaseImporter.this.handleDataEvent((List)parseEvent.getData(), parseEvent.getLine());
                        break;
                    }
                    case 2: {
                        if (BaseImporter.this.getTargetForm() != null && cd.isInfoEnabled()) {
                            if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                                cd.info(MessageFormat.format("Import Completed. {0} records were imported to {1}; {2} Records were not.", BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName())));
                            } else {
                                cd.info(MessageFormat.format("Import Completed. {0} records were imported to {1}.", BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                            }
                        }
                        BaseImporter.this.handleEndEvent();
                        break;
                    }
                    case 3: {
                        BaseImporter.this.handleTitlesEvent((List)parseEvent.getData());
                        break;
                    }
                    case 4: {
                        BaseImporter.this.handleStartTransaction();
                        break;
                    }
                    case 5: {
                        BaseImporter.this.handleEndTransaction(1);
                        break;
                    }
                    case 6: {
                        BaseImporter.this.handleEndTransaction(2);
                    }
                }
            }

            public boolean isAbort() {
                return false;
            }
        };
        if (this.b4 != null) {
            this.b4.addListener(this.b7);
        }
    }

    protected void handleEndTransaction(int n) throws ARImportException {
        try {
            if (this.cb) {
                this.cb = false;
                if (cd.isTraceEnabled()) {
                    cd.trace("Ending bulk transaction");
                }
                this.options.getContext().endBulkEntryTransaction(n);
            }
        }
        catch (ARException aRException) {
            if (cd.isEnabledFor(Level.ERROR)) {
                cd.error(MessageFormat.format("Error encountered ending bulk transaction: {0}", aRException.getMessage()));
            }
            if (cd.isDebugEnabled()) {
                cd.debug("Error encountered ending bulk transaction: ", aRException);
            }
            throw new ARImportException("Error encountered ending transaction", aRException);
        }
    }

    protected void handleStartTransaction() throws ARImportException {
        try {
            if (this.options.getDataOptions().getTransactionSize() > 1) {
                this.b3 = 0;
                if (cd.isTraceEnabled()) {
                    cd.trace("Starting bulk transaction");
                }
                this.options.getContext().beginBulkEntryTransaction();
                this.cb = true;
            }
        }
        catch (ARException aRException) {
            if (cd.isEnabledFor(Level.ERROR)) {
                cd.error(MessageFormat.format("Error encountered starting bulk transaction: {0}", aRException.getMessage()));
            }
            if (cd.isDebugEnabled()) {
                cd.debug("Error encountered starting bulk transaction: ", aRException);
            }
            throw new ARImportException("Error encountered starting bulk transaction", aRException);
        }
    }

    protected void handleTitlesEvent(List<String> list) throws ARException {
    }

    protected void handleEndEvent() throws ARImportException {
        if (this.cb) {
            this.handleEndTransaction(1);
        }
    }

    protected void handleDataEvent(List<String> list, String string) throws ARImportException, ARException {
        if (this.getParser().isAbort() && this.getParser().isCopyToLog()) {
            Util.logEntry(string);
            this.getOptions().getResults().addError(this.getTargetForm().getName(), null);
            this.getOptions().getResults().incrementRecordCount(this.getTargetForm().getName());
        } else if (this.isProcessDataSet()) {
            if (this.options.getDataOptions().getTransactionSize() > 1 && this.b3 == this.options.getDataOptions().getTransactionSize() && this.cb) {
                this.handleEndTransaction(1);
            }
            if (this.options.getDataOptions().getTransactionSize() > 1 && !this.cb) {
                this.handleStartTransaction();
            }
            this.createEntry(list, string);
            ++this.b3;
        }
    }

    protected void handleNewFormEvent(FormInformation formInformation) throws ARImportException, ARException {
    }

    public ImportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ImportOptions importOptions) {
        this.options = importOptions;
    }

    public abstract void startImport() throws ARImportException, IOException, ARException;

    protected void importEntry(FormInformation formInformation, Entry entry) throws ARException {
        ARServerUser aRServerUser = this.options.getContext();
        DataOptions dataOptions = this.options.getDataOptions();
        int n = this.a(dataOptions.getDuplicateIdHandling().getMergeOption());
        if (dataOptions.getDuplicateFields() != null && dataOptions.getDuplicateFields().size() > 0) {
            QualifierInfo qualifierInfo = this.a(formInformation, entry, dataOptions.getDuplicateFields());
            if (qualifierInfo != null) {
                ArrayList<EntryListFieldInfo> arrayList = new ArrayList<EntryListFieldInfo>(1);
                arrayList.add(new EntryListFieldInfo(1));
                int n2 = 0;
                if (dataOptions.getMultiMatch() == DataOptions.MultiMatch.USEFIRST) {
                    n2 = 1;
                }
                List list = null;
                try {
                    list = aRServerUser.getListEntry(formInformation.getName(), qualifierInfo, 0, n2, null, arrayList, false, null);
                }
                catch (ARException aRException) {
                    // empty catch block
                }
                if (list != null && !list.isEmpty()) {
                    if (dataOptions.getMultiMatch() == DataOptions.MultiMatch.SKIP) {
                        if (cd.isInfoEnabled()) {
                            cd.info("Multiple duplicate entries were found, but the configuration skips entries with multiple matches and do not update them");
                        }
                    } else {
                        for (EntryListInfo entryListInfo : list) {
                            entry.setEntryId(entryListInfo.getEntryID());
                            this.b5 = aRServerUser.mergeEntry(formInformation.getName(), entry, n);
                            if (this.getEntryFactory() != null) {
                                this.getEntryFactory().setLastId(this.b5);
                            }
                            if (!cd.isTraceEnabled()) continue;
                            cd.trace(MessageFormat.format("Entry created with ID: {0}", this.b5));
                        }
                    }
                } else {
                    if (dataOptions.getDuplicateIdHandling() == DataOptions.DuplicateHandling.DUP_OVERWRITE) {
                        n = this.a(2);
                        entry.remove((Object)1);
                    } else if (!dataOptions.getDuplicateFields().contains(1)) {
                        n = this.a(2);
                        entry.remove((Object)1);
                    }
                    this.b5 = aRServerUser.mergeEntry(formInformation.getName(), entry, n);
                    if (this.getEntryFactory() != null) {
                        this.getEntryFactory().setLastId(this.b5);
                    }
                    if (cd.isTraceEnabled()) {
                        cd.trace(MessageFormat.format("Entry created with ID: {0}", this.b5));
                    }
                }
            }
        } else {
            Value value = (Value)entry.get((Object)1);
            if (dataOptions.getDuplicateIdHandling().getMergeOption() == 5) {
                entry.remove((Object)1);
            }
            this.b5 = aRServerUser.mergeEntry(formInformation.getName(), entry, n);
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setLastId(this.b5);
            }
            if (cd.isTraceEnabled()) {
                cd.trace(MessageFormat.format("Entry created with ID: {0}", this.b5));
            }
        }
    }

    private int a(int n) {
        int n2 = n;
        if (this.options.getDataOptions().isDisablePattern()) {
            n2 |= 0x800;
        }
        if (this.options.getDataOptions().isDisableRequired()) {
            n2 |= 0x400;
        }
        if (this.options.getDataOptions().isSuppressFilters()) {
            try {
                if (this.getOptions().getContext() != null && this.getOptions().getContext().isAdministrator()) {
                    n2 |= 0x1000;
                }
            }
            catch (ARException aRException) {
                cd.error("Unable to determine if user is an administrator. Filter suppression will not be enabled", aRException);
            }
        }
        return n2;
    }

    private QualifierInfo a(FormInformation formInformation, Entry entry, List<Integer> list) throws ARException {
        QualifierInfo qualifierInfo;
        Value value;
        QualifierInfo qualifierInfo2 = null;
        ArrayList<QualifierInfo> arrayList = new ArrayList<QualifierInfo>(list.size());
        for (Integer n2 : list) {
            value = (Value)entry.get((Object)n2);
            if (value == null) continue;
            RelationalOperationInfo relationalOperationInfo = new RelationalOperationInfo();
            relationalOperationInfo.setOperation(1);
            relationalOperationInfo.setLeftOperand(new ArithmeticOrRelationalOperand(n2.intValue()));
            relationalOperationInfo.setRightOperand(new ArithmeticOrRelationalOperand(value));
            qualifierInfo = new QualifierInfo(relationalOperationInfo);
            arrayList.add(qualifierInfo);
        }
        if (!arrayList.isEmpty()) {
            int n = arrayList.size();
            if (n == 1) {
                return (QualifierInfo)arrayList.get(0);
            }
            qualifierInfo2 = new QualifierInfo(1, (QualifierInfo)arrayList.get(0), null);
            if (n == 2) {
                qualifierInfo2.setRightOperand((QualifierInfo)arrayList.get(1));
            } else {
                Integer n2;
                n2 = null;
                value = null;
                for (int i = 1; i < n; ++i) {
                    QualifierInfo qualifierInfo3;
                    qualifierInfo = null;
                    QualifierInfo qualifierInfo4 = (QualifierInfo)arrayList.get(i);
                    if (n > i + 1) {
                        qualifierInfo3 = (QualifierInfo)arrayList.get(++i);
                        qualifierInfo = new QualifierInfo(1, qualifierInfo4, qualifierInfo3);
                    } else {
                        qualifierInfo = qualifierInfo4;
                    }
                    if (n2 == null) {
                        qualifierInfo2.setRightOperand(qualifierInfo);
                        value = qualifierInfo2;
                        n2 = qualifierInfo;
                        continue;
                    }
                    qualifierInfo3 = new QualifierInfo(1, (QualifierInfo)n2, qualifierInfo);
                    value.setRightOperand(qualifierInfo3);
                    value = qualifierInfo3;
                    n2 = qualifierInfo3;
                }
            }
        }
        return qualifierInfo2;
    }

    protected void verifyCoreFields(FormInformation formInformation, Entry entry) {
    }

    public EntryFactory getEntryFactory() {
        return this.cc;
    }

    public void setEntryFactory(EntryFactory entryFactory) {
        this.cc = entryFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createEntry(List<String> list, String string) throws ARImportException, ARException {
        if (this.cc == null) {
            this.cc = new EntryFactory(this.getParser(), this.options, this.getSourceForm(), this.getTargetForm());
        }
        Entry entry = null;
        try {
            Entry entry2 = this.cc.createEntry(list, string);
            if (entry2 == null) return;
            entry = entry2;
            this.importEntry(this.getTargetForm(), entry2);
            List list2 = this.getOptions().getContext().getLastStatus();
            if (list2 != null && list2.size() > 0) {
                if (((StatusInfo)list2.get(0)).getMessageType() == 1) {
                    this.getOptions().getResults().addWarning(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), ((StatusInfo)this.getOptions().getContext().getLastStatus().get(0)).getMessageText(), null));
                    if (!cd.isEnabledFor(Level.WARN)) return;
                    cd.warn(MessageFormat.format("Record {0} imported with warnings:", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName())));
                    return;
                } else {
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                }
                return;
            }
            this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
            return;
        }
        catch (Exception exception) {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (exception instanceof ARException) {
                if (this.options.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.FALLBACK) {
                    this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), string));
                }
                object = (ARException)((Object)exception);
                StatusInfo[] statusInfoArray = object.getLastStatus().toArray(new StatusInfo[0]);
                for (int i = 0; i < statusInfoArray.length; ++i) {
                    long l = statusInfoArray[i].getMessageNum();
                    String string2 = statusInfoArray[i].getAppendedText();
                    if (string2 != null) {
                        String[] stringArray = string2.split(" ");
                        for (int j = 0; j < stringArray.length; ++j) {
                            try {
                                arrayList.add(Integer.parseInt(stringArray[j]));
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if (380L != l) continue;
                    if (!cd.isInfoEnabled()) return;
                    cd.info(MessageFormat.format("{1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                    return;
                }
            } else {
                this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), string));
                if (cd.isDebugEnabled()) {
                    cd.debug("Exception encountered", exception);
                }
            }
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.FALLBACK && entry != null) {
                try {
                    object = this.options.getMappingOptions(this.b6.getName(), this.b9.getName());
                    if (object == null) {
                        object = this.options.getMappingOptions(DATA_FILE_FORM, this.b9.getName());
                    }
                    Object[] objectArray = ((MappingOptions)object).getFallbacks().keySet().toArray();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (int i = 0; i < objectArray.length; ++i) {
                        arrayList2.add((Integer)objectArray[i]);
                    }
                    this.doFallback(list, arrayList, entry, arrayList2, string);
                    return;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.STOP) {
                if (!cd.isEnabledFor(Level.WARN)) throw new ARImportException(exception);
                cd.warn("Stopping import on first failure as defined in options");
                cd.warn(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                throw new ARImportException(exception);
            }
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.SKIP) {
                if (!cd.isInfoEnabled()) return;
                cd.info("Skipping import of record as defined in options");
                cd.info(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                return;
            }
            if (this.options.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.ALERTUSER || this.options.getUserAlertListener() == null) return;
            int n = this.options.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, exception.getMessage());
            switch (n) {
                case 0: {
                    cd.warn("Stopping import on first failure as instructed by user");
                    cd.warn(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                    this.getParser().setAbort(true);
                    this.handleEndTransaction(2);
                    return;
                }
                case 2: {
                    cd.warn(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                    cd.warn("Stopping import as instructed by user. Copying remaining records to log");
                    this.getParser().setAbort(true);
                    this.getParser().setCopyToLog(true);
                    this.handleEndTransaction(2);
                    return;
                }
                default: {
                    String string3 = MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string);
                    if (!cd.isInfoEnabled()) return;
                    cd.info("Skipping import of record as instructed by user");
                    cd.info(string3);
                }
            }
        }
    }

    protected void doFallback(List<String> list, ArrayList<Integer> arrayList, Entry entry, ArrayList<Integer> arrayList2, String string) throws ARException, ARImportException {
        Object object;
        MappingOptions mappingOptions = this.options.getMappingOptions(this.b6.getName(), this.b9.getName());
        if (mappingOptions == null) {
            mappingOptions = this.options.getMappingOptions(DATA_FILE_FORM, this.b9.getName());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!this.isFallback(arrayList.get(i), arrayList2)) continue;
            arrayList2.remove(arrayList.get(i));
            int n = this.cc.applyFallbackMappings(mappingOptions, this.b6, this.b9, list, arrayList.get(i));
            Mapping mapping = mappingOptions.getMappings().get(arrayList.get(i));
            FieldInformation fieldInformation = this.b9.getFields().get(arrayList.get(i));
            Converter converter = null;
            converter = new Converter(this.options);
            if (fieldInformation.getDataType() == null) continue;
            if (mapping.getType() == Mapping.Type.CONSTANT) {
                if (cd.isTraceEnabled()) {
                    cd.trace(MessageFormat.format("Setting value for {0} to constant based on mapping {1}", fieldInformation.getFieldId(), mapping));
                }
                entry.put(Integer.valueOf(fieldInformation.getFieldId()), new Value(mapping.getConstant()));
                continue;
            }
            int n2 = mapping.getTokenIndex();
            if (n2 <= -1 || n2 > list.size() - 1) continue;
            object = list.get(n2);
            Value value = mapping.getType() == Mapping.Type.KEYWORD ? converter.getKeywordValue(fieldInformation, mapping) : converter.convertToARValue(fieldInformation, (String)object);
            if (cd.isTraceEnabled()) {
                cd.trace(MessageFormat.format("Setting value for {0} to {1} based on mapping {2}", fieldInformation.getFieldId(), value, mapping));
            }
            entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
        }
        try {
            this.importEntry(this.b9, entry);
            List list2 = this.getOptions().getContext().getLastStatus();
            if (list2 != null && list2.size() > 0) {
                if (((StatusInfo)list2.get(0)).getMessageType() == 1) {
                    this.getOptions().getResults().addWarning(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), ((StatusInfo)this.getOptions().getContext().getLastStatus().get(0)).getMessageText(), null));
                    if (cd.isEnabledFor(Level.WARN)) {
                        cd.warn(MessageFormat.format("Record {0} imported with warnings:", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName())));
                    }
                } else {
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                }
            } else {
                this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
            }
        }
        catch (ARException aRException) {
            arrayList.clear();
            StatusInfo[] statusInfoArray = aRException.getLastStatus().toArray(new StatusInfo[0]);
            for (int i = 0; i < statusInfoArray.length; ++i) {
                long l = statusInfoArray[i].getMessageNum();
                String string2 = statusInfoArray[i].getAppendedText();
                object = string2.split(" ");
                for (int j = 0; j < ((String[])object).length; ++j) {
                    try {
                        arrayList.add(Integer.parseInt(object[j]));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (380L != l) continue;
                if (cd.isInfoEnabled()) {
                    cd.info(MessageFormat.format("{1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), aRException.getMessage(), System.getProperty("line.separator"), string));
                }
                return;
            }
            if (this.isFallback(arrayList.get(0), arrayList2)) {
                this.doFallback(list, arrayList, entry, arrayList2, string);
            }
            this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), aRException.getMessage(), string));
        }
    }

    protected String getCurrentSource() {
        return this.ca;
    }

    protected void setCurrentSource(String string) {
        this.ca = string;
    }

    protected FormInformation getSourceForm() {
        if (this.b6 == null) {
            this.b6 = this.options.getFirstFileForm();
        }
        return this.b6;
    }

    protected void setSourceForm(FormInformation formInformation) {
        this.b6 = formInformation;
    }

    protected FormInformation getTargetForm() throws ARException {
        return this.b9;
    }

    protected void setTargetForm(FormInformation formInformation) {
        this.b9 = formInformation;
    }

    public IParser getParser() throws ARImportException {
        if (this.b4 == null) {
            this.b4 = this.createParser();
            this.createListener();
        }
        return this.b4;
    }

    protected boolean isProcessDataSet() {
        return this.b8;
    }

    protected void setProcessDataSet(boolean bl) {
        this.b8 = bl;
    }

    protected boolean isFallback(Integer n, ArrayList<Integer> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equals(n)) continue;
            return true;
        }
        return false;
    }

    protected void removeFallbackAppliedID(Integer n, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((Integer)objectArray[i]).equals(n)) continue;
        }
    }
}

