/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import com.bmc.arsys.ws.mapping.ARSPort;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ARSWebService {
    protected LinkedList<ARSPort> portsList = new LinkedList();
    protected HashMap<String, ARSPort> ports = new HashMap();
    protected Element element;
    protected String name;
    protected String targetNamespace;
    protected String description = null;

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection getPorts() {
        return this.portsList;
    }

    public ARSWebService(String string, String string2, String string3) {
        this.name = string;
        this.targetNamespace = string2;
        this.element = null;
        this.description = string3;
    }

    public ARSWebService(Element element) {
        this.element = element;
        this.parseXML();
    }

    public ARSWebService(ARSWebService aRSWebService, String string, StringBuffer stringBuffer) {
        Document document = WsdlUtil.newDocument();
        document.appendChild(document.importNode(aRSWebService.element, true));
        this.element = document.getDocumentElement();
        this.parseXML();
    }

    public void parseXML() {
        Element element = this.element;
        if (!element.getLocalName().equals("webservice")) {
            throw new ARWSException("OTHER_ERROR", "ERROR: root element in parseWebServiceInfo should be webservice");
        }
        this.name = element.getAttribute("name");
        if (this.name == null) {
            throw new ARWSException("OTHER_ERROR", "ERROR: webservice should have a name attribute");
        }
        this.targetNamespace = element.getAttribute("targetNamespace");
        this.description = element.getAttribute("description");
        if (this.targetNamespace == null || this.targetNamespace.equals("")) {
            this.targetNamespace = "urn:" + this.name;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getLocalName().equals("port")) continue;
            ARSPort aRSPort = new ARSPort(element2, this.targetNamespace);
            this.addPort(aRSPort);
            if (this.targetNamespace != null) continue;
            this.targetNamespace = aRSPort.getTargetNamespace();
        }
    }

    public void addPort(ARSPort aRSPort) {
        if (!this.ports.containsKey(aRSPort.getName())) {
            this.ports.put(aRSPort.getName(), aRSPort);
            this.portsList.add(aRSPort);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void generateXML(Document document) {
        Element element = document.createElementNS(null, "webservice");
        element.setAttributeNS(null, "name", this.getName());
        element.setAttributeNS(null, "targetNamespace", this.getTargetNamespace());
        if (this.getDescription() != null) {
            element.setAttributeNS(null, "description", this.getDescription());
        }
        this.element = element;
        document.getDocumentElement().appendChild(element);
        for (ARSPort aRSPort : this.getPorts()) {
            aRSPort.generateXML(document, this.element);
        }
    }
}

