/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.apiconverter.ArAttachmentInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arcompress.ARDecompressor;
import com.bmc.arsys.arrpc.ArAttachStruct8;
import com.bmc.arsys.arrpc.ArBufStruct8;
import com.bmc.arsys.arrpc.ArLocStruct8;
import com.bmc.arsys.arrpc.ArPropList;
import com.bmc.arsys.arrpc.ArPropStruct;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.StringByteUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;

public class ValueObjectFactory {
    public static ArValueStruct setValueObject(int fieldId, Value value, String serverCharSetName) throws ARException {
        ArValueStruct valueStruct = ValueObjectFactory.setValueObject(value, serverCharSetName);
        return valueStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArValueStruct setValueObject(Value value, String serverCharSetName) throws ARException {
        if (value == null) {
            return new ArValueStruct();
        }
        ArValueStruct arValueStruct = null;
        int dataType = value.getDataType().toInt();
        Object dataVal = value.getValue();
        if (dataVal == null) {
            switch (dataType) {
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 41: 
                case 42: 
                case 43: {
                    dataType = 0;
                }
            }
        }
        switch (dataType) {
            case 9: {
                return new ArValueStruct(dataType, (Object)ApiToRpcMapping.getInstance().toRpcArByteList((ByteListValue)dataVal));
            }
            case 7: {
                return new ArValueStruct(dataType, (Object)new ArTimestamp((int)((Timestamp)dataVal).getValue()));
            }
            case 13: {
                return new ArValueStruct(dataType, (Object)((DateInfo)dataVal).getValue());
            }
            case 14: {
                return new ArValueStruct(dataType, (Object)((int)((Time)dataVal).getValue()));
            }
            case 10: {
                return new ArValueStruct(dataType, (Object)ConversionUtil.getStringValue((Object)((BigDecimal)dataVal)));
            }
            case 12: {
                return new ArValueStruct(dataType, (Object)ApiToRpcMapping.getInstance().toRpcArCurrencyStruct((CurrencyValue)dataVal));
            }
            case 41: {
                return new ArValueStruct(dataType, (Object)ApiToRpcMapping.getInstance().toRpcArCoordList((List)dataVal));
            }
            case 11: {
                AttachmentValue att = (AttachmentValue)dataVal;
                byte[] output = new byte[]{};
                if (att == null) return new ArValueStruct(49, (Object)new ArAttachStruct8());
                if (att.getContent() == null) return new ArValueStruct(49, (Object)new ArAttachStruct8());
                ARCompressor compresser = new ARCompressor();
                byte[] content = att.getContent();
                ARByteArrayBuffer buf = new ARByteArrayBuffer();
                try {
                    compresser.setInput(content);
                    int len = compresser.deflate(buf);
                    att.setCompressedSize((long)len);
                    output = buf.getBuffer();
                }
                finally {
                    buf.setBuffer(null);
                    buf = null;
                    compresser = null;
                }
                ArLocStruct8 loc8 = new ArLocStruct8(att.getLocationType(), (Object)new ArBufStruct8(output));
                return new ArValueStruct(49, (Object)new ArAttachStruct8(att.getName(), (int)att.getOriginalSize(), (int)att.getCompressedSize(), loc8));
            }
            case 8: 
            case 40: {
                return new ArValueStruct(dataType, (Object)StringByteUtil.longToULong((long)((Long)dataVal)));
            }
            case 5: {
                if (dataVal instanceof DiaryListValue) {
                    if (((DiaryListValue)dataVal).getAppendedText() == null) return new ArValueStruct(dataType, (Object)((DiaryListValue)dataVal).encode());
                    return new ArValueStruct(dataType, (Object)((DiaryListValue)dataVal).getAppendedText());
                }
                if (!(dataVal instanceof String)) return new ArValueStruct(dataType, (Object)"");
                return new ArValueStruct(dataType, dataVal);
            }
            case 1: {
                return new ArValueStruct(dataType, (Object)((Keyword)value.getValue()).toInt());
            }
            case 6: {
                return new ArValueStruct(dataType, (Object)((Number)value.getValue()).intValue());
            }
            default: {
                return new ArValueStruct(dataType, dataVal);
            }
        }
    }

    public static Value getValueObject(int fieldId, ArValueStruct valueStruct, String serverCharSetName) throws ARException {
        Value val = null;
        val = ValueObjectFactory.getValueObject(valueStruct);
        return val;
    }

    public static Value getValueObject(ArValueStruct valueStruct) throws ARException {
        if (valueStruct == null) {
            return new Value();
        }
        Value val = null;
        switch (valueStruct.dataType) {
            case 0: {
                val = new Value();
                break;
            }
            case 1: {
                val = new Value(valueStruct.keyNum);
                break;
            }
            case 2: {
                val = new Value(valueStruct.intVal);
                break;
            }
            case 3: {
                val = new Value(valueStruct.realVal);
                break;
            }
            case 4: 
            case 42: 
            case 43: {
                val = new Value(valueStruct.charVal);
                break;
            }
            case 5: {
                try {
                    val = new Value(DiaryListValue.decode((String)valueStruct.diaryVal));
                }
                catch (ARException ex) {
                    val = new Value((Object)valueStruct.diaryVal, DataType.DIARY);
                }
                break;
            }
            case 6: {
                val = new Value((Object)new Integer(valueStruct.enumVal), DataType.toDataType((int)6));
                break;
            }
            case 7: {
                val = new Value(new Timestamp((long)valueStruct.timeVal.getValue()));
                break;
            }
            case 8: {
                val = new Value(ValueObjectFactory.intToULong(valueStruct.maskVal));
                break;
            }
            case 10: {
                val = new Value(new BigDecimal(valueStruct.decimalVal));
                break;
            }
            case 11: {
                ARDecompressor decompresser = new ARDecompressor();
                try {
                    byte[] attVal = valueStruct.attachVal.getLoc().buf.getBuffer();
                    decompresser.setInput(attVal);
                    byte[] result = decompresser.inflate();
                    AttachmentValue att = new AttachmentValue(valueStruct.attachVal.getName(), result);
                    att.setCompressedSize((long)valueStruct.attachVal.getCompSize());
                    att.setOriginalSize((long)valueStruct.attachVal.getOrigSize());
                    val = new Value(att);
                    break;
                }
                catch (DataFormatException ex) {
                    throw new ARException(2, 160, ex.getMessage());
                }
                finally {
                    decompresser.end();
                    decompresser = null;
                }
            }
            case 12: {
                val = new Value(ApiToRpcMapping.getInstance().fromRpcArCurrencyStructToCurrencyInfo(valueStruct.currencyVal));
                break;
            }
            case 13: {
                val = new Value(new DateInfo(valueStruct.dateVal));
                break;
            }
            case 14: {
                val = new Value(new Time((long)valueStruct.timeOfDayVal));
                break;
            }
            case 40: {
                val = new Value(ValueObjectFactory.intToULong(valueStruct.ulongVal));
                break;
            }
            case 49: {
                ArAttachStruct8 attach8 = valueStruct.attachVal8;
                if (attach8 == null) break;
                val = new Value((AttachmentValue)new ArAttachmentInfo(attach8.getName(), (long)attach8.getOrigSize(), (long)attach8.getCompSize(), attach8.getLoc().buf.getBuffer(), ArAttachmentInfo.UNCOMPRESS));
                break;
            }
            case 9: {
                val = new Value(new ByteListValue(41, valueStruct.byteListVal.getBytes()));
                break;
            }
            case 41: {
                val = new Value(ApiToRpcMapping.getInstance().fromRpcArCoordList(valueStruct.coordListVal));
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by Value");
            }
        }
        return val;
    }

    public static long intToULong(int intVal) {
        return intVal & 0xFFFF;
    }

    public static int uLongToInt(long longVal) {
        return (int)(longVal & 0xFFFFFFFFFFFFFFFFL);
    }

    public static PropInfo[] getPropList(ArPropList pPropList) throws ARException {
        if (pPropList == null) {
            return null;
        }
        PropInfo[] retProps = new PropInfo[pPropList.value.length];
        for (int i = 0; i < pPropList.value.length; ++i) {
            Value val = ValueObjectFactory.getValueObject(pPropList.value[i].value);
            retProps[i] = new PropInfo(pPropList.value[i].prop, val);
        }
        return retProps;
    }

    public static ArPropList setPropList(PropInfo[] pProps) throws ARException {
        if (pProps == null) {
            return null;
        }
        ArrayList<ArPropStruct> propList = new ArrayList<ArPropStruct>();
        for (int i = 0; i < pProps.length; ++i) {
            if (pProps[i] == null) continue;
            ArValueStruct val = ValueObjectFactory.setValueObject(pProps[i].getPropertyValue(), null);
            propList.add(new ArPropStruct(pProps[i].getPropertyTag(), val));
        }
        return new ArPropList(propList.toArray(new ArPropStruct[propList.size()]));
    }
}

