/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.legacy.CARDBCPlugin;
import com.bmc.arsys.pluginsvr.legacy.CAREAPlugin;
import com.bmc.arsys.pluginsvr.legacy.CARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.AREAPluggable;
import com.bmc.arsys.pluginsvr.plugins.AREAPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.PluginClassLoader;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.TrustedAREAPluggable;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginLoaderRouter {
    private static int mPluginCount = 0;
    private static ClassLoader rootCl = Thread.currentThread().getContextClassLoader();
    private static Logger LOGGER = Logger.getLogger(ARPluginLoaderRouter.class);
    private static HashMap<Long, ARPluginLoaderRouter> MAP_THREAD_PLUGINS = new HashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGINSET_CLASS_LOADERS = new HashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGIN_CLASS_LOADERS = new HashMap();
    private static HashMap<String, Class> MAP_PLUGIN_CLASSES = new HashMap();
    public final ARDBCPluginRepository ARDBC = new ARDBCPluginRepository();
    public final AREAPluginRepository AREA = new AREAPluginRepository();
    public final ARFilterAPIPluginRepository FILTERAPI = new ARFilterAPIPluginRepository();

    public static synchronized void addPluginRouter(ARPluginLoaderRouter router) {
        MAP_THREAD_PLUGINS.put(Thread.currentThread().getId(), router);
    }

    public static synchronized ARPluginLoaderRouter getPluginRouter() {
        return MAP_THREAD_PLUGINS.get(Thread.currentThread().getId());
    }

    public static synchronized void removePluginRouter() {
        ARPluginLoaderRouter router = MAP_THREAD_PLUGINS.remove(Thread.currentThread().getId());
        router.cleanUpPlugins();
    }

    private static synchronized URLClassLoader getPluginSetClassLoader(String name) {
        return MAP_PLUGINSET_CLASS_LOADERS.get(name);
    }

    private static synchronized void addPluginSetClassLoader(String name, URLClassLoader loader) {
        MAP_PLUGINSET_CLASS_LOADERS.put(name, loader);
    }

    private static synchronized URLClassLoader getPluginClassLoader(String name) {
        return MAP_PLUGIN_CLASS_LOADERS.get(name);
    }

    private static synchronized void addPluginClassLoader(String name, URLClassLoader loader) {
        MAP_PLUGIN_CLASS_LOADERS.put(name, loader);
    }

    private static synchronized void addPluginClass(String name, Class clz) {
        MAP_PLUGIN_CLASSES.put(name, clz);
    }

    private static synchronized Class getPluginClass(String name) {
        return MAP_PLUGIN_CLASSES.get(name);
    }

    public static void initializeJavaPlugins() {
        LOGGER.info((Object)"Loading all Java Plugins and Plugin sets");
        String[] args = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> topLevelPlugins = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        ARPluginLoaderRouter.loadAllPlugins(null, topLevelPlugins, args);
        HashMap<String, PluginGroup> pluginsets = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        ARPluginLoaderRouter.loadPluginGroups(pluginsets, args);
    }

    public static void terminateAllPlugins() {
        if (!ARPluginServerConfiguration.getInstance().getNativePlugins().isEmpty()) {
            try {
                PluginProxy.getInstance().terminateNativePlugins();
            }
            catch (Exception e) {
                LOGGER.error((Object)CatalogReader.getInstance().getMessage(8794), (Throwable)e);
            }
        }
        if (!MAP_THREAD_PLUGINS.isEmpty()) {
            Set<Map.Entry<Long, ARPluginLoaderRouter>> entries = MAP_THREAD_PLUGINS.entrySet();
            for (ARPluginLoaderRouter aRPluginLoaderRouter : entries) {
                try {
                    aRPluginLoaderRouter.cleanUpPlugins();
                }
                catch (Exception e) {
                    LOGGER.error((Object)CatalogReader.getInstance().getMessage(8794), (Throwable)e);
                }
            }
        }
    }

    private static void logURLs(URL[] urls) {
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                LOGGER.info((Object)("URL" + (i + 1) + ": " + urls[i].toString()));
            }
        }
    }

    private static void loadPluginGroups(HashMap<String, PluginGroup> pluginsets, String[] args) {
        Set<String> keys = pluginsets.keySet();
        for (String groupName : keys) {
            URLClassLoader ucl;
            PluginGroup group;
            block4: {
                LOGGER.info((Object)("Loading Java PluginSet " + groupName));
                group = pluginsets.get(groupName);
                ucl = null;
                ucl = ARPluginLoaderRouter.getPluginSetClassLoader(groupName);
                try {
                    if (ucl != null) break block4;
                    URL[] urls = ARPluginLoaderRouter.getJarURLs(group, true);
                    LOGGER.info((Object)("Number of shared URLs for group " + groupName + " is " + urls.length));
                    ARPluginLoaderRouter.logURLs(urls);
                    ClassLoader parentLoader = null;
                    parentLoader = group.getParent().equals(ARPluginServerConfiguration.DEFAULT_SET_NAME) ? Thread.currentThread().getContextClassLoader() : ARPluginLoaderRouter.getPluginSetClassLoader(group.getParent());
                    ucl = new PluginClassLoader(urls, parentLoader, group.getFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                    ARPluginLoaderRouter.addPluginSetClassLoader(groupName, ucl);
                }
                catch (MalformedURLException mue) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + groupName), (Throwable)mue);
                    continue;
                }
                catch (IOException mue) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + groupName), (Throwable)mue);
                    continue;
                }
            }
            LOGGER.info((Object)("Loading all Java Plugins for the group " + groupName));
            ARPluginLoaderRouter.loadAllPlugins(ucl, group.getPlugins(), args);
            ARPluginLoaderRouter.loadPluginGroups(group.getGroups(), args);
        }
    }

    private static void loadAllPlugins(URLClassLoader ucl, ArrayList<ARPluginDefinition> pPluginList, String[] pArgs) {
        for (ARPluginDefinition plugDef : pPluginList) {
            URLClassLoader pluginucl;
            block4: {
                ClassLoader parent = null;
                parent = ucl == null ? Thread.currentThread().getContextClassLoader() : ucl;
                LOGGER.info((Object)("Attempting to load Java Plugin " + plugDef.getPluginName()));
                pluginucl = ARPluginLoaderRouter.getPluginClassLoader(plugDef.getPluginName());
                try {
                    if (pluginucl != null) break block4;
                    URL[] urls = ARPluginLoaderRouter.getJarURLs(plugDef, true);
                    LOGGER.info((Object)("Number of URLs for plugin " + plugDef.getPluginName() + " is " + urls.length));
                    ARPluginLoaderRouter.logURLs(urls);
                    pluginucl = new PluginClassLoader(urls, parent, plugDef.getClassPathFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                    ARPluginLoaderRouter.addPluginClassLoader(plugDef.getPluginName(), pluginucl);
                }
                catch (MalformedURLException mue) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + plugDef.getPluginName()), (Throwable)mue);
                    plugDef.setActive(false);
                    continue;
                }
                catch (IOException mue) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + plugDef.getPluginName()), (Throwable)mue);
                    plugDef.setActive(false);
                    continue;
                }
            }
            ARPluginLoaderRouter.loadClass(pluginucl, plugDef, plugDef.getFileName(), plugDef.getClassName(), pArgs);
            LOGGER.info((Object)("Succesfully loaded Java Plugin " + plugDef.getPluginName()));
        }
    }

    static void loadClass(URLClassLoader ucl, ARPluginDefinition plugDef, String pJarPath, String pClassName, String[] args) {
        String pName = plugDef.getPluginName();
        try {
            Class cl = ARPluginLoaderRouter.loadJars(ucl, pName, pJarPath, pClassName);
            ARPluginLoaderRouter.addPluginClass(pName, cl);
        }
        catch (ARException are) {
            plugDef.setActive(false);
        }
        catch (Throwable e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + plugDef.getPluginName()), e);
            plugDef.setActive(false);
        }
    }

    private static Class loadJars(URLClassLoader ucl, String name, String pJarPath, String pClassName) throws ARException {
        Class<?> pcl = null;
        try {
            pcl = Class.forName(pClassName, true, ucl);
            try {
                Method init;
                if (pcl != null && (init = pcl.getMethod("init", ARPluginContext.class)) != null) {
                    ARPluginContext context = new ARPluginContext();
                    context.setPluginInfo(new ARPluginInfo(name, 2, true));
                    init.invoke(null, context);
                }
            }
            catch (NoSuchMethodException ne) {
                LOGGER.info((Object)("No static init routine found, skipping init call - " + name));
            }
            catch (SecurityException se) {
                LOGGER.warn((Object)("Exception while finding static init method - " + name), (Throwable)se);
            }
            catch (InvocationTargetException ie) {
                LOGGER.warn((Object)("Invocation exception for static init method - " + name), (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                LOGGER.warn((Object)("Illegal Access exception for static init method - " + name), (Throwable)iae);
            }
            catch (IllegalArgumentException ile) {
                LOGGER.warn((Object)("Illegal argument exception for static init method - " + name), (Throwable)ile);
            }
            catch (Throwable e) {
                LOGGER.warn((Object)("Exception in static init method - " + name), e);
            }
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + name), (Throwable)cnfe);
            throw new ARException(2, 8756, cnfe.getLocalizedMessage());
        }
        catch (ClassCastException cce) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + name), (Throwable)cce);
            throw new ARException(2, 8756, cce.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + name), (Throwable)e);
            throw new ARException(2, 8756, e.getLocalizedMessage());
        }
        return pcl;
    }

    private static URL[] getJarURLs(ARPluginDefinition plugindef, boolean create) throws IOException {
        Attributes ma;
        String cp;
        Manifest mf;
        ArrayList<String> jars;
        File pluginJarFile = new File(plugindef.getFileName());
        JarFile jf = new JarFile(pluginJarFile);
        String workdir = ARPluginServerConfiguration.getInstance().getWorkingDirectory();
        File workFolder = new File(workdir);
        if (!workFolder.exists()) {
            workFolder.mkdirs();
        }
        File pluginFolder = new File(workFolder, "plugin_" + Thread.currentThread().getId() + "_" + mPluginCount++);
        ArrayList<URL> cps = new ArrayList<URL>();
        cps.add(pluginJarFile.toURI().toURL());
        ArrayList<String> folders = plugindef.getClassPathFolders();
        if (folders != null) {
            for (int i = 0; i < folders.size(); ++i) {
                File cpFolder = new File(folders.get(i));
                if (!cpFolder.exists()) continue;
                cps.add(cpFolder.toURI().toURL());
            }
        }
        if ((jars = plugindef.getClassPathJars()) != null) {
            for (int i = 0; i < jars.size(); ++i) {
                File cpJar = new File(jars.get(i));
                if (!cpJar.exists()) continue;
                cps.add(cpJar.toURI().toURL());
            }
        }
        if ((mf = jf.getManifest()) != null && (cp = (ma = mf.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String fname = st.nextToken();
                URL u = ARPluginLoaderRouter.getDependentJarURL(jf, pluginFolder, fname, create);
                if (u == null) continue;
                cps.add(u);
            }
        }
        return cps.toArray(new URL[0]);
    }

    private static URL[] getJarURLs(PluginGroup group, boolean create) throws IOException {
        ArrayList<URL> cps = new ArrayList<URL>();
        if (group != null) {
            ArrayList<String> jars;
            ArrayList<String> folders = group.getClassPathFolders();
            if (folders != null) {
                for (int j = 0; j < folders.size(); ++j) {
                    File cpFolder = new File(folders.get(j));
                    if (!cpFolder.exists()) continue;
                    cps.add(cpFolder.toURI().toURL());
                }
            }
            if ((jars = group.getClassPathJars()) != null) {
                for (int j = 0; j < jars.size(); ++j) {
                    File cpJar = new File(jars.get(j));
                    if (!cpJar.exists()) continue;
                    cps.add(cpJar.toURI().toURL());
                }
            }
        }
        return cps.toArray(new URL[0]);
    }

    private static URL[] getJarURLs(ArrayList<ARPluginDefinition> plugins, boolean create) throws IOException {
        ArrayList<URL> cps = new ArrayList<URL>();
        if (plugins != null) {
            for (int i = 0; i < plugins.size(); ++i) {
                Attributes ma;
                String cp;
                Manifest mf;
                ArrayList<String> jars;
                ARPluginDefinition plugin = plugins.get(i);
                if (plugin == null) continue;
                File pluginJarFile = new File(plugin.getFileName());
                JarFile jf = new JarFile(pluginJarFile);
                String workdir = ARPluginServerConfiguration.getInstance().getWorkingDirectory();
                File workFolder = new File(workdir);
                if (!workFolder.exists()) {
                    workFolder.mkdirs();
                }
                File pluginFolder = new File(workFolder, "plugin_" + Thread.currentThread().getId() + "_" + mPluginCount++);
                cps.add(pluginJarFile.toURI().toURL());
                ArrayList<String> folders = plugin.getClassPathFolders();
                if (folders != null) {
                    for (int j = 0; j < folders.size(); ++j) {
                        File cpFolder = new File(folders.get(j));
                        if (!cpFolder.exists()) continue;
                        cps.add(cpFolder.toURI().toURL());
                    }
                }
                if ((jars = plugin.getClassPathJars()) != null) {
                    for (int j = 0; j < jars.size(); ++j) {
                        File cpJar = new File(jars.get(j));
                        if (!cpJar.exists()) continue;
                        cps.add(cpJar.toURI().toURL());
                    }
                }
                if ((mf = jf.getManifest()) == null || (cp = (ma = mf.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                StringTokenizer st = new StringTokenizer(cp, " ");
                while (st.hasMoreTokens()) {
                    String fname = st.nextToken();
                    URL u = ARPluginLoaderRouter.getDependentJarURL(jf, pluginFolder, fname, create);
                    if (u == null) continue;
                    cps.add(u);
                }
            }
        }
        return cps.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getDependentJarURL(JarFile jf, File parent, String fname, boolean create) throws IOException {
        ZipEntry depEntry = jf.getEntry(fname);
        if (depEntry != null) {
            File depJar = new File(parent, fname);
            if (create || !depJar.exists()) {
                depJar.getParentFile().mkdirs();
                InputStream is = jf.getInputStream(depEntry);
                try {
                    ARPluginLoaderRouter.copyStreamDataToFile(is, depJar);
                }
                finally {
                    is.close();
                }
            }
            return depJar.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamDataToFile(InputStream is, File output) throws IOException {
        FileOutputStream fos = new FileOutputStream(output);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            int len;
            byte[] buff = new byte[8192];
            while ((len = is.read(buff)) != -1) {
                bos.write(buff, 0, len);
            }
        }
        finally {
            bos.close();
        }
    }

    public ARPluginLoaderRouter() {
        String[] args = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> topLevelPlugins = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        this.instantiateAllPlugins(null, topLevelPlugins, args);
        HashMap<String, PluginGroup> pluginsets = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        this.instantiatePluginGroups(pluginsets, args);
        ArrayList<ARPluginDefinition> nativePlugins = ARPluginServerConfiguration.getInstance().getNativePlugins();
        this.loadNativePluginWrappers(nativePlugins);
    }

    public void initializeInstanceData(ARPluginContext context) {
    }

    public void cleanUpPlugins() {
        ARPluginContext context = new ARPluginContext();
        context.setCmdLineArgs(ARPluginServerConfiguration.getInstance().getCmdLineArgs());
        this.AREA.terminatePlugins(context);
        this.FILTERAPI.terminatePlugins(context);
        this.ARDBC.terminatePlugins(context);
    }

    private void loadNativePluginWrappers(ArrayList<ARPluginDefinition> nativePlugins) {
        if (PluginProxy.IsNativeMethodAccessible()) {
            for (int i = 0; i < nativePlugins.size(); ++i) {
                ARPluginDefinition def = nativePlugins.get(i);
                String code = def.getPluginCode();
                String type = def.getPluginType();
                String name = def.getPluginName();
                if (code == null || !code.equalsIgnoreCase("C")) continue;
                try {
                    PluginEnvelope pEnvelope;
                    ARPlugin plugin;
                    if (type.equalsIgnoreCase("FilterAPI")) {
                        plugin = new CARFilterAPIPlugin(name);
                        pEnvelope = new PluginEnvelope(plugin, new ARPluginInfo(name, 2, false));
                        this.FILTERAPI.addPlugin(name, pEnvelope);
                        continue;
                    }
                    if (type.equalsIgnoreCase("ARDBC")) {
                        plugin = new CARDBCPlugin(name);
                        pEnvelope = new PluginEnvelope(plugin, new ARPluginInfo(name, 4, false));
                        this.ARDBC.addPlugin(name, pEnvelope);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("AREA")) continue;
                    plugin = new CAREAPlugin(name);
                    pEnvelope = new PluginEnvelope(plugin, new ARPluginInfo(name, 3, false));
                    this.AREA.addPlugin(name, pEnvelope);
                    continue;
                }
                catch (ARException e) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8767) + " Plugin: " + name), (Throwable)e);
                }
            }
        }
    }

    private void instantiatePluginGroups(HashMap<String, PluginGroup> pluginsets, String[] args) {
        Set<String> keys = pluginsets.keySet();
        for (String groupName : keys) {
            LOGGER.info((Object)("Creating instances of all plugins in the group " + groupName));
            PluginGroup group = pluginsets.get(groupName);
            URLClassLoader ucl = null;
            ucl = ARPluginLoaderRouter.getPluginSetClassLoader(groupName);
            if (ucl == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + groupName));
                continue;
            }
            this.instantiateAllPlugins(ucl, group.getPlugins(), args);
            this.instantiatePluginGroups(group.getGroups(), args);
        }
    }

    private void instantiateAllPlugins(URLClassLoader ucl, ArrayList<ARPluginDefinition> pPluginList, String[] pArgs) {
        for (ARPluginDefinition plugDef : pPluginList) {
            if (!plugDef.isActive()) continue;
            Class cl = null;
            LOGGER.info((Object)("Attempting to Create an instance of the plugin " + plugDef.getPluginName()));
            URLClassLoader pluginucl = ARPluginLoaderRouter.getPluginClassLoader(plugDef.getPluginName());
            if (pluginucl == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + plugDef.getFileName()));
                continue;
            }
            cl = ARPluginLoaderRouter.getPluginClass(plugDef.getPluginName());
            if (cl == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + plugDef.getFileName()));
                continue;
            }
            this.loadPlugin(pluginucl, cl, plugDef, pArgs);
        }
    }

    void loadPlugin(URLClassLoader ucl, Class cl, ARPluginDefinition plugDef, String[] args) {
        String pName = plugDef.getPluginName();
        try {
            ARPluggable pl = this.instantiatePlugin(cl, ucl);
            ARPluginInfo info = new ARPluginInfo(plugDef.getPluginName(), plugDef.getVersion(), !plugDef.getPluginCode().equals("C"));
            PluginEnvelope pluginEnvelope = this.initializePlugin(pName, args, pl, info);
            if (pluginEnvelope == null) {
                return;
            }
            pName = pluginEnvelope.getPluginName();
            if (pl instanceof ARFilterAPIPluggable) {
                this.FILTERAPI.addPlugin(pName, pluginEnvelope);
            } else if (pl instanceof AREAPluggable) {
                TrustedAREAPluggable trustedPlugin;
                int key;
                if (pl instanceof TrustedAREAPluggable && (key = (trustedPlugin = (TrustedAREAPluggable)pl).secretKey()) > 0) {
                    pluginEnvelope.setTrustedAreaPluginFlag(true);
                }
                this.AREA.addPlugin(pName, pluginEnvelope);
            } else if (pl instanceof ARDBCPluggable) {
                this.ARDBC.addPlugin(pName, pluginEnvelope);
            }
        }
        catch (ARException are) {
            plugDef.setActive(false);
        }
        catch (Throwable e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pName), e);
            plugDef.setActive(false);
        }
        LOGGER.info((Object)("Succesfully created instance of plugin " + plugDef.getPluginName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginEnvelope initializePlugin(String pName, String[] args, ARPluggable pPlugin, ARPluginInfo pluginInfo) throws ARException {
        assert (pPlugin != null);
        ARPluginContext dummyContext = new ARPluginContext();
        if (pPlugin == null) {
            return null;
        }
        String id = pluginInfo.getName();
        dummyContext.setCmdLineArgs(args);
        dummyContext.setPluginInfo(pluginInfo);
        if (id != null) {
            PluginEnvelope envelope = this.getPluginFromAnyMap(id);
            Object instance = null;
            if (envelope == null) {
                try {
                    Thread.currentThread().setContextClassLoader(ARPluginLoaderRouter.getPluginClassLoader(id));
                    pPlugin.initialize(dummyContext);
                    PluginEnvelope pluginEnvelope = envelope = new PluginEnvelope(pPlugin, pluginInfo, instance);
                    return pluginEnvelope;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(rootCl);
                }
            }
        }
        return null;
    }

    private PluginEnvelope getPluginFromAnyMap(String pName) {
        PluginEnvelope envelope = null;
        envelope = this.FILTERAPI.getPlugin(pName);
        if (envelope != null) {
            return envelope;
        }
        envelope = this.AREA.getPlugin(pName);
        if (envelope != null) {
            return envelope;
        }
        envelope = this.ARDBC.getPlugin(pName);
        return envelope;
    }

    private ARPluggable instantiatePlugin(Class pcl, URLClassLoader ucl) throws ARException {
        ARPluggable pl = null;
        try {
            pl = (ARPluggable)pcl.newInstance();
            if (pl.getClass().getClassLoader() != ucl) {
                throw new ARException(2, 8756, "The plugin class " + pcl.getName() + " has been loaded by a parent classloader.\n");
            }
        }
        catch (InstantiationException ie) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), (Throwable)ie);
            throw new ARException(2, 8756, ie.getLocalizedMessage());
        }
        catch (ClassCastException cce) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), (Throwable)cce);
            throw new ARException(2, 8756, cce.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), (Throwable)iae);
            throw new ARException(2, 8756, iae.getLocalizedMessage());
        }
        catch (Throwable e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), e);
            throw new ARException(2, 8756, e.getLocalizedMessage());
        }
        return pl;
    }
}

