/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arrpc.ArEsFilterApi4In;
import com.bmc.arsys.arrpc.ArEsFilterApi4Out;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArValueList;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARFilterAPIPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(ARFilterAPIPluginRepository.class);
    protected HashMap<String, PluginEnvelope> mPlugins = new HashMap();

    ARFilterAPIPluginRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArEsFilterApi4Out ARFilterApiCall(ArEsFilterApi4In arg1) {
        ArEsFilterApi4Out argOut = new ArEsFilterApi4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getServiceName().value);
        ARFilterAPIPluggable plugin = null;
        ARPluginInfo info = null;
        PluginEnvelope envelope = this.mPlugins.get(pluginName);
        if (envelope != null) {
            plugin = (ARFilterAPIPluggable)envelope.mPlugin;
            info = envelope.mPluginInfo;
        }
        if (plugin == null) {
            ARException e = new ARException();
            LOGGER.error((Object)("ARFilterApiCall FAIL " + pluginName), (Throwable)e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8755, CatalogReader.getInstance().getMessage(8755), pluginName);
            argOut.setStatus(status);
            return argOut;
        }
        ArValueStruct[] inValuesRaw = arg1.getInValues().value;
        ArrayList<Value> inValuesCooked = new ArrayList<Value>();
        try {
            this.validateClient(arg1.getControl().getPassword());
            for (int i = 0; i < inValuesRaw.length; ++i) {
                inValuesCooked.add(i, ValueObjectFactory.getValueObject(inValuesRaw[i]));
            }
            List<Value> outValuesCooked = plugin.filterAPICall(ApiToRpcMapping.getInstance().getContextFromControl(arg1.getControl(), info), inValuesCooked);
            ArValueList outValuesList = null;
            if (outValuesCooked != null) {
                ArValueStruct[] outValuesRaw = new ArValueStruct[outValuesCooked.size()];
                for (int i = 0; i < outValuesRaw.length; ++i) {
                    outValuesRaw[i] = ValueObjectFactory.setValueObject(outValuesCooked.get(i), null);
                }
                outValuesList = new ArValueList(outValuesRaw);
            } else {
                outValuesList = new ArValueList();
            }
            argOut = new ArEsFilterApi4Out(arg1.getControl(), outValuesList, new ArStatusList6());
        }
        catch (ARException e) {
            LOGGER.error((Object)("ARFilterApiCall FAIL " + pluginName), (Throwable)e);
            argOut.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("ARFilterApiCall FAIL " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            argOut.setStatus(status);
        }
        return argOut;
    }

    @Override
    void addPlugin(String pName, PluginEnvelope pEnvelope) throws ARException {
        assert (pName != null && pEnvelope != null && pEnvelope.mPlugin != null);
        this.mPlugins.put(pName, pEnvelope);
    }

    @Override
    PluginEnvelope getPlugin(String pName) {
        return this.mPlugins.get(pName);
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext context, int eventId) {
        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.onEvent(context, eventId);
            }
            catch (ARException e) {
                status.addAll(e.getLastStatus());
            }
        }
        return status;
    }

    @Override
    void terminatePlugins(ARPluginContext context) {
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.terminate(context);
            }
            catch (ARException e) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + env.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)e);
            }
        }
    }
}

