/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4In;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4In;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4In;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4Out;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4In;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGet4In;
import com.bmc.arsys.arrpc.ArEsArdbcGet4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4In;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4Out;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4In;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4Out;
import com.bmc.arsys.arrpc.ArEsArdbcSet4In;
import com.bmc.arsys.arrpc.ArEsArdbcSet4Out;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlewfOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlwefIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetOut;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARDBCPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(ARDBCPluginRepository.class);
    private HashMap<String, PluginEnvelope> mPlugins = new HashMap();

    protected ARDBCPluginRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addPlugin(String pName, PluginEnvelope pEnvelope) throws ARException {
        assert (pName != null && pEnvelope != null && pEnvelope.mPlugin != null);
        this.mPlugins.put(pName, pEnvelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARDBCPluggable getARDBCPlugin(String pName) throws ARException {
        ARDBCPluggable plugin = null;
        PluginEnvelope envelope = this.mPlugins.get(pName);
        if (envelope != null) {
            plugin = (ARDBCPluggable)envelope.mPlugin;
        }
        if (plugin == null) {
            LOGGER.error((Object)CatalogReader.getInstance().getMessage(8755));
            throw new ARException(2, 8755, pName);
        }
        return plugin;
    }

    @Override
    PluginEnvelope getPlugin(String pName) {
        return this.mPlugins.get(pName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARPluginInfo getARPluginInfo(String pName) throws ARException {
        ARPluginInfo data = null;
        PluginEnvelope envelope = this.mPlugins.get(pName);
        if (envelope != null) {
            data = envelope.mPluginInfo;
        }
        return data;
    }

    public ArEsArdbcCreate4Out ArdbcCreate(ArEsArdbcCreate4In arg1) {
        ArEsArdbcCreate4Out out = new ArEsArdbcCreate4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcCreateIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            String key = plugin.createEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntry());
            ArdbcCreateOut tempOut = new ArdbcCreateOut(key, arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("createEntry() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"createEntry() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGet4Out ArdbcGet(ArEsArdbcGet4In arg1) {
        ArEsArdbcGet4Out out = new ArEsArdbcGet4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcGetIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            Entry entry = plugin.getEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId(), in.getIdList());
            ArdbcGetOut tempOut = new ArdbcGetOut(entry, arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getEntry() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"getEntry() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcSet4Out ArdbcSet(ArEsArdbcSet4In arg1) {
        ArEsArdbcSet4Out out = new ArEsArdbcSet4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcSetIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.setEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId(), in.getEntry(), in.getTimestamp());
            ArdbcSetOut tempOut = new ArdbcSetOut(arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("setEntry() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"setEntry() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcDelete4Out ArdbcDelete(ArEsArdbcDelete4In arg1) {
        ArEsArdbcDelete4Out out = new ArEsArdbcDelete4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcDeleteIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.deleteEntry(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId());
            ArdbcDeleteOut tempOut = new ArdbcDeleteOut(arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("deleteEntry() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"deleteEntry() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetBlob4Out ArdbcGetBlob(ArEsArdbcGetBlob4In arg1) {
        ArEsArdbcGetBlob4Out out = new ArEsArdbcGetBlob4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcGetBlobIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            AttachmentValue info = plugin.getBLOB(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getEntryId(), in.getFieldId());
            ArdbcGetBlobOut tempOut = new ArdbcGetBlobOut(info, arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getBlob() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"getBlob() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGlewf4Out ArdbcGlewf(ArEsArdbcGlewf4In arg1) {
        ArEsArdbcGlewf4Out out = new ArEsArdbcGlewf4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ARPluginInfo info = this.getARPluginInfo(pluginName);
            ArdbcGlwefIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, info, info.isJavaPlugin());
            List<Entry> entries = plugin.getListEntryWithFields(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getQualifier(), in.getSortList(), in.getGetListFields(), in.getStartAt(), in.getMaxRetrieve(), in.getNumMatches());
            ArdbcGlewfOut tempOut = new ArdbcGlewfOut(arg1.getControl(), entries, in.getNumMatches(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getListEntryWithFields() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"getListEntryWithFields() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcCommit4Out ArdbcCommit(ArEsArdbcCommit4In arg1) {
        ArEsArdbcCommit4Out out = new ArEsArdbcCommit4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcCommitIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.commit(in.getContext(), in.getTransId());
            ArdbcCommitOut tempOut = new ArdbcCommitOut(arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("commit() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"commit() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcRollback4Out ArdbcRollback(ArEsArdbcRollback4In arg1) {
        ArEsArdbcRollback4Out out = new ArEsArdbcRollback4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcRollbackIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.rollback(in.getContext(), in.getTransId());
            ArdbcRollbackOut tempOut = new ArdbcRollbackOut(arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("rollback() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"rollback() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcCancelQuery4Out ArdbcCancelQuery(ArEsArdbcCancelQuery4In arg1) {
        ArEsArdbcCancelQuery4Out out = new ArEsArdbcCancelQuery4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcCancelIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            plugin.cancel(in.getContext(), in.getTransId());
            ArdbcCancelOut tempOut = new ArdbcCancelOut(arg1.getControl(), null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("cancelQuery() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"cancelQuery() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetListForms4Out ArdbcGetListForms(ArEsArdbcGetListForms4In arg1) {
        ArStatusList6 status;
        ArEsArdbcGetListForms4Out out = new ArEsArdbcGetListForms4Out();
        ArrayList<VendorForm> allforms = new ArrayList<VendorForm>();
        ArrayList<StatusInfo> allstatus = new ArrayList<StatusInfo>();
        Set<String> keys = this.mPlugins.keySet();
        for (String pluginName : keys) {
            try {
                this.validateClient(arg1.getControl().getPassword());
                ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
                ArdbcGetListFormsIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
                List<VendorForm> forms = plugin.getListForms(in.getContext());
                allforms.addAll(forms);
                LOGGER.info("Got " + forms != null ? Integer.valueOf(forms.size()) : "0from plugin " + pluginName);
                LOGGER.info((Object)forms.toString());
            }
            catch (ARException e) {
                LOGGER.error((Object)("getListForms() FAIL: " + pluginName), (Throwable)e);
                allstatus.addAll(e.getLastStatus());
            }
            catch (Throwable e) {
                LOGGER.error((Object)("getListForms() FAIL: " + pluginName), e);
                status = new StatusInfo(2, 8790L, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
                allstatus.add((StatusInfo)status);
            }
        }
        ArdbcGetListFormsOut tempOut = new ArdbcGetListFormsOut(arg1.getControl(), allforms, allstatus);
        try {
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)"Error occured during the getListForms() plugin call.", (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"getListForms() FAIL: ", e);
            status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetMultipleFields4Out ArdbcGetMultipleFields(ArEsArdbcGetMultipleFields4In arg1) {
        ArEsArdbcGetMultipleFields4Out out = new ArEsArdbcGetMultipleFields4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ArdbcGetMultipleFieldsIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, this.getARPluginInfo(pluginName));
            List<ARVendorField> fields = plugin.getMultipleFields(in.getContext(), in.getSchema());
            ArdbcGetMultipleFieldsOut tempOut = new ArdbcGetMultipleFieldsOut(arg1.getControl(), fields, null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getMultupleFields() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"getMultipleFields() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    public ArEsArdbcGetEntryStatistics4Out ArdbcGetEntryStatistics(ArEsArdbcGetEntryStatistics4In arg1) {
        ArEsArdbcGetEntryStatistics4Out out = new ArEsArdbcGetEntryStatistics4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getVendorName().value);
        try {
            this.validateClient(arg1.getControl().getPassword());
            ARDBCPluggable plugin = this.getARDBCPlugin(pluginName);
            ARPluginInfo info = this.getARPluginInfo(pluginName);
            ArdbcGetEntryStatisticsIn in = ApiToRpcMapping.getInstance().fromRPC(arg1, info, info.isJavaPlugin());
            List<StatisticsResultInfo> stats = plugin.getEntryStatistics(in.getContext(), in.getTableName(), in.getFieldsList(), in.getTransId(), in.getQualifier(), in.getTarget(), in.getStatistic(), in.getGroupByList());
            ArdbcGetEntryStatisticsOut tempOut = new ArdbcGetEntryStatisticsOut(arg1.getControl(), stats, null);
            out = ApiToRpcMapping.getInstance().toRPC(tempOut);
        }
        catch (ARException e) {
            LOGGER.error((Object)("getEntryStatistics() FAIL: " + pluginName), (Throwable)e);
            out.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)"getEntryStatistics() FAIL: ", e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), e.getLocalizedMessage());
            out.setStatus(status);
        }
        return out;
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext context, int eventId) {
        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.onEvent(context, eventId);
            }
            catch (ARException e) {
                status.addAll(e.getLastStatus());
            }
        }
        return status;
    }

    @Override
    void terminatePlugins(ARPluginContext context) {
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.terminate(context);
            }
            catch (ARException e) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + env.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)e);
            }
        }
    }
}

