/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpEncodingStream;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;
import org.acplt.oncrpc.server.OncRpcTcpServerTransport;
import org.apache.log4j.Logger;

public class ARTcpConnectionServerTransport
extends OncRpcTcpConnectionServerTransport {
    private static Logger log = Logger.getLogger(ARTcpConnectionServerTransport.class);
    private boolean mbEncryptedCall = false;
    private int mCurrentSessionId = 0;

    public ARTcpConnectionServerTransport(OncRpcDispatchable dispatcher, Socket socket, int program, int version, int bufferSize, OncRpcTcpServerTransport parent, int transmissionTimeout) throws OncRpcException, IOException {
        super(dispatcher, socket, program, version, bufferSize, parent, transmissionTimeout);
        this.changeToArXdrStream();
    }

    public ARTcpConnectionServerTransport(OncRpcDispatchable dispatcher, Socket socket, OncRpcServerTransportRegistrationInfo[] info, int bufferSize, OncRpcTcpServerTransport parent, int transmissionTimeout) throws OncRpcException, IOException {
        super(dispatcher, socket, info, bufferSize, parent, transmissionTimeout);
        this.changeToArXdrStream();
    }

    public void changeToArXdrStream() throws IOException, OncRpcException {
        int senderLen = ((XdrTcpEncodingStream)super.getXdrEncodingStream()).getBuffer().length;
        int receiverLen = ((XdrTcpDecodingStream)super.getXdrDecodingStream()).getBuffer().length;
        super.getXdrEncodingStream().close();
        super.getXdrDecodingStream().close();
        super.setXdrTcpEncodingStream((XdrTcpEncodingStream)new ARPluginSvrXdrTcpEncodingStream(this, super.getSocket(), senderLen));
        super.setXdrTcpDecodingStream((XdrTcpDecodingStream)new ARPluginSvrXdrTcpDecodingStream(this, super.getSocket(), receiverLen));
    }

    protected void dispatchCall(OncRpcCallInformation callInfo) throws IOException, OncRpcException {
        log.info((Object)"dispatchCall");
        if ((callInfo.callMessage.procedure & 0x8000) != 0) {
            callInfo.callMessage.procedure &= 0xFFFF7FFF;
            log.info((Object)"RPC call is encrypted");
            this.mbEncryptedCall = true;
        } else {
            log.info((Object)"RPC call is not encrypted");
            this.mbEncryptedCall = false;
        }
        log.info((Object)("Procedure No. " + callInfo.callMessage.procedure));
        ((ArXdrTcpEncodingStream)super.getXdrEncodingStream()).setArRrocessOn(this.mbEncryptedCall);
        ((ArXdrTcpDecodingStream)super.getXdrDecodingStream()).setArRrocessOn(this.mbEncryptedCall);
        int authStatus = this.isEncryptionPolicyValid(this.mbEncryptedCall, callInfo.callMessage.procedure);
        if (authStatus != 0) {
            log.error((Object)"Invalid call for the given encryption policy");
            this.mbEncryptedCall = false;
            callInfo.reply(new OncRpcServerReplyMessage(callInfo.callMessage, 1, 0, 1, 0, 0, authStatus), null);
            return;
        }
        super.dispatchCall(callInfo);
    }

    protected boolean isCurrentCallEncrypted() {
        return this.mbEncryptedCall;
    }

    protected void setCurrentCallEncryption(boolean enc) {
        this.mbEncryptedCall = enc;
    }

    protected int getCurrentSessionId() throws ARException {
        if (this.mCurrentSessionId == 0) {
            log.error((Object)"Failed to fetch sessionId for the current call");
            throw new ARException(2, 8784);
        }
        return this.mCurrentSessionId;
    }

    public void setCurrentSessionId(int id) {
        this.mCurrentSessionId = id;
    }

    private int isEncryptionPolicyValid(boolean encryptedCall, int proc_num) {
        int authStatus = 0;
        if (proc_num != 16) {
            try {
                ARPluginServerEncryptionInfo encryptInfo = ARPluginServerEncryptionInfo.getInstance();
                switch (encryptInfo.getEncryptionSecurityPolicy()) {
                    case 2: {
                        if (!encryptedCall && proc_num != 17 && proc_num != 18) break;
                        authStatus = 1;
                        break;
                    }
                    case 1: {
                        if (encryptedCall || proc_num == 17 || proc_num == 18) break;
                        authStatus = 5;
                    }
                }
            }
            catch (ARException e) {
                // empty catch block
            }
        }
        return authStatus;
    }

    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        super.beginEncoding(callInfo, state);
        ArXdrTcpEncodingStream sendingXdr = (ArXdrTcpEncodingStream)this.getXdrEncodingStream();
        if (sendingXdr instanceof ArXdrTcpEncodingStream) {
            int orgBufferBeginIndex = sendingXdr.getBufferIndex();
            sendingXdr.setOrgBufferBeginIndex(orgBufferBeginIndex);
        }
    }

    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        if (this.getXdrDecodingStream() instanceof ARPluginSvrXdrTcpDecodingStream) {
            ARPluginSvrXdrTcpDecodingStream receivingXdr = (ARPluginSvrXdrTcpDecodingStream)this.getXdrDecodingStream();
            receivingXdr.resetArFlags();
            receivingXdr.arExcBeforeUnXdrDecodeParams(call);
            if (!receivingXdr.isXdrDecodeDone()) {
                super.retrieveCall(call);
            }
        } else {
            super.retrieveCall(call);
        }
    }

    protected void initializeThreadData() {
        try {
            ARPluginLoaderRouter.addPluginRouter(new ARPluginLoaderRouter());
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)e);
        }
        try {
            PluginProxy.getInstance().createInstancesForThread();
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)e);
        }
    }

    protected void cleanUp() {
        try {
            ARPluginLoaderRouter.removePluginRouter();
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)e);
        }
        try {
            PluginProxy.getInstance().deleteInstancesForThread();
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)e);
        }
    }
}

