/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARTcpConnectionServerTransport;
import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpEncodingStream
extends ArXdrTcpEncodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpEncodingStream.class);
    private ARTcpConnectionServerTransport mConnection;
    private ARPluginServerEncryptionInfo mEncryptionInfo;

    public ARPluginSvrXdrTcpEncodingStream(ARTcpConnectionServerTransport conn, Socket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.mConnection = conn;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException e) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncAfterXdrEncoding(byte[] bufToencode) throws OncRpcException, IOException {
        byte[] encryptedXdrData = null;
        if (this.isDataEncrypted()) {
            this.setArRrocessOn(true);
            try {
                int sessionId = this.mConnection.getCurrentSessionId();
                XdrAble arXdrEnc = this.mEncryptionInfo.encryptAndXdrData(sessionId, bufToencode);
                this.arEncodeEncryptedData(arXdrEnc, this);
            }
            catch (ARException e) {
                log.error((Object)"Encryption of output failed", (Throwable)e);
                throw new OncRpcException("Rpc encryption error");
            }
        } else {
            this.setArRrocessOn(false);
            encryptedXdrData = bufToencode;
        }
        return encryptedXdrData;
    }

    protected boolean isDataEncrypted() {
        boolean isEncryted = false;
        if (this.mConnection != null && this.mConnection.isCurrentCallEncrypted()) {
            isEncryted = true;
        }
        return isEncryted;
    }
}

