/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARTcpConnectionServerTransport;
import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpDecodingStream
extends ArXdrTcpDecodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpDecodingStream.class);
    private ARTcpConnectionServerTransport mConnection;
    private ARPluginServerEncryptionInfo mEncryptionInfo;

    public ARPluginSvrXdrTcpDecodingStream(ARTcpConnectionServerTransport conn, Socket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.mConnection = conn;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException e) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncBeforeUnXdrDecoding(byte[] bufToDecode) throws OncRpcException, IOException {
        byte[] rst = null;
        if (this.isArRrocessOn()) {
            try {
                rst = this.mEncryptionInfo.unXdrAndDecryptData(bufToDecode, this.mConnection);
            }
            catch (ARException e) {
                super.endDecoding();
                log.error((Object)"Decrypting of the input arguments failed", (Throwable)e);
                throw new OncRpcException("Rpc decryption error");
            }
            catch (OncRpcException e) {
                log.error((Object)"Decoding of the input arguments failed", (Throwable)e);
                this.mConnection.setCurrentCallEncryption(false);
                throw e;
            }
        } else {
            rst = bufToDecode;
        }
        return rst;
    }

    protected void resetArFlags() {
        this.setXdrDecodeDone(false);
        this.setDataNotInXdrBuffer(false);
    }

    protected boolean isXdrDecodeDone() {
        return super.isXdrDecodeDone();
    }
}

