/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.mapping;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DateOnlyFieldLimit;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DisplayFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.ViewFieldLimit;
import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arrpc.ArAndOrStruct8;
import com.bmc.arsys.arrpc.ArArithOpStruct8;
import com.bmc.arsys.arrpc.ArAttachLimitsStruct12;
import com.bmc.arsys.arrpc.ArBoolean;
import com.bmc.arsys.arrpc.ArByteList;
import com.bmc.arsys.arrpc.ArCharLimitsStruct8;
import com.bmc.arsys.arrpc.ArColumnLimitsStruct8;
import com.bmc.arsys.arrpc.ArCompoundSchema12;
import com.bmc.arsys.arrpc.ArCompoundSchemaList12;
import com.bmc.arsys.arrpc.ArCoordList;
import com.bmc.arsys.arrpc.ArCoordStruct;
import com.bmc.arsys.arrpc.ArCurrencyCodeType;
import com.bmc.arsys.arrpc.ArCurrencyDetailList;
import com.bmc.arsys.arrpc.ArCurrencyDetailStruct;
import com.bmc.arsys.arrpc.ArCurrencyLimitsStruct;
import com.bmc.arsys.arrpc.ArCurrencyPartStruct;
import com.bmc.arsys.arrpc.ArCurrencyStruct;
import com.bmc.arsys.arrpc.ArDateLimitsStruct;
import com.bmc.arsys.arrpc.ArDecimalLimitsStruct6;
import com.bmc.arsys.arrpc.ArDiaryLimitsStruct;
import com.bmc.arsys.arrpc.ArDisplayLimits;
import com.bmc.arsys.arrpc.ArEntryIdList;
import com.bmc.arsys.arrpc.ArEntryIdType;
import com.bmc.arsys.arrpc.ArEntryListFieldList;
import com.bmc.arsys.arrpc.ArEntryListFieldValueList6;
import com.bmc.arsys.arrpc.ArEntryListFieldValueStruct6;
import com.bmc.arsys.arrpc.ArEnumItemList;
import com.bmc.arsys.arrpc.ArEnumItemStruct;
import com.bmc.arsys.arrpc.ArEnumLimitsStruct;
import com.bmc.arsys.arrpc.ArEnumQueryStruct;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4In;
import com.bmc.arsys.arrpc.ArEsArdbcCancelQuery4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4In;
import com.bmc.arsys.arrpc.ArEsArdbcCommit4Out;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4In;
import com.bmc.arsys.arrpc.ArEsArdbcCreate4Out;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4In;
import com.bmc.arsys.arrpc.ArEsArdbcDelete4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGet4In;
import com.bmc.arsys.arrpc.ArEsArdbcGet4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetBlob4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetEntryStatistics4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetListForms4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4In;
import com.bmc.arsys.arrpc.ArEsArdbcGetMultipleFields4Out;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4In;
import com.bmc.arsys.arrpc.ArEsArdbcGlewf4Out;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4In;
import com.bmc.arsys.arrpc.ArEsArdbcRollback4Out;
import com.bmc.arsys.arrpc.ArEsArdbcSet4In;
import com.bmc.arsys.arrpc.ArEsArdbcSet4Out;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsVendorFieldList;
import com.bmc.arsys.arrpc.ArEsVendorFieldStruct;
import com.bmc.arsys.arrpc.ArFieldLimitStruct12;
import com.bmc.arsys.arrpc.ArFieldMappingStruct10;
import com.bmc.arsys.arrpc.ArFieldValueList;
import com.bmc.arsys.arrpc.ArFieldValueOrArithStruct8;
import com.bmc.arsys.arrpc.ArFieldValueStruct;
import com.bmc.arsys.arrpc.ArFuncCurrencyList;
import com.bmc.arsys.arrpc.ArFuncCurrencyStruct;
import com.bmc.arsys.arrpc.ArIntegerLimitsStruct;
import com.bmc.arsys.arrpc.ArInternalId;
import com.bmc.arsys.arrpc.ArInternalIdList;
import com.bmc.arsys.arrpc.ArNameList8;
import com.bmc.arsys.arrpc.ArNameType8;
import com.bmc.arsys.arrpc.ArPropStruct;
import com.bmc.arsys.arrpc.ArQualifierStruct8;
import com.bmc.arsys.arrpc.ArQueryValueStruct8;
import com.bmc.arsys.arrpc.ArRealLimitsStruct2;
import com.bmc.arsys.arrpc.ArRelOpStruct8;
import com.bmc.arsys.arrpc.ArServerNameType;
import com.bmc.arsys.arrpc.ArSortList;
import com.bmc.arsys.arrpc.ArStatHistoryValue;
import com.bmc.arsys.arrpc.ArStatisticsResultList;
import com.bmc.arsys.arrpc.ArStatisticsResultStruct;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArTableLimitsStruct10;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.ArValueList;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.arrpc.ArVendorMappingStruct8;
import com.bmc.arsys.arrpc.ArVendorSchema12;
import com.bmc.arsys.arrpc.ArViewLimits;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCancelOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCommitOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcCreateOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcDeleteOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetBlobOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetEntryStatisticsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetListFormsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetMultipleFieldsOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGetOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlewfOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcGlwefIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcRollbackOut;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetIn;
import com.bmc.arsys.pluginsvr.mapping.ArdbcSetOut;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiToRpcMapping {
    private static ApiToRpcMapping theInstance = new ApiToRpcMapping();
    private static Logger LOGGER = Logger.getLogger(ApiToRpcMapping.class);

    public static ApiToRpcMapping getInstance() {
        return theInstance;
    }

    private ApiToRpcMapping() {
    }

    public String getEncodedString(byte[] value) {
        String string = null;
        try {
            string = StringByteUtil.createNullTerminatedString((byte[])value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
        }
        catch (UnsupportedEncodingException e1) {
            LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)e1);
            string = new String(value).trim();
        }
        return string;
    }

    List<ARVendorField> getVendorFields(ArEsVendorFieldList fieldsList) {
        ArrayList<ARVendorField> list = new ArrayList<ARVendorField>();
        ArEsVendorFieldStruct[] fields = fieldsList.value;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                int fieldId = fields[i].getFieldId().value;
                String fieldName = null;
                try {
                    fieldName = StringByteUtil.createNullTerminatedString((byte[])fields[i].getFieldName().value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)e);
                }
                int datatype = fields[i].getDataType();
                ARVendorField field = new ARVendorField(fieldName, fieldId, datatype);
                list.add(field);
            }
        }
        return list;
    }

    String getEntryIdListString(ArEntryIdList idList) {
        StringBuffer entryId = new StringBuffer("");
        if (idList.value != null) {
            for (int i = 0; i < idList.value.length; ++i) {
                try {
                    entryId.append(StringByteUtil.createNullTerminatedString((byte[])idList.value[i].value, (String)ARPluginServerConfiguration.getInstance().getServerCharset()));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)e);
                }
            }
        }
        return entryId.toString();
    }

    Entry getEntryFromInput(ArEntryIdList idlist, ArFieldValueList fieldValList, String tableName) throws ARException {
        String key;
        Entry entry = this.getEntryItemsFromFieldValList(fieldValList);
        if (!entry.containsKey((Object)CoreFieldId.EntryId.getFieldId()) && (key = this.getEntryIdListString(idlist)) != null) {
            entry.put(Integer.valueOf(CoreFieldId.EntryId.getFieldId()), new Value(key));
        }
        return entry;
    }

    Entry getEntryItemsFromFieldValList(ArFieldValueList fieldValList) throws ARException {
        Entry items = new Entry();
        if (fieldValList.value != null) {
            for (int i = 0; i < fieldValList.value.length; ++i) {
                items.put(Integer.valueOf(fieldValList.value[i].fieldId.value), ValueObjectFactory.getValueObject(fieldValList.value[i].value));
            }
        }
        return items;
    }

    ArFieldValueList getFieldValListFromEntryItems(Entry items) throws ARException {
        ArFieldValueList list = new ArFieldValueList();
        ArFieldValueStruct[] values = new ArFieldValueStruct[items.size()];
        int i = 0;
        for (Map.Entry fieldValue : items.entrySet()) {
            values[i] = new ArFieldValueStruct();
            values[i].fieldId = new ArInternalId(((Integer)fieldValue.getKey()).intValue());
            values[i].value = this.getArValueFromValue((Value)fieldValue.getValue());
            ++i;
        }
        list.value = values;
        return list;
    }

    ArValueList getArValueListFromValueList(Value[] values) throws ARException {
        ArValueList list = new ArValueList();
        if (values != null) {
            list.value = new ArValueStruct[values.length];
            for (int i = 0; i < values.length; ++i) {
                list.value[i] = this.getArValueFromValue(values[i]);
            }
        }
        return list;
    }

    ArValueList getArValueListFromValueList(List<Value> values) throws ARException {
        ArValueList list = new ArValueList();
        if (values != null) {
            list.value = new ArValueStruct[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                list.value[i] = this.getArValueFromValue(values.get(i));
            }
        }
        return list;
    }

    ArValueStruct getArValueFromValue(Value value) throws ARException {
        ArValueStruct val = ValueObjectFactory.setValueObject(value, null);
        return val;
    }

    ArEntryIdList getEntryIdListFromKey(String key) throws ARException {
        String[] entryIds = Entry.splitEntryId((String)key);
        return this.toRpcArEntryIdList(entryIds);
    }

    EntryKey getEntryKeyFromEntryId(String tablename, ArEntryIdList entryId) {
        EntryKey key = null;
        String id = this.getEntryIdListString(entryId);
        key = new EntryKey(tablename, id);
        return key;
    }

    int[] getIntListFromInternalIds(ArInternalIdList idList) {
        int[] list = null;
        if (idList.value != null) {
            list = new int[idList.value.length];
            for (int i = 0; i < idList.value.length; ++i) {
                list[i] = idList.value[i].value;
            }
        }
        return list;
    }

    public ArStatusList6 getRpcStatusFromStatusInfo(List<StatusInfo> status) {
        ArStatusList6 statusList = new ArStatusList6();
        if (status != null) {
            statusList.value = new ArStatusStruct6[status.size()];
            for (int i = 0; i < status.size(); ++i) {
                StatusInfo stat = status.get(i);
                statusList.value[i] = new ArStatusStruct6();
                statusList.value[i].messageNum = (int)stat.getMessageNum();
                statusList.value[i].messageText = stat.getMessageText();
                statusList.value[i].messageType = stat.getMessageType();
                statusList.value[i].appendedText = stat.getAppendedText();
                if (statusList.value[i].messageText == null) {
                    statusList.value[i].messageText = "";
                }
                if (statusList.value[i].appendedText != null) continue;
                statusList.value[i].appendedText = "";
            }
        }
        return statusList;
    }

    ArFieldValueList getFieldValueListFromEntry(Entry entry) throws ARException {
        ArFieldValueList list = this.getFieldValListFromEntryItems(entry);
        return list;
    }

    Timestamp getTimestampFromArTimestamp(ArTimestamp getTimestamp) {
        Timestamp time = new Timestamp((long)getTimestamp.value);
        return time;
    }

    ArTimestamp getArTimestampFromTimestamp(Timestamp getTimestamp) {
        ArTimestamp time = new ArTimestamp();
        time.value = (int)getTimestamp.getValue();
        return time;
    }

    boolean getBooleanFromArBoolean(ArBoolean deleteBLOB) {
        boolean ret = false;
        Boolean.getBoolean(deleteBLOB.toString());
        return ret;
    }

    protected ArEntryIdType toRpcArEntryIdType(String arg0) throws ARException {
        try {
            return new ArEntryIdType(StringByteUtil.stringToMaxByteArray((String)arg0, (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)16));
        }
        catch (UnsupportedEncodingException ex) {
            throw new ARException(2, 9062, ex.getMessage());
        }
    }

    private ArEntryIdList toRpcArEntryIdList(String[] arg0) throws ARException {
        int len = arg0 == null ? 0 : arg0.length;
        ArEntryIdType[] arList = new ArEntryIdType[len];
        for (int i = 0; i < len; ++i) {
            arList[i] = this.toRpcArEntryIdType(arg0[i]);
        }
        return new ArEntryIdList(arList);
    }

    ArEntryListFieldValueList6 getEntryListValueListFromEntries(List<Entry> entries) throws ARException {
        ArEntryListFieldValueList6 out = new ArEntryListFieldValueList6();
        if (entries != null) {
            out.value = new ArEntryListFieldValueStruct6[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                out.value[i] = new ArEntryListFieldValueStruct6();
                out.value[i].entryId = this.getEntryIdListFromKey(entries.get(i).getEntryId());
                out.value[i].entryValues = this.getFieldValListFromEntryItems(entries.get(i));
            }
        }
        return out;
    }

    List<SortInfo> getSortInfoFromRpcSortList(ArSortList sortList) {
        ArrayList<SortInfo> list = new ArrayList<SortInfo>();
        if (sortList != null && sortList.value != null) {
            for (int i = 0; i < sortList.value.length; ++i) {
                SortInfo info = new SortInfo(sortList.value[i].getFieldId().value, sortList.value[i].getSortOrder());
                list.add(info);
            }
        }
        return list;
    }

    List<EntryListFieldInfo> getGetListFieldsFromRPC(ArEntryListFieldList getListFields) {
        ArrayList<EntryListFieldInfo> list = new ArrayList<EntryListFieldInfo>();
        if (getListFields != null && getListFields.value != null) {
            for (int i = 0; i < getListFields.value.length; ++i) {
                EntryListFieldInfo info = new EntryListFieldInfo(getListFields.value[i].getFieldId().value, getListFields.value[i].getColumnWidth(), this.getEncodedString(getListFields.value[i].getSeparator()));
                list.add(info);
            }
        }
        return list;
    }

    ArCompoundSchemaList12 getRpcVendorForm(List<VendorForm> forms) throws ARException {
        ArCompoundSchemaList12 out = new ArCompoundSchemaList12();
        if (forms != null) {
            out.value = new ArCompoundSchema12[forms.size()];
            for (int i = 0; i < forms.size(); ++i) {
                VendorForm form = forms.get(i);
                out.value[i] = this.getCompoundSchema(form);
            }
        }
        return out;
    }

    ArCompoundSchema12 getCompoundSchema(VendorForm form) throws ARException {
        ArCompoundSchema12 out = new ArCompoundSchema12();
        out.schemaType = form.getFormType();
        out.vendor = new ArVendorSchema12();
        byte[] bytes = null;
        try {
            if (form.getVendorName() != null) {
                bytes = StringByteUtil.stringToMaxByteArray((String)form.getVendorName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                out.vendor.setVendorName(new ArNameType8(bytes));
            } else {
                out.vendor.setVendorName(new ArNameType8());
            }
        }
        catch (Exception e) {
            StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), form.getVendorName());
            ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
            status.add(info);
            throw new ARException(status);
        }
        try {
            bytes = form.getTableName() != null ? StringByteUtil.stringToMaxByteArray((String)form.getTableName(), null, (int)2048) : new byte[2048];
        }
        catch (Exception e) {
            StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), form.getTableName());
            ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
            status.add(info);
            throw new ARException(status);
        }
        out.vendor.setTableName(bytes);
        return out;
    }

    void getGMFOutFromVendorFields(ArEsArdbcGetMultipleFields4Out out, List<ARVendorField> fields) throws ARException {
        if (fields != null) {
            int size = fields.size();
            out.dataType.value = new int[size];
            out.fieldMapping.value = new ArFieldMappingStruct10[size];
            out.limitList.value = new ArFieldLimitStruct12[size];
            for (int i = 0; i < size; ++i) {
                ARVendorField field = fields.get(i);
                out.dataType.value[i] = field.getDataType();
                out.fieldMapping.value[i] = new ArFieldMappingStruct10();
                out.fieldMapping.value[i].fieldType = 4;
                out.fieldMapping.value[i].vendor = new ArVendorMappingStruct8();
                byte[] bytes = null;
                try {
                    if (field.getName() != null) {
                        bytes = StringByteUtil.stringToMaxByteArray((String)field.getName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                        out.fieldMapping.value[i].vendor.setFieldName(new ArNameType8(bytes));
                    } else {
                        out.fieldMapping.value[i].vendor.setFieldName(new ArNameType8());
                    }
                }
                catch (Exception e) {
                    StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), field.getName());
                    ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                    status.add(info);
                    throw new ARException(status);
                }
                out.limitList.value[i] = this.getRPCFieldLimit(field.getFieldLimit());
            }
        }
    }

    ArFieldLimitStruct12 getRPCFieldLimit(FieldLimit limit) throws ARException {
        byte[] bytes = null;
        ArFieldLimitStruct12 out = new ArFieldLimitStruct12();
        if (limit != null) {
            out.dataType = limit.getDataType();
            switch (limit.getDataType()) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    IntegerFieldLimit intLimit = (IntegerFieldLimit)limit;
                    out.intLimits = new ArIntegerLimitsStruct();
                    out.intLimits.setRangeHigh(intLimit.getHighRange());
                    out.intLimits.setRangeLow(intLimit.getLowRange());
                    break;
                }
                case 3: {
                    RealFieldLimit realLimit = (RealFieldLimit)limit;
                    out.realLimits = new ArRealLimitsStruct2();
                    out.realLimits.setPrecision(realLimit.getPrecision());
                    out.realLimits.setRangeHigh(realLimit.getHighRange());
                    out.realLimits.setRangeLow(realLimit.getLowRange());
                    break;
                }
                case 4: {
                    CharacterFieldLimit charLimit = (CharacterFieldLimit)limit;
                    out.charLimits = new ArCharLimitsStruct8();
                    try {
                        if (charLimit.getCharMenu() != null) {
                            bytes = StringByteUtil.stringToMaxByteArray((String)charLimit.getCharMenu(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                            out.charLimits.setCharMenu(new ArNameType8(bytes));
                        } else {
                            out.charLimits.setCharMenu(new ArNameType8());
                        }
                    }
                    catch (Exception e) {
                        StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), charLimit.getCharMenu());
                        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                        status.add(info);
                        throw new ARException(status);
                    }
                    out.charLimits.setFullTextOptions(charLimit.getFullTextOption());
                    out.charLimits.setMaxLength(charLimit.getMaxLength());
                    out.charLimits.setMenuStyle(charLimit.getMenuStyle());
                    out.charLimits.setPattern(charLimit.getPattern() == null ? "" : charLimit.getPattern());
                    out.charLimits.setQbeMatchOperation(charLimit.getQBEMatch());
                    break;
                }
                case 5: {
                    DiaryFieldLimit diaryLimit = (DiaryFieldLimit)limit;
                    out.diaryLimits = new ArDiaryLimitsStruct();
                    out.diaryLimits.setFullTextOptions(diaryLimit.getFullTextOption());
                    break;
                }
                case 7: {
                    out.dataType = 0;
                    break;
                }
                case 8: 
                case 40: {
                    break;
                }
                case 14: {
                    out.dataType = 0;
                    break;
                }
                case 12: {
                    CurrencyFieldLimit curLimit = (CurrencyFieldLimit)limit;
                    out.currencyLimits = new ArCurrencyLimitsStruct();
                    out.currencyLimits.allowableCurrencies = this.getCurrencyList(curLimit.getAllowable());
                    out.currencyLimits.functionalCurrencies = this.getCurrencyList(curLimit.getFunctional());
                    out.currencyLimits.precision = curLimit.getPrecision();
                    out.currencyLimits.rangeHigh = curLimit.getHighRange().toPlainString();
                    out.currencyLimits.rangeLow = curLimit.getLowRange().toPlainString();
                    break;
                }
                case 13: {
                    DateOnlyFieldLimit dateLimit = (DateOnlyFieldLimit)limit;
                    out.dateLimits = new ArDateLimitsStruct();
                    out.dateLimits.setMaxDate(dateLimit.getMaxDate());
                    out.dateLimits.setMinDate(dateLimit.getMinDate());
                    break;
                }
                case 10: {
                    DecimalFieldLimit decLimit = (DecimalFieldLimit)limit;
                    out.decimalLimits = new ArDecimalLimitsStruct6(decLimit.getLowRange().toPlainString(), decLimit.getHighRange().toPlainString(), decLimit.getPrecision());
                    break;
                }
                case 11: {
                    AttachmentFieldLimit attLimit = (AttachmentFieldLimit)limit;
                    out.attachLimits = new ArAttachLimitsStruct12();
                    out.attachLimits.setAttachType(attLimit.getAttachType());
                    out.attachLimits.setFullTextOptions(attLimit.getFullTextOption());
                    out.attachLimits.setMaxSize(attLimit.getMaxSize());
                    break;
                }
                case 34: {
                    ColumnFieldLimit colLimit = (ColumnFieldLimit)limit;
                    out.columnLimits = new ArColumnLimitsStruct8();
                    out.columnLimits.setColLength(colLimit.getColumnLength());
                    out.columnLimits.setDataField(new ArInternalId(colLimit.getDataField()));
                    out.columnLimits.setDataSource(colLimit.getDataSource());
                    out.columnLimits.setParent(new ArInternalId(colLimit.getParent()));
                    break;
                }
                case 33: {
                    TableFieldLimit tabLimit = (TableFieldLimit)limit;
                    out.tableLimits = new ArTableLimitsStruct10();
                    out.tableLimits.setMaxRetrieve(tabLimit.getMaxRetrieve());
                    out.tableLimits.setNumColumns(tabLimit.getColumnCount());
                    out.tableLimits.setQualifier(this.getRPCQualFromQualInfo(tabLimit.getQualifier()));
                    try {
                        if (tabLimit.getSampleForm() != null) {
                            bytes = StringByteUtil.stringToMaxByteArray((String)tabLimit.getSampleForm(), null, (int)255);
                            out.tableLimits.setSampleSchema(new ArNameType8(bytes));
                        } else {
                            out.tableLimits.setSampleSchema(new ArNameType8());
                        }
                    }
                    catch (Exception e) {
                        StatusInfo info = new StatusInfo(2, 8789L, "Error while encoding string to bytes", tabLimit.getSampleForm());
                        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                        status.add(info);
                        throw new ARException(status);
                    }
                    try {
                        if (tabLimit.getSampleServer() != null) {
                            bytes = StringByteUtil.stringToMaxByteArray((String)tabLimit.getSampleServer(), null, (int)65);
                            out.tableLimits.setSampleServer(new ArServerNameType(bytes));
                        } else {
                            out.tableLimits.setSampleServer(new ArServerNameType());
                        }
                    }
                    catch (Exception e) {
                        StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), tabLimit.getSampleServer());
                        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                        status.add(info);
                        throw new ARException(status);
                    }
                    try {
                        if (tabLimit.getForm() != null) {
                            bytes = StringByteUtil.stringToMaxByteArray((String)tabLimit.getForm(), null, (int)255);
                            out.tableLimits.setSchema(new ArNameType8(bytes));
                        } else {
                            out.tableLimits.setSchema(new ArNameType8());
                        }
                    }
                    catch (Exception e) {
                        StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), tabLimit.getForm());
                        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                        status.add(info);
                        throw new ARException(status);
                    }
                    try {
                        if (tabLimit.getServer() != null) {
                            bytes = StringByteUtil.stringToMaxByteArray((String)tabLimit.getServer(), null, (int)65);
                            out.tableLimits.setServer(new ArServerNameType(bytes));
                            break;
                        }
                        out.tableLimits.setServer(new ArServerNameType());
                        break;
                    }
                    catch (Exception e) {
                        StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), tabLimit.getServer());
                        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                        status.add(info);
                        throw new ARException(status);
                    }
                }
                case 43: {
                    DisplayFieldLimit dispLimit = (DisplayFieldLimit)limit;
                    out.displayLimits = new ArDisplayLimits();
                    out.displayLimits.setMaxLength(dispLimit.getMaxLength());
                    break;
                }
                case 6: {
                    SelectionFieldLimit enumLimit = (SelectionFieldLimit)limit;
                    out.enumLimits = new ArEnumLimitsStruct();
                    out.enumLimits.listStyle = enumLimit.getListStyle();
                    switch (out.enumLimits.listStyle) {
                        case 2: {
                            out.enumLimits.customList = this.getArEnumItemList(enumLimit.getValues());
                            break;
                        }
                        case 1: {
                            out.enumLimits.regularList = this.getArNameList(enumLimit.getValues());
                            break;
                        }
                        case 3: {
                            out.enumLimits.queryList = this.getArEnumStruct(enumLimit.getValues());
                        }
                    }
                    break;
                }
                case 42: {
                    ViewFieldLimit viewLimit = (ViewFieldLimit)limit;
                    out.viewLimits = new ArViewLimits();
                    out.viewLimits.setMaxLength(viewLimit.getMaxLength());
                    break;
                }
                case 41: {
                    break;
                }
            }
        }
        return out;
    }

    ArEnumItemList getArEnumItemList(List<EnumItem> items) throws ARException {
        ArEnumItemList list = new ArEnumItemList();
        if (items != null) {
            list.value = new ArEnumItemStruct[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                EnumItem item = items.get(i);
                list.value[i] = new ArEnumItemStruct();
                byte[] bytes = null;
                try {
                    if (item.getEnumItemName() != null) {
                        bytes = StringByteUtil.stringToMaxByteArray((String)item.getEnumItemName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                        list.value[i].setItemName(new ArNameType8(bytes));
                    } else {
                        list.value[i].setItemName(new ArNameType8());
                    }
                }
                catch (Exception e) {
                    StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), item.getEnumItemName());
                    ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                    status.add(info);
                    throw new ARException(status);
                }
                list.value[i].setItemNumber(item.getEnumItemNumber());
            }
        }
        return list;
    }

    ArNameList8 getArNameList(List<EnumItem> items) throws ARException {
        ArNameList8 list = new ArNameList8();
        if (items != null) {
            list.value = new ArNameType8[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                EnumItem item = items.get(i);
                byte[] bytes = null;
                try {
                    if (item.getEnumItemName() != null) {
                        bytes = StringByteUtil.stringToMaxByteArray((String)item.getEnumItemName(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                        list.value[i] = new ArNameType8(bytes);
                        continue;
                    }
                    list.value[i] = new ArNameType8();
                    continue;
                }
                catch (Exception e) {
                    StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), item.getEnumItemName());
                    ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                    status.add(info);
                    throw new ARException(status);
                }
            }
        }
        return list;
    }

    ArCurrencyDetailList getCurrencyList(List<CurrencyDetail> details) throws ARException {
        ArCurrencyDetailList list = new ArCurrencyDetailList();
        if (details != null) {
            list.value = new ArCurrencyDetailStruct[details.size()];
            for (int i = 0; i < details.size(); ++i) {
                list.value[i] = new ArCurrencyDetailStruct();
                CurrencyDetail detail = details.get(i);
                byte[] bytes = null;
                try {
                    if (detail.getCurrencyCode() != null) {
                        bytes = StringByteUtil.stringToMaxByteArray((String)detail.getCurrencyCode(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)4);
                        list.value[i].setCurrencyCode(new ArCurrencyCodeType(bytes));
                    } else {
                        list.value[i].setCurrencyCode(new ArCurrencyCodeType());
                    }
                }
                catch (Exception e) {
                    StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), detail.getCurrencyCode());
                    ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                    status.add(info);
                    throw new ARException(status);
                }
                list.value[i].setPrecision(detail.getPrecision());
            }
        }
        return list;
    }

    VendorForm getVendorForm(ArCompoundSchema12 schema) {
        VendorForm form = null;
        if (schema != null && schema.schemaType == 5 && schema.vendor != null) {
            String vendorName = null;
            String tableName = null;
            try {
                vendorName = StringByteUtil.createNullTerminatedString((byte[])schema.vendor.vendorName.value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
                tableName = StringByteUtil.createNullTerminatedString((byte[])schema.vendor.tableName, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)e);
            }
            form = new VendorForm(vendorName, tableName);
        }
        return form;
    }

    ArithmeticOrRelationalOperand getFieldValueOrArithFromRPC(ArFieldValueOrArithStruct8 target, boolean isJavaPlugin) throws ARException {
        ArithmeticOrRelationalOperand op = null;
        switch (target.tag) {
            case 3: {
                op = new ArithmeticOrRelationalOperand(this.getArithmeticOpInfo(target.arithOp, isJavaPlugin));
                break;
            }
            case 6: {
                op = new ArithmeticOrRelationalOperand(this.getCurrencyPartInfo(target.currencyField));
                break;
            }
            case 56: {
                op = new ArithmeticOrRelationalOperand(56, this.getCurrencyPartInfo(target.currencyFieldCurrent));
                break;
            }
            case 55: {
                op = new ArithmeticOrRelationalOperand(56, this.getCurrencyPartInfo(target.currencyFieldDB));
                break;
            }
            case 54: {
                op = new ArithmeticOrRelationalOperand(56, this.getCurrencyPartInfo(target.currencyFieldTran));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (isJavaPlugin) {
                    op = new ArithmeticOrRelationalOperand(OperandType.FIELDID, target.fieldId.value);
                    break;
                }
                op = new ArithmeticOrRelationalOperand(OperandType.getOperandType((int)target.tag), target.fieldId.value);
                break;
            }
            case 1: {
                op = new ArithmeticOrRelationalOperand(OperandType.FIELDID, target.fieldId.value);
                break;
            }
            case 99: {
                op = new ArithmeticOrRelationalOperand(OperandType.FIELDID_CURRENT, target.fieldIdDB.value);
                break;
            }
            case 51: {
                op = new ArithmeticOrRelationalOperand(OperandType.FIELDID_DB, target.fieldIdDB.value);
                break;
            }
            case 50: {
                op = new ArithmeticOrRelationalOperand(OperandType.FIELDID_TRANSACTION, target.fieldIdTran.value);
                break;
            }
            case 52: {
                op = new ArithmeticOrRelationalOperand(OperandType.LOCAL_VARIABLE, target.variable);
                break;
            }
            case 53: {
                op = new ArithmeticOrRelationalOperand(this.getQueryInfo(target.queryValue, isJavaPlugin));
                break;
            }
            case 2: {
                op = new ArithmeticOrRelationalOperand(this.getValue(target.value));
                break;
            }
            case 4: {
                op = new ArithmeticOrRelationalOperand(this.getStatHistoryValue(target.statHistory));
                break;
            }
            case 5: {
                op = new ArithmeticOrRelationalOperand(this.getValueList(target.valueSet));
            }
        }
        return op;
    }

    Value getValue(ArValueStruct struct) throws ARException {
        Value val = ValueObjectFactory.getValueObject(struct);
        return val;
    }

    List<Value> getValueList(ArValueList list) throws ARException {
        ArrayList<Value> values = new ArrayList<Value>();
        if (list != null && list.value != null) {
            for (int i = 0; i < list.value.length; ++i) {
                Value value = this.getValue(list.value[i]);
                values.add(value);
            }
        }
        return values;
    }

    StatusHistoryValueIndicator getStatHistoryValue(ArStatHistoryValue statHistory) {
        StatusHistoryValueIndicator stat = new StatusHistoryValueIndicator(statHistory.getEnumVal() == 1, statHistory.getUserOrTime());
        return null;
    }

    QueryInfo getQueryInfo(ArQueryValueStruct8 struct, boolean isJavaPlugin) throws ARException {
        String serverName = null;
        String schema = null;
        try {
            serverName = StringByteUtil.createNullTerminatedString((byte[])struct.server, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
            schema = StringByteUtil.createNullTerminatedString((byte[])struct.schema.value, (String)"utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)e);
        }
        QualifierInfo qual = this.getQualInfoFromRpcQual(struct.qualifier, isJavaPlugin);
        int fldID = struct.valueField.value;
        int nMatchMode = struct.multiMatchCode;
        QueryInfo query = new QueryInfo(schema, serverName, qual, fldID, nMatchMode);
        return query;
    }

    CurrencyPartInfo getCurrencyPartInfo(ArCurrencyPartStruct struct) {
        String code = null;
        try {
            code = StringByteUtil.createNullTerminatedString((byte[])struct.currencyCode.value, (String)ARPluginServerConfiguration.getInstance().getServerCharset());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)CatalogReader.getInstance().getMessage(8797), (Throwable)e);
        }
        CurrencyPartInfo info = new CurrencyPartInfo(struct.fieldId.value, struct.getPartTag(), code);
        return info;
    }

    ArithmeticOperationInfo getArithmeticOpInfo(ArArithOpStruct8 op, boolean isJavaPlugin) throws ARException {
        ArithmeticOperationInfo info = new ArithmeticOperationInfo(op.getOperation(), this.getFieldValueOrArithFromRPC(op.operandLeft, isJavaPlugin), this.getFieldValueOrArithFromRPC(op.operandRight, isJavaPlugin));
        return info;
    }

    ArStatisticsResultList getRPCStatisticsResults(List<StatisticsResultInfo> results) throws ARException {
        ArStatisticsResultList out = new ArStatisticsResultList();
        if (results != null) {
            out.value = new ArStatisticsResultStruct[results.size()];
            for (int i = 0; i < results.size(); ++i) {
                StatisticsResultInfo info = results.get(i);
                out.value[i] = new ArStatisticsResultStruct();
                List values = info.getGroupByValues();
                Value value = info.getResult();
                out.value[i].setGroupByValues(this.getArValueListFromValueList(values));
                out.value[i].setResult(this.getArValueFromValue(value));
            }
        }
        return null;
    }

    byte[] getBytesFromAttachmentValue(AttachmentValue attachment) {
        byte[] bytes = attachment.getContent();
        return bytes;
    }

    AttachmentValue getAttachmentInfoFromBytes(byte[] bytes) {
        AttachmentValue info = new AttachmentValue(bytes);
        return info;
    }

    QualifierInfo getQualInfoFromRpcQual(ArQualifierStruct8 qualifier, boolean isJavaPlugin) throws ARException {
        QualifierInfo out = null;
        if (qualifier != null) {
            switch (qualifier.operation) {
                case 1: {
                    out = new QualifierInfo(qualifier.operation, this.getQualInfoFromRpcQual(qualifier.andQual.operandLeft, isJavaPlugin), this.getQualInfoFromRpcQual(qualifier.andQual.operandRight, isJavaPlugin));
                    break;
                }
                case 0: {
                    out = new QualifierInfo();
                    out.setOperation(qualifier.operation);
                    break;
                }
                case 3: {
                    out = new QualifierInfo(qualifier.operation, this.getQualInfoFromRpcQual(qualifier.notQual, isJavaPlugin), null);
                    break;
                }
                case 2: {
                    out = new QualifierInfo(qualifier.operation, this.getQualInfoFromRpcQual(qualifier.orQual.operandLeft, isJavaPlugin), this.getQualInfoFromRpcQual(qualifier.orQual.operandLeft, isJavaPlugin));
                    break;
                }
                case 4: {
                    out = new QualifierInfo(this.getRelationOperationInfo(qualifier.relOp, isJavaPlugin));
                }
            }
        }
        return out;
    }

    RelationalOperationInfo getRelationOperationInfo(ArRelOpStruct8 op, boolean isJavaPlugin) throws ARException {
        RelationalOperationInfo info = new RelationalOperationInfo(op.getOperation(), this.getFieldValueOrArithFromRPC(op.getOperandLeft(), isJavaPlugin), this.getFieldValueOrArithFromRPC(op.getOperandRight(), isJavaPlugin));
        return info;
    }

    ArRelOpStruct8 getArRelOpStruct(RelationalOperationInfo op) throws ARException {
        ArRelOpStruct8 info = new ArRelOpStruct8(op.getOperation(), this.getRPCFieldValueOrArith(op.getLeftOperand()), this.getRPCFieldValueOrArith(op.getRightOperand()));
        return info;
    }

    ArFieldValueOrArithStruct8 getRPCFieldValueOrArith(ArithmeticOrRelationalOperand target) throws ARException {
        ArFieldValueOrArithStruct8 op = null;
        ArArithOpStruct8 obj = null;
        switch (target.getType().toInt()) {
            case 3: {
                obj = this.getArArithOpStruct((ArithmeticOperationInfo)target.getValue());
                op = new ArFieldValueOrArithStruct8(3, (Object)obj);
                break;
            }
            case 6: {
                obj = this.getArCurrencyStruct((CurrencyPartInfo)target.getValue());
                op = new ArFieldValueOrArithStruct8(6, (Object)obj);
                break;
            }
            case 56: {
                obj = this.getArCurrencyStruct((CurrencyPartInfo)target.getValue());
                op = new ArFieldValueOrArithStruct8(56, (Object)obj);
                break;
            }
            case 55: {
                obj = this.getArCurrencyStruct((CurrencyPartInfo)target.getValue());
                op = new ArFieldValueOrArithStruct8(3, (Object)obj);
                break;
            }
            case 54: {
                obj = this.getArCurrencyStruct((CurrencyPartInfo)target.getValue());
                op = new ArFieldValueOrArithStruct8(3, (Object)obj);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                obj = new ArInternalId(((Integer)target.getValue()).intValue());
                op = new ArFieldValueOrArithStruct8(target.getType().toInt(), (Object)obj);
                break;
            }
            case 99: {
                obj = new ArInternalId(((Integer)target.getValue()).intValue());
                op = new ArFieldValueOrArithStruct8(99, (Object)obj);
                break;
            }
            case 51: {
                obj = new ArInternalId(((Integer)target.getValue()).intValue());
                op = new ArFieldValueOrArithStruct8(51, (Object)obj);
                break;
            }
            case 50: {
                obj = new ArInternalId(((Integer)target.getValue()).intValue());
                op = new ArFieldValueOrArithStruct8(50, (Object)obj);
                break;
            }
            case 52: {
                obj = new ArInternalId(((Integer)target.getValue()).intValue());
                op = new ArFieldValueOrArithStruct8(52, (Object)obj);
                break;
            }
            case 53: {
                obj = this.getArQueryValueStruct((QueryInfo)target.getValue());
                op = new ArFieldValueOrArithStruct8(53, (Object)obj);
                break;
            }
            case 2: {
                obj = this.getArValueFromValue((Value)target.getValue());
                op = new ArFieldValueOrArithStruct8(2, (Object)obj);
                break;
            }
            case 4: {
                obj = this.getArStatHistory((StatusHistoryValueIndicator)target.getValue());
                op = new ArFieldValueOrArithStruct8(4, (Object)obj);
                break;
            }
            case 5: {
                obj = this.getArValueListFromValueList((List)target.getValue());
                op = new ArFieldValueOrArithStruct8(5, (Object)obj);
            }
        }
        return op;
    }

    ArStatHistoryValue getArStatHistory(StatusHistoryValueIndicator stat) {
        ArStatHistoryValue value = null;
        if (stat != null) {
            value = new ArStatHistoryValue(stat.getEnumValue(), stat.isUser() ? 1 : 2);
        }
        return value;
    }

    ArCurrencyPartStruct getArCurrencyStruct(CurrencyPartInfo info) throws ARException {
        ArCurrencyPartStruct struct = null;
        if (info != null) {
            byte[] bytes = null;
            ArCurrencyCodeType code = null;
            try {
                if (info.getCurrencyCode() != null) {
                    bytes = StringByteUtil.stringToMaxByteArray((String)info.getCurrencyCode(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)4);
                    code = new ArCurrencyCodeType(bytes);
                } else {
                    code = new ArCurrencyCodeType();
                }
            }
            catch (Exception e) {
                StatusInfo stat = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8797), info.getCurrencyCode());
                ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                status.add(stat);
                throw new ARException(status);
            }
            struct = new ArCurrencyPartStruct(new ArInternalId(info.getFieldId()), info.getPartTag(), code);
        }
        return struct;
    }

    public ArCoordList toRpcArCoordList(List<CoordinateInfo> arg0) throws ARException {
        int len = arg0 == null ? 0 : arg0.size();
        ArCoordStruct[] arList = new ArCoordStruct[len];
        for (int i = 0; i < len; ++i) {
            arList[i] = this.toRpcArCoordStruct(arg0.get(i));
        }
        return new ArCoordList(arList);
    }

    public ArCoordStruct toRpcArCoordStruct(CoordinateInfo arg0) throws ARException {
        if (arg0 == null) {
            return new ArCoordStruct();
        }
        int x = arg0.getXCoordinate();
        int y = arg0.getYCoordinate();
        return new ArCoordStruct(x, y);
    }

    public List<CoordinateInfo> fromRpcArCoordList(ArCoordList arg0) {
        ArrayList<CoordinateInfo> list = new ArrayList<CoordinateInfo>();
        if (arg0 != null) {
            for (ArCoordStruct cord : arg0.value) {
                list.add(new CoordinateInfo(cord.x, cord.y));
            }
        }
        return list;
    }

    public String byteArrayToString(byte[] byteArray) throws ARException {
        try {
            int i;
            for (i = 0; i < byteArray.length && byteArray[i] != 0; ++i) {
            }
            return new String(byteArray, 0, i, ARPluginServerConfiguration.getInstance().getServerCharset()).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new ARException(2, 9062, e.getLocalizedMessage());
        }
    }

    public byte[] stringToByteArray(String arg0) throws ARException {
        try {
            return StringByteUtil.stringToMaxByteArray((String)arg0, (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)(arg0.getBytes(ARPluginServerConfiguration.getInstance().getServerCharset()).length + 1));
        }
        catch (UnsupportedEncodingException ex) {
            throw new ARException(2, 9062, ex.getMessage());
        }
    }

    public ArCurrencyCodeType toRpcArCurrencyCodeType(String arg0) throws ARException {
        try {
            return new ArCurrencyCodeType(StringByteUtil.stringToMaxByteArray((String)arg0, (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)4));
        }
        catch (UnsupportedEncodingException ex) {
            throw new ARException(2, 9062, ex.getMessage());
        }
    }

    public ArCurrencyStruct toRpcArCurrencyStruct(CurrencyValue arg0) throws ARException {
        if (arg0 == null) {
            return new ArCurrencyStruct();
        }
        String value = arg0.getValueString();
        ArCurrencyCodeType currencyCode = this.toRpcArCurrencyCodeType(arg0.getCurrencyCode());
        ArTimestamp conversionDate = this.getArTimestampFromTimestamp(arg0.getConversionDate());
        ArFuncCurrencyList funcCurrencyList = this.toRpcArFuncCurrencyList(arg0.getFuncCurrencyList());
        return new ArCurrencyStruct(value, currencyCode, conversionDate, funcCurrencyList);
    }

    public ArFuncCurrencyList toRpcArFuncCurrencyList(List<FuncCurrencyInfo> arg0) throws ARException {
        int len = arg0 == null ? 0 : arg0.size();
        ArFuncCurrencyStruct[] arList = new ArFuncCurrencyStruct[len];
        for (int i = 0; i < len; ++i) {
            arList[i] = this.toRpcArFuncCurrencyStruct(arg0.get(i));
        }
        return new ArFuncCurrencyList(arList);
    }

    public ArFuncCurrencyStruct toRpcArFuncCurrencyStruct(FuncCurrencyInfo arg0) throws ARException {
        if (arg0 == null) {
            return new ArFuncCurrencyStruct();
        }
        String value = arg0.getValueString();
        ArCurrencyCodeType currencyCode = this.toRpcArCurrencyCodeType(arg0.getCurrencyCode());
        return new ArFuncCurrencyStruct(value, currencyCode);
    }

    public CurrencyValue fromRpcArCurrencyStructToCurrencyInfo(ArCurrencyStruct arg0) throws ARException {
        return new CurrencyValue(new BigDecimal(arg0.getValue()), this.byteArrayToString(arg0.getCurrencyCode().getValue()), this.getTimestampFromArTimestamp(arg0.getConversionDate()), this.fromRpcArFuncCurrencyListToList(arg0.getFuncCurrencyList()));
    }

    public List<FuncCurrencyInfo> fromRpcArFuncCurrencyListToList(ArFuncCurrencyList arg0) throws ARException {
        ArrayList<FuncCurrencyInfo> listObj = new ArrayList<FuncCurrencyInfo>();
        for (int i = 0; i < arg0.getValue().length; ++i) {
            FuncCurrencyInfo item = this.fromRpcArFuncCurrencyStructToFuncCurrencyInfo(arg0.getValue()[i]);
            if (item == null) continue;
            listObj.add(item);
        }
        return listObj;
    }

    public FuncCurrencyInfo fromRpcArFuncCurrencyStructToFuncCurrencyInfo(ArFuncCurrencyStruct arg0) throws ARException {
        if (arg0.getValue() != null && arg0.getValue().equals("")) {
            return null;
        }
        return new FuncCurrencyInfo(new BigDecimal(arg0.getValue()), this.byteArrayToString(arg0.getCurrencyCode().getValue()));
    }

    ArQueryValueStruct8 getArQueryValueStruct(QueryInfo query) throws ARException {
        ArQueryValueStruct8 struct = null;
        if (query != null) {
            byte[] schema = null;
            byte[] server = null;
            try {
                if (query.getFormID() != null) {
                    schema = StringByteUtil.stringToMaxByteArray((String)query.getFormID(), (String)ARPluginServerConfiguration.getInstance().getServerCharset(), (int)255);
                }
                server = query.getServerName() != null ? StringByteUtil.stringToMaxByteArray((String)query.getServerName(), null, (int)65) : new byte[65];
            }
            catch (Exception e) {
                StatusInfo info = new StatusInfo(2, 8789L, CatalogReader.getInstance().getMessage(8789), query.getFormID());
                ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
                status.add(info);
                throw new ARException(status);
            }
            struct = new ArQueryValueStruct8(new ArNameType8(schema), server, this.getRPCQualFromQualInfo(query.getQualifierInfo()), new ArInternalId(query.getFieldID()), query.getMatchMode());
        } else {
            struct = new ArQueryValueStruct8();
        }
        return struct;
    }

    ArArithOpStruct8 getArArithOpStruct(ArithmeticOperationInfo info) throws ARException {
        ArArithOpStruct8 out = new ArArithOpStruct8(info.getOperation(), this.getRPCFieldValueOrArith(info.getLeftOperand()), this.getRPCFieldValueOrArith(info.getRightOperand()));
        return null;
    }

    ArQualifierStruct8 getRPCQualFromQualInfo(QualifierInfo qual) throws ARException {
        ArQualifierStruct8 qStruct = null;
        ArQualifierStruct8 obj = null;
        switch (qual.getOperation()) {
            case 1: {
                obj = new ArAndOrStruct8(this.getRPCQualFromQualInfo(qual.getLeftOperand()), this.getRPCQualFromQualInfo(qual.getRightOperand()));
                qStruct = new ArQualifierStruct8(qual.getOperation(), (Object)obj);
                break;
            }
            case 0: {
                qStruct = new ArQualifierStruct8(qual.getOperation(), (Object)obj);
                break;
            }
            case 3: {
                obj = this.getRPCQualFromQualInfo(qual.getNotOperand());
                qStruct = new ArQualifierStruct8(qual.getOperation(), (Object)obj);
                break;
            }
            case 2: {
                obj = new ArAndOrStruct8(this.getRPCQualFromQualInfo(qual.getLeftOperand()), this.getRPCQualFromQualInfo(qual.getRightOperand()));
                qStruct = new ArQualifierStruct8(qual.getOperation(), (Object)obj);
                break;
            }
            case 4: {
                obj = this.getArRelOpStruct(qual.getRelationalOperationInfo());
                qStruct = new ArQualifierStruct8(qual.getOperation(), (Object)obj);
            }
        }
        return qStruct;
    }

    public ARPluginContext getContextFromControl(ArEsControlStruct4 control, ARPluginInfo pluginInfo) {
        ARPluginContext context = null;
        String user = null;
        String userGuid = null;
        String authString = null;
        if (control != null && control.reservedPropList != null) {
            ArPropStruct[] props = control.reservedPropList.getValue();
            if (props != null) {
                block5: for (int i = 0; i < props.length; ++i) {
                    ArValueStruct value = props[i].getValue();
                    if (value.getDataType() != 4) continue;
                    switch (props[i].getProp()) {
                        case 1: {
                            user = value.charVal;
                            continue block5;
                        }
                        case 2: {
                            authString = value.charVal;
                            continue block5;
                        }
                        case 3: {
                            userGuid = value.charVal;
                        }
                    }
                }
            }
            context = new ARPluginContext(user, userGuid, authString, ARPluginServerConfiguration.getInstance().getCmdLineArgs(), pluginInfo);
        }
        return context;
    }

    ArEnumQueryStruct getArEnumStruct(List<EnumItem> items) {
        ArEnumQueryStruct query = new ArEnumQueryStruct();
        return query;
    }

    public ByteListValue fromRpcArByteListToByteListInfo(ArByteList arg0) throws ARException {
        return new ByteListValue(arg0.getType(), arg0.getBytes());
    }

    public ArByteList toRpcArByteList(ByteListValue arg0) throws ARException {
        if (arg0 == null) {
            return new ArByteList();
        }
        int type = arg0.getType();
        byte[] bytes = arg0.getValue();
        return new ArByteList(type, bytes);
    }

    public ArdbcCreateIn fromRPC(ArEsArdbcCreate4In in, ARPluginInfo info) throws ARException {
        ArdbcCreateIn out = null;
        out = new ArdbcCreateIn();
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.entry = this.getEntryFromInput(in.entryId, in.fieldValueList, in.tableName);
        out.context = this.getContextFromControl(in.control, info);
        return out;
    }

    public ArEsArdbcCreate4Out toRPC(ArdbcCreateOut out) throws ARException {
        ArEsArdbcCreate4Out ret = new ArEsArdbcCreate4Out(out.control, this.getEntryIdListFromKey(out.key), this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcGetIn fromRPC(ArEsArdbcGet4In in, ARPluginInfo info) {
        ArdbcGetIn out = new ArdbcGetIn();
        out.context = this.getContextFromControl(in.control, info);
        out.entryId = this.getEntryIdListString(in.entryId);
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.idList = this.getIntListFromInternalIds(in.idList);
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        return out;
    }

    public ArEsArdbcGet4Out toRPC(ArdbcGetOut out) throws ARException {
        ArEsArdbcGet4Out ret = new ArEsArdbcGet4Out(out.control, this.getFieldValueListFromEntry(out.entry), this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcSetIn fromRPC(ArEsArdbcSet4In in, ARPluginInfo info) throws ARException {
        ArdbcSetIn out = new ArdbcSetIn();
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.entryId = this.getEntryIdListString(in.entryId);
        out.entry = this.getEntryFromInput(in.entryId, in.fieldValueList, in.tableName);
        out.context = this.getContextFromControl(in.control, info);
        out.timestamp = this.getTimestampFromArTimestamp(in.getTimestamp);
        return out;
    }

    public ArEsArdbcSet4Out toRPC(ArdbcSetOut out) {
        ArEsArdbcSet4Out ret = new ArEsArdbcSet4Out(out.control, this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcDeleteIn fromRPC(ArEsArdbcDelete4In in, ARPluginInfo info) {
        ArdbcDeleteIn out = new ArdbcDeleteIn();
        out.context = this.getContextFromControl(in.control, info);
        out.entryId = this.getEntryIdListString(in.entryId);
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        out.deleteBlob = this.getBooleanFromArBoolean(in.deleteBLOB);
        return out;
    }

    public ArEsArdbcDelete4Out toRPC(ArdbcDeleteOut out) {
        ArEsArdbcDelete4Out ret = new ArEsArdbcDelete4Out(out.control, this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcGetBlobIn fromRPC(ArEsArdbcGetBlob4In in, ARPluginInfo info) {
        ArdbcGetBlobIn out = new ArdbcGetBlobIn();
        out.context = this.getContextFromControl(in.control, info);
        out.entryId = this.getEntryIdListString(in.entryId);
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        out.fieldId = in.fieldId.value;
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArEsArdbcGetBlob4Out toRPC(ArdbcGetBlobOut out) {
        byte[] bytes = this.getBytesFromAttachmentValue(out.attachment);
        byte[] returnBytes = new byte[]{};
        if (bytes != null) {
            ARCompressor compresser = new ARCompressor();
            ARByteArrayBuffer buf = new ARByteArrayBuffer();
            try {
                compresser.setInput(bytes);
                compresser.deflate(buf);
                returnBytes = buf.getBuffer();
            }
            finally {
                buf.setBuffer(null);
                buf = null;
                compresser = null;
            }
        }
        ArEsArdbcGetBlob4Out ret = new ArEsArdbcGetBlob4Out(out.control, returnBytes, this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcGlwefIn fromRPC(ArEsArdbcGlewf4In in, ARPluginInfo info, boolean isJavaPlugin) throws ARException {
        ArdbcGlwefIn out = new ArdbcGlwefIn();
        out.context = this.getContextFromControl(in.control, info);
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        out.maxRetrieve = in.maxRetrieve;
        out.startAt = in.firstRetrieve;
        out.qualifier = this.getQualInfoFromRpcQual(in.qualifier, isJavaPlugin);
        out.sortList = this.getSortInfoFromRpcSortList(in.sortList);
        out.getListFields = this.getGetListFieldsFromRPC(in.getListFields);
        return out;
    }

    public ArEsArdbcGlewf4Out toRPC(ArdbcGlewfOut out) throws ARException {
        ArEsArdbcGlewf4Out ret = new ArEsArdbcGlewf4Out(out.control, this.getEntryListValueListFromEntries(out.entries), out.numMatches.intValue(), this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcCommitIn fromRPC(ArEsArdbcCommit4In in, ARPluginInfo info) {
        ArdbcCommitIn out = new ArdbcCommitIn();
        out.context = this.getContextFromControl(in.control, info);
        out.transId = in.transId.value;
        return out;
    }

    public ArEsArdbcCommit4Out toRPC(ArdbcCommitOut out) {
        ArEsArdbcCommit4Out ret = new ArEsArdbcCommit4Out(out.control, this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcRollbackIn fromRPC(ArEsArdbcRollback4In in, ARPluginInfo info) {
        ArdbcRollbackIn out = new ArdbcRollbackIn();
        out.context = this.getContextFromControl(in.control, info);
        out.transId = in.transId.value;
        return out;
    }

    public ArEsArdbcRollback4Out toRPC(ArdbcRollbackOut out) {
        ArEsArdbcRollback4Out ret = new ArEsArdbcRollback4Out(out.control, this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcCancelIn fromRPC(ArEsArdbcCancelQuery4In in, ARPluginInfo info) {
        ArdbcCancelIn out = new ArdbcCancelIn();
        out.context = this.getContextFromControl(in.control, info);
        out.transId = in.transId.value;
        return out;
    }

    public ArEsArdbcCancelQuery4Out toRPC(ArdbcCancelOut out) {
        ArEsArdbcCancelQuery4Out ret = new ArEsArdbcCancelQuery4Out(out.control, this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcGetListFormsIn fromRPC(ArEsArdbcGetListForms4In in, ARPluginInfo info) {
        ArdbcGetListFormsIn out = new ArdbcGetListFormsIn();
        out.context = this.getContextFromControl(in.control, info);
        return out;
    }

    public ArEsArdbcGetListForms4Out toRPC(ArdbcGetListFormsOut out) throws ARException {
        ArEsArdbcGetListForms4Out ret = new ArEsArdbcGetListForms4Out(out.control, this.getRpcVendorForm(out.forms), this.getRpcStatusFromStatusInfo(out.status));
        return ret;
    }

    public ArdbcGetMultipleFieldsIn fromRPC(ArEsArdbcGetMultipleFields4In in, ARPluginInfo info) {
        ArdbcGetMultipleFieldsIn out = new ArdbcGetMultipleFieldsIn();
        out.context = this.getContextFromControl(in.control, info);
        out.schema = this.getVendorForm(in.schema);
        return out;
    }

    public ArEsArdbcGetMultipleFields4Out toRPC(ArdbcGetMultipleFieldsOut out) throws ARException {
        ArEsArdbcGetMultipleFields4Out ret = new ArEsArdbcGetMultipleFields4Out();
        this.getGMFOutFromVendorFields(ret, out.fields);
        return ret;
    }

    public ArdbcGetEntryStatisticsIn fromRPC(ArEsArdbcGetEntryStatistics4In in, ARPluginInfo info, boolean isJavaPlugin) throws ARException {
        ArdbcGetEntryStatisticsIn out = new ArdbcGetEntryStatisticsIn();
        out.context = this.getContextFromControl(in.control, info);
        out.fieldsList = this.getVendorFields(in.vendorFieldList);
        out.tableName = in.tableName;
        out.transId = in.transId.value;
        out.qualifier = this.getQualInfoFromRpcQual(in.qualifier, isJavaPlugin);
        out.groupByList = this.getIntListFromInternalIds(in.groupByList);
        out.statistic = in.statistic;
        out.target = this.getFieldValueOrArithFromRPC(in.target, isJavaPlugin);
        return out;
    }

    public ArEsArdbcGetEntryStatistics4Out toRPC(ArdbcGetEntryStatisticsOut out) throws ARException {
        ArEsArdbcGetEntryStatistics4Out ret = new ArEsArdbcGetEntryStatistics4Out();
        ret.control = out.control;
        ret.status = this.getRpcStatusFromStatusInfo(out.status);
        ret.results = this.getRPCStatisticsResults(out.stats);
        return ret;
    }
}

