/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.encrypt;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.arxdrenc.ArXdrEncryptRPCSvrToCnt;
import com.bmc.arsys.api.arxdrenc.ArXdrUnXdrBufferStream;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.arencrypt.ARPublicPrivateKeyPair;
import com.bmc.arsys.arencrypt.KeyExchangeEncryption;
import com.bmc.arsys.arencrypt.NetWorkDataKeyInfo;
import com.bmc.arsys.arencrypt.NetworkDataEncryption;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import com.bmc.arsys.arrpc.ArEncryptRPCCntToSvr;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.encrypt.AREncryptAPISessionNode;
import com.bmc.arsys.pluginsvr.oncrpcext.ARTcpConnectionServerTransport;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferDecodingStream;
import org.acplt.oncrpc.XdrDecodingStream;
import org.apache.log4j.Logger;

public class ARPluginServerEncryptionInfo {
    private static Logger log = Logger.getLogger(ARPluginServerEncryptionInfo.class);
    private int mDataEncryptionKeyExpiry;
    private int mPublicKeyExpiry;
    private int mEncryptionSecurityPolicy;
    private int mDataEncryptionAlgorithm;
    private int mPublicKeyAlgorithm;
    private int mNumEncSessionHashentries;
    private transient ARPublicPrivateKeyPair mKeypair;
    private NetworkDataEncryption mDataEncryptor;
    private HashMap<Integer, AREncryptAPISessionNode> mMapSessionNodes;
    private static ARPluginServerEncryptionInfo theInstance;
    private static final transient String PLUGIN_USER = "Plug-in Server";
    private static final transient String ARPLUGIN_A = "Plug-in";
    private static final transient String ARPLUGIN_B = "Alert";
    private static final transient String ARPLUGIN_C = "$";
    private static final transient String ARPLUGIN_D = "Msg";
    private static final int PASSWORD_CHAR_SIZE = 30;
    public static final transient int PASSWORD_CHAR_ENCRYPTED_SIZE = 120;

    private ARPluginServerEncryptionInfo() throws ARException {
        log.debug((Object)"Constructor ARPluginServerEncryptionInfo");
        this.mDataEncryptionKeyExpiry = ARPluginServerConfiguration.getInstance().getDataEncryptionKeyExpiry();
        this.mPublicKeyExpiry = ARPluginServerConfiguration.getInstance().getPublicKeyExpiry();
        this.mEncryptionSecurityPolicy = ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy();
        this.mDataEncryptionAlgorithm = ARPluginServerConfiguration.getInstance().getDataEncryptionAlgorithm();
        this.mPublicKeyAlgorithm = ARPluginServerConfiguration.getInstance().getPublicKeyAlgorithm();
        this.mMapSessionNodes = new HashMap();
        this.mDataEncryptor = new NetworkDataEncryption(false, false);
        try {
            this.mKeypair = new ARPublicPrivateKeyPair(this.mPublicKeyAlgorithm, this.mPublicKeyExpiry);
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8786), (Throwable)e);
            throw new ARException(2, 8786);
        }
    }

    public static ARPluginServerEncryptionInfo getInstance() throws ARException {
        if (theInstance == null) {
            theInstance = new ARPluginServerEncryptionInfo();
        }
        return theInstance;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public synchronized PrivateKey getPrivateKey() throws ARException {
        log.info((Object)"getPrivateKey");
        try {
            return this.mKeypair.getPrivateKey();
        }
        catch (AREncryptionException e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8787), (Throwable)e);
            throw new ARException(2, 8787, e.getLocalizedMessage());
        }
    }

    public synchronized PublicKey getPublicKey() throws ARException {
        log.info((Object)"getPublicKey");
        try {
            return this.mKeypair.getPublicKey();
        }
        catch (AREncryptionException e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8788), (Throwable)e);
            throw new ARException(2, 8788);
        }
    }

    public synchronized Date getLastCreateTime() {
        return this.mKeypair.getLastCreateTime();
    }

    public synchronized byte[] getPublicKeyBytes() throws ARException {
        log.info((Object)"getPublicKeyBytes");
        try {
            return this.mKeypair.getPublicKeyBytes();
        }
        catch (AREncryptionException e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8788), (Throwable)e);
            throw new ARException(2, 8788);
        }
    }

    public static byte[] generateRandomBytes() {
        return StringByteUtil.generateRandomBytes((int)20);
    }

    public long createAndInsertSessionNode(byte[] svrBytes, byte[] clntBytes) {
        log.info((Object)"createAndInsertSessionNode");
        AREncryptAPISessionNode node = new AREncryptAPISessionNode(this.mDataEncryptionAlgorithm, svrBytes, clntBytes);
        this.mMapSessionNodes.put(node.getSessionId(), node);
        return node.getSessionId();
    }

    public synchronized byte[] unxdrAndDecryptPreMasterkey(int sessionId, byte[] databytes) throws ARException {
        log.info((Object)"unxdrAndDecryptPreMasterkey");
        byte[] bytes = null;
        try {
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node == null) {
                throw new ARException(2, 9002);
            }
            KeyExchangeEncryption keyEncryption = new KeyExchangeEncryption((ARPPKey)this.mKeypair);
            byte[] dataTounxdr = keyEncryption.decrypt(databytes, (Key)this.mKeypair.getPrivateKey());
            bytes = ArXdrUnXdrBufferStream.unXdrBytes((byte[])dataTounxdr);
            node.setPreMasterKey(bytes);
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
            throw new ARException(2, 9002);
        }
        return bytes;
    }

    AREncryptAPISessionNode getSessionNode(int sessionId) {
        AREncryptAPISessionNode node = this.mMapSessionNodes.get(new Integer(sessionId));
        return node;
    }

    public synchronized void generateServerAndClientDataKey(int sessionId, byte[] preMasterKey) throws ARException {
        log.info((Object)"generateServerAndClientDataKey");
        try {
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(9002));
                throw new ARException(2, 9002);
            }
            NetWorkDataKeyInfo datakey = new NetWorkDataKeyInfo();
            datakey.setEncAlgorithmParam(this.mDataEncryptionAlgorithm);
            datakey.genDataEncKeys(node.getEncTransferObject());
            node.setServerClientDataKey(datakey);
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
            throw new ARException(2, 9002);
        }
    }

    private synchronized void CleanUpTimedoutSessions() {
        log.info((Object)"CleanUpTimedoutSessions");
        Set<Integer> keys = this.mMapSessionNodes.keySet();
        if (keys.size() > 0) {
            for (Integer key : keys) {
                AREncryptAPISessionNode node = this.mMapSessionNodes.get(key);
                if (node == null || System.currentTimeMillis() <= node.getCreateTime() + (long)this.mDataEncryptionKeyExpiry && node.getEncryptionAlgorithm() == this.mDataEncryptionAlgorithm) continue;
                this.mMapSessionNodes.remove(key);
            }
        }
    }

    public synchronized byte[] XdrAndEncryptSessionId(int sessionId) throws ARException {
        byte[] sessionBytes;
        block4: {
            log.info((Object)"XdrAndEncryptSessionId");
            sessionBytes = null;
            try {
                AREncryptAPISessionNode node = this.getSessionNode(sessionId);
                if (node != null) {
                    byte[] xdredBytes = ArXdrUnXdrBufferStream.xdrInt((int)sessionId);
                    ARDataKey datakey = node.getServerDataKey();
                    if (datakey != null) {
                        sessionBytes = this.mDataEncryptor.encryptData(datakey, xdredBytes);
                    }
                    break block4;
                }
                log.error((Object)CatalogReader.getInstance().getMessage(9002));
                throw new ARException(2, 9002);
            }
            catch (Exception e) {
                log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)e);
                throw new ARException(2, 9002);
            }
        }
        return sessionBytes;
    }

    public synchronized XdrAble encryptAndXdrData(int sessionId, byte[] bufToencode) throws ARException, OncRpcAuthenticationException {
        log.info((Object)"encryptAndXdrData");
        NetworkDataEncryption dataEnc = new NetworkDataEncryption(false, false);
        try {
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node != null) {
                int errorCode = 0;
                ARDataKey dataKey = node.getServerDataKey();
                byte[] encryptedData = dataEnc.encryptData(dataKey, bufToencode);
                ArXdrEncryptRPCSvrToCnt arXdrEnc = new ArXdrEncryptRPCSvrToCnt(new byte[0], 0);
                arXdrEnc.setOut(encryptedData);
                arXdrEnc.setErrorCode(errorCode);
                return arXdrEnc;
            }
            log.error((Object)"Encryption info not found for the API session. Key Exchange required.");
            throw new OncRpcAuthenticationException(2);
        }
        catch (OncRpcAuthenticationException oae) {
            throw oae;
        }
        catch (Exception e) {
            log.error((Object)CatalogReader.getInstance().getMessage(8784), (Throwable)e);
            throw new ARException(2, 8784);
        }
    }

    public synchronized byte[] unXdrAndDecryptData(byte[] bufToDecode, ARTcpConnectionServerTransport conn) throws ARException, OncRpcAuthenticationException {
        log.info((Object)"unXdrAndDecryptData");
        ArEncryptRPCCntToSvr arXdrEnc = null;
        XdrBufferDecodingStream xdr = null;
        try {
            arXdrEnc = new ArEncryptRPCCntToSvr();
            xdr = new XdrBufferDecodingStream(bufToDecode, bufToDecode.length + 4);
            xdr.beginDecoding();
            arXdrEnc.xdrDecode((XdrDecodingStream)xdr);
            byte[] encryptedXdrData = arXdrEnc.getIn();
            int sessionId = arXdrEnc.getSessionId();
            conn.setCurrentSessionId(sessionId);
            AREncryptAPISessionNode node = this.getSessionNode(sessionId);
            if (node != null) {
                byte[] rst;
                NetworkDataEncryption dataEnc = new NetworkDataEncryption(false, false);
                byte[] byArray = rst = dataEnc.decryptData(node.getClientDataKey(), encryptedXdrData);
                return byArray;
            }
            try {
                log.error((Object)"Encryption info not found for the API session. Key Exchange required.");
                throw new OncRpcAuthenticationException(2);
            }
            catch (OncRpcAuthenticationException oae) {
                throw oae;
            }
            catch (Exception e) {
                log.error((Object)CatalogReader.getInstance().getMessage(8785), (Throwable)e);
                throw new ARException(2, 8785);
            }
        }
        finally {
            try {
                xdr.endDecoding();
                xdr.close();
                xdr = null;
            }
            catch (Exception e) {}
        }
    }

    public String toPswdString(String str) throws ARException {
        String rtnStr = "";
        byte[] buf = str.getBytes();
        if (buf.length == 120) {
            PasswordEncryption pwdEnc = new PasswordEncryption(0, false);
            try {
                rtnStr = new String(pwdEnc.decryptPasswordEx(str.getBytes()));
            }
            catch (AREncryptionException e) {
                throw new ARException(2, e.getErrorNum(), e.getLocalizedMessage());
            }
        }
        return rtnStr;
    }

    public String doMagic(String str) {
        String ret = "";
        char[] temp = new char[30];
        char[] retArray = new char[30];
        StringBuilder builder = new StringBuilder(30);
        builder.append(ARPLUGIN_A);
        builder.append(ARPLUGIN_D);
        builder.append(ARPLUGIN_C);
        builder.append(ARPLUGIN_B);
        builder.append(ARPLUGIN_C);
        ret = builder.toString();
        int size = ret.length();
        if (str != null && !str.equals("")) {
            StringBuilder newBuilder = new StringBuilder(str).reverse();
            String conf = newBuilder.toString();
            if (conf.length() < 30 - size) {
                builder.append(conf);
                return builder.toString();
            }
            char[] confArray = conf.toCharArray();
            char[] newArray = builder.toString().toCharArray();
            System.arraycopy(confArray, 0, temp, 30 - confArray.length, confArray.length);
            for (int i = 0; i < 30; ++i) {
                retArray[i] = (char)(newArray[i] ^ temp[i]);
                if (retArray[i] != '\u0000' && retArray[i] != '\n' && retArray[i] != '\r') continue;
                retArray[i] = temp[i];
            }
            return new String(retArray);
        }
        return ret;
    }
}

