/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.encrypt;

import com.bmc.arsys.api.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.NetWorkDataKeyInfo;
import com.bmc.arsys.arencrypt.NetWorkDateEncTransferObject;

public class AREncryptAPISessionNode
extends AREncryptAPISessionNodeBase {
    private static int uniqueIdCounter = 10000;
    long mCreationTime;
    int mDataEncAlgorithm;

    public AREncryptAPISessionNode(int encAlg) {
        this.setSessionId((int)AREncryptAPISessionNode.getUniqueSessionId());
        this.mCreationTime = System.currentTimeMillis();
        this.mDataEncAlgorithm = encAlg;
    }

    public AREncryptAPISessionNode(int encAlg, byte[] svrBytes, byte[] clntBytes) {
        super(encAlg, svrBytes, clntBytes);
        this.setSessionId((int)AREncryptAPISessionNode.getUniqueSessionId());
        this.mCreationTime = System.currentTimeMillis();
        this.mDataEncAlgorithm = encAlg;
    }

    public AREncryptAPISessionNode(int encAlg, byte[] svrBytes, byte[] clntBytes, byte[] preMaster) {
        super(encAlg, svrBytes, clntBytes, preMaster);
        this.setSessionId((int)AREncryptAPISessionNode.getUniqueSessionId());
        this.mCreationTime = System.currentTimeMillis();
        this.mDataEncAlgorithm = encAlg;
    }

    public long getCreateTime() {
        return this.mCreationTime;
    }

    public int getEncryptionAlgorithm() {
        return this.mDataEncAlgorithm;
    }

    private static synchronized long getUniqueSessionId() {
        long sessionId = 0L;
        sessionId = ++uniqueIdCounter;
        return sessionId;
    }

    public ARDataKey getServerDataKey() {
        NetWorkDataKeyInfo clntServerDataKey = this.getClintKeyInfo();
        if (clntServerDataKey != null) {
            return clntServerDataKey.getSvrDataKey();
        }
        return null;
    }

    public ARDataKey getClientDataKey() {
        NetWorkDataKeyInfo clntServerDataKey = this.getClintKeyInfo();
        if (clntServerDataKey != null) {
            return clntServerDataKey.getCntDataKey();
        }
        return null;
    }

    public void setServerClientRandomBytes(byte[] svrBytes, byte[] clntBytes, byte[] preMaster) {
        this.getDataEncRandomBytesObj().setClntRandBytes(clntBytes);
        this.getDataEncRandomBytesObj().setServerRandBytes(svrBytes);
        this.getDataEncRandomBytesObj().setPreMasterKey(preMaster);
    }

    public byte[] getServerRandomByte() {
        return this.getDataEncRandomBytesObj().getServerRandBytes();
    }

    public byte[] getClientRandomByte() {
        return this.getDataEncRandomBytesObj().getClntRandBytes();
    }

    public byte[] getPreMasterKey() {
        return this.getDataEncRandomBytesObj().getPreMasterKey();
    }

    public NetWorkDateEncTransferObject getEncTransferObject() {
        return this.getDataEncRandomBytesObj();
    }

    public void setPreMasterKey(byte[] preMaster) {
        this.getDataEncRandomBytesObj().setPreMasterKey(preMaster);
    }
}

