/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginServerConfigKey;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginServerConfiguration {
    private static final String PLUGIN_SERVER_WORKING_DIRECTORY = "pluginWork";
    private static Logger log = Logger.getLogger(ARPluginServerConfiguration.class);
    private static ARPluginServerConfiguration theInstance = new ARPluginServerConfiguration();
    private static String AR_PLUGIN_SERVER_CONFIG_FILE = "pluginsvr_config.xml";
    public static String DEFAULT_SET_NAME = "NONE";
    private static String SET_NAME_PREFIX = "PluginSet_";
    private static int SETCOUNT = 0;
    private static String AR_PLUGIN_USER_DEFINED_TAG = "userDefined";
    private XMLConfiguration mConfig;
    private InetAddress mHostID;
    private int mPort;
    private String mInstallPath = "";
    private String mCharSet;
    private String[] mCmdLineArgs;
    private int mMinThreads = 2;
    private int mMaxThreads = 5;
    private int mThreadTimeout = 10000;
    private int mDataEncryptionKeyExpiry = ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue();
    private int mPublicKeyExpiry = ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue();
    private int mEncryptionSecurityPolicy = ARPluginServerConfigKey.EncPolicy.getIntDefaultValue();
    private int mDataEncryptionAlgorithm = ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue();
    private int mPublicKeyAlgorithm = ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue();
    private int mNumEncSessionHashentries;
    private HashMap<String, PluginGroup> mPluginGroups;
    private ArrayList<ARPluginDefinition> mTopLevelPlugins;
    private ArrayList<ARPluginDefinition> mLegacyPlugins = new ArrayList();
    private HashMap<String, String> mPluginNames = new HashMap();
    private HashMap<String, Integer> mPluginCount = new HashMap();
    private HashMap<String, Integer> mGroupCount = new HashMap();
    private HashMap mARConfig = new HashMap();
    private String mPluginAuth;
    private String mPluginPass;
    private boolean mbRegPortMapper = false;
    private boolean mbLoadNativePluginHost = true;

    private ARPluginServerConfiguration() {
    }

    private void initializeLogging() {
        Logger root;
        Appender app;
        URL url = Thread.currentThread().getContextClassLoader().getResource("log4j_pluginsvr.xml");
        if (url != null) {
            DOMConfigurator.configure((URL)url);
        }
        if ((app = (root = Logger.getRootLogger()).getAppender("PluginLog")) instanceof RollingFileAppender) {
            String fileName = ((RollingFileAppender)app).getFile();
            PrintStream outPrintStream = null;
            PrintStream errPrintStream = null;
            if (fileName != null) {
                try {
                    File logFile = new File(fileName);
                    if (!logFile.exists()) {
                        logFile.createNewFile();
                    }
                    FileOutputStream outOutputStream = new FileOutputStream(fileName, true);
                    outPrintStream = new PrintStream(outOutputStream);
                    FileOutputStream errOutputStream = new FileOutputStream(fileName, true);
                    errPrintStream = new PrintStream(errOutputStream);
                    System.setErr(errPrintStream);
                    System.setOut(outPrintStream);
                }
                catch (IOException e) {
                    log.warn((Object)"Error encountered while redirecting stdout and stderr to the plugin log", (Throwable)e);
                }
            }
        }
    }

    public void initialize(String[] args) throws ARException {
        this.mCmdLineArgs = args;
        try {
            this.initializeLogging();
            this.parseCommandLineArguments(args);
            URL url = Thread.currentThread().getContextClassLoader().getResource(AR_PLUGIN_SERVER_CONFIG_FILE);
            if (url == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(8768));
                System.out.println(CatalogReader.getInstance().getMessage(8768));
                throw new ARException(2, 8768);
            }
            this.mConfig = new XMLConfiguration(url);
            this.mConfig.load();
            this.mEncryptionSecurityPolicy = this.mConfig.getInt(ARPluginServerConfigKey.EncPolicy.getKey(), ARPluginServerConfigKey.EncPolicy.getIntDefaultValue());
            this.mPublicKeyAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyAlg.getKey(), ARPluginServerConfigKey.PublicKeyAlg.getIntDefaultValue());
            this.mPublicKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.PublicKeyExpiry.getKey(), ARPluginServerConfigKey.PublicKeyExpiry.getIntDefaultValue());
            this.mDataEncryptionAlgorithm = this.mConfig.getInt(ARPluginServerConfigKey.DataEncryptionAlg.getKey(), ARPluginServerConfigKey.DataEncryptionAlg.getIntDefaultValue());
            this.mDataEncryptionKeyExpiry = this.mConfig.getInt(ARPluginServerConfigKey.DataKeyExpiry.getKey(), ARPluginServerConfigKey.DataKeyExpiry.getIntDefaultValue());
            this.mPort = this.mConfig.getInt(ARPluginServerConfigKey.TcpPort.getKey(), ARPluginServerConfigKey.TcpPort.getIntDefaultValue());
            this.mPluginAuth = this.mConfig.getString(ARPluginServerConfigKey.PluginAuth.getKey(), ARPluginServerConfigKey.PluginAuth.getDefaultValue());
            this.mbRegPortMapper = this.mConfig.getBoolean(ARPluginServerConfigKey.RegPortMapper.getKey(), ARPluginServerConfigKey.RegPortMapper.getBoolDefaultValue());
            this.mbLoadNativePluginHost = this.mConfig.getBoolean(ARPluginServerConfigKey.LoadNativePluginHost.getKey(), ARPluginServerConfigKey.LoadNativePluginHost.getBoolDefaultValue());
            if (this.mPort < 0 || this.mPort > 65535) {
                log.error((Object)CatalogReader.getInstance().getMessage(8782));
                log.error((Object)"Using portmapper for an available port");
                this.mbRegPortMapper = true;
                this.mPort = 0;
            }
            if (this.mPort == 0) {
                this.mbRegPortMapper = true;
                this.mPort = 0;
                log.info((Object)"Using portmapper for an available port");
            }
            if (this.mCharSet == null) {
                String charSet = this.mConfig.getString(ARPluginServerConfigKey.ServerCharSet.getKey());
                if (charSet != null) {
                    this.mCharSet = ARCharSet.getServerCharSetName((String)charSet);
                    if (!Charset.isSupported(this.mCharSet)) {
                        log.warn((Object)"The configured charset is not supported by the JVM.");
                        this.mCharSet = null;
                    }
                }
                if (this.mCharSet == null) {
                    Charset charset = Charset.defaultCharset();
                    this.mCharSet = charset.name();
                }
            }
            String path = ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.Plugins.getKey();
            this.mTopLevelPlugins = this.loadPlugins((HierarchicalConfiguration)this.mConfig, path, path);
            this.mPluginGroups = this.loadPluginGroups(ARPluginServerConfigKey.PluginsRoot.getKey() + ARPluginServerConfigKey.PluginSet.getKey(), DEFAULT_SET_NAME);
            this.setupPluginAuth();
        }
        catch (ConfigurationException cex) {
            log.error((Object)CatalogReader.getInstance().getMessage(8768), (Throwable)cex);
            System.out.println(CatalogReader.getInstance().getMessage(8768) + cex.getLocalizedMessage());
            throw new ARException(2, 8768, cex.getLocalizedMessage());
        }
    }

    private boolean isValidPluginConfiguration(ARPluginDefinition def) {
        boolean yesorno = true;
        String name = def.getFileName();
        String type = def.getPluginType();
        String code = def.getPluginCode();
        String filename = def.getFileName();
        String classname = def.getClassName();
        int version = def.getVersion();
        if (name == null || name.equals("")) {
            if (!code.equals("C")) {
                return false;
            }
            name = "";
        }
        if (filename == null || filename.equals("")) {
            return false;
        }
        if (code == null || code.equals("") || !code.equalsIgnoreCase("C") && !code.equalsIgnoreCase("JAVA")) {
            return false;
        }
        if (code.equalsIgnoreCase("JAVA") && (classname == null || classname.equals(""))) {
            return false;
        }
        if (type == null || type.equals("") || !type.equalsIgnoreCase("ARDBC") && !type.equalsIgnoreCase("AREA") && !type.equalsIgnoreCase("FilterAPI")) {
            return false;
        }
        if (type.equals("ARDBC")) {
            if (version == 0) {
                def.setVersion(4);
            } else if (version != 4) {
                return false;
            }
        } else if (type.equals("AREA")) {
            if (version == 0) {
                def.setVersion(3);
            } else if (version != 3) {
                return false;
            }
        } else if (type.equals("FILTERAPI")) {
            if (version == 0) {
                def.setVersion(2);
            } else if (version != 2) {
                return false;
            }
        }
        return yesorno;
    }

    private ArrayList<ARPluginDefinition> loadPlugins(HierarchicalConfiguration conf, String absolutePath, String path) {
        ArrayList<ARPluginDefinition> plugins = new ArrayList<ARPluginDefinition>();
        List fields = conf.configurationsAt(path);
        for (HierarchicalConfiguration sub : fields) {
            String pluginName = sub.getString(ARPluginServerConfigKey.PluginName.getKey());
            String pluginType = sub.getString(ARPluginServerConfigKey.PluginType.getKey());
            String fileName = sub.getString(ARPluginServerConfigKey.PluginFilename.getKey());
            String code = sub.getString(ARPluginServerConfigKey.PluginCode.getKey());
            String className = sub.getString(ARPluginServerConfigKey.PluginClassname.getKey());
            int version = sub.getInt(ARPluginServerConfigKey.PluginVersion.getKey(), ARPluginServerConfigKey.PluginVersion.getIntDefaultValue());
            ARPluginDefinition def = new ARPluginDefinition(pluginName, fileName, className, code, pluginType, version);
            List paths = sub.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey());
            if (paths != null && paths.size() > 0) {
                ArrayList<String> jars = new ArrayList<String>();
                ArrayList<String> folders = new ArrayList<String>();
                for (HierarchicalConfiguration classpath : paths) {
                    String type = classpath.getString("[@type]");
                    String folder = null;
                    String jarfile = null;
                    if (type != null && type.equals("path")) {
                        folder = (String)classpath.getRoot().getValue();
                    } else if (type != null && type.equals("location")) {
                        jarfile = (String)classpath.getRoot().getValue();
                    }
                    if (folder != null) {
                        folders.add(folder);
                    }
                    if (jarfile == null) continue;
                    jars.add(jarfile);
                }
                def.setClassPathFolders(folders);
                def.setClassPathJars(jars);
            }
            if (!this.isValidPluginConfiguration(def)) {
                String id = def.getPluginName();
                if (def.getPluginName() == null || def.getPluginName().equals("")) {
                    id = def.getFileName();
                }
                log.error((Object)(CatalogReader.getInstance().getMessage(8769) + ": " + id));
                continue;
            }
            if (this.mPluginNames.containsKey(pluginName)) {
                int count = this.mPluginCount.get(pluginName) + 1;
                this.mPluginCount.put(pluginName, count);
                if ((pluginName == null || pluginName.equals("")) && code.equals("C")) {
                    if (this.mLegacyPlugins.contains(def)) {
                        if (count <= 2) continue;
                        log.error((Object)(CatalogReader.getInstance().getMessage(8771) + " :" + pluginName));
                        continue;
                    }
                } else {
                    if (count <= 2) continue;
                    log.error((Object)(CatalogReader.getInstance().getMessage(8771) + " :" + pluginName));
                    continue;
                }
            }
            this.mPluginNames.put(pluginName, absolutePath);
            this.mPluginCount.put(pluginName, 1);
            if (code.equalsIgnoreCase("C") || fileName.endsWith(".dll")) {
                this.mLegacyPlugins.add(def);
                continue;
            }
            plugins.add(def);
        }
        return plugins;
    }

    private HashMap<String, PluginGroup> loadPluginGroups(String path, String parent) {
        List fields = this.mConfig.configurationsAt(path);
        HashMap<String, PluginGroup> groups = new HashMap<String, PluginGroup>();
        for (HierarchicalConfiguration sub : fields) {
            String groupName = sub.getString("[@name]");
            if (groupName == null) {
                groupName = SET_NAME_PREFIX + SETCOUNT++;
            }
            if (groups.containsKey(groupName)) {
                int count = this.mGroupCount.get(groupName) + 1;
                this.mGroupCount.put(groupName, count);
                if (count <= 2) continue;
                log.warn((Object)(CatalogReader.getInstance().getMessage(8771) + " " + groupName));
                continue;
            }
            ArrayList<ARPluginDefinition> plugins = this.loadPlugins(sub, path + ARPluginServerConfigKey.Plugins.getKey(), ARPluginServerConfigKey.Plugins.getKey().substring(1));
            HashMap<String, PluginGroup> subgroups = this.loadPluginGroups(path + ARPluginServerConfigKey.PluginSet.getKey(), groupName);
            PluginGroup group = new PluginGroup(parent, subgroups, plugins);
            List paths = sub.configurationsAt(ARPluginServerConfigKey.PluginClassPath.getKey());
            if (paths != null && paths.size() > 0) {
                ArrayList<String> jars = new ArrayList<String>();
                ArrayList<String> folders = new ArrayList<String>();
                for (HierarchicalConfiguration classpath : paths) {
                    String type = classpath.getString("[@type]");
                    String folder = null;
                    String jarfile = null;
                    if (type != null && type.equals("path")) {
                        folder = (String)classpath.getRoot().getValue();
                    } else if (type != null && type.equals("location")) {
                        jarfile = (String)classpath.getRoot().getValue();
                    }
                    if (folder != null) {
                        folders.add(folder);
                    }
                    if (jarfile == null) continue;
                    jars.add(jarfile);
                }
                group.setClassPathFolders(folders);
                group.setClassPathJars(jars);
            }
            groups.put(groupName, group);
            this.mGroupCount.put(groupName, 1);
        }
        return groups;
    }

    public static ARPluginServerConfiguration getInstance() {
        return theInstance;
    }

    public boolean getLoadNativePluginhost() {
        String osarch = System.getProperty("os.arch");
        if (osarch != null && osarch.equals("sparc")) {
            return false;
        }
        return this.mbLoadNativePluginHost;
    }

    public String getServerCharset() {
        return this.mCharSet;
    }

    public String getServerARCharset() {
        return ARCharSet.getServerKnownCharSetString((String)this.mCharSet.toLowerCase());
    }

    public String[] getCmdLineArgs() {
        return this.mCmdLineArgs;
    }

    public synchronized String getConfigValue(String pluginName, String key) {
        String path;
        String value = null;
        if (pluginName != null && key != null && (path = this.mPluginNames.get(pluginName)) != null && !path.equals("")) {
            List fields = this.mConfig.configurationsAt(path);
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (!name.equals(pluginName)) continue;
                value = sub.getString(AR_PLUGIN_USER_DEFINED_TAG + "." + key);
                break;
            }
        }
        return value;
    }

    public synchronized void setConfigValue(String pluginName, String key, Object value) {
        String path;
        if (pluginName != null && key != null && (path = this.mPluginNames.get(pluginName)) != null && !path.equals("")) {
            List fields = this.mConfig.configurationsAt(path);
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(ARPluginServerConfigKey.PluginName.getKey());
                if (!name.equals(pluginName)) continue;
                sub.setProperty(key, value);
                break;
            }
        }
    }

    public synchronized void saveConfiguration() {
        try {
            this.mConfig.save();
        }
        catch (ConfigurationException cex) {
            log.warn((Object)CatalogReader.getInstance().getMessage(8769), (Throwable)cex);
        }
    }

    public int getThreadTimeout() {
        return this.mThreadTimeout;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostName() {
        return this.mHostID.getHostName();
    }

    public InetAddress getHostID() {
        return this.mHostID;
    }

    public int getMinThreads(int queueType) {
        return this.mMinThreads;
    }

    public int getMaxThreads(int queueType) {
        return this.mMaxThreads;
    }

    public ArrayList<ARPluginDefinition> getConfiguredPlugins() {
        return this.mTopLevelPlugins;
    }

    public ArrayList<ARPluginDefinition> getNativePlugins() {
        return this.mLegacyPlugins;
    }

    public HashMap<String, PluginGroup> getConfiguredPluginGroups() {
        return this.mPluginGroups;
    }

    public boolean isRegisteredWithPortMapper() {
        return this.mbRegPortMapper;
    }

    public void setMaxThreads(int queueType, int numThreads) {
        this.mMaxThreads = numThreads;
    }

    public void setMinThreads(int queutType, int numThreads) {
        this.mMinThreads = numThreads;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public String getWorkingDirectory() {
        if (this.mInstallPath.endsWith(File.separator)) {
            return this.mInstallPath + PLUGIN_SERVER_WORKING_DIRECTORY;
        }
        return this.mInstallPath + File.separator + PLUGIN_SERVER_WORKING_DIRECTORY;
    }

    public String getARConfigEntry(String key) {
        StringBuffer ret = new StringBuffer("");
        Object o = this.mARConfig.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            ArrayList list = (ArrayList)o;
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                ret.append(s);
                ret.append(";");
            }
        } else {
            ret.append((String)o);
        }
        return ret.toString();
    }

    public Object getARConfigItem(String key) {
        Object o = this.mARConfig.get(key);
        return o;
    }

    public String getPluginPassword() {
        return this.mPluginPass;
    }

    public void parseCommandLineArguments(String[] args) throws ARException {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (i < args.length && args[i].equals("-x")) {
                    String hostName;
                    String string = hostName = ++i < args.length ? args[i] : null;
                    if (hostName != null && !hostName.equals("")) {
                        try {
                            this.mHostID = InetAddress.getByName(hostName);
                            continue;
                        }
                        catch (UnknownHostException ue) {
                            try {
                                this.mHostID = InetAddress.getLocalHost();
                                continue;
                            }
                            catch (UnknownHostException e) {
                                log.error((Object)CatalogReader.getInstance().getMessage(8783), (Throwable)ue);
                                throw new ARException(2, 8783);
                            }
                        }
                    }
                    try {
                        this.mHostID = InetAddress.getLocalHost();
                        continue;
                    }
                    catch (UnknownHostException e) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8781));
                        throw new ARException(2, 8781);
                    }
                }
                if (i < args.length && args[i].equals("-t")) {
                    String port;
                    String string = port = ++i < args.length ? args[i] : null;
                    if (port == null || port.equals("")) continue;
                    try {
                        this.mPort = Integer.parseInt(port);
                    }
                    catch (NumberFormatException ne) {
                        log.error((Object)CatalogReader.getInstance().getMessage(8782), (Throwable)ne);
                    }
                    continue;
                }
                if (i < args.length && args[i].equals("-i")) {
                    String path;
                    String string = path = ++i < args.length ? args[i] : null;
                    if (path != null && !path.equals("")) {
                        File file = new File(path);
                        if (!file.exists() || !file.isDirectory()) {
                            log.error((Object)("Invalid path for install folder " + path));
                            this.mInstallPath = "";
                            continue;
                        }
                        this.mInstallPath = path;
                        if (this.mInstallPath.endsWith("/") || this.mInstallPath.endsWith("\\")) continue;
                        this.mInstallPath = this.mInstallPath + "/";
                        continue;
                    }
                    this.mInstallPath = "";
                    log.error((Object)CatalogReader.getInstance().getMessage(8781));
                    System.out.println(CatalogReader.getInstance().getMessage(8781));
                    throw new ARException(2, 8781);
                }
                if (i >= args.length || !args[i].equalsIgnoreCase("--unicode") && !args[i].equalsIgnoreCase("--U")) continue;
                this.mCharSet = "utf-8";
            }
            if (this.mHostID == null) {
                try {
                    this.mHostID = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.error((Object)CatalogReader.getInstance().getMessage(8781));
                    throw new ARException(2, 8781);
                }
            }
        } else {
            System.out.println("Invalid command line arguments");
            this.printUsage();
            log.error((Object)CatalogReader.getInstance().getMessage(8781));
            throw new ARException(2, 8781);
        }
        this.loadARConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadARConfigFile() {
        if (this.mInstallPath != null && !this.mInstallPath.equals("")) {
            BufferedReader input = null;
            try {
                String arInstallPath = this.mInstallPath + File.separator + "conf" + File.separator + "ar.";
                String arConfFile = arInstallPath + "cfg";
                File confFile = new File(arConfFile);
                if (!confFile.exists() || !confFile.isFile()) {
                    arConfFile = arInstallPath + "conf";
                    confFile = new File(arConfFile);
                }
                if (confFile.exists() && confFile.isFile()) {
                    input = new BufferedReader(new FileReader(confFile));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        int index;
                        if (line.equals("") || (index = line.indexOf(58)) <= 0) continue;
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim();
                        if (this.mARConfig.containsKey(key)) {
                            Object o = this.mARConfig.get(key);
                            if (o instanceof List) {
                                ((List)o).add(value);
                                this.mARConfig.put(key, o);
                                continue;
                            }
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(o);
                            list.add(value);
                            this.mARConfig.put(key, list);
                            continue;
                        }
                        this.mARConfig.put(key, value);
                    }
                } else {
                    log.error((Object)("Could not find AR config file " + arConfFile));
                }
            }
            catch (Throwable e) {
                log.error((Object)"Could not load AR config file ", e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception ie) {}
                }
            }
        }
    }

    private void setupPluginAuth() throws ARException {
        String osarch;
        String conf = null;
        if (this.mPluginAuth == null || this.mPluginAuth.equals("")) {
            Object o = this.getARConfigItem("Plugin-Password");
            if (o != null) {
                String passwordForThisServer = null;
                if (o instanceof String) {
                    passwordForThisServer = (String)o;
                } else {
                    ArrayList list = (ArrayList)o;
                    for (int i = 0; i < list.size() && (passwordForThisServer = (String)list.get(i)) == null; ++i) {
                    }
                }
                if (passwordForThisServer != null) {
                    conf = passwordForThisServer;
                }
            }
        } else {
            conf = this.mPluginAuth;
        }
        this.mPluginPass = conf != null ? ((osarch = System.getProperty("os.arch")) != null && osarch.equals("sparc") ? null : ARPluginServerEncryptionInfo.getInstance().toPswdString(conf)) : null;
    }

    private void printUsage() {
        System.out.println("Usage: java ARPluginServerMain -x hostname -t portnum");
    }
}

